/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "MeshVolumePy.h"

using namespace boost::python;

void exportMeshVolume()
{
  // Check that Boost 1.34.0 or higher is being used.
  // If so, disable auto-generation of C++ signatures for Epydoc
  // (which stumbles over indentation in the auto-generated strings).
  #if ((BOOST_VERSION / 100000 >= 1)		 \
       && (BOOST_VERSION / 100 % 1000 >= 34))	 \
    || (BOOST_VERSION / 100000 >= 2)
  boost::python::docstring_options no_autogen(true,false);
  #endif

  class_<MeshVolume, bases<AVolume3D> >(
	"MeshVolume",
        "A class defining a volume bounded by a triangle mesh.",
        init<>()
      )
      .def(
        init<const TriPatchSet& >(
          ( arg("Mesh")),
          "Constructs a volume from a supplied set of triangles.\n"
          "@type Mesh: L{TriPatchSet}\n"
          "@kwarg Mesh: The set of triangles\n"
        )
      )
      ;
}

