#!/usr/bin/env python
#
# $Id: setup.py,v 1.27 2002/07/16 21:58:57 mrnolta Exp $
#
# Copyright (C) 2001 :
#
#	Berthold Hllmann <bhoel@starship.python.net>
#	Mike Nolta <mrnolta@users.sourceforge.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#

#
# distutils setup file for biggles originally contributed
# by Berthold Hllmann.
#

from distutils.core import setup, Extension
from distutils.command.install_data import install_data
from distutils.sysconfig import get_python_inc
import sys

## libplot

if sys.platform == "win32":
	libplot_include_dirs = []
	libplot_library_dirs = []
	libplot_libraries = ["plot.dll"]
else:
	libplot_prefix = "/usr/local"
	libplot_include_dirs = [libplot_prefix+"/include"]
	libplot_library_dirs = [libplot_prefix+"/lib", "/usr/X11R6/lib"]
	libplot_libraries = ["plot","Xaw","Xmu","Xt","SM","ICE","Xext","X11"]

# own install_data class to allow installation of data file
# (config.ini) to biggles directory

class my_install_data( install_data ):

	def finalize_options( self ):
		self.set_undefined_options( "install", \
			( "install_lib", "install_dir" ), \
			( "root", "root" ), \
			( "force", "force" ), \
		)

long_description = """\
Biggles is a Python module for creating publication-quality 2D scientific
plots. It supports multiple output formats (postscript, x11, png, svg, gif),
understands simple TeX, and sports a high-level, elegant interface. It's
intended for technical users with sophisticated plotting needs.
"""

setup(
	# Distribution meta-data

	name		= "python2-biggles",
	version		= "1.6.3",
	author		= "Mike Nolta",
	author_email	= "mrnolta@users.sourceforge.net",
	url		= "http://biggles.sourceforge.net/",
	licence		= "GPL", # (sic)
	description	= "scientific plotting module",
	long_description= long_description,

	# Description of the modules and packages in the distribution

	packages	= [ "biggles", "biggles.libplot" ],
	package_dir	= { "biggles" : "src" },

	ext_package	= "biggles",
	ext_modules	= [
		Extension( "_biggles", ["src/_biggles.c"] ),

		Extension( "libplot.libplot",
			["src/libplot/libplot.c"],
			include_dirs = libplot_include_dirs,
			library_dirs = libplot_library_dirs,
			libraries = libplot_libraries ), 
	],

	cmdclass	= { "install_data" : my_install_data },
	data_files	= [ ("biggles", ["src/config.ini"]) ]
)
