# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_create_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    version = kwargs.pop('version', "2021-04-10")  # type: str
    file_type_constant = kwargs.pop('file_type_constant', "file")  # type: str
    file_content_length = kwargs.pop('file_content_length')  # type: int
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    file_content_type = kwargs.pop('file_content_type', None)  # type: Optional[str]
    file_content_encoding = kwargs.pop('file_content_encoding', None)  # type: Optional[str]
    file_content_language = kwargs.pop('file_content_language', None)  # type: Optional[str]
    file_cache_control = kwargs.pop('file_cache_control', None)  # type: Optional[str]
    file_content_md5 = kwargs.pop('file_content_md5', None)  # type: Optional[bytearray]
    file_content_disposition = kwargs.pop('file_content_disposition', None)  # type: Optional[str]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    file_permission = kwargs.pop('file_permission', "inherit")  # type: Optional[str]
    file_permission_key = kwargs.pop('file_permission_key', None)  # type: Optional[str]
    file_attributes = kwargs.pop('file_attributes', "none")  # type: str
    file_creation_time = kwargs.pop('file_creation_time', "now")  # type: str
    file_last_write_time = kwargs.pop('file_last_write_time', "now")  # type: str
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    _header_parameters['x-ms-content-length'] = _SERIALIZER.header("file_content_length", file_content_length, 'long')
    _header_parameters['x-ms-type'] = _SERIALIZER.header("file_type_constant", file_type_constant, 'str')
    if file_content_type is not None:
        _header_parameters['x-ms-content-type'] = _SERIALIZER.header("file_content_type", file_content_type, 'str')
    if file_content_encoding is not None:
        _header_parameters['x-ms-content-encoding'] = _SERIALIZER.header("file_content_encoding", file_content_encoding, 'str')
    if file_content_language is not None:
        _header_parameters['x-ms-content-language'] = _SERIALIZER.header("file_content_language", file_content_language, 'str')
    if file_cache_control is not None:
        _header_parameters['x-ms-cache-control'] = _SERIALIZER.header("file_cache_control", file_cache_control, 'str')
    if file_content_md5 is not None:
        _header_parameters['x-ms-content-md5'] = _SERIALIZER.header("file_content_md5", file_content_md5, 'bytearray')
    if file_content_disposition is not None:
        _header_parameters['x-ms-content-disposition'] = _SERIALIZER.header("file_content_disposition", file_content_disposition, 'str')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    if file_permission is not None:
        _header_parameters['x-ms-file-permission'] = _SERIALIZER.header("file_permission", file_permission, 'str')
    if file_permission_key is not None:
        _header_parameters['x-ms-file-permission-key'] = _SERIALIZER.header("file_permission_key", file_permission_key, 'str')
    _header_parameters['x-ms-file-attributes'] = _SERIALIZER.header("file_attributes", file_attributes, 'str')
    _header_parameters['x-ms-file-creation-time'] = _SERIALIZER.header("file_creation_time", file_creation_time, 'str')
    _header_parameters['x-ms-file-last-write-time'] = _SERIALIZER.header("file_last_write_time", file_last_write_time, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_download_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    range = kwargs.pop('range', None)  # type: Optional[str]
    range_get_content_md5 = kwargs.pop('range_get_content_md5', None)  # type: Optional[bool]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if range is not None:
        _header_parameters['x-ms-range'] = _SERIALIZER.header("range", range, 'str')
    if range_get_content_md5 is not None:
        _header_parameters['x-ms-range-get-content-md5'] = _SERIALIZER.header("range_get_content_md5", range_get_content_md5, 'bool')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_properties_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    version = kwargs.pop('version', "2021-04-10")  # type: str
    sharesnapshot = kwargs.pop('sharesnapshot', None)  # type: Optional[str]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if sharesnapshot is not None:
        _query_parameters['sharesnapshot'] = _SERIALIZER.query("sharesnapshot", sharesnapshot, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="HEAD",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_delete_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_set_http_headers_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "properties")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    file_content_length = kwargs.pop('file_content_length', None)  # type: Optional[int]
    file_content_type = kwargs.pop('file_content_type', None)  # type: Optional[str]
    file_content_encoding = kwargs.pop('file_content_encoding', None)  # type: Optional[str]
    file_content_language = kwargs.pop('file_content_language', None)  # type: Optional[str]
    file_cache_control = kwargs.pop('file_cache_control', None)  # type: Optional[str]
    file_content_md5 = kwargs.pop('file_content_md5', None)  # type: Optional[bytearray]
    file_content_disposition = kwargs.pop('file_content_disposition', None)  # type: Optional[str]
    file_permission = kwargs.pop('file_permission', "inherit")  # type: Optional[str]
    file_permission_key = kwargs.pop('file_permission_key', None)  # type: Optional[str]
    file_attributes = kwargs.pop('file_attributes', "none")  # type: str
    file_creation_time = kwargs.pop('file_creation_time', "now")  # type: str
    file_last_write_time = kwargs.pop('file_last_write_time', "now")  # type: str
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if file_content_length is not None:
        _header_parameters['x-ms-content-length'] = _SERIALIZER.header("file_content_length", file_content_length, 'long')
    if file_content_type is not None:
        _header_parameters['x-ms-content-type'] = _SERIALIZER.header("file_content_type", file_content_type, 'str')
    if file_content_encoding is not None:
        _header_parameters['x-ms-content-encoding'] = _SERIALIZER.header("file_content_encoding", file_content_encoding, 'str')
    if file_content_language is not None:
        _header_parameters['x-ms-content-language'] = _SERIALIZER.header("file_content_language", file_content_language, 'str')
    if file_cache_control is not None:
        _header_parameters['x-ms-cache-control'] = _SERIALIZER.header("file_cache_control", file_cache_control, 'str')
    if file_content_md5 is not None:
        _header_parameters['x-ms-content-md5'] = _SERIALIZER.header("file_content_md5", file_content_md5, 'bytearray')
    if file_content_disposition is not None:
        _header_parameters['x-ms-content-disposition'] = _SERIALIZER.header("file_content_disposition", file_content_disposition, 'str')
    if file_permission is not None:
        _header_parameters['x-ms-file-permission'] = _SERIALIZER.header("file_permission", file_permission, 'str')
    if file_permission_key is not None:
        _header_parameters['x-ms-file-permission-key'] = _SERIALIZER.header("file_permission_key", file_permission_key, 'str')
    _header_parameters['x-ms-file-attributes'] = _SERIALIZER.header("file_attributes", file_attributes, 'str')
    _header_parameters['x-ms-file-creation-time'] = _SERIALIZER.header("file_creation_time", file_creation_time, 'str')
    _header_parameters['x-ms-file-last-write-time'] = _SERIALIZER.header("file_last_write_time", file_last_write_time, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_set_metadata_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "metadata")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_acquire_lease_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "lease")  # type: str
    action = kwargs.pop('action', "acquire")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    duration = kwargs.pop('duration', None)  # type: Optional[int]
    proposed_lease_id = kwargs.pop('proposed_lease_id', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-lease-action'] = _SERIALIZER.header("action", action, 'str')
    if duration is not None:
        _header_parameters['x-ms-lease-duration'] = _SERIALIZER.header("duration", duration, 'int')
    if proposed_lease_id is not None:
        _header_parameters['x-ms-proposed-lease-id'] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_release_lease_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "lease")  # type: str
    action = kwargs.pop('action', "release")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    lease_id = kwargs.pop('lease_id')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-lease-action'] = _SERIALIZER.header("action", action, 'str')
    _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_change_lease_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "lease")  # type: str
    action = kwargs.pop('action', "change")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    lease_id = kwargs.pop('lease_id')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    proposed_lease_id = kwargs.pop('proposed_lease_id', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-lease-action'] = _SERIALIZER.header("action", action, 'str')
    _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if proposed_lease_id is not None:
        _header_parameters['x-ms-proposed-lease-id'] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_break_lease_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "lease")  # type: str
    action = kwargs.pop('action', "break")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-lease-action'] = _SERIALIZER.header("action", action, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_upload_range_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "range")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    range = kwargs.pop('range')  # type: str
    content_length = kwargs.pop('content_length')  # type: int
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    file_range_write = kwargs.pop('file_range_write', "update")  # type: Union[str, "_models.FileRangeWriteType"]
    content_md5 = kwargs.pop('content_md5', None)  # type: Optional[bytearray]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-range'] = _SERIALIZER.header("range", range, 'str')
    _header_parameters['x-ms-write'] = _SERIALIZER.header("file_range_write", file_range_write, 'str')
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    if content_md5 is not None:
        _header_parameters['Content-MD5'] = _SERIALIZER.header("content_md5", content_md5, 'bytearray')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_upload_range_from_url_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "range")  # type: str
    file_range_write_from_url = kwargs.pop('file_range_write_from_url', "update")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    range = kwargs.pop('range')  # type: str
    copy_source = kwargs.pop('copy_source')  # type: str
    content_length = kwargs.pop('content_length')  # type: int
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    source_range = kwargs.pop('source_range', None)  # type: Optional[str]
    source_content_crc64 = kwargs.pop('source_content_crc64', None)  # type: Optional[bytearray]
    source_if_match_crc64 = kwargs.pop('source_if_match_crc64', None)  # type: Optional[bytearray]
    source_if_none_match_crc64 = kwargs.pop('source_if_none_match_crc64', None)  # type: Optional[bytearray]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    copy_source_authorization = kwargs.pop('copy_source_authorization', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-range'] = _SERIALIZER.header("range", range, 'str')
    _header_parameters['x-ms-copy-source'] = _SERIALIZER.header("copy_source", copy_source, 'str')
    if source_range is not None:
        _header_parameters['x-ms-source-range'] = _SERIALIZER.header("source_range", source_range, 'str')
    _header_parameters['x-ms-write'] = _SERIALIZER.header("file_range_write_from_url", file_range_write_from_url, 'str')
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    if source_content_crc64 is not None:
        _header_parameters['x-ms-source-content-crc64'] = _SERIALIZER.header("source_content_crc64", source_content_crc64, 'bytearray')
    if source_if_match_crc64 is not None:
        _header_parameters['x-ms-source-if-match-crc64'] = _SERIALIZER.header("source_if_match_crc64", source_if_match_crc64, 'bytearray')
    if source_if_none_match_crc64 is not None:
        _header_parameters['x-ms-source-if-none-match-crc64'] = _SERIALIZER.header("source_if_none_match_crc64", source_if_none_match_crc64, 'bytearray')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if copy_source_authorization is not None:
        _header_parameters['x-ms-copy-source-authorization'] = _SERIALIZER.header("copy_source_authorization", copy_source_authorization, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_range_list_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "rangelist")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    sharesnapshot = kwargs.pop('sharesnapshot', None)  # type: Optional[str]
    prevsharesnapshot = kwargs.pop('prevsharesnapshot', None)  # type: Optional[str]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    range = kwargs.pop('range', None)  # type: Optional[str]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if sharesnapshot is not None:
        _query_parameters['sharesnapshot'] = _SERIALIZER.query("sharesnapshot", sharesnapshot, 'str')
    if prevsharesnapshot is not None:
        _query_parameters['prevsharesnapshot'] = _SERIALIZER.query("prevsharesnapshot", prevsharesnapshot, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if range is not None:
        _header_parameters['x-ms-range'] = _SERIALIZER.header("range", range, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_start_copy_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    version = kwargs.pop('version', "2021-04-10")  # type: str
    copy_source = kwargs.pop('copy_source')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    file_permission = kwargs.pop('file_permission', "inherit")  # type: Optional[str]
    file_permission_key = kwargs.pop('file_permission_key', None)  # type: Optional[str]
    file_permission_copy_mode = kwargs.pop('file_permission_copy_mode', None)  # type: Optional[Union[str, "_models.PermissionCopyModeType"]]
    ignore_read_only = kwargs.pop('ignore_read_only', None)  # type: Optional[bool]
    file_attributes = kwargs.pop('file_attributes', None)  # type: Optional[str]
    file_creation_time = kwargs.pop('file_creation_time', None)  # type: Optional[str]
    file_last_write_time = kwargs.pop('file_last_write_time', None)  # type: Optional[str]
    set_archive_attribute = kwargs.pop('set_archive_attribute', None)  # type: Optional[bool]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    _header_parameters['x-ms-copy-source'] = _SERIALIZER.header("copy_source", copy_source, 'str')
    if file_permission is not None:
        _header_parameters['x-ms-file-permission'] = _SERIALIZER.header("file_permission", file_permission, 'str')
    if file_permission_key is not None:
        _header_parameters['x-ms-file-permission-key'] = _SERIALIZER.header("file_permission_key", file_permission_key, 'str')
    if file_permission_copy_mode is not None:
        _header_parameters['x-ms-file-permission-copy-mode'] = _SERIALIZER.header("file_permission_copy_mode", file_permission_copy_mode, 'str')
    if ignore_read_only is not None:
        _header_parameters['x-ms-file-copy-ignore-readonly'] = _SERIALIZER.header("ignore_read_only", ignore_read_only, 'bool')
    if file_attributes is not None:
        _header_parameters['x-ms-file-attributes'] = _SERIALIZER.header("file_attributes", file_attributes, 'str')
    if file_creation_time is not None:
        _header_parameters['x-ms-file-creation-time'] = _SERIALIZER.header("file_creation_time", file_creation_time, 'str')
    if file_last_write_time is not None:
        _header_parameters['x-ms-file-last-write-time'] = _SERIALIZER.header("file_last_write_time", file_last_write_time, 'str')
    if set_archive_attribute is not None:
        _header_parameters['x-ms-file-copy-set-archive'] = _SERIALIZER.header("set_archive_attribute", set_archive_attribute, 'bool')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_abort_copy_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "copy")  # type: str
    copy_action_abort_constant = kwargs.pop('copy_action_abort_constant', "abort")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    copy_id = kwargs.pop('copy_id')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    _query_parameters['copyid'] = _SERIALIZER.query("copy_id", copy_id, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-copy-action'] = _SERIALIZER.header("copy_action_abort_constant", copy_action_abort_constant, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_handles_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "listhandles")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    marker = kwargs.pop('marker', None)  # type: Optional[str]
    maxresults = kwargs.pop('maxresults', None)  # type: Optional[int]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    sharesnapshot = kwargs.pop('sharesnapshot', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if marker is not None:
        _query_parameters['marker'] = _SERIALIZER.query("marker", marker, 'str')
    if maxresults is not None:
        _query_parameters['maxresults'] = _SERIALIZER.query("maxresults", maxresults, 'int', minimum=1)
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)
    if sharesnapshot is not None:
        _query_parameters['sharesnapshot'] = _SERIALIZER.query("sharesnapshot", sharesnapshot, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_force_close_handles_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "forceclosehandles")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    handle_id = kwargs.pop('handle_id')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    marker = kwargs.pop('marker', None)  # type: Optional[str]
    sharesnapshot = kwargs.pop('sharesnapshot', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)
    if marker is not None:
        _query_parameters['marker'] = _SERIALIZER.query("marker", marker, 'str')
    if sharesnapshot is not None:
        _query_parameters['sharesnapshot'] = _SERIALIZER.query("sharesnapshot", sharesnapshot, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-handle-id'] = _SERIALIZER.header("handle_id", handle_id, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_rename_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "rename")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    rename_source = kwargs.pop('rename_source')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    replace_if_exists = kwargs.pop('replace_if_exists', None)  # type: Optional[bool]
    ignore_read_only = kwargs.pop('ignore_read_only', None)  # type: Optional[bool]
    source_lease_id = kwargs.pop('source_lease_id', None)  # type: Optional[str]
    destination_lease_id = kwargs.pop('destination_lease_id', None)  # type: Optional[str]
    file_attributes = kwargs.pop('file_attributes', None)  # type: Optional[str]
    file_creation_time = kwargs.pop('file_creation_time', None)  # type: Optional[str]
    file_last_write_time = kwargs.pop('file_last_write_time', None)  # type: Optional[str]
    file_permission = kwargs.pop('file_permission', "inherit")  # type: Optional[str]
    file_permission_key = kwargs.pop('file_permission_key', None)  # type: Optional[str]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}/{directory}/{fileName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    _header_parameters['x-ms-file-rename-source'] = _SERIALIZER.header("rename_source", rename_source, 'str')
    if replace_if_exists is not None:
        _header_parameters['x-ms-file-rename-replace-if-exists'] = _SERIALIZER.header("replace_if_exists", replace_if_exists, 'bool')
    if ignore_read_only is not None:
        _header_parameters['x-ms-file-rename-ignore-readonly'] = _SERIALIZER.header("ignore_read_only", ignore_read_only, 'bool')
    if source_lease_id is not None:
        _header_parameters['x-ms-source-lease-id'] = _SERIALIZER.header("source_lease_id", source_lease_id, 'str')
    if destination_lease_id is not None:
        _header_parameters['x-ms-destination-lease-id'] = _SERIALIZER.header("destination_lease_id", destination_lease_id, 'str')
    if file_attributes is not None:
        _header_parameters['x-ms-file-attributes'] = _SERIALIZER.header("file_attributes", file_attributes, 'str')
    if file_creation_time is not None:
        _header_parameters['x-ms-file-creation-time'] = _SERIALIZER.header("file_creation_time", file_creation_time, 'str')
    if file_last_write_time is not None:
        _header_parameters['x-ms-file-last-write-time'] = _SERIALIZER.header("file_last_write_time", file_last_write_time, 'str')
    if file_permission is not None:
        _header_parameters['x-ms-file-permission'] = _SERIALIZER.header("file_permission", file_permission, 'str')
    if file_permission_key is not None:
        _header_parameters['x-ms-file-permission-key'] = _SERIALIZER.header("file_permission_key", file_permission_key, 'str')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class FileOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.AzureFileStorage`'s
        :attr:`file` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace
    def create(  # pylint: disable=inconsistent-return-statements
        self,
        file_content_length,  # type: int
        timeout=None,  # type: Optional[int]
        metadata=None,  # type: Optional[Dict[str, str]]
        file_permission="inherit",  # type: Optional[str]
        file_permission_key=None,  # type: Optional[str]
        file_attributes="none",  # type: str
        file_creation_time="now",  # type: str
        file_last_write_time="now",  # type: str
        file_http_headers=None,  # type: Optional["_models.FileHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Creates a new file or replaces a file. Note it only initializes the file with no content.

        :param file_content_length: Specifies the maximum size for the file, up to 4 TB.
        :type file_content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_http_headers: Parameter group. Default value is None.
        :type file_http_headers: ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword file_type_constant: Dummy constant parameter, file type can only be file. Default
         value is "file". Note that overriding this default value may result in unsupported behavior.
        :paramtype file_type_constant: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        file_type_constant = kwargs.pop('file_type_constant', "file")  # type: str

        _file_content_type = None
        _file_content_encoding = None
        _file_content_language = None
        _file_cache_control = None
        _file_content_md5 = None
        _file_content_disposition = None
        _lease_id = None
        if file_http_headers is not None:
            _file_content_type = file_http_headers.file_content_type
            _file_content_encoding = file_http_headers.file_content_encoding
            _file_content_language = file_http_headers.file_content_language
            _file_cache_control = file_http_headers.file_cache_control
            _file_content_md5 = file_http_headers.file_content_md5
            _file_content_disposition = file_http_headers.file_content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_create_request(
            url=self._config.url,
            version=self._config.version,
            file_type_constant=file_type_constant,
            file_content_length=file_content_length,
            timeout=timeout,
            file_content_type=_file_content_type,
            file_content_encoding=_file_content_encoding,
            file_content_language=_file_content_language,
            file_cache_control=_file_cache_control,
            file_content_md5=_file_content_md5,
            file_content_disposition=_file_content_disposition,
            metadata=metadata,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            lease_id=_lease_id,
            template_url=self.create.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def download(
        self,
        timeout=None,  # type: Optional[int]
        range=None,  # type: Optional[str]
        range_get_content_md5=None,  # type: Optional[bool]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> IO
        """Reads or downloads a file from the system, including its metadata and properties.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param range: Return file data only from the specified byte range. Default value is None.
        :type range: str
        :param range_get_content_md5: When this header is set to true and specified together with the
         Range header, the service returns the MD5 hash for the range, as long as the range is less than
         or equal to 4 MB in size. Default value is None.
        :type range_get_content_md5: bool
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_download_request(
            url=self._config.url,
            version=self._config.version,
            timeout=timeout,
            range=range,
            range_get_content_md5=range_get_content_md5,
            lease_id=_lease_id,
            template_url=self.download.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=True,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-content-md5'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
            response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
            response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
            response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
            response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
            response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
            response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            
            deserialized = response.stream_download(self._client._pipeline)

        if response.status_code == 206:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-content-md5'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
            response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
            response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
            response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
            response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
            response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
            response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    download.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def get_properties(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Returns all user-defined metadata, standard HTTP properties, and system properties for the
        file. It does not return the content of the file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_properties_request(
            url=self._config.url,
            version=self._config.version,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.get_properties.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
        response_headers['x-ms-type']=self._deserialize('str', response.headers.get('x-ms-type'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
        response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
        response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
        response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
        response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
        response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
        response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
        response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
        response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
        response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        timeout=None,  # type: Optional[int]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """removes the file from the storage account.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_delete_request(
            url=self._config.url,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def set_http_headers(  # pylint: disable=inconsistent-return-statements
        self,
        timeout=None,  # type: Optional[int]
        file_content_length=None,  # type: Optional[int]
        file_permission="inherit",  # type: Optional[str]
        file_permission_key=None,  # type: Optional[str]
        file_attributes="none",  # type: str
        file_creation_time="now",  # type: str
        file_last_write_time="now",  # type: str
        file_http_headers=None,  # type: Optional["_models.FileHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Sets HTTP headers on the file.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param file_content_length: Resizes a file to the specified size. If the specified byte value
         is less than the current size of the file, then all ranges above the specified byte value are
         cleared. Default value is None.
        :type file_content_length: long
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_http_headers: Parameter group. Default value is None.
        :type file_http_headers: ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "properties". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "properties")  # type: str

        _file_content_type = None
        _file_content_encoding = None
        _file_content_language = None
        _file_cache_control = None
        _file_content_md5 = None
        _file_content_disposition = None
        _lease_id = None
        if file_http_headers is not None:
            _file_content_type = file_http_headers.file_content_type
            _file_content_encoding = file_http_headers.file_content_encoding
            _file_content_language = file_http_headers.file_content_language
            _file_cache_control = file_http_headers.file_cache_control
            _file_content_md5 = file_http_headers.file_content_md5
            _file_content_disposition = file_http_headers.file_content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_http_headers_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            file_content_length=file_content_length,
            file_content_type=_file_content_type,
            file_content_encoding=_file_content_encoding,
            file_content_language=_file_content_language,
            file_cache_control=_file_cache_control,
            file_content_md5=_file_content_md5,
            file_content_disposition=_file_content_disposition,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            lease_id=_lease_id,
            template_url=self.set_http_headers.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_http_headers.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def set_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        timeout=None,  # type: Optional[int]
        metadata=None,  # type: Optional[Dict[str, str]]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Updates user-defined metadata for the specified file.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "metadata". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "metadata")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_metadata_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            metadata=metadata,
            lease_id=_lease_id,
            template_url=self.set_metadata.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_metadata.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def acquire_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout=None,  # type: Optional[int]
        duration=None,  # type: Optional[int]
        proposed_lease_id=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "acquire". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "acquire")  # type: str

        
        request = build_acquire_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.acquire_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    acquire_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def release_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id,  # type: str
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "release". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "release")  # type: str

        
        request = build_release_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            template_url=self.release_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    release_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def change_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id,  # type: str
        timeout=None,  # type: Optional[int]
        proposed_lease_id=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "change". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "change")  # type: str

        
        request = build_change_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            proposed_lease_id=proposed_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.change_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    change_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def break_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "break". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "break")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_break_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.break_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    break_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def upload_range(  # pylint: disable=inconsistent-return-statements
        self,
        range,  # type: str
        content_length,  # type: int
        timeout=None,  # type: Optional[int]
        file_range_write="update",  # type: Union[str, "_models.FileRangeWriteType"]
        content_md5=None,  # type: Optional[bytearray]
        optionalbody=None,  # type: Optional[IO]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Upload a range of bytes to a file.

        :param range: Specifies the range of bytes to be written. Both the start and end of the range
         must be specified. For an update operation, the range can be up to 4 MB in size. For a clear
         operation, the range can be up to the value of the file's full size. The File service accepts
         only a single byte range for the Range and 'x-ms-range' headers, and the byte range must be
         specified in the following format: bytes=startByte-endByte.
        :type range: str
        :param content_length: Specifies the number of bytes being transmitted in the request body.
         When the x-ms-write header is set to clear, the value of this header must be set to zero.
        :type content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param file_range_write: Specify one of the following options: - Update: Writes the bytes
         specified by the request body into the specified range. The Range and Content-Length headers
         must match to perform the update. - Clear: Clears the specified range and releases the space
         used in storage for that range. To clear a range, set the Content-Length header to zero, and
         set the Range header to a value that indicates the range to clear, up to maximum file size.
         Default value is "update".
        :type file_range_write: str or ~azure.storage.fileshare.models.FileRangeWriteType
        :param content_md5: An MD5 hash of the content. This hash is used to verify the integrity of
         the data during transport. When the Content-MD5 header is specified, the File service compares
         the hash of the content that has arrived with the header value that was sent. If the two hashes
         do not match, the operation will fail with error code 400 (Bad Request). Default value is None.
        :type content_md5: bytearray
        :param optionalbody: Initial data. Default value is None.
        :type optionalbody: IO
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "range". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "range")  # type: str
        content_type = kwargs.pop('content_type', "application/octet-stream")  # type: Optional[str]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        _content = optionalbody

        request = build_upload_range_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            content_type=content_type,
            range=range,
            content_length=content_length,
            content=_content,
            timeout=timeout,
            file_range_write=file_range_write,
            content_md5=content_md5,
            lease_id=_lease_id,
            template_url=self.upload_range.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    upload_range.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def upload_range_from_url(  # pylint: disable=inconsistent-return-statements
        self,
        range,  # type: str
        copy_source,  # type: str
        content_length,  # type: int
        timeout=None,  # type: Optional[int]
        source_range=None,  # type: Optional[str]
        source_content_crc64=None,  # type: Optional[bytearray]
        copy_source_authorization=None,  # type: Optional[str]
        source_modified_access_conditions=None,  # type: Optional["_models.SourceModifiedAccessConditions"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Upload a range of bytes to a file where the contents are read from a URL.

        :param range: Writes data to the specified byte range in the file.
        :type range: str
        :param copy_source: Specifies the URL of the source file or blob, up to 2 KB in length. To copy
         a file to another file within the same storage account, you may use Shared Key to authenticate
         the source file. If you are copying a file from another storage account, or if you are copying
         a blob from the same storage account or another storage account, then you must authenticate the
         source file or blob using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a share snapshot can also
         be specified as a copy source.
        :type copy_source: str
        :param content_length: Specifies the number of bytes being transmitted in the request body.
         When the x-ms-write header is set to clear, the value of this header must be set to zero.
        :type content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param source_range: Bytes of source data in the specified range. Default value is None.
        :type source_range: str
        :param source_content_crc64: Specify the crc64 calculated for the range of bytes that must be
         read from the copy source. Default value is None.
        :type source_content_crc64: bytearray
        :param copy_source_authorization: Only Bearer type is supported. Credentials should be a valid
         OAuth access token to copy source. Default value is None.
        :type copy_source_authorization: str
        :param source_modified_access_conditions: Parameter group. Default value is None.
        :type source_modified_access_conditions:
         ~azure.storage.fileshare.models.SourceModifiedAccessConditions
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "range". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "range")  # type: str

        _source_if_match_crc64 = None
        _source_if_none_match_crc64 = None
        _lease_id = None
        if source_modified_access_conditions is not None:
            _source_if_match_crc64 = source_modified_access_conditions.source_if_match_crc64
            _source_if_none_match_crc64 = source_modified_access_conditions.source_if_none_match_crc64
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_upload_range_from_url_request(
            url=self._config.url,
            comp=comp,
            file_range_write_from_url=self._config.file_range_write_from_url,
            version=self._config.version,
            range=range,
            copy_source=copy_source,
            content_length=content_length,
            timeout=timeout,
            source_range=source_range,
            source_content_crc64=source_content_crc64,
            source_if_match_crc64=_source_if_match_crc64,
            source_if_none_match_crc64=_source_if_none_match_crc64,
            lease_id=_lease_id,
            copy_source_authorization=copy_source_authorization,
            template_url=self.upload_range_from_url.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    upload_range_from_url.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def get_range_list(
        self,
        sharesnapshot=None,  # type: Optional[str]
        prevsharesnapshot=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        range=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ShareFileRangeList"
        """Returns the list of valid ranges for a file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param prevsharesnapshot: The previous snapshot parameter is an opaque DateTime value that,
         when present, specifies the previous snapshot. Default value is None.
        :type prevsharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param range: Specifies the range of bytes over which to list ranges, inclusively. Default
         value is None.
        :type range: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "rangelist". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareFileRangeList, or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ShareFileRangeList
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ShareFileRangeList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "rangelist")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_range_list_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            sharesnapshot=sharesnapshot,
            prevsharesnapshot=prevsharesnapshot,
            timeout=timeout,
            range=range,
            lease_id=_lease_id,
            template_url=self.get_range_list.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['x-ms-content-length']=self._deserialize('long', response.headers.get('x-ms-content-length'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ShareFileRangeList', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_range_list.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def start_copy(  # pylint: disable=inconsistent-return-statements
        self,
        copy_source,  # type: str
        timeout=None,  # type: Optional[int]
        metadata=None,  # type: Optional[Dict[str, str]]
        file_permission="inherit",  # type: Optional[str]
        file_permission_key=None,  # type: Optional[str]
        copy_file_smb_info=None,  # type: Optional["_models.CopyFileSmbInfo"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Copies a blob or file to a destination file within the storage account.

        :param copy_source: Specifies the URL of the source file or blob, up to 2 KB in length. To copy
         a file to another file within the same storage account, you may use Shared Key to authenticate
         the source file. If you are copying a file from another storage account, or if you are copying
         a blob from the same storage account or another storage account, then you must authenticate the
         source file or blob using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a share snapshot can also
         be specified as a copy source.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param copy_file_smb_info: Parameter group. Default value is None.
        :type copy_file_smb_info: ~azure.storage.fileshare.models.CopyFileSmbInfo
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _file_permission_copy_mode = None
        _ignore_read_only = None
        _file_attributes = None
        _file_creation_time = None
        _file_last_write_time = None
        _set_archive_attribute = None
        _lease_id = None
        if copy_file_smb_info is not None:
            _file_permission_copy_mode = copy_file_smb_info.file_permission_copy_mode
            _ignore_read_only = copy_file_smb_info.ignore_read_only
            _file_attributes = copy_file_smb_info.file_attributes
            _file_creation_time = copy_file_smb_info.file_creation_time
            _file_last_write_time = copy_file_smb_info.file_last_write_time
            _set_archive_attribute = copy_file_smb_info.set_archive_attribute
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_start_copy_request(
            url=self._config.url,
            version=self._config.version,
            copy_source=copy_source,
            timeout=timeout,
            metadata=metadata,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_permission_copy_mode=_file_permission_copy_mode,
            ignore_read_only=_ignore_read_only,
            file_attributes=_file_attributes,
            file_creation_time=_file_creation_time,
            file_last_write_time=_file_last_write_time,
            set_archive_attribute=_set_archive_attribute,
            lease_id=_lease_id,
            template_url=self.start_copy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    start_copy.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def abort_copy(  # pylint: disable=inconsistent-return-statements
        self,
        copy_id,  # type: str
        timeout=None,  # type: Optional[int]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Aborts a pending Copy File operation, and leaves a destination file with zero length and full
        metadata.

        :param copy_id: The copy identifier provided in the x-ms-copy-id header of the original Copy
         File operation.
        :type copy_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "copy". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword copy_action_abort_constant: Abort. Default value is "abort". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype copy_action_abort_constant: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "copy")  # type: str
        copy_action_abort_constant = kwargs.pop('copy_action_abort_constant', "abort")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_abort_copy_request(
            url=self._config.url,
            comp=comp,
            copy_action_abort_constant=copy_action_abort_constant,
            version=self._config.version,
            copy_id=copy_id,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.abort_copy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    abort_copy.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def list_handles(
        self,
        marker=None,  # type: Optional[str]
        maxresults=None,  # type: Optional[int]
        timeout=None,  # type: Optional[int]
        sharesnapshot=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ListHandlesResponse"
        """Lists handles for file.

        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of entries to return. If the request does not
         specify maxresults, or specifies a value greater than 5,000, the server will return up to 5,000
         items. Default value is None.
        :type maxresults: int
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :keyword comp: comp. Default value is "listhandles". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListHandlesResponse, or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ListHandlesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ListHandlesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "listhandles")  # type: str

        
        request = build_list_handles_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            marker=marker,
            maxresults=maxresults,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            template_url=self.list_handles.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ListHandlesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    list_handles.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def force_close_handles(  # pylint: disable=inconsistent-return-statements
        self,
        handle_id,  # type: str
        timeout=None,  # type: Optional[int]
        marker=None,  # type: Optional[str]
        sharesnapshot=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Closes all handles open for given file.

        :param handle_id: Specifies handle ID opened on the file or directory to be closed. Asterisk
         (‘*’) is a wildcard that specifies all handles.
        :type handle_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :keyword comp: comp. Default value is "forceclosehandles". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "forceclosehandles")  # type: str

        
        request = build_force_close_handles_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            handle_id=handle_id,
            timeout=timeout,
            marker=marker,
            sharesnapshot=sharesnapshot,
            template_url=self.force_close_handles.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-marker']=self._deserialize('str', response.headers.get('x-ms-marker'))
        response_headers['x-ms-number-of-handles-closed']=self._deserialize('int', response.headers.get('x-ms-number-of-handles-closed'))
        response_headers['x-ms-number-of-handles-failed']=self._deserialize('int', response.headers.get('x-ms-number-of-handles-failed'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    force_close_handles.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace
    def rename(  # pylint: disable=inconsistent-return-statements
        self,
        rename_source,  # type: str
        timeout=None,  # type: Optional[int]
        replace_if_exists=None,  # type: Optional[bool]
        ignore_read_only=None,  # type: Optional[bool]
        file_permission="inherit",  # type: Optional[str]
        file_permission_key=None,  # type: Optional[str]
        metadata=None,  # type: Optional[Dict[str, str]]
        source_lease_access_conditions=None,  # type: Optional["_models.SourceLeaseAccessConditions"]
        destination_lease_access_conditions=None,  # type: Optional["_models.DestinationLeaseAccessConditions"]
        copy_file_smb_info=None,  # type: Optional["_models.CopyFileSmbInfo"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Renames a file.

        :param rename_source: Required. Specifies the URI-style path of the source file, up to 2 KB in
         length.
        :type rename_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param replace_if_exists: Optional. A boolean value for if the destination file already exists,
         whether this request will overwrite the file or not. If true, the rename will succeed and will
         overwrite the destination file. If not provided or if false and the destination file does
         exist, the request will not overwrite the destination file. If provided and the destination
         file doesn’t exist, the rename will succeed. Note: This value does not override the
         x-ms-file-copy-ignore-read-only header value. Default value is None.
        :type replace_if_exists: bool
        :param ignore_read_only: Optional. A boolean value that specifies whether the ReadOnly
         attribute on a preexisting destination file should be respected. If true, the rename will
         succeed, otherwise, a previous file at the destination with the ReadOnly attribute set will
         cause the rename to fail. Default value is None.
        :type ignore_read_only: bool
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param source_lease_access_conditions: Parameter group. Default value is None.
        :type source_lease_access_conditions:
         ~azure.storage.fileshare.models.SourceLeaseAccessConditions
        :param destination_lease_access_conditions: Parameter group. Default value is None.
        :type destination_lease_access_conditions:
         ~azure.storage.fileshare.models.DestinationLeaseAccessConditions
        :param copy_file_smb_info: Parameter group. Default value is None.
        :type copy_file_smb_info: ~azure.storage.fileshare.models.CopyFileSmbInfo
        :keyword comp: comp. Default value is "rename". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "rename")  # type: str

        _source_lease_id = None
        _destination_lease_id = None
        _file_attributes = None
        _file_creation_time = None
        _file_last_write_time = None
        if source_lease_access_conditions is not None:
            _source_lease_id = source_lease_access_conditions.source_lease_id
        if destination_lease_access_conditions is not None:
            _destination_lease_id = destination_lease_access_conditions.destination_lease_id
        if copy_file_smb_info is not None:
            _file_attributes = copy_file_smb_info.file_attributes
            _file_creation_time = copy_file_smb_info.file_creation_time
            _file_last_write_time = copy_file_smb_info.file_last_write_time

        request = build_rename_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            rename_source=rename_source,
            timeout=timeout,
            replace_if_exists=replace_if_exists,
            ignore_read_only=ignore_read_only,
            source_lease_id=_source_lease_id,
            destination_lease_id=_destination_lease_id,
            file_attributes=_file_attributes,
            file_creation_time=_file_creation_time,
            file_last_write_time=_file_last_write_time,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            metadata=metadata,
            template_url=self.rename.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    rename.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore

