# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._security_insights_enums import *


class DataConnectorsCheckRequirements(msrest.serialization.Model):
    """Data connector requirements properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AwsCloudTrailCheckRequirements, AwsS3CheckRequirements, AADCheckRequirements, AATPCheckRequirements, ASCCheckRequirements, Dynamics365CheckRequirements, IoTCheckRequirements, MCASCheckRequirements, MDATPCheckRequirements, MSTICheckRequirements, MtpCheckRequirements, Office365ProjectCheckRequirements, OfficeATPCheckRequirements, OfficeIRMCheckRequirements, OfficePowerBICheckRequirements, TICheckRequirements, TiTaxiiCheckRequirements.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AmazonWebServicesCloudTrail': 'AwsCloudTrailCheckRequirements', 'AmazonWebServicesS3': 'AwsS3CheckRequirements', 'AzureActiveDirectory': 'AADCheckRequirements', 'AzureAdvancedThreatProtection': 'AATPCheckRequirements', 'AzureSecurityCenter': 'ASCCheckRequirements', 'Dynamics365': 'Dynamics365CheckRequirements', 'IOT': 'IoTCheckRequirements', 'MicrosoftCloudAppSecurity': 'MCASCheckRequirements', 'MicrosoftDefenderAdvancedThreatProtection': 'MDATPCheckRequirements', 'MicrosoftThreatIntelligence': 'MSTICheckRequirements', 'MicrosoftThreatProtection': 'MtpCheckRequirements', 'Office365Project': 'Office365ProjectCheckRequirements', 'OfficeATP': 'OfficeATPCheckRequirements', 'OfficeIRM': 'OfficeIRMCheckRequirements', 'OfficePowerBI': 'OfficePowerBICheckRequirements', 'ThreatIntelligence': 'TICheckRequirements', 'ThreatIntelligenceTaxii': 'TiTaxiiCheckRequirements'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DataConnectorsCheckRequirements, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AADCheckRequirements(DataConnectorsCheckRequirements):
    """Represents AAD (Azure Active Directory) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AADCheckRequirements, self).__init__(**kwargs)
        self.kind = 'AzureActiveDirectory'  # type: str
        self.tenant_id = tenant_id


class DataConnectorTenantId(msrest.serialization.Model):
    """Properties data connector on tenant level.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(DataConnectorTenantId, self).__init__(**kwargs)
        self.tenant_id = tenant_id


class AADCheckRequirementsProperties(DataConnectorTenantId):
    """AAD (Azure Active Directory) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AADCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ResourceWithEtag(Resource):
    """An azure resource object with an Etag property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(ResourceWithEtag, self).__init__(**kwargs)
        self.etag = etag


class DataConnector(ResourceWithEtag):
    """Data connector.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CodelessApiPollingDataConnector, AwsCloudTrailDataConnector, AwsS3DataConnector, AADDataConnector, AATPDataConnector, ASCDataConnector, Dynamics365DataConnector, CodelessUiDataConnector, IoTDataConnector, MCASDataConnector, MDATPDataConnector, MSTIDataConnector, MTPDataConnector, OfficeDataConnector, Office365ProjectDataConnector, OfficeATPDataConnector, OfficeIRMDataConnector, OfficePowerBIDataConnector, TIDataConnector, TiTaxiiDataConnector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'APIPolling': 'CodelessApiPollingDataConnector', 'AmazonWebServicesCloudTrail': 'AwsCloudTrailDataConnector', 'AmazonWebServicesS3': 'AwsS3DataConnector', 'AzureActiveDirectory': 'AADDataConnector', 'AzureAdvancedThreatProtection': 'AATPDataConnector', 'AzureSecurityCenter': 'ASCDataConnector', 'Dynamics365': 'Dynamics365DataConnector', 'GenericUI': 'CodelessUiDataConnector', 'IOT': 'IoTDataConnector', 'MicrosoftCloudAppSecurity': 'MCASDataConnector', 'MicrosoftDefenderAdvancedThreatProtection': 'MDATPDataConnector', 'MicrosoftThreatIntelligence': 'MSTIDataConnector', 'MicrosoftThreatProtection': 'MTPDataConnector', 'Office365': 'OfficeDataConnector', 'Office365Project': 'Office365ProjectDataConnector', 'OfficeATP': 'OfficeATPDataConnector', 'OfficeIRM': 'OfficeIRMDataConnector', 'OfficePowerBI': 'OfficePowerBIDataConnector', 'ThreatIntelligence': 'TIDataConnector', 'ThreatIntelligenceTaxii': 'TiTaxiiDataConnector'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(DataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'DataConnector'  # type: str


class AADDataConnector(DataConnector):
    """Represents AAD (Azure Active Directory) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(AADDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureActiveDirectory'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class DataConnectorWithAlertsProperties(msrest.serialization.Model):
    """Data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(DataConnectorWithAlertsProperties, self).__init__(**kwargs)
        self.data_types = data_types


class AADDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """AAD (Azure Active Directory) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AADDataConnectorProperties, self).__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class AATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents AATP (Azure Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AATPCheckRequirements, self).__init__(**kwargs)
        self.kind = 'AzureAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id


class AATPCheckRequirementsProperties(DataConnectorTenantId):
    """AATP (Azure Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AATPCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class AATPDataConnector(DataConnector):
    """Represents AATP (Azure Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(AATPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class AATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """AATP (Azure Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(AATPDataConnectorProperties, self).__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class Entity(Resource):
    """Specific entity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountEntity, AzureResourceEntity, HuntingBookmark, CloudApplicationEntity, DnsEntity, FileEntity, FileHashEntity, HostEntity, IoTDeviceEntity, IpEntity, MailClusterEntity, MailMessageEntity, MailboxEntity, MalwareEntity, ProcessEntity, RegistryKeyEntity, RegistryValueEntity, SecurityAlert, SecurityGroupEntity, SubmissionMailEntity, UrlEntity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Account': 'AccountEntity', 'AzureResource': 'AzureResourceEntity', 'Bookmark': 'HuntingBookmark', 'CloudApplication': 'CloudApplicationEntity', 'DnsResolution': 'DnsEntity', 'File': 'FileEntity', 'FileHash': 'FileHashEntity', 'Host': 'HostEntity', 'IoTDevice': 'IoTDeviceEntity', 'Ip': 'IpEntity', 'MailCluster': 'MailClusterEntity', 'MailMessage': 'MailMessageEntity', 'Mailbox': 'MailboxEntity', 'Malware': 'MalwareEntity', 'Process': 'ProcessEntity', 'RegistryKey': 'RegistryKeyEntity', 'RegistryValue': 'RegistryValueEntity', 'SecurityAlert': 'SecurityAlert', 'SecurityGroup': 'SecurityGroupEntity', 'SubmissionMail': 'SubmissionMailEntity', 'Url': 'UrlEntity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Entity, self).__init__(**kwargs)
        self.kind = 'Entity'  # type: str


class AccountEntity(Entity):
    """Represents an account entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar aad_tenant_id: The Azure Active Directory tenant id.
    :vartype aad_tenant_id: str
    :ivar aad_user_id: The Azure Active Directory user id.
    :vartype aad_user_id: str
    :ivar account_name: The name of the account. This field should hold only the name without any
     domain added to it, i.e. administrator.
    :vartype account_name: str
    :ivar display_name: The display name of the account.
    :vartype display_name: str
    :ivar host_entity_id: The Host entity id that contains the account in case it is a local
     account (not domain joined).
    :vartype host_entity_id: str
    :ivar is_domain_joined: Determines whether this is a domain account.
    :vartype is_domain_joined: bool
    :ivar nt_domain: The NetBIOS domain name as it appears in the alert format domain/username.
     Examples: NT AUTHORITY.
    :vartype nt_domain: str
    :ivar object_guid: The objectGUID attribute is a single-value attribute that is the unique
     identifier for the object, assigned by active directory.
    :vartype object_guid: str
    :ivar puid: The Azure Active Directory Passport User ID.
    :vartype puid: str
    :ivar sid: The account security identifier, e.g. S-1-5-18.
    :vartype sid: str
    :ivar upn_suffix: The user principal name suffix for the account, in some cases it is also the
     domain name. Examples: contoso.com.
    :vartype upn_suffix: str
    :ivar dns_domain: The fully qualified domain DNS name.
    :vartype dns_domain: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'aad_tenant_id': {'readonly': True},
        'aad_user_id': {'readonly': True},
        'account_name': {'readonly': True},
        'display_name': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'is_domain_joined': {'readonly': True},
        'nt_domain': {'readonly': True},
        'object_guid': {'readonly': True},
        'puid': {'readonly': True},
        'sid': {'readonly': True},
        'upn_suffix': {'readonly': True},
        'dns_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'aad_tenant_id': {'key': 'properties.aadTenantId', 'type': 'str'},
        'aad_user_id': {'key': 'properties.aadUserId', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'host_entity_id': {'key': 'properties.hostEntityId', 'type': 'str'},
        'is_domain_joined': {'key': 'properties.isDomainJoined', 'type': 'bool'},
        'nt_domain': {'key': 'properties.ntDomain', 'type': 'str'},
        'object_guid': {'key': 'properties.objectGuid', 'type': 'str'},
        'puid': {'key': 'properties.puid', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'upn_suffix': {'key': 'properties.upnSuffix', 'type': 'str'},
        'dns_domain': {'key': 'properties.dnsDomain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AccountEntity, self).__init__(**kwargs)
        self.kind = 'Account'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.aad_tenant_id = None
        self.aad_user_id = None
        self.account_name = None
        self.display_name = None
        self.host_entity_id = None
        self.is_domain_joined = None
        self.nt_domain = None
        self.object_guid = None
        self.puid = None
        self.sid = None
        self.upn_suffix = None
        self.dns_domain = None


class EntityCommonProperties(msrest.serialization.Model):
    """Entity common property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EntityCommonProperties, self).__init__(**kwargs)
        self.additional_data = None
        self.friendly_name = None


class AccountEntityProperties(EntityCommonProperties):
    """Account entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar aad_tenant_id: The Azure Active Directory tenant id.
    :vartype aad_tenant_id: str
    :ivar aad_user_id: The Azure Active Directory user id.
    :vartype aad_user_id: str
    :ivar account_name: The name of the account. This field should hold only the name without any
     domain added to it, i.e. administrator.
    :vartype account_name: str
    :ivar display_name: The display name of the account.
    :vartype display_name: str
    :ivar host_entity_id: The Host entity id that contains the account in case it is a local
     account (not domain joined).
    :vartype host_entity_id: str
    :ivar is_domain_joined: Determines whether this is a domain account.
    :vartype is_domain_joined: bool
    :ivar nt_domain: The NetBIOS domain name as it appears in the alert format domain/username.
     Examples: NT AUTHORITY.
    :vartype nt_domain: str
    :ivar object_guid: The objectGUID attribute is a single-value attribute that is the unique
     identifier for the object, assigned by active directory.
    :vartype object_guid: str
    :ivar puid: The Azure Active Directory Passport User ID.
    :vartype puid: str
    :ivar sid: The account security identifier, e.g. S-1-5-18.
    :vartype sid: str
    :ivar upn_suffix: The user principal name suffix for the account, in some cases it is also the
     domain name. Examples: contoso.com.
    :vartype upn_suffix: str
    :ivar dns_domain: The fully qualified domain DNS name.
    :vartype dns_domain: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'aad_tenant_id': {'readonly': True},
        'aad_user_id': {'readonly': True},
        'account_name': {'readonly': True},
        'display_name': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'is_domain_joined': {'readonly': True},
        'nt_domain': {'readonly': True},
        'object_guid': {'readonly': True},
        'puid': {'readonly': True},
        'sid': {'readonly': True},
        'upn_suffix': {'readonly': True},
        'dns_domain': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'aad_user_id': {'key': 'aadUserId', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'host_entity_id': {'key': 'hostEntityId', 'type': 'str'},
        'is_domain_joined': {'key': 'isDomainJoined', 'type': 'bool'},
        'nt_domain': {'key': 'ntDomain', 'type': 'str'},
        'object_guid': {'key': 'objectGuid', 'type': 'str'},
        'puid': {'key': 'puid', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
        'upn_suffix': {'key': 'upnSuffix', 'type': 'str'},
        'dns_domain': {'key': 'dnsDomain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AccountEntityProperties, self).__init__(**kwargs)
        self.aad_tenant_id = None
        self.aad_user_id = None
        self.account_name = None
        self.display_name = None
        self.host_entity_id = None
        self.is_domain_joined = None
        self.nt_domain = None
        self.object_guid = None
        self.puid = None
        self.sid = None
        self.upn_suffix = None
        self.dns_domain = None


class ActionPropertiesBase(msrest.serialization.Model):
    """Action property bag base.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Required. Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        **kwargs
    ):
        """
        :keyword logic_app_resource_id: Required. Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        """
        super(ActionPropertiesBase, self).__init__(**kwargs)
        self.logic_app_resource_id = logic_app_resource_id


class ActionRequest(ResourceWithEtag):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar trigger_uri: Logic App Callback URL for this specific workflow.
    :vartype trigger_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'logic_app_resource_id': {'key': 'properties.logicAppResourceId', 'type': 'str'},
        'trigger_uri': {'key': 'properties.triggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        trigger_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword trigger_uri: Logic App Callback URL for this specific workflow.
        :paramtype trigger_uri: str
        """
        super(ActionRequest, self).__init__(etag=etag, **kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.trigger_uri = trigger_uri


class ActionRequestProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Required. Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar trigger_uri: Required. Logic App Callback URL for this specific workflow.
    :vartype trigger_uri: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
        'trigger_uri': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'trigger_uri': {'key': 'triggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        trigger_uri: str,
        **kwargs
    ):
        """
        :keyword logic_app_resource_id: Required. Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword trigger_uri: Required. Logic App Callback URL for this specific workflow.
        :paramtype trigger_uri: str
        """
        super(ActionRequestProperties, self).__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.trigger_uri = trigger_uri


class ActionResponse(ResourceWithEtag):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar workflow_id: The name of the logic app's workflow.
    :vartype workflow_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'logic_app_resource_id': {'key': 'properties.logicAppResourceId', 'type': 'str'},
        'workflow_id': {'key': 'properties.workflowId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        workflow_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword workflow_id: The name of the logic app's workflow.
        :paramtype workflow_id: str
        """
        super(ActionResponse, self).__init__(etag=etag, **kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.workflow_id = workflow_id


class ActionResponseProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Required. Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar workflow_id: The name of the logic app's workflow.
    :vartype workflow_id: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'workflow_id': {'key': 'workflowId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        workflow_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword logic_app_resource_id: Required. Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword workflow_id: The name of the logic app's workflow.
        :paramtype workflow_id: str
        """
        super(ActionResponseProperties, self).__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.workflow_id = workflow_id


class ActionsList(msrest.serialization.Model):
    """List all the actions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of actions.
    :vartype next_link: str
    :ivar value: Required. Array of actions.
    :vartype value: list[~azure.mgmt.securityinsight.models.ActionResponse]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ActionResponse]'},
    }

    def __init__(
        self,
        *,
        value: List["ActionResponse"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of actions.
        :paramtype value: list[~azure.mgmt.securityinsight.models.ActionResponse]
        """
        super(ActionsList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class CustomEntityQuery(ResourceWithEtag):
    """Specific entity query that supports put requests.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActivityCustomEntityQuery.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. the entity query kind.Constant filled by server. Possible values include:
     "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.CustomEntityQueryKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Activity': 'ActivityCustomEntityQuery'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(CustomEntityQuery, self).__init__(etag=etag, **kwargs)
        self.kind = 'CustomEntityQuery'  # type: str


class ActivityCustomEntityQuery(CustomEntityQuery):
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. the entity query kind.Constant filled by server. Possible values include:
     "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.CustomEntityQueryKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
    :ivar input_entity_type: The type of the query's source entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    :ivar template_name: The template id this activity was created from.
    :vartype template_name: str
    :ivar enabled: Determines whether this activity is enabled or disabled.
    :vartype enabled: bool
    :ivar created_time_utc: The time the activity was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the activity was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'created_time_utc': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'query_definitions': {'key': 'properties.queryDefinitions', 'type': 'ActivityEntityQueriesPropertiesQueryDefinitions'},
        'input_entity_type': {'key': 'properties.inputEntityType', 'type': 'str'},
        'required_input_fields_sets': {'key': 'properties.requiredInputFieldsSets', 'type': '[[str]]'},
        'entities_filter': {'key': 'properties.entitiesFilter', 'type': '{[str]}'},
        'template_name': {'key': 'properties.templateName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["ActivityEntityQueriesPropertiesQueryDefinitions"] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
        :keyword input_entity_type: The type of the query's source entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        :keyword template_name: The template id this activity was created from.
        :paramtype template_name: str
        :keyword enabled: Determines whether this activity is enabled or disabled.
        :paramtype enabled: bool
        """
        super(ActivityCustomEntityQuery, self).__init__(etag=etag, **kwargs)
        self.kind = 'Activity'  # type: str
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter
        self.template_name = template_name
        self.enabled = enabled
        self.created_time_utc = None
        self.last_modified_time_utc = None


class ActivityEntityQueriesPropertiesQueryDefinitions(msrest.serialization.Model):
    """The Activity query definitions.

    :ivar query: The Activity query to run on a given entity.
    :vartype query: str
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query: The Activity query to run on a given entity.
        :paramtype query: str
        """
        super(ActivityEntityQueriesPropertiesQueryDefinitions, self).__init__(**kwargs)
        self.query = query


class EntityQuery(ResourceWithEtag):
    """Specific entity query.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActivityEntityQuery, ExpansionEntityQuery.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. the entity query kind.Constant filled by server. Possible values include:
     "Expansion", "Insight", "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Activity': 'ActivityEntityQuery', 'Expansion': 'ExpansionEntityQuery'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(EntityQuery, self).__init__(etag=etag, **kwargs)
        self.kind = 'EntityQuery'  # type: str


class ActivityEntityQuery(EntityQuery):
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. the entity query kind.Constant filled by server. Possible values include:
     "Expansion", "Insight", "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
    :ivar input_entity_type: The type of the query's source entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    :ivar template_name: The template id this activity was created from.
    :vartype template_name: str
    :ivar enabled: Determines whether this activity is enabled or disabled.
    :vartype enabled: bool
    :ivar created_time_utc: The time the activity was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the activity was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'created_time_utc': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'query_definitions': {'key': 'properties.queryDefinitions', 'type': 'ActivityEntityQueriesPropertiesQueryDefinitions'},
        'input_entity_type': {'key': 'properties.inputEntityType', 'type': 'str'},
        'required_input_fields_sets': {'key': 'properties.requiredInputFieldsSets', 'type': '[[str]]'},
        'entities_filter': {'key': 'properties.entitiesFilter', 'type': '{[str]}'},
        'template_name': {'key': 'properties.templateName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["ActivityEntityQueriesPropertiesQueryDefinitions"] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
        :keyword input_entity_type: The type of the query's source entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        :keyword template_name: The template id this activity was created from.
        :paramtype template_name: str
        :keyword enabled: Determines whether this activity is enabled or disabled.
        :paramtype enabled: bool
        """
        super(ActivityEntityQuery, self).__init__(etag=etag, **kwargs)
        self.kind = 'Activity'  # type: str
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter
        self.template_name = template_name
        self.enabled = enabled
        self.created_time_utc = None
        self.last_modified_time_utc = None


class EntityQueryTemplate(Resource):
    """Specific entity query template.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActivityEntityQueryTemplate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. the entity query template kind.Constant filled by server. Possible values
     include: "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryTemplateKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Activity': 'ActivityEntityQueryTemplate'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EntityQueryTemplate, self).__init__(**kwargs)
        self.kind = 'EntityQueryTemplate'  # type: str


class ActivityEntityQueryTemplate(EntityQueryTemplate):
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. the entity query template kind.Constant filled by server. Possible values
     include: "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryTemplateKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueryTemplatePropertiesQueryDefinitions
    :ivar data_types: List of required data types for the given entity query template.
    :vartype data_types: list[~azure.mgmt.securityinsight.models.DataTypeDefinitions]
    :ivar input_entity_type: The type of the query's source entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'query_definitions': {'key': 'properties.queryDefinitions', 'type': 'ActivityEntityQueryTemplatePropertiesQueryDefinitions'},
        'data_types': {'key': 'properties.dataTypes', 'type': '[DataTypeDefinitions]'},
        'input_entity_type': {'key': 'properties.inputEntityType', 'type': 'str'},
        'required_input_fields_sets': {'key': 'properties.requiredInputFieldsSets', 'type': '[[str]]'},
        'entities_filter': {'key': 'properties.entitiesFilter', 'type': '{[str]}'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["ActivityEntityQueryTemplatePropertiesQueryDefinitions"] = None,
        data_types: Optional[List["DataTypeDefinitions"]] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        **kwargs
    ):
        """
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueryTemplatePropertiesQueryDefinitions
        :keyword data_types: List of required data types for the given entity query template.
        :paramtype data_types: list[~azure.mgmt.securityinsight.models.DataTypeDefinitions]
        :keyword input_entity_type: The type of the query's source entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        """
        super(ActivityEntityQueryTemplate, self).__init__(**kwargs)
        self.kind = 'Activity'  # type: str
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.data_types = data_types
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter


class ActivityEntityQueryTemplatePropertiesQueryDefinitions(msrest.serialization.Model):
    """The Activity query definitions.

    :ivar query: The Activity query to run on a given entity.
    :vartype query: str
    :ivar summarize_by: The dimensions we want to summarize the timeline results on, this is comma
     separated list.
    :vartype summarize_by: str
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'summarize_by': {'key': 'summarizeBy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        summarize_by: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query: The Activity query to run on a given entity.
        :paramtype query: str
        :keyword summarize_by: The dimensions we want to summarize the timeline results on, this is
         comma separated list.
        :paramtype summarize_by: str
        """
        super(ActivityEntityQueryTemplatePropertiesQueryDefinitions, self).__init__(**kwargs)
        self.query = query
        self.summarize_by = summarize_by


class EntityTimelineItem(msrest.serialization.Model):
    """Entity timeline Item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActivityTimelineItem, BookmarkTimelineItem, SecurityAlertTimelineItem.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. The entity query kind type.Constant filled by server. Possible values
     include: "Activity", "Bookmark", "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Activity': 'ActivityTimelineItem', 'Bookmark': 'BookmarkTimelineItem', 'SecurityAlert': 'SecurityAlertTimelineItem'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EntityTimelineItem, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ActivityTimelineItem(EntityTimelineItem):
    """Represents Activity timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. The entity query kind type.Constant filled by server. Possible values
     include: "Activity", "Bookmark", "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar query_id: Required. The activity query id.
    :vartype query_id: str
    :ivar bucket_start_time_utc: Required. The grouping bucket start time.
    :vartype bucket_start_time_utc: ~datetime.datetime
    :ivar bucket_end_time_utc: Required. The grouping bucket end time.
    :vartype bucket_end_time_utc: ~datetime.datetime
    :ivar first_activity_time_utc: Required. The time of the first activity in the grouping bucket.
    :vartype first_activity_time_utc: ~datetime.datetime
    :ivar last_activity_time_utc: Required. The time of the last activity in the grouping bucket.
    :vartype last_activity_time_utc: ~datetime.datetime
    :ivar content: Required. The activity timeline content.
    :vartype content: str
    :ivar title: Required. The activity timeline title.
    :vartype title: str
    """

    _validation = {
        'kind': {'required': True},
        'query_id': {'required': True},
        'bucket_start_time_utc': {'required': True},
        'bucket_end_time_utc': {'required': True},
        'first_activity_time_utc': {'required': True},
        'last_activity_time_utc': {'required': True},
        'content': {'required': True},
        'title': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'query_id': {'key': 'queryId', 'type': 'str'},
        'bucket_start_time_utc': {'key': 'bucketStartTimeUTC', 'type': 'iso-8601'},
        'bucket_end_time_utc': {'key': 'bucketEndTimeUTC', 'type': 'iso-8601'},
        'first_activity_time_utc': {'key': 'firstActivityTimeUTC', 'type': 'iso-8601'},
        'last_activity_time_utc': {'key': 'lastActivityTimeUTC', 'type': 'iso-8601'},
        'content': {'key': 'content', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query_id: str,
        bucket_start_time_utc: datetime.datetime,
        bucket_end_time_utc: datetime.datetime,
        first_activity_time_utc: datetime.datetime,
        last_activity_time_utc: datetime.datetime,
        content: str,
        title: str,
        **kwargs
    ):
        """
        :keyword query_id: Required. The activity query id.
        :paramtype query_id: str
        :keyword bucket_start_time_utc: Required. The grouping bucket start time.
        :paramtype bucket_start_time_utc: ~datetime.datetime
        :keyword bucket_end_time_utc: Required. The grouping bucket end time.
        :paramtype bucket_end_time_utc: ~datetime.datetime
        :keyword first_activity_time_utc: Required. The time of the first activity in the grouping
         bucket.
        :paramtype first_activity_time_utc: ~datetime.datetime
        :keyword last_activity_time_utc: Required. The time of the last activity in the grouping
         bucket.
        :paramtype last_activity_time_utc: ~datetime.datetime
        :keyword content: Required. The activity timeline content.
        :paramtype content: str
        :keyword title: Required. The activity timeline title.
        :paramtype title: str
        """
        super(ActivityTimelineItem, self).__init__(**kwargs)
        self.kind = 'Activity'  # type: str
        self.query_id = query_id
        self.bucket_start_time_utc = bucket_start_time_utc
        self.bucket_end_time_utc = bucket_end_time_utc
        self.first_activity_time_utc = first_activity_time_utc
        self.last_activity_time_utc = last_activity_time_utc
        self.content = content
        self.title = title


class AlertDetailsOverride(msrest.serialization.Model):
    """Settings for how to dynamically override alert static details.

    :ivar alert_display_name_format: the format containing columns name(s) to override the alert
     name.
    :vartype alert_display_name_format: str
    :ivar alert_description_format: the format containing columns name(s) to override the alert
     description.
    :vartype alert_description_format: str
    :ivar alert_tactics_column_name: the column name to take the alert tactics from.
    :vartype alert_tactics_column_name: str
    :ivar alert_severity_column_name: the column name to take the alert severity from.
    :vartype alert_severity_column_name: str
    """

    _attribute_map = {
        'alert_display_name_format': {'key': 'alertDisplayNameFormat', 'type': 'str'},
        'alert_description_format': {'key': 'alertDescriptionFormat', 'type': 'str'},
        'alert_tactics_column_name': {'key': 'alertTacticsColumnName', 'type': 'str'},
        'alert_severity_column_name': {'key': 'alertSeverityColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alert_display_name_format: Optional[str] = None,
        alert_description_format: Optional[str] = None,
        alert_tactics_column_name: Optional[str] = None,
        alert_severity_column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword alert_display_name_format: the format containing columns name(s) to override the alert
         name.
        :paramtype alert_display_name_format: str
        :keyword alert_description_format: the format containing columns name(s) to override the alert
         description.
        :paramtype alert_description_format: str
        :keyword alert_tactics_column_name: the column name to take the alert tactics from.
        :paramtype alert_tactics_column_name: str
        :keyword alert_severity_column_name: the column name to take the alert severity from.
        :paramtype alert_severity_column_name: str
        """
        super(AlertDetailsOverride, self).__init__(**kwargs)
        self.alert_display_name_format = alert_display_name_format
        self.alert_description_format = alert_description_format
        self.alert_tactics_column_name = alert_tactics_column_name
        self.alert_severity_column_name = alert_severity_column_name


class AlertRule(ResourceWithEtag):
    """Alert rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FusionAlertRule, MLBehaviorAnalyticsAlertRule, MicrosoftSecurityIncidentCreationAlertRule, NrtAlertRule, ScheduledAlertRule, ThreatIntelligenceAlertRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Fusion': 'FusionAlertRule', 'MLBehaviorAnalytics': 'MLBehaviorAnalyticsAlertRule', 'MicrosoftSecurityIncidentCreation': 'MicrosoftSecurityIncidentCreationAlertRule', 'NRT': 'NrtAlertRule', 'Scheduled': 'ScheduledAlertRule', 'ThreatIntelligence': 'ThreatIntelligenceAlertRule'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(AlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'AlertRule'  # type: str


class AlertRulesList(msrest.serialization.Model):
    """List all the alert rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rules.
    :vartype next_link: str
    :ivar value: Required. Array of alert rules.
    :vartype value: list[~azure.mgmt.securityinsight.models.AlertRule]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AlertRule]'},
    }

    def __init__(
        self,
        *,
        value: List["AlertRule"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of alert rules.
        :paramtype value: list[~azure.mgmt.securityinsight.models.AlertRule]
        """
        super(AlertRulesList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRuleTemplate(Resource):
    """Alert rule template.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FusionAlertRuleTemplate, MLBehaviorAnalyticsAlertRuleTemplate, MicrosoftSecurityIncidentCreationAlertRuleTemplate, NrtAlertRuleTemplate, ScheduledAlertRuleTemplate, ThreatIntelligenceAlertRuleTemplate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Fusion': 'FusionAlertRuleTemplate', 'MLBehaviorAnalytics': 'MLBehaviorAnalyticsAlertRuleTemplate', 'MicrosoftSecurityIncidentCreation': 'MicrosoftSecurityIncidentCreationAlertRuleTemplate', 'NRT': 'NrtAlertRuleTemplate', 'Scheduled': 'ScheduledAlertRuleTemplate', 'ThreatIntelligence': 'ThreatIntelligenceAlertRuleTemplate'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'AlertRuleTemplate'  # type: str


class AlertRuleTemplateDataSource(msrest.serialization.Model):
    """alert rule template data sources.

    :ivar connector_id: The connector id that provides the following data types.
    :vartype connector_id: str
    :ivar data_types: The data types used by the alert rule template.
    :vartype data_types: list[str]
    """

    _attribute_map = {
        'connector_id': {'key': 'connectorId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        connector_id: Optional[str] = None,
        data_types: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword connector_id: The connector id that provides the following data types.
        :paramtype connector_id: str
        :keyword data_types: The data types used by the alert rule template.
        :paramtype data_types: list[str]
        """
        super(AlertRuleTemplateDataSource, self).__init__(**kwargs)
        self.connector_id = connector_id
        self.data_types = data_types


class AlertRuleTemplatePropertiesBase(msrest.serialization.Model):
    """Base alert rule template property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        """
        super(AlertRuleTemplatePropertiesBase, self).__init__(**kwargs)
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status


class AlertRuleTemplatesList(msrest.serialization.Model):
    """List all the alert rule templates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rule templates.
    :vartype next_link: str
    :ivar value: Required. Array of alert rule templates.
    :vartype value: list[~azure.mgmt.securityinsight.models.AlertRuleTemplate]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AlertRuleTemplate]'},
    }

    def __init__(
        self,
        *,
        value: List["AlertRuleTemplate"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of alert rule templates.
        :paramtype value: list[~azure.mgmt.securityinsight.models.AlertRuleTemplate]
        """
        super(AlertRuleTemplatesList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRuleTemplateWithMitreProperties(AlertRuleTemplatePropertiesBase):
    """Alert rule template with MITRE property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        """
        super(AlertRuleTemplateWithMitreProperties, self).__init__(alert_rules_created_by_template_count=alert_rules_created_by_template_count, description=description, display_name=display_name, required_data_connectors=required_data_connectors, status=status, **kwargs)
        self.tactics = tactics
        self.techniques = techniques


class AlertsDataTypeOfDataConnector(msrest.serialization.Model):
    """Alerts data type for data connectors.

    All required parameters must be populated in order to send to Azure.

    :ivar alerts: Required. Alerts data type connection.
    :vartype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _validation = {
        'alerts': {'required': True},
    }

    _attribute_map = {
        'alerts': {'key': 'alerts', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        alerts: "DataConnectorDataTypeCommon",
        **kwargs
    ):
        """
        :keyword alerts: Required. Alerts data type connection.
        :paramtype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        """
        super(AlertsDataTypeOfDataConnector, self).__init__(**kwargs)
        self.alerts = alerts


class Settings(ResourceWithEtag):
    """The Setting.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Anomalies, EntityAnalytics, EyesOn, Ueba.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the setting.Constant filled by server. Possible values
     include: "Anomalies", "EyesOn", "EntityAnalytics", "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Anomalies': 'Anomalies', 'EntityAnalytics': 'EntityAnalytics', 'EyesOn': 'EyesOn', 'Ueba': 'Ueba'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(Settings, self).__init__(etag=etag, **kwargs)
        self.kind = 'Settings'  # type: str


class Anomalies(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the setting.Constant filled by server. Possible values
     include: "Anomalies", "EyesOn", "EntityAnalytics", "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar is_enabled: Determines whether the setting is enable or disabled.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(Anomalies, self).__init__(etag=etag, **kwargs)
        self.kind = 'Anomalies'  # type: str
        self.is_enabled = None


class ASCCheckRequirements(DataConnectorsCheckRequirements):
    """Represents ASC (Azure Security Center) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(ASCCheckRequirements, self).__init__(**kwargs)
        self.kind = 'AzureSecurityCenter'  # type: str
        self.subscription_id = subscription_id


class ASCDataConnector(DataConnector):
    """Represents ASC (Azure Security Center) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(ASCDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureSecurityCenter'  # type: str
        self.data_types = data_types
        self.subscription_id = subscription_id


class ASCDataConnectorProperties(DataConnectorWithAlertsProperties):
    """ASC (Azure Security Center) data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(ASCDataConnectorProperties, self).__init__(data_types=data_types, **kwargs)
        self.subscription_id = subscription_id


class AutomationRule(ResourceWithEtag):
    """AutomationRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar display_name: Required. The display name of the automation rule.
    :vartype display_name: str
    :ivar order: Required. The order of execution of the automation rule.
    :vartype order: int
    :ivar triggering_logic: Required. Describes automation rule triggering logic.
    :vartype triggering_logic: ~azure.mgmt.securityinsight.models.AutomationRuleTriggeringLogic
    :ivar actions: Required. The actions to execute when the automation rule is triggered.
    :vartype actions: list[~azure.mgmt.securityinsight.models.AutomationRuleAction]
    :ivar last_modified_time_utc: The last time the automation rule was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar created_time_utc: The time the automation rule was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_by: Information on the client (user or application) that made some action.
    :vartype last_modified_by: ~azure.mgmt.securityinsight.models.ClientInfo
    :ivar created_by: Information on the client (user or application) that made some action.
    :vartype created_by: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'display_name': {'required': True, 'max_length': 500, 'min_length': 0},
        'order': {'required': True, 'maximum': 1000, 'minimum': 1},
        'triggering_logic': {'required': True},
        'actions': {'required': True, 'max_items': 20, 'min_items': 0},
        'last_modified_time_utc': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'created_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'order': {'key': 'properties.order', 'type': 'int'},
        'triggering_logic': {'key': 'properties.triggeringLogic', 'type': 'AutomationRuleTriggeringLogic'},
        'actions': {'key': 'properties.actions', 'type': '[AutomationRuleAction]'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'ClientInfo'},
        'created_by': {'key': 'properties.createdBy', 'type': 'ClientInfo'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        order: int,
        triggering_logic: "AutomationRuleTriggeringLogic",
        actions: List["AutomationRuleAction"],
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword display_name: Required. The display name of the automation rule.
        :paramtype display_name: str
        :keyword order: Required. The order of execution of the automation rule.
        :paramtype order: int
        :keyword triggering_logic: Required. Describes automation rule triggering logic.
        :paramtype triggering_logic: ~azure.mgmt.securityinsight.models.AutomationRuleTriggeringLogic
        :keyword actions: Required. The actions to execute when the automation rule is triggered.
        :paramtype actions: list[~azure.mgmt.securityinsight.models.AutomationRuleAction]
        """
        super(AutomationRule, self).__init__(etag=etag, **kwargs)
        self.display_name = display_name
        self.order = order
        self.triggering_logic = triggering_logic
        self.actions = actions
        self.last_modified_time_utc = None
        self.created_time_utc = None
        self.last_modified_by = None
        self.created_by = None


class AutomationRuleAction(msrest.serialization.Model):
    """Describes an automation rule action.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutomationRuleModifyPropertiesAction, AutomationRuleRunPlaybookAction.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: Required. The type of the automation rule action.Constant filled by server.
     Possible values include: "ModifyProperties", "RunPlaybook".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    """

    _validation = {
        'order': {'required': True},
        'action_type': {'required': True},
    }

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    _subtype_map = {
        'action_type': {'ModifyProperties': 'AutomationRuleModifyPropertiesAction', 'RunPlaybook': 'AutomationRuleRunPlaybookAction'}
    }

    def __init__(
        self,
        *,
        order: int,
        **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        """
        super(AutomationRuleAction, self).__init__(**kwargs)
        self.order = order
        self.action_type = None  # type: Optional[str]


class AutomationRuleCondition(msrest.serialization.Model):
    """Describes an automation rule condition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PropertyConditionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Constant filled by server. Possible values include: "Property".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    """

    _validation = {
        'condition_type': {'required': True},
    }

    _attribute_map = {
        'condition_type': {'key': 'conditionType', 'type': 'str'},
    }

    _subtype_map = {
        'condition_type': {'Property': 'PropertyConditionProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutomationRuleCondition, self).__init__(**kwargs)
        self.condition_type = None  # type: Optional[str]


class AutomationRuleModifyPropertiesAction(AutomationRuleAction):
    """Describes an automation rule action to modify an object's properties.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: Required. The type of the automation rule action.Constant filled by server.
     Possible values include: "ModifyProperties", "RunPlaybook".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    :ivar action_configuration:
    :vartype action_configuration: ~azure.mgmt.securityinsight.models.IncidentPropertiesAction
    """

    _validation = {
        'order': {'required': True},
        'action_type': {'required': True},
    }

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'action_configuration': {'key': 'actionConfiguration', 'type': 'IncidentPropertiesAction'},
    }

    def __init__(
        self,
        *,
        order: int,
        action_configuration: Optional["IncidentPropertiesAction"] = None,
        **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        :keyword action_configuration:
        :paramtype action_configuration: ~azure.mgmt.securityinsight.models.IncidentPropertiesAction
        """
        super(AutomationRuleModifyPropertiesAction, self).__init__(order=order, **kwargs)
        self.action_type = 'ModifyProperties'  # type: str
        self.action_configuration = action_configuration


class AutomationRulePropertyValuesCondition(msrest.serialization.Model):
    """AutomationRulePropertyValuesCondition.

    :ivar property_name: The property to evaluate in an automation rule property condition.
     Possible values include: "IncidentTitle", "IncidentDescription", "IncidentSeverity",
     "IncidentStatus", "IncidentRelatedAnalyticRuleIds", "IncidentTactics", "IncidentLabel",
     "IncidentProviderName", "AccountAadTenantId", "AccountAadUserId", "AccountName",
     "AccountNTDomain", "AccountPUID", "AccountSid", "AccountObjectGuid", "AccountUPNSuffix",
     "AlertProductNames", "AzureResourceResourceId", "AzureResourceSubscriptionId",
     "CloudApplicationAppId", "CloudApplicationAppName", "DNSDomainName", "FileDirectory",
     "FileName", "FileHashValue", "HostAzureID", "HostName", "HostNetBiosName", "HostNTDomain",
     "HostOSVersion", "IoTDeviceId", "IoTDeviceName", "IoTDeviceType", "IoTDeviceVendor",
     "IoTDeviceModel", "IoTDeviceOperatingSystem", "IPAddress", "MailboxDisplayName",
     "MailboxPrimaryAddress", "MailboxUPN", "MailMessageDeliveryAction",
     "MailMessageDeliveryLocation", "MailMessageRecipient", "MailMessageSenderIP",
     "MailMessageSubject", "MailMessageP1Sender", "MailMessageP2Sender", "MalwareCategory",
     "MalwareName", "ProcessCommandLine", "ProcessId", "RegistryKey", "RegistryValueData", "Url".
    :vartype property_name: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedProperty
    :ivar operator: Possible values include: "Equals", "NotEquals", "Contains", "NotContains",
     "StartsWith", "NotStartsWith", "EndsWith", "NotEndsWith".
    :vartype operator: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
    :ivar property_values:
    :vartype property_values: list[str]
    """

    _attribute_map = {
        'property_name': {'key': 'propertyName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'property_values': {'key': 'propertyValues', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        property_name: Optional[Union[str, "AutomationRulePropertyConditionSupportedProperty"]] = None,
        operator: Optional[Union[str, "AutomationRulePropertyConditionSupportedOperator"]] = None,
        property_values: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword property_name: The property to evaluate in an automation rule property condition.
         Possible values include: "IncidentTitle", "IncidentDescription", "IncidentSeverity",
         "IncidentStatus", "IncidentRelatedAnalyticRuleIds", "IncidentTactics", "IncidentLabel",
         "IncidentProviderName", "AccountAadTenantId", "AccountAadUserId", "AccountName",
         "AccountNTDomain", "AccountPUID", "AccountSid", "AccountObjectGuid", "AccountUPNSuffix",
         "AlertProductNames", "AzureResourceResourceId", "AzureResourceSubscriptionId",
         "CloudApplicationAppId", "CloudApplicationAppName", "DNSDomainName", "FileDirectory",
         "FileName", "FileHashValue", "HostAzureID", "HostName", "HostNetBiosName", "HostNTDomain",
         "HostOSVersion", "IoTDeviceId", "IoTDeviceName", "IoTDeviceType", "IoTDeviceVendor",
         "IoTDeviceModel", "IoTDeviceOperatingSystem", "IPAddress", "MailboxDisplayName",
         "MailboxPrimaryAddress", "MailboxUPN", "MailMessageDeliveryAction",
         "MailMessageDeliveryLocation", "MailMessageRecipient", "MailMessageSenderIP",
         "MailMessageSubject", "MailMessageP1Sender", "MailMessageP2Sender", "MalwareCategory",
         "MalwareName", "ProcessCommandLine", "ProcessId", "RegistryKey", "RegistryValueData", "Url".
        :paramtype property_name: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedProperty
        :keyword operator: Possible values include: "Equals", "NotEquals", "Contains", "NotContains",
         "StartsWith", "NotStartsWith", "EndsWith", "NotEndsWith".
        :paramtype operator: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
        :keyword property_values:
        :paramtype property_values: list[str]
        """
        super(AutomationRulePropertyValuesCondition, self).__init__(**kwargs)
        self.property_name = property_name
        self.operator = operator
        self.property_values = property_values


class AutomationRuleRunPlaybookAction(AutomationRuleAction):
    """Describes an automation rule action to run a playbook.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: Required. The type of the automation rule action.Constant filled by server.
     Possible values include: "ModifyProperties", "RunPlaybook".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    :ivar action_configuration:
    :vartype action_configuration: ~azure.mgmt.securityinsight.models.PlaybookActionProperties
    """

    _validation = {
        'order': {'required': True},
        'action_type': {'required': True},
    }

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'action_configuration': {'key': 'actionConfiguration', 'type': 'PlaybookActionProperties'},
    }

    def __init__(
        self,
        *,
        order: int,
        action_configuration: Optional["PlaybookActionProperties"] = None,
        **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        :keyword action_configuration:
        :paramtype action_configuration: ~azure.mgmt.securityinsight.models.PlaybookActionProperties
        """
        super(AutomationRuleRunPlaybookAction, self).__init__(order=order, **kwargs)
        self.action_type = 'RunPlaybook'  # type: str
        self.action_configuration = action_configuration


class AutomationRulesList(msrest.serialization.Model):
    """AutomationRulesList.

    :ivar value:
    :vartype value: list[~azure.mgmt.securityinsight.models.AutomationRule]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutomationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AutomationRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.securityinsight.models.AutomationRule]
        :keyword next_link:
        :paramtype next_link: str
        """
        super(AutomationRulesList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutomationRuleTriggeringLogic(msrest.serialization.Model):
    """Describes automation rule triggering logic.

    All required parameters must be populated in order to send to Azure.

    :ivar is_enabled: Required. Determines whether the automation rule is enabled or disabled.
    :vartype is_enabled: bool
    :ivar expiration_time_utc: Determines when the automation rule should automatically expire and
     be disabled.
    :vartype expiration_time_utc: ~datetime.datetime
    :ivar triggers_on: Required. Possible values include: "Incidents".
    :vartype triggers_on: str or ~azure.mgmt.securityinsight.models.TriggersOn
    :ivar triggers_when: Required. Possible values include: "Created".
    :vartype triggers_when: str or ~azure.mgmt.securityinsight.models.TriggersWhen
    :ivar conditions: The conditions to evaluate to determine if the automation rule should be
     triggered on a given object.
    :vartype conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
    """

    _validation = {
        'is_enabled': {'required': True},
        'triggers_on': {'required': True},
        'triggers_when': {'required': True},
        'conditions': {'max_items': 50, 'min_items': 0},
    }

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'triggers_on': {'key': 'triggersOn', 'type': 'str'},
        'triggers_when': {'key': 'triggersWhen', 'type': 'str'},
        'conditions': {'key': 'conditions', 'type': '[AutomationRuleCondition]'},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        triggers_on: Union[str, "TriggersOn"],
        triggers_when: Union[str, "TriggersWhen"],
        expiration_time_utc: Optional[datetime.datetime] = None,
        conditions: Optional[List["AutomationRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword is_enabled: Required. Determines whether the automation rule is enabled or disabled.
        :paramtype is_enabled: bool
        :keyword expiration_time_utc: Determines when the automation rule should automatically expire
         and be disabled.
        :paramtype expiration_time_utc: ~datetime.datetime
        :keyword triggers_on: Required. Possible values include: "Incidents".
        :paramtype triggers_on: str or ~azure.mgmt.securityinsight.models.TriggersOn
        :keyword triggers_when: Required. Possible values include: "Created".
        :paramtype triggers_when: str or ~azure.mgmt.securityinsight.models.TriggersWhen
        :keyword conditions: The conditions to evaluate to determine if the automation rule should be
         triggered on a given object.
        :paramtype conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
        """
        super(AutomationRuleTriggeringLogic, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.expiration_time_utc = expiration_time_utc
        self.triggers_on = triggers_on
        self.triggers_when = triggers_when
        self.conditions = conditions


class Availability(msrest.serialization.Model):
    """Connector Availability Status.

    :ivar status: The connector Availability Status. The only acceptable values to pass in are None
     and 1. The default value is None.
    :vartype status: int
    :ivar is_preview: Set connector as preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword status: The connector Availability Status. The only acceptable values to pass in are
         None and 1. The default value is None.
        :paramtype status: int
        :keyword is_preview: Set connector as preview.
        :paramtype is_preview: bool
        """
        super(Availability, self).__init__(**kwargs)
        self.status = status
        self.is_preview = is_preview


class AwsCloudTrailCheckRequirements(DataConnectorsCheckRequirements):
    """Amazon Web Services CloudTrail requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AwsCloudTrailCheckRequirements, self).__init__(**kwargs)
        self.kind = 'AmazonWebServicesCloudTrail'  # type: str


class AwsCloudTrailDataConnector(DataConnector):
    """Represents Amazon Web Services CloudTrail data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar aws_role_arn: The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access
     the Aws account.
    :vartype aws_role_arn: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'aws_role_arn': {'key': 'properties.awsRoleArn', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AwsCloudTrailDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        aws_role_arn: Optional[str] = None,
        data_types: Optional["AwsCloudTrailDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword aws_role_arn: The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access
         the Aws account.
        :paramtype aws_role_arn: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypes
        """
        super(AwsCloudTrailDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AmazonWebServicesCloudTrail'  # type: str
        self.aws_role_arn = aws_role_arn
        self.data_types = data_types


class AwsCloudTrailDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Amazon Web Services CloudTrail data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Required. Logs data type.
    :vartype logs: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypesLogs
    """

    _validation = {
        'logs': {'required': True},
    }

    _attribute_map = {
        'logs': {'key': 'logs', 'type': 'AwsCloudTrailDataConnectorDataTypesLogs'},
    }

    def __init__(
        self,
        *,
        logs: "AwsCloudTrailDataConnectorDataTypesLogs",
        **kwargs
    ):
        """
        :keyword logs: Required. Logs data type.
        :paramtype logs: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypesLogs
        """
        super(AwsCloudTrailDataConnectorDataTypes, self).__init__(**kwargs)
        self.logs = logs


class DataConnectorDataTypeCommon(msrest.serialization.Model):
    """Common field for data type in data connectors.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(DataConnectorDataTypeCommon, self).__init__(**kwargs)
        self.state = state


class AwsCloudTrailDataConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(AwsCloudTrailDataConnectorDataTypesLogs, self).__init__(state=state, **kwargs)


class AwsS3CheckRequirements(DataConnectorsCheckRequirements):
    """Amazon Web Services S3 requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AwsS3CheckRequirements, self).__init__(**kwargs)
        self.kind = 'AmazonWebServicesS3'  # type: str


class AwsS3DataConnector(DataConnector):
    """Represents Amazon Web Services S3 data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar destination_table: The logs destination table name in LogAnalytics.
    :vartype destination_table: str
    :ivar sqs_urls: The AWS sqs urls for the connector.
    :vartype sqs_urls: list[str]
    :ivar role_arn: The Aws Role Arn that is used to access the Aws account.
    :vartype role_arn: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'destination_table': {'key': 'properties.destinationTable', 'type': 'str'},
        'sqs_urls': {'key': 'properties.sqsUrls', 'type': '[str]'},
        'role_arn': {'key': 'properties.roleArn', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AwsS3DataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        destination_table: Optional[str] = None,
        sqs_urls: Optional[List[str]] = None,
        role_arn: Optional[str] = None,
        data_types: Optional["AwsS3DataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword destination_table: The logs destination table name in LogAnalytics.
        :paramtype destination_table: str
        :keyword sqs_urls: The AWS sqs urls for the connector.
        :paramtype sqs_urls: list[str]
        :keyword role_arn: The Aws Role Arn that is used to access the Aws account.
        :paramtype role_arn: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypes
        """
        super(AwsS3DataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AmazonWebServicesS3'  # type: str
        self.destination_table = destination_table
        self.sqs_urls = sqs_urls
        self.role_arn = role_arn
        self.data_types = data_types


class AwsS3DataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Amazon Web Services S3 data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Required. Logs data type.
    :vartype logs: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypesLogs
    """

    _validation = {
        'logs': {'required': True},
    }

    _attribute_map = {
        'logs': {'key': 'logs', 'type': 'AwsS3DataConnectorDataTypesLogs'},
    }

    def __init__(
        self,
        *,
        logs: "AwsS3DataConnectorDataTypesLogs",
        **kwargs
    ):
        """
        :keyword logs: Required. Logs data type.
        :paramtype logs: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypesLogs
        """
        super(AwsS3DataConnectorDataTypes, self).__init__(**kwargs)
        self.logs = logs


class AwsS3DataConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(AwsS3DataConnectorDataTypesLogs, self).__init__(state=state, **kwargs)


class AzureDevOpsResourceInfo(msrest.serialization.Model):
    """Resources created in Azure DevOps repository.

    :ivar pipeline_id: Id of the pipeline created for the source-control.
    :vartype pipeline_id: str
    :ivar service_connection_id: Id of the service-connection created for the source-control.
    :vartype service_connection_id: str
    """

    _attribute_map = {
        'pipeline_id': {'key': 'pipelineId', 'type': 'str'},
        'service_connection_id': {'key': 'serviceConnectionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pipeline_id: Optional[str] = None,
        service_connection_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword pipeline_id: Id of the pipeline created for the source-control.
        :paramtype pipeline_id: str
        :keyword service_connection_id: Id of the service-connection created for the source-control.
        :paramtype service_connection_id: str
        """
        super(AzureDevOpsResourceInfo, self).__init__(**kwargs)
        self.pipeline_id = pipeline_id
        self.service_connection_id = service_connection_id


class AzureResourceEntity(Entity):
    """Represents an azure resource entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar resource_id: The azure resource id of the resource.
    :vartype resource_id: str
    :ivar subscription_id: The subscription id of the resource.
    :vartype subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureResourceEntity, self).__init__(**kwargs)
        self.kind = 'AzureResource'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.resource_id = None
        self.subscription_id = None


class AzureResourceEntityProperties(EntityCommonProperties):
    """AzureResource entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar resource_id: The azure resource id of the resource.
    :vartype resource_id: str
    :ivar subscription_id: The subscription id of the resource.
    :vartype subscription_id: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureResourceEntityProperties, self).__init__(**kwargs)
        self.resource_id = None
        self.subscription_id = None


class Bookmark(ResourceWithEtag):
    """Represents a bookmark in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: The display name of the bookmark.
    :vartype display_name: str
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: The query of the bookmark.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar event_time: The bookmark event time.
    :vartype event_time: ~datetime.datetime
    :ivar query_start_time: The start time for the query.
    :vartype query_start_time: ~datetime.datetime
    :ivar query_end_time: The end time for the query.
    :vartype query_end_time: ~datetime.datetime
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    :ivar entity_mappings: Describes the entity mappings of the bookmark.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.BookmarkEntityMappings]
    :ivar tactics: A list of relevant mitre attacks.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: A list of relevant mitre techniques.
    :vartype techniques: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'UserInfo'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_result': {'key': 'properties.queryResult', 'type': 'str'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'UserInfo'},
        'event_time': {'key': 'properties.eventTime', 'type': 'iso-8601'},
        'query_start_time': {'key': 'properties.queryStartTime', 'type': 'iso-8601'},
        'query_end_time': {'key': 'properties.queryEndTime', 'type': 'iso-8601'},
        'incident_info': {'key': 'properties.incidentInfo', 'type': 'IncidentInfo'},
        'entity_mappings': {'key': 'properties.entityMappings', 'type': '[BookmarkEntityMappings]'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        display_name: Optional[str] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["UserInfo"] = None,
        event_time: Optional[datetime.datetime] = None,
        query_start_time: Optional[datetime.datetime] = None,
        query_end_time: Optional[datetime.datetime] = None,
        incident_info: Optional["IncidentInfo"] = None,
        entity_mappings: Optional[List["BookmarkEntityMappings"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: The display name of the bookmark.
        :paramtype display_name: str
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: The query of the bookmark.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword event_time: The bookmark event time.
        :paramtype event_time: ~datetime.datetime
        :keyword query_start_time: The start time for the query.
        :paramtype query_start_time: ~datetime.datetime
        :keyword query_end_time: The end time for the query.
        :paramtype query_end_time: ~datetime.datetime
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        :keyword entity_mappings: Describes the entity mappings of the bookmark.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.BookmarkEntityMappings]
        :keyword tactics: A list of relevant mitre attacks.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: A list of relevant mitre techniques.
        :paramtype techniques: list[str]
        """
        super(Bookmark, self).__init__(etag=etag, **kwargs)
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.event_time = event_time
        self.query_start_time = query_start_time
        self.query_end_time = query_end_time
        self.incident_info = incident_info
        self.entity_mappings = entity_mappings
        self.tactics = tactics
        self.techniques = techniques


class BookmarkEntityMappings(msrest.serialization.Model):
    """Describes the entity mappings of a single entity.

    :ivar entity_type: The entity type.
    :vartype entity_type: str
    :ivar field_mappings: Array of fields mapping for that entity type.
    :vartype field_mappings: list[~azure.mgmt.securityinsight.models.EntityFieldMapping]
    """

    _attribute_map = {
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'field_mappings': {'key': 'fieldMappings', 'type': '[EntityFieldMapping]'},
    }

    def __init__(
        self,
        *,
        entity_type: Optional[str] = None,
        field_mappings: Optional[List["EntityFieldMapping"]] = None,
        **kwargs
    ):
        """
        :keyword entity_type: The entity type.
        :paramtype entity_type: str
        :keyword field_mappings: Array of fields mapping for that entity type.
        :paramtype field_mappings: list[~azure.mgmt.securityinsight.models.EntityFieldMapping]
        """
        super(BookmarkEntityMappings, self).__init__(**kwargs)
        self.entity_type = entity_type
        self.field_mappings = field_mappings


class BookmarkExpandParameters(msrest.serialization.Model):
    """The parameters required to execute an expand operation on the given bookmark.

    :ivar end_time: The end date filter, so the only expansion results returned are before this
     date.
    :vartype end_time: ~datetime.datetime
    :ivar expansion_id: The Id of the expansion to perform.
    :vartype expansion_id: str
    :ivar start_time: The start date filter, so the only expansion results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'expansion_id': {'key': 'expansionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        expansion_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: The end date filter, so the only expansion results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword expansion_id: The Id of the expansion to perform.
        :paramtype expansion_id: str
        :keyword start_time: The start date filter, so the only expansion results returned are after
         this date.
        :paramtype start_time: ~datetime.datetime
        """
        super(BookmarkExpandParameters, self).__init__(**kwargs)
        self.end_time = end_time
        self.expansion_id = expansion_id
        self.start_time = start_time


class BookmarkExpandResponse(msrest.serialization.Model):
    """The entity expansion result operation response.

    :ivar meta_data: The metadata from the expansion operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
    :ivar value: The expansion result values.
    :vartype value: ~azure.mgmt.securityinsight.models.BookmarkExpandResponseValue
    """

    _attribute_map = {
        'meta_data': {'key': 'metaData', 'type': 'ExpansionResultsMetadata'},
        'value': {'key': 'value', 'type': 'BookmarkExpandResponseValue'},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["ExpansionResultsMetadata"] = None,
        value: Optional["BookmarkExpandResponseValue"] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the expansion operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
        :keyword value: The expansion result values.
        :paramtype value: ~azure.mgmt.securityinsight.models.BookmarkExpandResponseValue
        """
        super(BookmarkExpandResponse, self).__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class BookmarkExpandResponseValue(msrest.serialization.Model):
    """The expansion result values.

    :ivar entities: Array of the expansion result entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar edges: Array of expansion result connected entities.
    :vartype edges: list[~azure.mgmt.securityinsight.models.ConnectedEntity]
    """

    _attribute_map = {
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'edges': {'key': 'edges', 'type': '[ConnectedEntity]'},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["Entity"]] = None,
        edges: Optional[List["ConnectedEntity"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the expansion result entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword edges: Array of expansion result connected entities.
        :paramtype edges: list[~azure.mgmt.securityinsight.models.ConnectedEntity]
        """
        super(BookmarkExpandResponseValue, self).__init__(**kwargs)
        self.entities = entities
        self.edges = edges


class BookmarkList(msrest.serialization.Model):
    """List all the bookmarks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of bookmarks.
    :vartype next_link: str
    :ivar value: Required. Array of bookmarks.
    :vartype value: list[~azure.mgmt.securityinsight.models.Bookmark]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Bookmark]'},
    }

    def __init__(
        self,
        *,
        value: List["Bookmark"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of bookmarks.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Bookmark]
        """
        super(BookmarkList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class BookmarkTimelineItem(EntityTimelineItem):
    """Represents bookmark timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. The entity query kind type.Constant filled by server. Possible values
     include: "Activity", "Bookmark", "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar azure_resource_id: Required. The bookmark azure resource id.
    :vartype azure_resource_id: str
    :ivar display_name: The bookmark display name.
    :vartype display_name: str
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar end_time_utc: The bookmark end time.
    :vartype end_time_utc: ~datetime.datetime
    :ivar start_time_utc: The bookmark start time.
    :vartype start_time_utc: ~datetime.datetime
    :ivar event_time: The bookmark event time.
    :vartype event_time: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    """

    _validation = {
        'kind': {'required': True},
        'azure_resource_id': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'azure_resource_id': {'key': 'azureResourceId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'notes': {'key': 'notes', 'type': 'str'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'UserInfo'},
        'labels': {'key': 'labels', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        azure_resource_id: str,
        display_name: Optional[str] = None,
        notes: Optional[str] = None,
        end_time_utc: Optional[datetime.datetime] = None,
        start_time_utc: Optional[datetime.datetime] = None,
        event_time: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        labels: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword azure_resource_id: Required. The bookmark azure resource id.
        :paramtype azure_resource_id: str
        :keyword display_name: The bookmark display name.
        :paramtype display_name: str
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword end_time_utc: The bookmark end time.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword start_time_utc: The bookmark start time.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword event_time: The bookmark event time.
        :paramtype event_time: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        """
        super(BookmarkTimelineItem, self).__init__(**kwargs)
        self.kind = 'Bookmark'  # type: str
        self.azure_resource_id = azure_resource_id
        self.display_name = display_name
        self.notes = notes
        self.end_time_utc = end_time_utc
        self.start_time_utc = start_time_utc
        self.event_time = event_time
        self.created_by = created_by
        self.labels = labels


class ClientInfo(msrest.serialization.Model):
    """Information on the client (user or application) that made some action.

    :ivar email: The email of the client.
    :vartype email: str
    :ivar name: The name of the client.
    :vartype name: str
    :ivar object_id: The object id of the client.
    :vartype object_id: str
    :ivar user_principal_name: The user principal name of the client.
    :vartype user_principal_name: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'user_principal_name': {'key': 'userPrincipalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email: The email of the client.
        :paramtype email: str
        :keyword name: The name of the client.
        :paramtype name: str
        :keyword object_id: The object id of the client.
        :paramtype object_id: str
        :keyword user_principal_name: The user principal name of the client.
        :paramtype user_principal_name: str
        """
        super(ClientInfo, self).__init__(**kwargs)
        self.email = email
        self.name = name
        self.object_id = object_id
        self.user_principal_name = user_principal_name


class CloudApplicationEntity(Entity):
    """Represents a cloud application entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar app_id: The technical identifier of the application.
    :vartype app_id: int
    :ivar app_name: The name of the related cloud application.
    :vartype app_name: str
    :ivar instance_name: The user defined instance name of the cloud application. It is often used
     to distinguish between several applications of the same type that a customer has.
    :vartype instance_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'app_id': {'readonly': True},
        'app_name': {'readonly': True},
        'instance_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'app_id': {'key': 'properties.appId', 'type': 'int'},
        'app_name': {'key': 'properties.appName', 'type': 'str'},
        'instance_name': {'key': 'properties.instanceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CloudApplicationEntity, self).__init__(**kwargs)
        self.kind = 'CloudApplication'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.app_id = None
        self.app_name = None
        self.instance_name = None


class CloudApplicationEntityProperties(EntityCommonProperties):
    """CloudApplication entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar app_id: The technical identifier of the application.
    :vartype app_id: int
    :ivar app_name: The name of the related cloud application.
    :vartype app_name: str
    :ivar instance_name: The user defined instance name of the cloud application. It is often used
     to distinguish between several applications of the same type that a customer has.
    :vartype instance_name: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'app_id': {'readonly': True},
        'app_name': {'readonly': True},
        'instance_name': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'int'},
        'app_name': {'key': 'appName', 'type': 'str'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CloudApplicationEntityProperties, self).__init__(**kwargs)
        self.app_id = None
        self.app_name = None
        self.instance_name = None


class CloudErrorBody(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None


class CodelessApiPollingDataConnector(DataConnector):
    """Represents Codeless API Polling data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar connector_ui_config: Config to describe the instructions blade.
    :vartype connector_ui_config:
     ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
    :ivar polling_config: Config to describe the polling instructions.
    :vartype polling_config:
     ~azure.mgmt.securityinsight.models.CodelessConnectorPollingConfigProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'connector_ui_config': {'key': 'properties.connectorUiConfig', 'type': 'CodelessUiConnectorConfigProperties'},
        'polling_config': {'key': 'properties.pollingConfig', 'type': 'CodelessConnectorPollingConfigProperties'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        connector_ui_config: Optional["CodelessUiConnectorConfigProperties"] = None,
        polling_config: Optional["CodelessConnectorPollingConfigProperties"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword connector_ui_config: Config to describe the instructions blade.
        :paramtype connector_ui_config:
         ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
        :keyword polling_config: Config to describe the polling instructions.
        :paramtype polling_config:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingConfigProperties
        """
        super(CodelessApiPollingDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'APIPolling'  # type: str
        self.connector_ui_config = connector_ui_config
        self.polling_config = polling_config


class CodelessConnectorPollingAuthProperties(msrest.serialization.Model):
    """Describe the authentication properties needed to successfully authenticate with the server.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.
    :vartype auth_type: str
    :ivar api_key_name: The header name which the token is sent with.
    :vartype api_key_name: str
    :ivar api_key_identifier: A prefix send in the header before the actual token.
    :vartype api_key_identifier: str
    :ivar is_api_key_in_post_payload: Marks if the key should sent in header.
    :vartype is_api_key_in_post_payload: str
    :ivar flow_name: Describes the flow name, for example 'AuthCode' for Oauth 2.0.
    :vartype flow_name: str
    :ivar token_endpoint: The endpoint used to issue a token, used in Oauth 2.0 flow.
    :vartype token_endpoint: str
    :ivar authorization_endpoint: The endpoint used to authorize the user, used in Oauth 2.0 flow.
    :vartype authorization_endpoint: str
    :ivar authorization_endpoint_query_parameters: The query parameters used in authorization
     request, used in Oauth 2.0 flow.
    :vartype authorization_endpoint_query_parameters: any
    :ivar redirection_endpoint: The redirect endpoint where we will get the authorization code,
     used in Oauth 2.0 flow.
    :vartype redirection_endpoint: str
    :ivar token_endpoint_headers: The query headers used in token request, used in Oauth 2.0 flow.
    :vartype token_endpoint_headers: any
    :ivar token_endpoint_query_parameters: The query parameters used in token request, used in
     Oauth 2.0 flow.
    :vartype token_endpoint_query_parameters: any
    :ivar is_client_secret_in_header: Marks if we should send the client secret in header or
     payload, used in Oauth 2.0 flow.
    :vartype is_client_secret_in_header: bool
    :ivar scope: The OAuth token scope.
    :vartype scope: str
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'api_key_name': {'key': 'apiKeyName', 'type': 'str'},
        'api_key_identifier': {'key': 'apiKeyIdentifier', 'type': 'str'},
        'is_api_key_in_post_payload': {'key': 'isApiKeyInPostPayload', 'type': 'str'},
        'flow_name': {'key': 'flowName', 'type': 'str'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'authorization_endpoint_query_parameters': {'key': 'authorizationEndpointQueryParameters', 'type': 'object'},
        'redirection_endpoint': {'key': 'redirectionEndpoint', 'type': 'str'},
        'token_endpoint_headers': {'key': 'tokenEndpointHeaders', 'type': 'object'},
        'token_endpoint_query_parameters': {'key': 'tokenEndpointQueryParameters', 'type': 'object'},
        'is_client_secret_in_header': {'key': 'isClientSecretInHeader', 'type': 'bool'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_type: str,
        api_key_name: Optional[str] = None,
        api_key_identifier: Optional[str] = None,
        is_api_key_in_post_payload: Optional[str] = None,
        flow_name: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        authorization_endpoint: Optional[str] = None,
        authorization_endpoint_query_parameters: Optional[Any] = None,
        redirection_endpoint: Optional[str] = None,
        token_endpoint_headers: Optional[Any] = None,
        token_endpoint_query_parameters: Optional[Any] = None,
        is_client_secret_in_header: Optional[bool] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword auth_type: Required. The authentication type.
        :paramtype auth_type: str
        :keyword api_key_name: The header name which the token is sent with.
        :paramtype api_key_name: str
        :keyword api_key_identifier: A prefix send in the header before the actual token.
        :paramtype api_key_identifier: str
        :keyword is_api_key_in_post_payload: Marks if the key should sent in header.
        :paramtype is_api_key_in_post_payload: str
        :keyword flow_name: Describes the flow name, for example 'AuthCode' for Oauth 2.0.
        :paramtype flow_name: str
        :keyword token_endpoint: The endpoint used to issue a token, used in Oauth 2.0 flow.
        :paramtype token_endpoint: str
        :keyword authorization_endpoint: The endpoint used to authorize the user, used in Oauth 2.0
         flow.
        :paramtype authorization_endpoint: str
        :keyword authorization_endpoint_query_parameters: The query parameters used in authorization
         request, used in Oauth 2.0 flow.
        :paramtype authorization_endpoint_query_parameters: any
        :keyword redirection_endpoint: The redirect endpoint where we will get the authorization code,
         used in Oauth 2.0 flow.
        :paramtype redirection_endpoint: str
        :keyword token_endpoint_headers: The query headers used in token request, used in Oauth 2.0
         flow.
        :paramtype token_endpoint_headers: any
        :keyword token_endpoint_query_parameters: The query parameters used in token request, used in
         Oauth 2.0 flow.
        :paramtype token_endpoint_query_parameters: any
        :keyword is_client_secret_in_header: Marks if we should send the client secret in header or
         payload, used in Oauth 2.0 flow.
        :paramtype is_client_secret_in_header: bool
        :keyword scope: The OAuth token scope.
        :paramtype scope: str
        """
        super(CodelessConnectorPollingAuthProperties, self).__init__(**kwargs)
        self.auth_type = auth_type
        self.api_key_name = api_key_name
        self.api_key_identifier = api_key_identifier
        self.is_api_key_in_post_payload = is_api_key_in_post_payload
        self.flow_name = flow_name
        self.token_endpoint = token_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.authorization_endpoint_query_parameters = authorization_endpoint_query_parameters
        self.redirection_endpoint = redirection_endpoint
        self.token_endpoint_headers = token_endpoint_headers
        self.token_endpoint_query_parameters = token_endpoint_query_parameters
        self.is_client_secret_in_header = is_client_secret_in_header
        self.scope = scope


class CodelessConnectorPollingConfigProperties(msrest.serialization.Model):
    """Config to describe the polling config for API poller connector.

    All required parameters must be populated in order to send to Azure.

    :ivar is_active: The poller active status.
    :vartype is_active: bool
    :ivar auth: Required. Describe the authentication type of the poller.
    :vartype auth: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingAuthProperties
    :ivar request: Required. Describe the poll request config parameters of the poller.
    :vartype request: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingRequestProperties
    :ivar paging: Describe the poll request paging config of the poller.
    :vartype paging: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingPagingProperties
    :ivar response: Describe the response config parameters of the poller.
    :vartype response:
     ~azure.mgmt.securityinsight.models.CodelessConnectorPollingResponseProperties
    """

    _validation = {
        'auth': {'required': True},
        'request': {'required': True},
    }

    _attribute_map = {
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'auth': {'key': 'auth', 'type': 'CodelessConnectorPollingAuthProperties'},
        'request': {'key': 'request', 'type': 'CodelessConnectorPollingRequestProperties'},
        'paging': {'key': 'paging', 'type': 'CodelessConnectorPollingPagingProperties'},
        'response': {'key': 'response', 'type': 'CodelessConnectorPollingResponseProperties'},
    }

    def __init__(
        self,
        *,
        auth: "CodelessConnectorPollingAuthProperties",
        request: "CodelessConnectorPollingRequestProperties",
        is_active: Optional[bool] = None,
        paging: Optional["CodelessConnectorPollingPagingProperties"] = None,
        response: Optional["CodelessConnectorPollingResponseProperties"] = None,
        **kwargs
    ):
        """
        :keyword is_active: The poller active status.
        :paramtype is_active: bool
        :keyword auth: Required. Describe the authentication type of the poller.
        :paramtype auth: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingAuthProperties
        :keyword request: Required. Describe the poll request config parameters of the poller.
        :paramtype request:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingRequestProperties
        :keyword paging: Describe the poll request paging config of the poller.
        :paramtype paging: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingPagingProperties
        :keyword response: Describe the response config parameters of the poller.
        :paramtype response:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingResponseProperties
        """
        super(CodelessConnectorPollingConfigProperties, self).__init__(**kwargs)
        self.is_active = is_active
        self.auth = auth
        self.request = request
        self.paging = paging
        self.response = response


class CodelessConnectorPollingPagingProperties(msrest.serialization.Model):
    """Describe the properties needed to make a pagination call.

    All required parameters must be populated in order to send to Azure.

    :ivar paging_type: Required. Describes the type. could be 'None', 'PageToken', 'PageCount',
     'TimeStamp'.
    :vartype paging_type: str
    :ivar next_page_para_name: Defines the name of a next page attribute.
    :vartype next_page_para_name: str
    :ivar next_page_token_json_path: Defines the path to a next page token JSON.
    :vartype next_page_token_json_path: str
    :ivar page_count_attribute_path: Defines the path to a page count attribute.
    :vartype page_count_attribute_path: str
    :ivar page_total_count_attribute_path: Defines the path to a page total count attribute.
    :vartype page_total_count_attribute_path: str
    :ivar page_time_stamp_attribute_path: Defines the path to a paging time stamp attribute.
    :vartype page_time_stamp_attribute_path: str
    :ivar search_the_latest_time_stamp_from_events_list: Determines whether to search for the
     latest time stamp in the events list.
    :vartype search_the_latest_time_stamp_from_events_list: str
    :ivar page_size_para_name: Defines the name of the page size parameter.
    :vartype page_size_para_name: str
    :ivar page_size: Defines the paging size.
    :vartype page_size: int
    """

    _validation = {
        'paging_type': {'required': True},
    }

    _attribute_map = {
        'paging_type': {'key': 'pagingType', 'type': 'str'},
        'next_page_para_name': {'key': 'nextPageParaName', 'type': 'str'},
        'next_page_token_json_path': {'key': 'nextPageTokenJsonPath', 'type': 'str'},
        'page_count_attribute_path': {'key': 'pageCountAttributePath', 'type': 'str'},
        'page_total_count_attribute_path': {'key': 'pageTotalCountAttributePath', 'type': 'str'},
        'page_time_stamp_attribute_path': {'key': 'pageTimeStampAttributePath', 'type': 'str'},
        'search_the_latest_time_stamp_from_events_list': {'key': 'searchTheLatestTimeStampFromEventsList', 'type': 'str'},
        'page_size_para_name': {'key': 'pageSizeParaName', 'type': 'str'},
        'page_size': {'key': 'pageSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        paging_type: str,
        next_page_para_name: Optional[str] = None,
        next_page_token_json_path: Optional[str] = None,
        page_count_attribute_path: Optional[str] = None,
        page_total_count_attribute_path: Optional[str] = None,
        page_time_stamp_attribute_path: Optional[str] = None,
        search_the_latest_time_stamp_from_events_list: Optional[str] = None,
        page_size_para_name: Optional[str] = None,
        page_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword paging_type: Required. Describes the type. could be 'None', 'PageToken', 'PageCount',
         'TimeStamp'.
        :paramtype paging_type: str
        :keyword next_page_para_name: Defines the name of a next page attribute.
        :paramtype next_page_para_name: str
        :keyword next_page_token_json_path: Defines the path to a next page token JSON.
        :paramtype next_page_token_json_path: str
        :keyword page_count_attribute_path: Defines the path to a page count attribute.
        :paramtype page_count_attribute_path: str
        :keyword page_total_count_attribute_path: Defines the path to a page total count attribute.
        :paramtype page_total_count_attribute_path: str
        :keyword page_time_stamp_attribute_path: Defines the path to a paging time stamp attribute.
        :paramtype page_time_stamp_attribute_path: str
        :keyword search_the_latest_time_stamp_from_events_list: Determines whether to search for the
         latest time stamp in the events list.
        :paramtype search_the_latest_time_stamp_from_events_list: str
        :keyword page_size_para_name: Defines the name of the page size parameter.
        :paramtype page_size_para_name: str
        :keyword page_size: Defines the paging size.
        :paramtype page_size: int
        """
        super(CodelessConnectorPollingPagingProperties, self).__init__(**kwargs)
        self.paging_type = paging_type
        self.next_page_para_name = next_page_para_name
        self.next_page_token_json_path = next_page_token_json_path
        self.page_count_attribute_path = page_count_attribute_path
        self.page_total_count_attribute_path = page_total_count_attribute_path
        self.page_time_stamp_attribute_path = page_time_stamp_attribute_path
        self.search_the_latest_time_stamp_from_events_list = search_the_latest_time_stamp_from_events_list
        self.page_size_para_name = page_size_para_name
        self.page_size = page_size


class CodelessConnectorPollingRequestProperties(msrest.serialization.Model):
    """Describe the request properties needed to successfully pull from the server.

    All required parameters must be populated in order to send to Azure.

    :ivar api_endpoint: Required. Describe the endpoint we should pull the data from.
    :vartype api_endpoint: str
    :ivar rate_limit_qps: Defines the rate limit QPS.
    :vartype rate_limit_qps: int
    :ivar query_window_in_min: Required. The window interval we will use the pull the data.
    :vartype query_window_in_min: int
    :ivar http_method: Required. The http method type we will use in the poll request, GET or POST.
    :vartype http_method: str
    :ivar query_time_format: Required. The time format will be used the query events in a specific
     window.
    :vartype query_time_format: str
    :ivar retry_count: Describe the amount of time we should try and poll the data in case of
     failure.
    :vartype retry_count: int
    :ivar timeout_in_seconds: The number of seconds we will consider as a request timeout.
    :vartype timeout_in_seconds: int
    :ivar headers: Describe the headers sent in the poll request.
    :vartype headers: any
    :ivar query_parameters: Describe the query parameters sent in the poll request.
    :vartype query_parameters: any
    :ivar query_parameters_template: For advanced scenarios for example user name/password embedded
     in nested JSON payload.
    :vartype query_parameters_template: str
    :ivar start_time_attribute_name: This will be used the query events from a start of the time
     window.
    :vartype start_time_attribute_name: str
    :ivar end_time_attribute_name: This will be used the query events from the end of the time
     window.
    :vartype end_time_attribute_name: str
    """

    _validation = {
        'api_endpoint': {'required': True},
        'query_window_in_min': {'required': True},
        'http_method': {'required': True},
        'query_time_format': {'required': True},
    }

    _attribute_map = {
        'api_endpoint': {'key': 'apiEndpoint', 'type': 'str'},
        'rate_limit_qps': {'key': 'rateLimitQps', 'type': 'int'},
        'query_window_in_min': {'key': 'queryWindowInMin', 'type': 'int'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'query_time_format': {'key': 'queryTimeFormat', 'type': 'str'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'int'},
        'headers': {'key': 'headers', 'type': 'object'},
        'query_parameters': {'key': 'queryParameters', 'type': 'object'},
        'query_parameters_template': {'key': 'queryParametersTemplate', 'type': 'str'},
        'start_time_attribute_name': {'key': 'startTimeAttributeName', 'type': 'str'},
        'end_time_attribute_name': {'key': 'endTimeAttributeName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_endpoint: str,
        query_window_in_min: int,
        http_method: str,
        query_time_format: str,
        rate_limit_qps: Optional[int] = None,
        retry_count: Optional[int] = None,
        timeout_in_seconds: Optional[int] = None,
        headers: Optional[Any] = None,
        query_parameters: Optional[Any] = None,
        query_parameters_template: Optional[str] = None,
        start_time_attribute_name: Optional[str] = None,
        end_time_attribute_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_endpoint: Required. Describe the endpoint we should pull the data from.
        :paramtype api_endpoint: str
        :keyword rate_limit_qps: Defines the rate limit QPS.
        :paramtype rate_limit_qps: int
        :keyword query_window_in_min: Required. The window interval we will use the pull the data.
        :paramtype query_window_in_min: int
        :keyword http_method: Required. The http method type we will use in the poll request, GET or
         POST.
        :paramtype http_method: str
        :keyword query_time_format: Required. The time format will be used the query events in a
         specific window.
        :paramtype query_time_format: str
        :keyword retry_count: Describe the amount of time we should try and poll the data in case of
         failure.
        :paramtype retry_count: int
        :keyword timeout_in_seconds: The number of seconds we will consider as a request timeout.
        :paramtype timeout_in_seconds: int
        :keyword headers: Describe the headers sent in the poll request.
        :paramtype headers: any
        :keyword query_parameters: Describe the query parameters sent in the poll request.
        :paramtype query_parameters: any
        :keyword query_parameters_template: For advanced scenarios for example user name/password
         embedded in nested JSON payload.
        :paramtype query_parameters_template: str
        :keyword start_time_attribute_name: This will be used the query events from a start of the time
         window.
        :paramtype start_time_attribute_name: str
        :keyword end_time_attribute_name: This will be used the query events from the end of the time
         window.
        :paramtype end_time_attribute_name: str
        """
        super(CodelessConnectorPollingRequestProperties, self).__init__(**kwargs)
        self.api_endpoint = api_endpoint
        self.rate_limit_qps = rate_limit_qps
        self.query_window_in_min = query_window_in_min
        self.http_method = http_method
        self.query_time_format = query_time_format
        self.retry_count = retry_count
        self.timeout_in_seconds = timeout_in_seconds
        self.headers = headers
        self.query_parameters = query_parameters
        self.query_parameters_template = query_parameters_template
        self.start_time_attribute_name = start_time_attribute_name
        self.end_time_attribute_name = end_time_attribute_name


class CodelessConnectorPollingResponseProperties(msrest.serialization.Model):
    """Describes the response from the external server.

    All required parameters must be populated in order to send to Azure.

    :ivar events_json_paths: Required. Describes the path we should extract the data in the
     response.
    :vartype events_json_paths: list[str]
    :ivar success_status_json_path: Describes the path we should extract the status code in the
     response.
    :vartype success_status_json_path: str
    :ivar success_status_value: Describes the path we should extract the status value in the
     response.
    :vartype success_status_value: str
    :ivar is_gzip_compressed: Describes if the data in the response is Gzip.
    :vartype is_gzip_compressed: bool
    """

    _validation = {
        'events_json_paths': {'required': True},
    }

    _attribute_map = {
        'events_json_paths': {'key': 'eventsJsonPaths', 'type': '[str]'},
        'success_status_json_path': {'key': 'successStatusJsonPath', 'type': 'str'},
        'success_status_value': {'key': 'successStatusValue', 'type': 'str'},
        'is_gzip_compressed': {'key': 'isGzipCompressed', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        events_json_paths: List[str],
        success_status_json_path: Optional[str] = None,
        success_status_value: Optional[str] = None,
        is_gzip_compressed: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword events_json_paths: Required. Describes the path we should extract the data in the
         response.
        :paramtype events_json_paths: list[str]
        :keyword success_status_json_path: Describes the path we should extract the status code in the
         response.
        :paramtype success_status_json_path: str
        :keyword success_status_value: Describes the path we should extract the status value in the
         response.
        :paramtype success_status_value: str
        :keyword is_gzip_compressed: Describes if the data in the response is Gzip.
        :paramtype is_gzip_compressed: bool
        """
        super(CodelessConnectorPollingResponseProperties, self).__init__(**kwargs)
        self.events_json_paths = events_json_paths
        self.success_status_json_path = success_status_json_path
        self.success_status_value = success_status_value
        self.is_gzip_compressed = is_gzip_compressed


class CodelessUiConnectorConfigProperties(msrest.serialization.Model):
    """Config to describe the instructions blade.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Required. Connector blade title.
    :vartype title: str
    :ivar publisher: Required. Connector publisher name.
    :vartype publisher: str
    :ivar description_markdown: Required. Connector description.
    :vartype description_markdown: str
    :ivar custom_image: An optional custom image to be used when displaying the connector within
     Azure Sentinel's connector's gallery.
    :vartype custom_image: str
    :ivar graph_queries_table_name: Required. Name of the table the connector will insert the data
     to.
    :vartype graph_queries_table_name: str
    :ivar graph_queries: Required. The graph query to show the current data status.
    :vartype graph_queries:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesGraphQueriesItem]
    :ivar sample_queries: Required. The sample queries for the connector.
    :vartype sample_queries:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesSampleQueriesItem]
    :ivar data_types: Required. Data types to check for last data received.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesDataTypesItem]
    :ivar connectivity_criteria: Required. Define the way the connector check connectivity.
    :vartype connectivity_criteria:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]
    :ivar availability: Required. Connector Availability Status.
    :vartype availability: ~azure.mgmt.securityinsight.models.Availability
    :ivar permissions: Required. Permissions required for the connector.
    :vartype permissions: ~azure.mgmt.securityinsight.models.Permissions
    :ivar instruction_steps: Required. Instruction steps to enable the connector.
    :vartype instruction_steps:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesInstructionStepsItem]
    """

    _validation = {
        'title': {'required': True},
        'publisher': {'required': True},
        'description_markdown': {'required': True},
        'graph_queries_table_name': {'required': True},
        'graph_queries': {'required': True},
        'sample_queries': {'required': True},
        'data_types': {'required': True},
        'connectivity_criteria': {'required': True},
        'availability': {'required': True},
        'permissions': {'required': True},
        'instruction_steps': {'required': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'description_markdown': {'key': 'descriptionMarkdown', 'type': 'str'},
        'custom_image': {'key': 'customImage', 'type': 'str'},
        'graph_queries_table_name': {'key': 'graphQueriesTableName', 'type': 'str'},
        'graph_queries': {'key': 'graphQueries', 'type': '[CodelessUiConnectorConfigPropertiesGraphQueriesItem]'},
        'sample_queries': {'key': 'sampleQueries', 'type': '[CodelessUiConnectorConfigPropertiesSampleQueriesItem]'},
        'data_types': {'key': 'dataTypes', 'type': '[CodelessUiConnectorConfigPropertiesDataTypesItem]'},
        'connectivity_criteria': {'key': 'connectivityCriteria', 'type': '[CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]'},
        'availability': {'key': 'availability', 'type': 'Availability'},
        'permissions': {'key': 'permissions', 'type': 'Permissions'},
        'instruction_steps': {'key': 'instructionSteps', 'type': '[CodelessUiConnectorConfigPropertiesInstructionStepsItem]'},
    }

    def __init__(
        self,
        *,
        title: str,
        publisher: str,
        description_markdown: str,
        graph_queries_table_name: str,
        graph_queries: List["CodelessUiConnectorConfigPropertiesGraphQueriesItem"],
        sample_queries: List["CodelessUiConnectorConfigPropertiesSampleQueriesItem"],
        data_types: List["CodelessUiConnectorConfigPropertiesDataTypesItem"],
        connectivity_criteria: List["CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem"],
        availability: "Availability",
        permissions: "Permissions",
        instruction_steps: List["CodelessUiConnectorConfigPropertiesInstructionStepsItem"],
        custom_image: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword title: Required. Connector blade title.
        :paramtype title: str
        :keyword publisher: Required. Connector publisher name.
        :paramtype publisher: str
        :keyword description_markdown: Required. Connector description.
        :paramtype description_markdown: str
        :keyword custom_image: An optional custom image to be used when displaying the connector within
         Azure Sentinel's connector's gallery.
        :paramtype custom_image: str
        :keyword graph_queries_table_name: Required. Name of the table the connector will insert the
         data to.
        :paramtype graph_queries_table_name: str
        :keyword graph_queries: Required. The graph query to show the current data status.
        :paramtype graph_queries:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesGraphQueriesItem]
        :keyword sample_queries: Required. The sample queries for the connector.
        :paramtype sample_queries:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesSampleQueriesItem]
        :keyword data_types: Required. Data types to check for last data received.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesDataTypesItem]
        :keyword connectivity_criteria: Required. Define the way the connector check connectivity.
        :paramtype connectivity_criteria:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]
        :keyword availability: Required. Connector Availability Status.
        :paramtype availability: ~azure.mgmt.securityinsight.models.Availability
        :keyword permissions: Required. Permissions required for the connector.
        :paramtype permissions: ~azure.mgmt.securityinsight.models.Permissions
        :keyword instruction_steps: Required. Instruction steps to enable the connector.
        :paramtype instruction_steps:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesInstructionStepsItem]
        """
        super(CodelessUiConnectorConfigProperties, self).__init__(**kwargs)
        self.title = title
        self.publisher = publisher
        self.description_markdown = description_markdown
        self.custom_image = custom_image
        self.graph_queries_table_name = graph_queries_table_name
        self.graph_queries = graph_queries
        self.sample_queries = sample_queries
        self.data_types = data_types
        self.connectivity_criteria = connectivity_criteria
        self.availability = availability
        self.permissions = permissions
        self.instruction_steps = instruction_steps


class ConnectivityCriteria(msrest.serialization.Model):
    """Setting for the connector check connectivity.

    :ivar type: type of connectivity. Possible values include: "IsConnectedQuery".
    :vartype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
    :ivar value: Queries for checking connectivity.
    :vartype value: list[str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ConnectivityType"]] = None,
        value: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: type of connectivity. Possible values include: "IsConnectedQuery".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
        :keyword value: Queries for checking connectivity.
        :paramtype value: list[str]
        """
        super(ConnectivityCriteria, self).__init__(**kwargs)
        self.type = type
        self.value = value


class CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem(ConnectivityCriteria):
    """CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem.

    :ivar type: type of connectivity. Possible values include: "IsConnectedQuery".
    :vartype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
    :ivar value: Queries for checking connectivity.
    :vartype value: list[str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ConnectivityType"]] = None,
        value: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: type of connectivity. Possible values include: "IsConnectedQuery".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
        :keyword value: Queries for checking connectivity.
        :paramtype value: list[str]
        """
        super(CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem, self).__init__(type=type, value=value, **kwargs)


class LastDataReceivedDataType(msrest.serialization.Model):
    """Data type for last data received.

    :ivar name: Name of the data type to show in the graph. can be use with
     {{graphQueriesTableName}} placeholder.
    :vartype name: str
    :ivar last_data_received_query: Query for indicate last data received.
    :vartype last_data_received_query: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'last_data_received_query': {'key': 'lastDataReceivedQuery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        last_data_received_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the data type to show in the graph. can be use with
         {{graphQueriesTableName}} placeholder.
        :paramtype name: str
        :keyword last_data_received_query: Query for indicate last data received.
        :paramtype last_data_received_query: str
        """
        super(LastDataReceivedDataType, self).__init__(**kwargs)
        self.name = name
        self.last_data_received_query = last_data_received_query


class CodelessUiConnectorConfigPropertiesDataTypesItem(LastDataReceivedDataType):
    """CodelessUiConnectorConfigPropertiesDataTypesItem.

    :ivar name: Name of the data type to show in the graph. can be use with
     {{graphQueriesTableName}} placeholder.
    :vartype name: str
    :ivar last_data_received_query: Query for indicate last data received.
    :vartype last_data_received_query: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'last_data_received_query': {'key': 'lastDataReceivedQuery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        last_data_received_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the data type to show in the graph. can be use with
         {{graphQueriesTableName}} placeholder.
        :paramtype name: str
        :keyword last_data_received_query: Query for indicate last data received.
        :paramtype last_data_received_query: str
        """
        super(CodelessUiConnectorConfigPropertiesDataTypesItem, self).__init__(name=name, last_data_received_query=last_data_received_query, **kwargs)


class GraphQueries(msrest.serialization.Model):
    """The graph query to show the current data status.

    :ivar metric_name: the metric that the query is checking.
    :vartype metric_name: str
    :ivar legend: The legend for the graph.
    :vartype legend: str
    :ivar base_query: The base query for the graph.
    :vartype base_query: str
    """

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'legend': {'key': 'legend', 'type': 'str'},
        'base_query': {'key': 'baseQuery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        legend: Optional[str] = None,
        base_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword metric_name: the metric that the query is checking.
        :paramtype metric_name: str
        :keyword legend: The legend for the graph.
        :paramtype legend: str
        :keyword base_query: The base query for the graph.
        :paramtype base_query: str
        """
        super(GraphQueries, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.legend = legend
        self.base_query = base_query


class CodelessUiConnectorConfigPropertiesGraphQueriesItem(GraphQueries):
    """CodelessUiConnectorConfigPropertiesGraphQueriesItem.

    :ivar metric_name: the metric that the query is checking.
    :vartype metric_name: str
    :ivar legend: The legend for the graph.
    :vartype legend: str
    :ivar base_query: The base query for the graph.
    :vartype base_query: str
    """

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'legend': {'key': 'legend', 'type': 'str'},
        'base_query': {'key': 'baseQuery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        legend: Optional[str] = None,
        base_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword metric_name: the metric that the query is checking.
        :paramtype metric_name: str
        :keyword legend: The legend for the graph.
        :paramtype legend: str
        :keyword base_query: The base query for the graph.
        :paramtype base_query: str
        """
        super(CodelessUiConnectorConfigPropertiesGraphQueriesItem, self).__init__(metric_name=metric_name, legend=legend, base_query=base_query, **kwargs)


class InstructionSteps(msrest.serialization.Model):
    """Instruction steps to enable the connector.

    :ivar title: Instruction step title.
    :vartype title: str
    :ivar description: Instruction step description.
    :vartype description: str
    :ivar instructions: Instruction step details.
    :vartype instructions:
     list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'instructions': {'key': 'instructions', 'type': '[InstructionStepsInstructionsItem]'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        instructions: Optional[List["InstructionStepsInstructionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword title: Instruction step title.
        :paramtype title: str
        :keyword description: Instruction step description.
        :paramtype description: str
        :keyword instructions: Instruction step details.
        :paramtype instructions:
         list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
        """
        super(InstructionSteps, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.instructions = instructions


class CodelessUiConnectorConfigPropertiesInstructionStepsItem(InstructionSteps):
    """CodelessUiConnectorConfigPropertiesInstructionStepsItem.

    :ivar title: Instruction step title.
    :vartype title: str
    :ivar description: Instruction step description.
    :vartype description: str
    :ivar instructions: Instruction step details.
    :vartype instructions:
     list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'instructions': {'key': 'instructions', 'type': '[InstructionStepsInstructionsItem]'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        instructions: Optional[List["InstructionStepsInstructionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword title: Instruction step title.
        :paramtype title: str
        :keyword description: Instruction step description.
        :paramtype description: str
        :keyword instructions: Instruction step details.
        :paramtype instructions:
         list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
        """
        super(CodelessUiConnectorConfigPropertiesInstructionStepsItem, self).__init__(title=title, description=description, instructions=instructions, **kwargs)


class SampleQueries(msrest.serialization.Model):
    """The sample queries for the connector.

    :ivar description: The sample query description.
    :vartype description: str
    :ivar query: the sample query.
    :vartype query: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The sample query description.
        :paramtype description: str
        :keyword query: the sample query.
        :paramtype query: str
        """
        super(SampleQueries, self).__init__(**kwargs)
        self.description = description
        self.query = query


class CodelessUiConnectorConfigPropertiesSampleQueriesItem(SampleQueries):
    """CodelessUiConnectorConfigPropertiesSampleQueriesItem.

    :ivar description: The sample query description.
    :vartype description: str
    :ivar query: the sample query.
    :vartype query: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The sample query description.
        :paramtype description: str
        :keyword query: the sample query.
        :paramtype query: str
        """
        super(CodelessUiConnectorConfigPropertiesSampleQueriesItem, self).__init__(description=description, query=query, **kwargs)


class CodelessUiDataConnector(DataConnector):
    """Represents Codeless UI data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar connector_ui_config: Config to describe the instructions blade.
    :vartype connector_ui_config:
     ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'connector_ui_config': {'key': 'properties.connectorUiConfig', 'type': 'CodelessUiConnectorConfigProperties'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        connector_ui_config: Optional["CodelessUiConnectorConfigProperties"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword connector_ui_config: Config to describe the instructions blade.
        :paramtype connector_ui_config:
         ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
        """
        super(CodelessUiDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'GenericUI'  # type: str
        self.connector_ui_config = connector_ui_config


class ConnectedEntity(msrest.serialization.Model):
    """Expansion result connected entities.

    :ivar target_entity_id: Entity Id of the connected entity.
    :vartype target_entity_id: str
    :ivar additional_data: key-value pairs for a connected entity mapping.
    :vartype additional_data: any
    """

    _attribute_map = {
        'target_entity_id': {'key': 'targetEntityId', 'type': 'str'},
        'additional_data': {'key': 'additionalData', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        target_entity_id: Optional[str] = None,
        additional_data: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword target_entity_id: Entity Id of the connected entity.
        :paramtype target_entity_id: str
        :keyword additional_data: key-value pairs for a connected entity mapping.
        :paramtype additional_data: any
        """
        super(ConnectedEntity, self).__init__(**kwargs)
        self.target_entity_id = target_entity_id
        self.additional_data = additional_data


class ConnectorInstructionModelBase(msrest.serialization.Model):
    """Instruction step details.

    All required parameters must be populated in order to send to Azure.

    :ivar parameters: The parameters for the setting.
    :vartype parameters: any
    :ivar type: Required. The kind of the setting. Possible values include: "CopyableLabel",
     "InstructionStepsGroup", "InfoMessage".
    :vartype type: str or ~azure.mgmt.securityinsight.models.SettingType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "SettingType"],
        parameters: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword parameters: The parameters for the setting.
        :paramtype parameters: any
        :keyword type: Required. The kind of the setting. Possible values include: "CopyableLabel",
         "InstructionStepsGroup", "InfoMessage".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.SettingType
        """
        super(ConnectorInstructionModelBase, self).__init__(**kwargs)
        self.parameters = parameters
        self.type = type


class ContentPathMap(msrest.serialization.Model):
    """The mapping of content type to a repo path.

    :ivar content_type: Content type. Possible values include: "AnalyticRule", "Workbook".
    :vartype content_type: str or ~azure.mgmt.securityinsight.models.ContentType
    :ivar path: The path to the content.
    :vartype path: str
    """

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content_type: Optional[Union[str, "ContentType"]] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content_type: Content type. Possible values include: "AnalyticRule", "Workbook".
        :paramtype content_type: str or ~azure.mgmt.securityinsight.models.ContentType
        :keyword path: The path to the content.
        :paramtype path: str
        """
        super(ContentPathMap, self).__init__(**kwargs)
        self.content_type = content_type
        self.path = path


class CustomsPermission(msrest.serialization.Model):
    """Customs permissions required for the connector.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super(CustomsPermission, self).__init__(**kwargs)
        self.name = name
        self.description = description


class Customs(CustomsPermission):
    """Customs permissions required for the connector.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super(Customs, self).__init__(name=name, description=description, **kwargs)


class DataConnectorConnectBody(msrest.serialization.Model):
    """Represents Codeless API Polling data connector.

    :ivar kind: The authentication kind used to poll the data. Possible values include: "Basic",
     "OAuth2", "APIKey".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ConnectAuthKind
    :ivar api_key: The API key of the audit server.
    :vartype api_key: str
    :ivar client_secret: The client secret of the OAuth 2.0 application.
    :vartype client_secret: str
    :ivar client_id: The client id of the OAuth 2.0 application.
    :vartype client_id: str
    :ivar authorization_code: The authorization code used in OAuth 2.0 code flow to issue a token.
    :vartype authorization_code: str
    :ivar user_name: The user name in the audit log server.
    :vartype user_name: str
    :ivar password: The user password in the audit log server.
    :vartype password: str
    :ivar request_config_user_input_values:
    :vartype request_config_user_input_values: list[any]
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'authorization_code': {'key': 'authorizationCode', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'request_config_user_input_values': {'key': 'requestConfigUserInputValues', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "ConnectAuthKind"]] = None,
        api_key: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_id: Optional[str] = None,
        authorization_code: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        request_config_user_input_values: Optional[List[Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: The authentication kind used to poll the data. Possible values include: "Basic",
         "OAuth2", "APIKey".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.ConnectAuthKind
        :keyword api_key: The API key of the audit server.
        :paramtype api_key: str
        :keyword client_secret: The client secret of the OAuth 2.0 application.
        :paramtype client_secret: str
        :keyword client_id: The client id of the OAuth 2.0 application.
        :paramtype client_id: str
        :keyword authorization_code: The authorization code used in OAuth 2.0 code flow to issue a
         token.
        :paramtype authorization_code: str
        :keyword user_name: The user name in the audit log server.
        :paramtype user_name: str
        :keyword password: The user password in the audit log server.
        :paramtype password: str
        :keyword request_config_user_input_values:
        :paramtype request_config_user_input_values: list[any]
        """
        super(DataConnectorConnectBody, self).__init__(**kwargs)
        self.kind = kind
        self.api_key = api_key
        self.client_secret = client_secret
        self.client_id = client_id
        self.authorization_code = authorization_code
        self.user_name = user_name
        self.password = password
        self.request_config_user_input_values = request_config_user_input_values


class DataConnectorList(msrest.serialization.Model):
    """List all the data connectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of data connectors.
    :vartype next_link: str
    :ivar value: Required. Array of data connectors.
    :vartype value: list[~azure.mgmt.securityinsight.models.DataConnector]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataConnector]'},
    }

    def __init__(
        self,
        *,
        value: List["DataConnector"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of data connectors.
        :paramtype value: list[~azure.mgmt.securityinsight.models.DataConnector]
        """
        super(DataConnectorList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class DataConnectorRequirementsState(msrest.serialization.Model):
    """Data connector requirements status.

    :ivar authorization_state: Authorization state for this connector. Possible values include:
     "Valid", "Invalid".
    :vartype authorization_state: str or
     ~azure.mgmt.securityinsight.models.DataConnectorAuthorizationState
    :ivar license_state: License state for this connector. Possible values include: "Valid",
     "Invalid", "Unknown".
    :vartype license_state: str or ~azure.mgmt.securityinsight.models.DataConnectorLicenseState
    """

    _attribute_map = {
        'authorization_state': {'key': 'authorizationState', 'type': 'str'},
        'license_state': {'key': 'licenseState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_state: Optional[Union[str, "DataConnectorAuthorizationState"]] = None,
        license_state: Optional[Union[str, "DataConnectorLicenseState"]] = None,
        **kwargs
    ):
        """
        :keyword authorization_state: Authorization state for this connector. Possible values include:
         "Valid", "Invalid".
        :paramtype authorization_state: str or
         ~azure.mgmt.securityinsight.models.DataConnectorAuthorizationState
        :keyword license_state: License state for this connector. Possible values include: "Valid",
         "Invalid", "Unknown".
        :paramtype license_state: str or ~azure.mgmt.securityinsight.models.DataConnectorLicenseState
        """
        super(DataConnectorRequirementsState, self).__init__(**kwargs)
        self.authorization_state = authorization_state
        self.license_state = license_state


class DataTypeDefinitions(msrest.serialization.Model):
    """The data type definition.

    :ivar data_type: The data type name.
    :vartype data_type: str
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_type: The data type name.
        :paramtype data_type: str
        """
        super(DataTypeDefinitions, self).__init__(**kwargs)
        self.data_type = data_type


class Deployment(msrest.serialization.Model):
    """Description about a deployment.

    :ivar deployment_id: Deployment identifier.
    :vartype deployment_id: str
    :ivar deployment_state: Current status of the deployment. Possible values include:
     "In_Progress", "Completed", "Queued", "Canceling".
    :vartype deployment_state: str or ~azure.mgmt.securityinsight.models.DeploymentState
    :ivar deployment_result: The outcome of the deployment. Possible values include: "Success",
     "Canceled", "Failed".
    :vartype deployment_result: str or ~azure.mgmt.securityinsight.models.DeploymentResult
    :ivar deployment_time: The time when the deployment finished.
    :vartype deployment_time: ~datetime.datetime
    :ivar deployment_logs_url: Url to access repository action logs.
    :vartype deployment_logs_url: str
    """

    _attribute_map = {
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'deployment_state': {'key': 'deploymentState', 'type': 'str'},
        'deployment_result': {'key': 'deploymentResult', 'type': 'str'},
        'deployment_time': {'key': 'deploymentTime', 'type': 'iso-8601'},
        'deployment_logs_url': {'key': 'deploymentLogsUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        deployment_id: Optional[str] = None,
        deployment_state: Optional[Union[str, "DeploymentState"]] = None,
        deployment_result: Optional[Union[str, "DeploymentResult"]] = None,
        deployment_time: Optional[datetime.datetime] = None,
        deployment_logs_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_id: Deployment identifier.
        :paramtype deployment_id: str
        :keyword deployment_state: Current status of the deployment. Possible values include:
         "In_Progress", "Completed", "Queued", "Canceling".
        :paramtype deployment_state: str or ~azure.mgmt.securityinsight.models.DeploymentState
        :keyword deployment_result: The outcome of the deployment. Possible values include: "Success",
         "Canceled", "Failed".
        :paramtype deployment_result: str or ~azure.mgmt.securityinsight.models.DeploymentResult
        :keyword deployment_time: The time when the deployment finished.
        :paramtype deployment_time: ~datetime.datetime
        :keyword deployment_logs_url: Url to access repository action logs.
        :paramtype deployment_logs_url: str
        """
        super(Deployment, self).__init__(**kwargs)
        self.deployment_id = deployment_id
        self.deployment_state = deployment_state
        self.deployment_result = deployment_result
        self.deployment_time = deployment_time
        self.deployment_logs_url = deployment_logs_url


class DeploymentInfo(msrest.serialization.Model):
    """Information regarding a deployment.

    :ivar deployment_fetch_status: Status while fetching the last deployment. Possible values
     include: "Success", "Unauthorized", "NotFound".
    :vartype deployment_fetch_status: str or
     ~azure.mgmt.securityinsight.models.DeploymentFetchStatus
    :ivar deployment: Deployment information.
    :vartype deployment: ~azure.mgmt.securityinsight.models.Deployment
    :ivar message: Additional details about the deployment that can be shown to the user.
    :vartype message: str
    """

    _attribute_map = {
        'deployment_fetch_status': {'key': 'deploymentFetchStatus', 'type': 'str'},
        'deployment': {'key': 'deployment', 'type': 'Deployment'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        deployment_fetch_status: Optional[Union[str, "DeploymentFetchStatus"]] = None,
        deployment: Optional["Deployment"] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_fetch_status: Status while fetching the last deployment. Possible values
         include: "Success", "Unauthorized", "NotFound".
        :paramtype deployment_fetch_status: str or
         ~azure.mgmt.securityinsight.models.DeploymentFetchStatus
        :keyword deployment: Deployment information.
        :paramtype deployment: ~azure.mgmt.securityinsight.models.Deployment
        :keyword message: Additional details about the deployment that can be shown to the user.
        :paramtype message: str
        """
        super(DeploymentInfo, self).__init__(**kwargs)
        self.deployment_fetch_status = deployment_fetch_status
        self.deployment = deployment
        self.message = message


class DnsEntity(Entity):
    """Represents a dns entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar dns_server_ip_entity_id: An ip entity id for the dns server resolving the request.
    :vartype dns_server_ip_entity_id: str
    :ivar domain_name: The name of the dns record associated with the alert.
    :vartype domain_name: str
    :ivar host_ip_address_entity_id: An ip entity id for the dns request client.
    :vartype host_ip_address_entity_id: str
    :ivar ip_address_entity_ids: Ip entity identifiers for the resolved ip address.
    :vartype ip_address_entity_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'dns_server_ip_entity_id': {'readonly': True},
        'domain_name': {'readonly': True},
        'host_ip_address_entity_id': {'readonly': True},
        'ip_address_entity_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'dns_server_ip_entity_id': {'key': 'properties.dnsServerIpEntityId', 'type': 'str'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'host_ip_address_entity_id': {'key': 'properties.hostIpAddressEntityId', 'type': 'str'},
        'ip_address_entity_ids': {'key': 'properties.ipAddressEntityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DnsEntity, self).__init__(**kwargs)
        self.kind = 'DnsResolution'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.dns_server_ip_entity_id = None
        self.domain_name = None
        self.host_ip_address_entity_id = None
        self.ip_address_entity_ids = None


class DnsEntityProperties(EntityCommonProperties):
    """Dns entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar dns_server_ip_entity_id: An ip entity id for the dns server resolving the request.
    :vartype dns_server_ip_entity_id: str
    :ivar domain_name: The name of the dns record associated with the alert.
    :vartype domain_name: str
    :ivar host_ip_address_entity_id: An ip entity id for the dns request client.
    :vartype host_ip_address_entity_id: str
    :ivar ip_address_entity_ids: Ip entity identifiers for the resolved ip address.
    :vartype ip_address_entity_ids: list[str]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'dns_server_ip_entity_id': {'readonly': True},
        'domain_name': {'readonly': True},
        'host_ip_address_entity_id': {'readonly': True},
        'ip_address_entity_ids': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'dns_server_ip_entity_id': {'key': 'dnsServerIpEntityId', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'host_ip_address_entity_id': {'key': 'hostIpAddressEntityId', 'type': 'str'},
        'ip_address_entity_ids': {'key': 'ipAddressEntityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DnsEntityProperties, self).__init__(**kwargs)
        self.dns_server_ip_entity_id = None
        self.domain_name = None
        self.host_ip_address_entity_id = None
        self.ip_address_entity_ids = None


class Dynamics365CheckRequirements(DataConnectorsCheckRequirements):
    """Represents Dynamics365 requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(Dynamics365CheckRequirements, self).__init__(**kwargs)
        self.kind = 'Dynamics365'  # type: str
        self.tenant_id = tenant_id


class Dynamics365CheckRequirementsProperties(DataConnectorTenantId):
    """Dynamics365 requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(Dynamics365CheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class Dynamics365DataConnector(DataConnector):
    """Represents Dynamics365 data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'Dynamics365DataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["Dynamics365DataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
        """
        super(Dynamics365DataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'Dynamics365'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class Dynamics365DataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Dynamics365 data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar dynamics365_cds_activities: Required. Common Data Service data type connection.
    :vartype dynamics365_cds_activities:
     ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
    """

    _validation = {
        'dynamics365_cds_activities': {'required': True},
    }

    _attribute_map = {
        'dynamics365_cds_activities': {'key': 'dynamics365CdsActivities', 'type': 'Dynamics365DataConnectorDataTypesDynamics365CdsActivities'},
    }

    def __init__(
        self,
        *,
        dynamics365_cds_activities: "Dynamics365DataConnectorDataTypesDynamics365CdsActivities",
        **kwargs
    ):
        """
        :keyword dynamics365_cds_activities: Required. Common Data Service data type connection.
        :paramtype dynamics365_cds_activities:
         ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
        """
        super(Dynamics365DataConnectorDataTypes, self).__init__(**kwargs)
        self.dynamics365_cds_activities = dynamics365_cds_activities


class Dynamics365DataConnectorDataTypesDynamics365CdsActivities(DataConnectorDataTypeCommon):
    """Common Data Service data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(Dynamics365DataConnectorDataTypesDynamics365CdsActivities, self).__init__(state=state, **kwargs)


class Dynamics365DataConnectorProperties(DataConnectorTenantId):
    """Dynamics365 data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'Dynamics365DataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "Dynamics365DataConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
        """
        super(Dynamics365DataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class EnrichmentDomainWhois(msrest.serialization.Model):
    """Whois information for a given domain and associated metadata.

    :ivar domain: The domain for this whois record.
    :vartype domain: str
    :ivar server: The hostname of this registrar's whois server.
    :vartype server: str
    :ivar created: The timestamp at which this record was created.
    :vartype created: ~datetime.datetime
    :ivar updated: The timestamp at which this record was last updated.
    :vartype updated: ~datetime.datetime
    :ivar expires: The timestamp at which this record will expire.
    :vartype expires: ~datetime.datetime
    :ivar parsed_whois: The whois record for a given domain.
    :vartype parsed_whois: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisDetails
    """

    _attribute_map = {
        'domain': {'key': 'domain', 'type': 'str'},
        'server': {'key': 'server', 'type': 'str'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'updated': {'key': 'updated', 'type': 'iso-8601'},
        'expires': {'key': 'expires', 'type': 'iso-8601'},
        'parsed_whois': {'key': 'parsedWhois', 'type': 'EnrichmentDomainWhoisDetails'},
    }

    def __init__(
        self,
        *,
        domain: Optional[str] = None,
        server: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        parsed_whois: Optional["EnrichmentDomainWhoisDetails"] = None,
        **kwargs
    ):
        """
        :keyword domain: The domain for this whois record.
        :paramtype domain: str
        :keyword server: The hostname of this registrar's whois server.
        :paramtype server: str
        :keyword created: The timestamp at which this record was created.
        :paramtype created: ~datetime.datetime
        :keyword updated: The timestamp at which this record was last updated.
        :paramtype updated: ~datetime.datetime
        :keyword expires: The timestamp at which this record will expire.
        :paramtype expires: ~datetime.datetime
        :keyword parsed_whois: The whois record for a given domain.
        :paramtype parsed_whois: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisDetails
        """
        super(EnrichmentDomainWhois, self).__init__(**kwargs)
        self.domain = domain
        self.server = server
        self.created = created
        self.updated = updated
        self.expires = expires
        self.parsed_whois = parsed_whois


class EnrichmentDomainWhoisContact(msrest.serialization.Model):
    """An individual contact associated with this domain.

    :ivar name: The name of this contact.
    :vartype name: str
    :ivar org: The organization for this contact.
    :vartype org: str
    :ivar street: A list describing the street address for this contact.
    :vartype street: list[str]
    :ivar city: The city for this contact.
    :vartype city: str
    :ivar state: The state for this contact.
    :vartype state: str
    :ivar postal: The postal code for this contact.
    :vartype postal: str
    :ivar country: The country for this contact.
    :vartype country: str
    :ivar phone: The phone number for this contact.
    :vartype phone: str
    :ivar fax: The fax number for this contact.
    :vartype fax: str
    :ivar email: The email address for this contact.
    :vartype email: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'org': {'key': 'org', 'type': 'str'},
        'street': {'key': 'street', 'type': '[str]'},
        'city': {'key': 'city', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'postal': {'key': 'postal', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'fax': {'key': 'fax', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        org: Optional[str] = None,
        street: Optional[List[str]] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        postal: Optional[str] = None,
        country: Optional[str] = None,
        phone: Optional[str] = None,
        fax: Optional[str] = None,
        email: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of this contact.
        :paramtype name: str
        :keyword org: The organization for this contact.
        :paramtype org: str
        :keyword street: A list describing the street address for this contact.
        :paramtype street: list[str]
        :keyword city: The city for this contact.
        :paramtype city: str
        :keyword state: The state for this contact.
        :paramtype state: str
        :keyword postal: The postal code for this contact.
        :paramtype postal: str
        :keyword country: The country for this contact.
        :paramtype country: str
        :keyword phone: The phone number for this contact.
        :paramtype phone: str
        :keyword fax: The fax number for this contact.
        :paramtype fax: str
        :keyword email: The email address for this contact.
        :paramtype email: str
        """
        super(EnrichmentDomainWhoisContact, self).__init__(**kwargs)
        self.name = name
        self.org = org
        self.street = street
        self.city = city
        self.state = state
        self.postal = postal
        self.country = country
        self.phone = phone
        self.fax = fax
        self.email = email


class EnrichmentDomainWhoisContacts(msrest.serialization.Model):
    """The set of contacts associated with this domain.

    :ivar admin: The admin contact for this whois record.
    :vartype admin: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar billing: The billing contact for this whois record.
    :vartype billing: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar registrant: The registrant contact for this whois record.
    :vartype registrant: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar tech: The technical contact for this whois record.
    :vartype tech: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    """

    _attribute_map = {
        'admin': {'key': 'admin', 'type': 'EnrichmentDomainWhoisContact'},
        'billing': {'key': 'billing', 'type': 'EnrichmentDomainWhoisContact'},
        'registrant': {'key': 'registrant', 'type': 'EnrichmentDomainWhoisContact'},
        'tech': {'key': 'tech', 'type': 'EnrichmentDomainWhoisContact'},
    }

    def __init__(
        self,
        *,
        admin: Optional["EnrichmentDomainWhoisContact"] = None,
        billing: Optional["EnrichmentDomainWhoisContact"] = None,
        registrant: Optional["EnrichmentDomainWhoisContact"] = None,
        tech: Optional["EnrichmentDomainWhoisContact"] = None,
        **kwargs
    ):
        """
        :keyword admin: The admin contact for this whois record.
        :paramtype admin: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword billing: The billing contact for this whois record.
        :paramtype billing: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword registrant: The registrant contact for this whois record.
        :paramtype registrant: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword tech: The technical contact for this whois record.
        :paramtype tech: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        """
        super(EnrichmentDomainWhoisContacts, self).__init__(**kwargs)
        self.admin = admin
        self.billing = billing
        self.registrant = registrant
        self.tech = tech


class EnrichmentDomainWhoisDetails(msrest.serialization.Model):
    """The whois record for a given domain.

    :ivar registrar: The registrar associated with this domain.
    :vartype registrar: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisRegistrarDetails
    :ivar contacts: The set of contacts associated with this domain.
    :vartype contacts: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContacts
    :ivar name_servers: A list of name servers associated with this domain.
    :vartype name_servers: list[str]
    :ivar statuses: The set of status flags for this whois record.
    :vartype statuses: list[str]
    """

    _attribute_map = {
        'registrar': {'key': 'registrar', 'type': 'EnrichmentDomainWhoisRegistrarDetails'},
        'contacts': {'key': 'contacts', 'type': 'EnrichmentDomainWhoisContacts'},
        'name_servers': {'key': 'nameServers', 'type': '[str]'},
        'statuses': {'key': 'statuses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        registrar: Optional["EnrichmentDomainWhoisRegistrarDetails"] = None,
        contacts: Optional["EnrichmentDomainWhoisContacts"] = None,
        name_servers: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword registrar: The registrar associated with this domain.
        :paramtype registrar: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisRegistrarDetails
        :keyword contacts: The set of contacts associated with this domain.
        :paramtype contacts: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContacts
        :keyword name_servers: A list of name servers associated with this domain.
        :paramtype name_servers: list[str]
        :keyword statuses: The set of status flags for this whois record.
        :paramtype statuses: list[str]
        """
        super(EnrichmentDomainWhoisDetails, self).__init__(**kwargs)
        self.registrar = registrar
        self.contacts = contacts
        self.name_servers = name_servers
        self.statuses = statuses


class EnrichmentDomainWhoisRegistrarDetails(msrest.serialization.Model):
    """The registrar associated with this domain.

    :ivar name: The name of this registrar.
    :vartype name: str
    :ivar abuse_contact_email: This registrar's abuse contact email.
    :vartype abuse_contact_email: str
    :ivar abuse_contact_phone: This registrar's abuse contact phone number.
    :vartype abuse_contact_phone: str
    :ivar iana_id: This registrar's Internet Assigned Numbers Authority id.
    :vartype iana_id: str
    :ivar url: This registrar's URL.
    :vartype url: str
    :ivar whois_server: The hostname of this registrar's whois server.
    :vartype whois_server: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'abuse_contact_email': {'key': 'abuseContactEmail', 'type': 'str'},
        'abuse_contact_phone': {'key': 'abuseContactPhone', 'type': 'str'},
        'iana_id': {'key': 'ianaId', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'whois_server': {'key': 'whoisServer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        abuse_contact_email: Optional[str] = None,
        abuse_contact_phone: Optional[str] = None,
        iana_id: Optional[str] = None,
        url: Optional[str] = None,
        whois_server: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of this registrar.
        :paramtype name: str
        :keyword abuse_contact_email: This registrar's abuse contact email.
        :paramtype abuse_contact_email: str
        :keyword abuse_contact_phone: This registrar's abuse contact phone number.
        :paramtype abuse_contact_phone: str
        :keyword iana_id: This registrar's Internet Assigned Numbers Authority id.
        :paramtype iana_id: str
        :keyword url: This registrar's URL.
        :paramtype url: str
        :keyword whois_server: The hostname of this registrar's whois server.
        :paramtype whois_server: str
        """
        super(EnrichmentDomainWhoisRegistrarDetails, self).__init__(**kwargs)
        self.name = name
        self.abuse_contact_email = abuse_contact_email
        self.abuse_contact_phone = abuse_contact_phone
        self.iana_id = iana_id
        self.url = url
        self.whois_server = whois_server


class EnrichmentIpGeodata(msrest.serialization.Model):
    """Geodata information for a given IP address.

    :ivar asn: The autonomous system number associated with this IP address.
    :vartype asn: str
    :ivar carrier: The name of the carrier for this IP address.
    :vartype carrier: str
    :ivar city: The city this IP address is located in.
    :vartype city: str
    :ivar city_cf: A numeric rating of confidence that the value in the 'city' field is correct, on
     a scale of 0-100.
    :vartype city_cf: int
    :ivar continent: The continent this IP address is located on.
    :vartype continent: str
    :ivar country: The county this IP address is located in.
    :vartype country: str
    :ivar country_cf: A numeric rating of confidence that the value in the 'country' field is
     correct on a scale of 0-100.
    :vartype country_cf: int
    :ivar ip_addr: The dotted-decimal or colon-separated string representation of the IP address.
    :vartype ip_addr: str
    :ivar ip_routing_type: A description of the connection type of this IP address.
    :vartype ip_routing_type: str
    :ivar latitude: The latitude of this IP address.
    :vartype latitude: str
    :ivar longitude: The longitude of this IP address.
    :vartype longitude: str
    :ivar organization: The name of the organization for this IP address.
    :vartype organization: str
    :ivar organization_type: The type of the organization for this IP address.
    :vartype organization_type: str
    :ivar region: The geographic region this IP address is located in.
    :vartype region: str
    :ivar state: The state this IP address is located in.
    :vartype state: str
    :ivar state_cf: A numeric rating of confidence that the value in the 'state' field is correct
     on a scale of 0-100.
    :vartype state_cf: int
    :ivar state_code: The abbreviated name for the state this IP address is located in.
    :vartype state_code: str
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'str'},
        'carrier': {'key': 'carrier', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'city_cf': {'key': 'cityCf', 'type': 'int'},
        'continent': {'key': 'continent', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'country_cf': {'key': 'countryCf', 'type': 'int'},
        'ip_addr': {'key': 'ipAddr', 'type': 'str'},
        'ip_routing_type': {'key': 'ipRoutingType', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'str'},
        'longitude': {'key': 'longitude', 'type': 'str'},
        'organization': {'key': 'organization', 'type': 'str'},
        'organization_type': {'key': 'organizationType', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'state_cf': {'key': 'stateCf', 'type': 'int'},
        'state_code': {'key': 'stateCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asn: Optional[str] = None,
        carrier: Optional[str] = None,
        city: Optional[str] = None,
        city_cf: Optional[int] = None,
        continent: Optional[str] = None,
        country: Optional[str] = None,
        country_cf: Optional[int] = None,
        ip_addr: Optional[str] = None,
        ip_routing_type: Optional[str] = None,
        latitude: Optional[str] = None,
        longitude: Optional[str] = None,
        organization: Optional[str] = None,
        organization_type: Optional[str] = None,
        region: Optional[str] = None,
        state: Optional[str] = None,
        state_cf: Optional[int] = None,
        state_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asn: The autonomous system number associated with this IP address.
        :paramtype asn: str
        :keyword carrier: The name of the carrier for this IP address.
        :paramtype carrier: str
        :keyword city: The city this IP address is located in.
        :paramtype city: str
        :keyword city_cf: A numeric rating of confidence that the value in the 'city' field is correct,
         on a scale of 0-100.
        :paramtype city_cf: int
        :keyword continent: The continent this IP address is located on.
        :paramtype continent: str
        :keyword country: The county this IP address is located in.
        :paramtype country: str
        :keyword country_cf: A numeric rating of confidence that the value in the 'country' field is
         correct on a scale of 0-100.
        :paramtype country_cf: int
        :keyword ip_addr: The dotted-decimal or colon-separated string representation of the IP
         address.
        :paramtype ip_addr: str
        :keyword ip_routing_type: A description of the connection type of this IP address.
        :paramtype ip_routing_type: str
        :keyword latitude: The latitude of this IP address.
        :paramtype latitude: str
        :keyword longitude: The longitude of this IP address.
        :paramtype longitude: str
        :keyword organization: The name of the organization for this IP address.
        :paramtype organization: str
        :keyword organization_type: The type of the organization for this IP address.
        :paramtype organization_type: str
        :keyword region: The geographic region this IP address is located in.
        :paramtype region: str
        :keyword state: The state this IP address is located in.
        :paramtype state: str
        :keyword state_cf: A numeric rating of confidence that the value in the 'state' field is
         correct on a scale of 0-100.
        :paramtype state_cf: int
        :keyword state_code: The abbreviated name for the state this IP address is located in.
        :paramtype state_code: str
        """
        super(EnrichmentIpGeodata, self).__init__(**kwargs)
        self.asn = asn
        self.carrier = carrier
        self.city = city
        self.city_cf = city_cf
        self.continent = continent
        self.country = country
        self.country_cf = country_cf
        self.ip_addr = ip_addr
        self.ip_routing_type = ip_routing_type
        self.latitude = latitude
        self.longitude = longitude
        self.organization = organization
        self.organization_type = organization_type
        self.region = region
        self.state = state
        self.state_cf = state_cf
        self.state_code = state_code


class EntityAnalytics(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the setting.Constant filled by server. Possible values
     include: "Anomalies", "EyesOn", "EntityAnalytics", "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar is_enabled: Determines whether the setting is enable or disabled.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(EntityAnalytics, self).__init__(etag=etag, **kwargs)
        self.kind = 'EntityAnalytics'  # type: str
        self.is_enabled = None


class EntityEdges(msrest.serialization.Model):
    """The edge that connects the entity to the other entity.

    :ivar target_entity_id: The target entity Id.
    :vartype target_entity_id: str
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    """

    _attribute_map = {
        'target_entity_id': {'key': 'targetEntityId', 'type': 'str'},
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        target_entity_id: Optional[str] = None,
        additional_data: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword target_entity_id: The target entity Id.
        :paramtype target_entity_id: str
        :keyword additional_data: A bag of custom fields that should be part of the entity and will be
         presented to the user.
        :paramtype additional_data: dict[str, any]
        """
        super(EntityEdges, self).__init__(**kwargs)
        self.target_entity_id = target_entity_id
        self.additional_data = additional_data


class EntityExpandParameters(msrest.serialization.Model):
    """The parameters required to execute an expand operation on the given entity.

    :ivar end_time: The end date filter, so the only expansion results returned are before this
     date.
    :vartype end_time: ~datetime.datetime
    :ivar expansion_id: The Id of the expansion to perform.
    :vartype expansion_id: str
    :ivar start_time: The start date filter, so the only expansion results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'expansion_id': {'key': 'expansionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        expansion_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: The end date filter, so the only expansion results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword expansion_id: The Id of the expansion to perform.
        :paramtype expansion_id: str
        :keyword start_time: The start date filter, so the only expansion results returned are after
         this date.
        :paramtype start_time: ~datetime.datetime
        """
        super(EntityExpandParameters, self).__init__(**kwargs)
        self.end_time = end_time
        self.expansion_id = expansion_id
        self.start_time = start_time


class EntityExpandResponse(msrest.serialization.Model):
    """The entity expansion result operation response.

    :ivar meta_data: The metadata from the expansion operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
    :ivar value: The expansion result values.
    :vartype value: ~azure.mgmt.securityinsight.models.EntityExpandResponseValue
    """

    _attribute_map = {
        'meta_data': {'key': 'metaData', 'type': 'ExpansionResultsMetadata'},
        'value': {'key': 'value', 'type': 'EntityExpandResponseValue'},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["ExpansionResultsMetadata"] = None,
        value: Optional["EntityExpandResponseValue"] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the expansion operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
        :keyword value: The expansion result values.
        :paramtype value: ~azure.mgmt.securityinsight.models.EntityExpandResponseValue
        """
        super(EntityExpandResponse, self).__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EntityExpandResponseValue(msrest.serialization.Model):
    """The expansion result values.

    :ivar entities: Array of the expansion result entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar edges: Array of edges that connects the entity to the list of entities.
    :vartype edges: list[~azure.mgmt.securityinsight.models.EntityEdges]
    """

    _attribute_map = {
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'edges': {'key': 'edges', 'type': '[EntityEdges]'},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["Entity"]] = None,
        edges: Optional[List["EntityEdges"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the expansion result entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword edges: Array of edges that connects the entity to the list of entities.
        :paramtype edges: list[~azure.mgmt.securityinsight.models.EntityEdges]
        """
        super(EntityExpandResponseValue, self).__init__(**kwargs)
        self.entities = entities
        self.edges = edges


class EntityFieldMapping(msrest.serialization.Model):
    """Map identifiers of a single entity.

    :ivar identifier: Alert V3 identifier.
    :vartype identifier: str
    :ivar value: The value of the identifier.
    :vartype value: str
    """

    _attribute_map = {
        'identifier': {'key': 'identifier', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identifier: Alert V3 identifier.
        :paramtype identifier: str
        :keyword value: The value of the identifier.
        :paramtype value: str
        """
        super(EntityFieldMapping, self).__init__(**kwargs)
        self.identifier = identifier
        self.value = value


class EntityGetInsightsParameters(msrest.serialization.Model):
    """The parameters required to execute insights operation on the given entity.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: Required. The start timeline date, so the results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Required. The end timeline date, so the results returned are before this date.
    :vartype end_time: ~datetime.datetime
    :ivar add_default_extended_time_range: Indicates if query time range should be extended with
     default time range of the query. Default value is false.
    :vartype add_default_extended_time_range: bool
    :ivar insight_query_ids: List of Insights Query Id. If empty, default value is all insights of
     this entity.
    :vartype insight_query_ids: list[str]
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'add_default_extended_time_range': {'key': 'addDefaultExtendedTimeRange', 'type': 'bool'},
        'insight_query_ids': {'key': 'insightQueryIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        add_default_extended_time_range: Optional[bool] = None,
        insight_query_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword start_time: Required. The start timeline date, so the results returned are after this
         date.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Required. The end timeline date, so the results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword add_default_extended_time_range: Indicates if query time range should be extended with
         default time range of the query. Default value is false.
        :paramtype add_default_extended_time_range: bool
        :keyword insight_query_ids: List of Insights Query Id. If empty, default value is all insights
         of this entity.
        :paramtype insight_query_ids: list[str]
        """
        super(EntityGetInsightsParameters, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.add_default_extended_time_range = add_default_extended_time_range
        self.insight_query_ids = insight_query_ids


class EntityGetInsightsResponse(msrest.serialization.Model):
    """The Get Insights result operation response.

    :ivar meta_data: The metadata from the get insights operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.GetInsightsResultsMetadata
    :ivar value: The insights result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityInsightItem]
    """

    _attribute_map = {
        'meta_data': {'key': 'metaData', 'type': 'GetInsightsResultsMetadata'},
        'value': {'key': 'value', 'type': '[EntityInsightItem]'},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["GetInsightsResultsMetadata"] = None,
        value: Optional[List["EntityInsightItem"]] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the get insights operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.GetInsightsResultsMetadata
        :keyword value: The insights result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityInsightItem]
        """
        super(EntityGetInsightsResponse, self).__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EntityInsightItem(msrest.serialization.Model):
    """Entity insight Item.

    :ivar query_id: The query id of the insight.
    :vartype query_id: str
    :ivar query_time_interval: The Time interval that the query actually executed on.
    :vartype query_time_interval:
     ~azure.mgmt.securityinsight.models.EntityInsightItemQueryTimeInterval
    :ivar table_query_results: Query results for table insights query.
    :vartype table_query_results: ~azure.mgmt.securityinsight.models.InsightsTableResult
    :ivar chart_query_results: Query results for table insights query.
    :vartype chart_query_results: list[~azure.mgmt.securityinsight.models.InsightsTableResult]
    """

    _attribute_map = {
        'query_id': {'key': 'queryId', 'type': 'str'},
        'query_time_interval': {'key': 'queryTimeInterval', 'type': 'EntityInsightItemQueryTimeInterval'},
        'table_query_results': {'key': 'tableQueryResults', 'type': 'InsightsTableResult'},
        'chart_query_results': {'key': 'chartQueryResults', 'type': '[InsightsTableResult]'},
    }

    def __init__(
        self,
        *,
        query_id: Optional[str] = None,
        query_time_interval: Optional["EntityInsightItemQueryTimeInterval"] = None,
        table_query_results: Optional["InsightsTableResult"] = None,
        chart_query_results: Optional[List["InsightsTableResult"]] = None,
        **kwargs
    ):
        """
        :keyword query_id: The query id of the insight.
        :paramtype query_id: str
        :keyword query_time_interval: The Time interval that the query actually executed on.
        :paramtype query_time_interval:
         ~azure.mgmt.securityinsight.models.EntityInsightItemQueryTimeInterval
        :keyword table_query_results: Query results for table insights query.
        :paramtype table_query_results: ~azure.mgmt.securityinsight.models.InsightsTableResult
        :keyword chart_query_results: Query results for table insights query.
        :paramtype chart_query_results: list[~azure.mgmt.securityinsight.models.InsightsTableResult]
        """
        super(EntityInsightItem, self).__init__(**kwargs)
        self.query_id = query_id
        self.query_time_interval = query_time_interval
        self.table_query_results = table_query_results
        self.chart_query_results = chart_query_results


class EntityInsightItemQueryTimeInterval(msrest.serialization.Model):
    """The Time interval that the query actually executed on.

    :ivar start_time: Insight query start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Insight query end time.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword start_time: Insight query start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Insight query end time.
        :paramtype end_time: ~datetime.datetime
        """
        super(EntityInsightItemQueryTimeInterval, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class EntityList(msrest.serialization.Model):
    """List of all the entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entities.
    :vartype next_link: str
    :ivar value: Required. Array of entities.
    :vartype value: list[~azure.mgmt.securityinsight.models.Entity]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        value: List["Entity"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of entities.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Entity]
        """
        super(EntityList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityMapping(msrest.serialization.Model):
    """Single entity mapping for the alert rule.

    :ivar entity_type: The V3 type of the mapped entity. Possible values include: "Account",
     "Host", "IP", "Malware", "File", "Process", "CloudApplication", "DNS", "AzureResource",
     "FileHash", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "Mailbox", "MailCluster",
     "MailMessage", "SubmissionMail".
    :vartype entity_type: str or ~azure.mgmt.securityinsight.models.EntityMappingType
    :ivar field_mappings: array of field mappings for the given entity mapping.
    :vartype field_mappings: list[~azure.mgmt.securityinsight.models.FieldMapping]
    """

    _attribute_map = {
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'field_mappings': {'key': 'fieldMappings', 'type': '[FieldMapping]'},
    }

    def __init__(
        self,
        *,
        entity_type: Optional[Union[str, "EntityMappingType"]] = None,
        field_mappings: Optional[List["FieldMapping"]] = None,
        **kwargs
    ):
        """
        :keyword entity_type: The V3 type of the mapped entity. Possible values include: "Account",
         "Host", "IP", "Malware", "File", "Process", "CloudApplication", "DNS", "AzureResource",
         "FileHash", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "Mailbox", "MailCluster",
         "MailMessage", "SubmissionMail".
        :paramtype entity_type: str or ~azure.mgmt.securityinsight.models.EntityMappingType
        :keyword field_mappings: array of field mappings for the given entity mapping.
        :paramtype field_mappings: list[~azure.mgmt.securityinsight.models.FieldMapping]
        """
        super(EntityMapping, self).__init__(**kwargs)
        self.entity_type = entity_type
        self.field_mappings = field_mappings


class EntityQueryItem(msrest.serialization.Model):
    """An abstract Query item for entity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InsightQueryItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Query Template ARM ID.
    :vartype id: str
    :ivar name: Query Template ARM Name.
    :vartype name: str
    :ivar type: ARM Type.
    :vartype type: str
    :ivar kind: Required. The kind of the entity query.Constant filled by server. Possible values
     include: "Expansion", "Insight", "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    """

    _validation = {
        'id': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Insight': 'InsightQueryItem'}
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Query Template ARM Name.
        :paramtype name: str
        :keyword type: ARM Type.
        :paramtype type: str
        """
        super(EntityQueryItem, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = type
        self.kind = None  # type: Optional[str]


class EntityQueryItemProperties(msrest.serialization.Model):
    """An properties abstract Query item for entity.

    :ivar data_types: Data types for template.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
    :ivar input_entity_type: The type of the entity. Possible values include: "Account", "Host",
     "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
     "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: Data types for template.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: any
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': '[EntityQueryItemPropertiesDataTypesItem]'},
        'input_entity_type': {'key': 'inputEntityType', 'type': 'str'},
        'required_input_fields_sets': {'key': 'requiredInputFieldsSets', 'type': '[[str]]'},
        'entities_filter': {'key': 'entitiesFilter', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        data_types: Optional[List["EntityQueryItemPropertiesDataTypesItem"]] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword data_types: Data types for template.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
        :keyword input_entity_type: The type of the entity. Possible values include: "Account", "Host",
         "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
         "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
         "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: Data types for template.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: any
        """
        super(EntityQueryItemProperties, self).__init__(**kwargs)
        self.data_types = data_types
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter


class EntityQueryItemPropertiesDataTypesItem(msrest.serialization.Model):
    """EntityQueryItemPropertiesDataTypesItem.

    :ivar data_type: Data type name.
    :vartype data_type: str
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_type: Data type name.
        :paramtype data_type: str
        """
        super(EntityQueryItemPropertiesDataTypesItem, self).__init__(**kwargs)
        self.data_type = data_type


class EntityQueryList(msrest.serialization.Model):
    """List of all the entity queries.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entity queries.
    :vartype next_link: str
    :ivar value: Required. Array of entity queries.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQuery]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EntityQuery]'},
    }

    def __init__(
        self,
        *,
        value: List["EntityQuery"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of entity queries.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQuery]
        """
        super(EntityQueryList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityQueryTemplateList(msrest.serialization.Model):
    """List of all the entity query templates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entity query templates.
    :vartype next_link: str
    :ivar value: Required. Array of entity query templates.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQueryTemplate]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EntityQueryTemplate]'},
    }

    def __init__(
        self,
        *,
        value: List["EntityQueryTemplate"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of entity query templates.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQueryTemplate]
        """
        super(EntityQueryTemplateList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityTimelineParameters(msrest.serialization.Model):
    """The parameters required to execute s timeline operation on the given entity.

    All required parameters must be populated in order to send to Azure.

    :ivar kinds: Array of timeline Item kinds.
    :vartype kinds: list[str or ~azure.mgmt.securityinsight.models.EntityTimelineKind]
    :ivar start_time: Required. The start timeline date, so the results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Required. The end timeline date, so the results returned are before this date.
    :vartype end_time: ~datetime.datetime
    :ivar number_of_bucket: The number of bucket for timeline queries aggregation.
    :vartype number_of_bucket: int
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'kinds': {'key': 'kinds', 'type': '[str]'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'number_of_bucket': {'key': 'numberOfBucket', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        kinds: Optional[List[Union[str, "EntityTimelineKind"]]] = None,
        number_of_bucket: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword kinds: Array of timeline Item kinds.
        :paramtype kinds: list[str or ~azure.mgmt.securityinsight.models.EntityTimelineKind]
        :keyword start_time: Required. The start timeline date, so the results returned are after this
         date.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Required. The end timeline date, so the results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword number_of_bucket: The number of bucket for timeline queries aggregation.
        :paramtype number_of_bucket: int
        """
        super(EntityTimelineParameters, self).__init__(**kwargs)
        self.kinds = kinds
        self.start_time = start_time
        self.end_time = end_time
        self.number_of_bucket = number_of_bucket


class EntityTimelineResponse(msrest.serialization.Model):
    """The entity timeline result operation response.

    :ivar meta_data: The metadata from the timeline operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.TimelineResultsMetadata
    :ivar value: The timeline result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityTimelineItem]
    """

    _attribute_map = {
        'meta_data': {'key': 'metaData', 'type': 'TimelineResultsMetadata'},
        'value': {'key': 'value', 'type': '[EntityTimelineItem]'},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["TimelineResultsMetadata"] = None,
        value: Optional[List["EntityTimelineItem"]] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the timeline operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.TimelineResultsMetadata
        :keyword value: The timeline result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityTimelineItem]
        """
        super(EntityTimelineResponse, self).__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EventGroupingSettings(msrest.serialization.Model):
    """Event grouping settings property bag.

    :ivar aggregation_kind: The event grouping aggregation kinds. Possible values include:
     "SingleAlert", "AlertPerResult".
    :vartype aggregation_kind: str or
     ~azure.mgmt.securityinsight.models.EventGroupingAggregationKind
    """

    _attribute_map = {
        'aggregation_kind': {'key': 'aggregationKind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        aggregation_kind: Optional[Union[str, "EventGroupingAggregationKind"]] = None,
        **kwargs
    ):
        """
        :keyword aggregation_kind: The event grouping aggregation kinds. Possible values include:
         "SingleAlert", "AlertPerResult".
        :paramtype aggregation_kind: str or
         ~azure.mgmt.securityinsight.models.EventGroupingAggregationKind
        """
        super(EventGroupingSettings, self).__init__(**kwargs)
        self.aggregation_kind = aggregation_kind


class ExpansionEntityQuery(EntityQuery):
    """Represents Expansion entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. the entity query kind.Constant filled by server. Possible values include:
     "Expansion", "Insight", "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar data_sources: List of the data sources that are required to run the query.
    :vartype data_sources: list[str]
    :ivar display_name: The query display name.
    :vartype display_name: str
    :ivar input_entity_type: The type of the query's source entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar input_fields: List of the fields of the source entity that are required to run the query.
    :vartype input_fields: list[str]
    :ivar output_entity_types: List of the desired output types to be constructed from the result.
    :vartype output_entity_types: list[str or ~azure.mgmt.securityinsight.models.EntityType]
    :ivar query_template: The template query string to be parsed and formatted.
    :vartype query_template: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[str]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'input_entity_type': {'key': 'properties.inputEntityType', 'type': 'str'},
        'input_fields': {'key': 'properties.inputFields', 'type': '[str]'},
        'output_entity_types': {'key': 'properties.outputEntityTypes', 'type': '[str]'},
        'query_template': {'key': 'properties.queryTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_sources: Optional[List[str]] = None,
        display_name: Optional[str] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        input_fields: Optional[List[str]] = None,
        output_entity_types: Optional[List[Union[str, "EntityType"]]] = None,
        query_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_sources: List of the data sources that are required to run the query.
        :paramtype data_sources: list[str]
        :keyword display_name: The query display name.
        :paramtype display_name: str
        :keyword input_entity_type: The type of the query's source entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword input_fields: List of the fields of the source entity that are required to run the
         query.
        :paramtype input_fields: list[str]
        :keyword output_entity_types: List of the desired output types to be constructed from the
         result.
        :paramtype output_entity_types: list[str or ~azure.mgmt.securityinsight.models.EntityType]
        :keyword query_template: The template query string to be parsed and formatted.
        :paramtype query_template: str
        """
        super(ExpansionEntityQuery, self).__init__(etag=etag, **kwargs)
        self.kind = 'Expansion'  # type: str
        self.data_sources = data_sources
        self.display_name = display_name
        self.input_entity_type = input_entity_type
        self.input_fields = input_fields
        self.output_entity_types = output_entity_types
        self.query_template = query_template


class ExpansionResultAggregation(msrest.serialization.Model):
    """Information of a specific aggregation in the expansion result.

    All required parameters must be populated in order to send to Azure.

    :ivar aggregation_type: The common type of the aggregation. (for e.g. entity field name).
    :vartype aggregation_type: str
    :ivar count: Required. Total number of aggregations of the given kind (and aggregationType if
     given) in the expansion result.
    :vartype count: int
    :ivar display_name: The display name of the aggregation by type.
    :vartype display_name: str
    :ivar entity_kind: Required. The kind of the aggregated entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash",
     "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    """

    _validation = {
        'count': {'required': True},
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'entity_kind': {'key': 'entityKind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: int,
        entity_kind: Union[str, "EntityKind"],
        aggregation_type: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword aggregation_type: The common type of the aggregation. (for e.g. entity field name).
        :paramtype aggregation_type: str
        :keyword count: Required. Total number of aggregations of the given kind (and aggregationType
         if given) in the expansion result.
        :paramtype count: int
        :keyword display_name: The display name of the aggregation by type.
        :paramtype display_name: str
        :keyword entity_kind: Required. The kind of the aggregated entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash",
         "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
         "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
         "SubmissionMail".
        :paramtype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
        """
        super(ExpansionResultAggregation, self).__init__(**kwargs)
        self.aggregation_type = aggregation_type
        self.count = count
        self.display_name = display_name
        self.entity_kind = entity_kind


class ExpansionResultsMetadata(msrest.serialization.Model):
    """Expansion result metadata.

    :ivar aggregations: Information of the aggregated nodes in the expansion result.
    :vartype aggregations: list[~azure.mgmt.securityinsight.models.ExpansionResultAggregation]
    """

    _attribute_map = {
        'aggregations': {'key': 'aggregations', 'type': '[ExpansionResultAggregation]'},
    }

    def __init__(
        self,
        *,
        aggregations: Optional[List["ExpansionResultAggregation"]] = None,
        **kwargs
    ):
        """
        :keyword aggregations: Information of the aggregated nodes in the expansion result.
        :paramtype aggregations: list[~azure.mgmt.securityinsight.models.ExpansionResultAggregation]
        """
        super(ExpansionResultsMetadata, self).__init__(**kwargs)
        self.aggregations = aggregations


class EyesOn(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the setting.Constant filled by server. Possible values
     include: "Anomalies", "EyesOn", "EntityAnalytics", "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar is_enabled: Determines whether the setting is enable or disabled.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(EyesOn, self).__init__(etag=etag, **kwargs)
        self.kind = 'EyesOn'  # type: str
        self.is_enabled = None


class FieldMapping(msrest.serialization.Model):
    """A single field mapping of the mapped entity.

    :ivar identifier: the V3 identifier of the entity.
    :vartype identifier: str
    :ivar column_name: the column name to be mapped to the identifier.
    :vartype column_name: str
    """

    _attribute_map = {
        'identifier': {'key': 'identifier', 'type': 'str'},
        'column_name': {'key': 'columnName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identifier: the V3 identifier of the entity.
        :paramtype identifier: str
        :keyword column_name: the column name to be mapped to the identifier.
        :paramtype column_name: str
        """
        super(FieldMapping, self).__init__(**kwargs)
        self.identifier = identifier
        self.column_name = column_name


class FileEntity(Entity):
    """Represents a file entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar directory: The full path to the file.
    :vartype directory: str
    :ivar file_hash_entity_ids: The file hash entity identifiers associated with this file.
    :vartype file_hash_entity_ids: list[str]
    :ivar file_name: The file name without path (some alerts might not include path).
    :vartype file_name: str
    :ivar host_entity_id: The Host entity id which the file belongs to.
    :vartype host_entity_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'directory': {'readonly': True},
        'file_hash_entity_ids': {'readonly': True},
        'file_name': {'readonly': True},
        'host_entity_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'directory': {'key': 'properties.directory', 'type': 'str'},
        'file_hash_entity_ids': {'key': 'properties.fileHashEntityIds', 'type': '[str]'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'host_entity_id': {'key': 'properties.hostEntityId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileEntity, self).__init__(**kwargs)
        self.kind = 'File'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.directory = None
        self.file_hash_entity_ids = None
        self.file_name = None
        self.host_entity_id = None


class FileEntityProperties(EntityCommonProperties):
    """File entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar directory: The full path to the file.
    :vartype directory: str
    :ivar file_hash_entity_ids: The file hash entity identifiers associated with this file.
    :vartype file_hash_entity_ids: list[str]
    :ivar file_name: The file name without path (some alerts might not include path).
    :vartype file_name: str
    :ivar host_entity_id: The Host entity id which the file belongs to.
    :vartype host_entity_id: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'directory': {'readonly': True},
        'file_hash_entity_ids': {'readonly': True},
        'file_name': {'readonly': True},
        'host_entity_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'directory': {'key': 'directory', 'type': 'str'},
        'file_hash_entity_ids': {'key': 'fileHashEntityIds', 'type': '[str]'},
        'file_name': {'key': 'fileName', 'type': 'str'},
        'host_entity_id': {'key': 'hostEntityId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileEntityProperties, self).__init__(**kwargs)
        self.directory = None
        self.file_hash_entity_ids = None
        self.file_name = None
        self.host_entity_id = None


class FileHashEntity(Entity):
    """Represents a file hash entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar algorithm: The hash algorithm type. Possible values include: "Unknown", "MD5", "SHA1",
     "SHA256", "SHA256AC".
    :vartype algorithm: str or ~azure.mgmt.securityinsight.models.FileHashAlgorithm
    :ivar hash_value: The file hash value.
    :vartype hash_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'algorithm': {'readonly': True},
        'hash_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'algorithm': {'key': 'properties.algorithm', 'type': 'str'},
        'hash_value': {'key': 'properties.hashValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileHashEntity, self).__init__(**kwargs)
        self.kind = 'FileHash'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.algorithm = None
        self.hash_value = None


class FileHashEntityProperties(EntityCommonProperties):
    """FileHash entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar algorithm: The hash algorithm type. Possible values include: "Unknown", "MD5", "SHA1",
     "SHA256", "SHA256AC".
    :vartype algorithm: str or ~azure.mgmt.securityinsight.models.FileHashAlgorithm
    :ivar hash_value: The file hash value.
    :vartype hash_value: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'algorithm': {'readonly': True},
        'hash_value': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'hash_value': {'key': 'hashValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileHashEntityProperties, self).__init__(**kwargs)
        self.algorithm = None
        self.hash_value = None


class FusionAlertRule(AlertRule):
    """Represents Fusion alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar source_settings: Configuration for all supported source signals in fusion detection.
    :vartype source_settings: list[~azure.mgmt.securityinsight.models.FusionSourceSettings]
    :ivar scenario_exclusion_patterns: Configuration to exclude scenarios in fusion detection.
    :vartype scenario_exclusion_patterns:
     list[~azure.mgmt.securityinsight.models.FusionScenarioExclusionPattern]
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'last_modified_utc': {'readonly': True},
        'severity': {'readonly': True},
        'tactics': {'readonly': True},
        'techniques': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'source_settings': {'key': 'properties.sourceSettings', 'type': '[FusionSourceSettings]'},
        'scenario_exclusion_patterns': {'key': 'properties.scenarioExclusionPatterns', 'type': '[FusionScenarioExclusionPattern]'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        source_settings: Optional[List["FusionSourceSettings"]] = None,
        scenario_exclusion_patterns: Optional[List["FusionScenarioExclusionPattern"]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword source_settings: Configuration for all supported source signals in fusion detection.
        :paramtype source_settings: list[~azure.mgmt.securityinsight.models.FusionSourceSettings]
        :keyword scenario_exclusion_patterns: Configuration to exclude scenarios in fusion detection.
        :paramtype scenario_exclusion_patterns:
         list[~azure.mgmt.securityinsight.models.FusionScenarioExclusionPattern]
        """
        super(FusionAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'Fusion'  # type: str
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.source_settings = source_settings
        self.scenario_exclusion_patterns = scenario_exclusion_patterns
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class FusionAlertRuleTemplate(AlertRuleTemplate):
    """Represents Fusion alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar last_updated_date_utc: The time that this alert rule template was last updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data connectors for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule template.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar source_settings: All supported source signal configurations consumed in fusion detection.
    :vartype source_settings: list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSetting]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'created_date_utc': {'readonly': True},
        'last_updated_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'source_settings': {'key': 'properties.sourceSettings', 'type': '[FusionTemplateSourceSetting]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        source_settings: Optional[List["FusionTemplateSourceSetting"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data connectors for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword tactics: The tactics of the alert rule template.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword source_settings: All supported source signal configurations consumed in fusion
         detection.
        :paramtype source_settings:
         list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSetting]
        """
        super(FusionAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'Fusion'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.last_updated_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.severity = severity
        self.tactics = tactics
        self.techniques = techniques
        self.source_settings = source_settings


class FusionScenarioExclusionPattern(msrest.serialization.Model):
    """Represents a Fusion scenario exclusion patterns in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar exclusion_pattern: Required. Scenario exclusion pattern.
    :vartype exclusion_pattern: str
    :ivar date_added_in_utc: Required. DateTime when scenario exclusion pattern is added in UTC.
    :vartype date_added_in_utc: str
    """

    _validation = {
        'exclusion_pattern': {'required': True},
        'date_added_in_utc': {'required': True},
    }

    _attribute_map = {
        'exclusion_pattern': {'key': 'exclusionPattern', 'type': 'str'},
        'date_added_in_utc': {'key': 'dateAddedInUTC', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exclusion_pattern: str,
        date_added_in_utc: str,
        **kwargs
    ):
        """
        :keyword exclusion_pattern: Required. Scenario exclusion pattern.
        :paramtype exclusion_pattern: str
        :keyword date_added_in_utc: Required. DateTime when scenario exclusion pattern is added in UTC.
        :paramtype date_added_in_utc: str
        """
        super(FusionScenarioExclusionPattern, self).__init__(**kwargs)
        self.exclusion_pattern = exclusion_pattern
        self.date_added_in_utc = date_added_in_utc


class FusionSourceSettings(msrest.serialization.Model):
    """Represents a supported source signal configuration in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Determines whether this source signal is enabled or disabled in Fusion
     detection.
    :vartype enabled: bool
    :ivar source_name: Required. Name of the Fusion source signal. Refer to Fusion alert rule
     template for supported values.
    :vartype source_name: str
    :ivar source_sub_types: Configuration for all source subtypes under this source signal consumed
     in fusion detection.
    :vartype source_sub_types: list[~azure.mgmt.securityinsight.models.FusionSourceSubTypeSetting]
    """

    _validation = {
        'enabled': {'required': True},
        'source_name': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'source_sub_types': {'key': 'sourceSubTypes', 'type': '[FusionSourceSubTypeSetting]'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        source_name: str,
        source_sub_types: Optional[List["FusionSourceSubTypeSetting"]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Required. Determines whether this source signal is enabled or disabled in
         Fusion detection.
        :paramtype enabled: bool
        :keyword source_name: Required. Name of the Fusion source signal. Refer to Fusion alert rule
         template for supported values.
        :paramtype source_name: str
        :keyword source_sub_types: Configuration for all source subtypes under this source signal
         consumed in fusion detection.
        :paramtype source_sub_types:
         list[~azure.mgmt.securityinsight.models.FusionSourceSubTypeSetting]
        """
        super(FusionSourceSettings, self).__init__(**kwargs)
        self.enabled = enabled
        self.source_name = source_name
        self.source_sub_types = source_sub_types


class FusionSourceSubTypeSetting(msrest.serialization.Model):
    """Represents a supported source subtype configuration under a source signal in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Determines whether this source subtype under source signal is enabled
     or disabled in Fusion detection.
    :vartype enabled: bool
    :ivar source_sub_type_name: Required. The Name of the source subtype under a given source
     signal in Fusion detection. Refer to Fusion alert rule template for supported values.
    :vartype source_sub_type_name: str
    :ivar source_sub_type_display_name: The display name of source subtype under a source signal
     consumed in Fusion detection.
    :vartype source_sub_type_display_name: str
    :ivar severity_filters: Required. Severity configuration for a source subtype consumed in
     fusion detection.
    :vartype severity_filters: ~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFilter
    """

    _validation = {
        'enabled': {'required': True},
        'source_sub_type_name': {'required': True},
        'source_sub_type_display_name': {'readonly': True},
        'severity_filters': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'source_sub_type_name': {'key': 'sourceSubTypeName', 'type': 'str'},
        'source_sub_type_display_name': {'key': 'sourceSubTypeDisplayName', 'type': 'str'},
        'severity_filters': {'key': 'severityFilters', 'type': 'FusionSubTypeSeverityFilter'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        source_sub_type_name: str,
        severity_filters: "FusionSubTypeSeverityFilter",
        **kwargs
    ):
        """
        :keyword enabled: Required. Determines whether this source subtype under source signal is
         enabled or disabled in Fusion detection.
        :paramtype enabled: bool
        :keyword source_sub_type_name: Required. The Name of the source subtype under a given source
         signal in Fusion detection. Refer to Fusion alert rule template for supported values.
        :paramtype source_sub_type_name: str
        :keyword severity_filters: Required. Severity configuration for a source subtype consumed in
         fusion detection.
        :paramtype severity_filters: ~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFilter
        """
        super(FusionSourceSubTypeSetting, self).__init__(**kwargs)
        self.enabled = enabled
        self.source_sub_type_name = source_sub_type_name
        self.source_sub_type_display_name = None
        self.severity_filters = severity_filters


class FusionSubTypeSeverityFilter(msrest.serialization.Model):
    """Represents severity configuration for a source subtype consumed in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: Determines whether this source subtype supports severity configuration or
     not.
    :vartype is_supported: bool
    :ivar filters: Individual Severity configuration settings for a given source subtype consumed
     in Fusion detection.
    :vartype filters: list[~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFiltersItem]
    """

    _validation = {
        'is_supported': {'readonly': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'filters': {'key': 'filters', 'type': '[FusionSubTypeSeverityFiltersItem]'},
    }

    def __init__(
        self,
        *,
        filters: Optional[List["FusionSubTypeSeverityFiltersItem"]] = None,
        **kwargs
    ):
        """
        :keyword filters: Individual Severity configuration settings for a given source subtype
         consumed in Fusion detection.
        :paramtype filters: list[~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFiltersItem]
        """
        super(FusionSubTypeSeverityFilter, self).__init__(**kwargs)
        self.is_supported = None
        self.filters = filters


class FusionSubTypeSeverityFiltersItem(msrest.serialization.Model):
    """Represents a Severity filter setting for a given source subtype consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar severity: Required. The Severity for a given source subtype consumed in Fusion detection.
     Possible values include: "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar enabled: Required. Determines whether this severity is enabled or disabled for this
     source subtype consumed in Fusion detection.
    :vartype enabled: bool
    """

    _validation = {
        'severity': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'severity': {'key': 'severity', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "AlertSeverity"],
        enabled: bool,
        **kwargs
    ):
        """
        :keyword severity: Required. The Severity for a given source subtype consumed in Fusion
         detection. Possible values include: "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword enabled: Required. Determines whether this severity is enabled or disabled for this
         source subtype consumed in Fusion detection.
        :paramtype enabled: bool
        """
        super(FusionSubTypeSeverityFiltersItem, self).__init__(**kwargs)
        self.severity = severity
        self.enabled = enabled


class FusionTemplateSourceSetting(msrest.serialization.Model):
    """Represents a source signal consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar source_name: Required. The name of a source signal consumed in Fusion detection.
    :vartype source_name: str
    :ivar source_sub_types: All supported source subtypes under this source signal consumed in
     fusion detection.
    :vartype source_sub_types: list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSubType]
    """

    _validation = {
        'source_name': {'required': True},
    }

    _attribute_map = {
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'source_sub_types': {'key': 'sourceSubTypes', 'type': '[FusionTemplateSourceSubType]'},
    }

    def __init__(
        self,
        *,
        source_name: str,
        source_sub_types: Optional[List["FusionTemplateSourceSubType"]] = None,
        **kwargs
    ):
        """
        :keyword source_name: Required. The name of a source signal consumed in Fusion detection.
        :paramtype source_name: str
        :keyword source_sub_types: All supported source subtypes under this source signal consumed in
         fusion detection.
        :paramtype source_sub_types:
         list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSubType]
        """
        super(FusionTemplateSourceSetting, self).__init__(**kwargs)
        self.source_name = source_name
        self.source_sub_types = source_sub_types


class FusionTemplateSourceSubType(msrest.serialization.Model):
    """Represents a source subtype under a source signal consumed in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar source_sub_type_name: Required. The name of source subtype under a source signal consumed
     in Fusion detection.
    :vartype source_sub_type_name: str
    :ivar source_sub_type_display_name: The display name of source subtype under a source signal
     consumed in Fusion detection.
    :vartype source_sub_type_display_name: str
    :ivar severity_filter: Required. Severity configuration available for a source subtype consumed
     in fusion detection.
    :vartype severity_filter:
     ~azure.mgmt.securityinsight.models.FusionTemplateSubTypeSeverityFilter
    """

    _validation = {
        'source_sub_type_name': {'required': True},
        'source_sub_type_display_name': {'readonly': True},
        'severity_filter': {'required': True},
    }

    _attribute_map = {
        'source_sub_type_name': {'key': 'sourceSubTypeName', 'type': 'str'},
        'source_sub_type_display_name': {'key': 'sourceSubTypeDisplayName', 'type': 'str'},
        'severity_filter': {'key': 'severityFilter', 'type': 'FusionTemplateSubTypeSeverityFilter'},
    }

    def __init__(
        self,
        *,
        source_sub_type_name: str,
        severity_filter: "FusionTemplateSubTypeSeverityFilter",
        **kwargs
    ):
        """
        :keyword source_sub_type_name: Required. The name of source subtype under a source signal
         consumed in Fusion detection.
        :paramtype source_sub_type_name: str
        :keyword severity_filter: Required. Severity configuration available for a source subtype
         consumed in fusion detection.
        :paramtype severity_filter:
         ~azure.mgmt.securityinsight.models.FusionTemplateSubTypeSeverityFilter
        """
        super(FusionTemplateSourceSubType, self).__init__(**kwargs)
        self.source_sub_type_name = source_sub_type_name
        self.source_sub_type_display_name = None
        self.severity_filter = severity_filter


class FusionTemplateSubTypeSeverityFilter(msrest.serialization.Model):
    """Represents severity configurations available for a source subtype consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar is_supported: Required. Determines whether severity configuration is supported for this
     source subtype consumed in Fusion detection.
    :vartype is_supported: bool
    :ivar severity_filters: List of all supported severities for this source subtype consumed in
     Fusion detection.
    :vartype severity_filters: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'is_supported': {'required': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'severity_filters': {'key': 'severityFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        is_supported: bool,
        severity_filters: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword is_supported: Required. Determines whether severity configuration is supported for
         this source subtype consumed in Fusion detection.
        :paramtype is_supported: bool
        :keyword severity_filters: List of all supported severities for this source subtype consumed in
         Fusion detection.
        :paramtype severity_filters: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super(FusionTemplateSubTypeSeverityFilter, self).__init__(**kwargs)
        self.is_supported = is_supported
        self.severity_filters = severity_filters


class GeoLocation(msrest.serialization.Model):
    """The geo-location context attached to the ip entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asn: Autonomous System Number.
    :vartype asn: int
    :ivar city: City name.
    :vartype city: str
    :ivar country_code: The country code according to ISO 3166 format.
    :vartype country_code: str
    :ivar country_name: Country name according to ISO 3166 Alpha 2: the lowercase of the English
     Short Name.
    :vartype country_name: str
    :ivar latitude: The longitude of the identified location, expressed as a floating point number
     with range of -180 to 180, with positive numbers representing East and negative numbers
     representing West. Latitude and longitude are derived from the city or postal code.
    :vartype latitude: float
    :ivar longitude: The latitude of the identified location, expressed as a floating point number
     with range of - 90 to 90, with positive numbers representing North and negative numbers
     representing South. Latitude and longitude are derived from the city or postal code.
    :vartype longitude: float
    :ivar state: State name.
    :vartype state: str
    """

    _validation = {
        'asn': {'readonly': True},
        'city': {'readonly': True},
        'country_code': {'readonly': True},
        'country_name': {'readonly': True},
        'latitude': {'readonly': True},
        'longitude': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'int'},
        'city': {'key': 'city', 'type': 'str'},
        'country_code': {'key': 'countryCode', 'type': 'str'},
        'country_name': {'key': 'countryName', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'float'},
        'longitude': {'key': 'longitude', 'type': 'float'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GeoLocation, self).__init__(**kwargs)
        self.asn = None
        self.city = None
        self.country_code = None
        self.country_name = None
        self.latitude = None
        self.longitude = None
        self.state = None


class GetInsightsError(msrest.serialization.Model):
    """GetInsights Query Errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: the query kind. Has constant value: "Insight".
    :vartype kind: str
    :ivar query_id: the query id.
    :vartype query_id: str
    :ivar error_message: Required. the error message.
    :vartype error_message: str
    """

    _validation = {
        'kind': {'required': True, 'constant': True},
        'error_message': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'query_id': {'key': 'queryId', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    kind = "Insight"

    def __init__(
        self,
        *,
        error_message: str,
        query_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query_id: the query id.
        :paramtype query_id: str
        :keyword error_message: Required. the error message.
        :paramtype error_message: str
        """
        super(GetInsightsError, self).__init__(**kwargs)
        self.query_id = query_id
        self.error_message = error_message


class GetInsightsResultsMetadata(msrest.serialization.Model):
    """Get Insights result metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar total_count: Required. the total items found for the insights request.
    :vartype total_count: int
    :ivar errors: information about the failed queries.
    :vartype errors: list[~azure.mgmt.securityinsight.models.GetInsightsError]
    """

    _validation = {
        'total_count': {'required': True},
    }

    _attribute_map = {
        'total_count': {'key': 'totalCount', 'type': 'int'},
        'errors': {'key': 'errors', 'type': '[GetInsightsError]'},
    }

    def __init__(
        self,
        *,
        total_count: int,
        errors: Optional[List["GetInsightsError"]] = None,
        **kwargs
    ):
        """
        :keyword total_count: Required. the total items found for the insights request.
        :paramtype total_count: int
        :keyword errors: information about the failed queries.
        :paramtype errors: list[~azure.mgmt.securityinsight.models.GetInsightsError]
        """
        super(GetInsightsResultsMetadata, self).__init__(**kwargs)
        self.total_count = total_count
        self.errors = errors


class GetQueriesResponse(msrest.serialization.Model):
    """Retrieve queries for entity result operation response.

    :ivar value: The query result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQueryItem]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EntityQueryItem]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EntityQueryItem"]] = None,
        **kwargs
    ):
        """
        :keyword value: The query result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQueryItem]
        """
        super(GetQueriesResponse, self).__init__(**kwargs)
        self.value = value


class GitHubResourceInfo(msrest.serialization.Model):
    """Resources created in GitHub repository.

    :ivar app_installation_id: GitHub application installation id.
    :vartype app_installation_id: str
    """

    _attribute_map = {
        'app_installation_id': {'key': 'appInstallationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_installation_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword app_installation_id: GitHub application installation id.
        :paramtype app_installation_id: str
        """
        super(GitHubResourceInfo, self).__init__(**kwargs)
        self.app_installation_id = app_installation_id


class GroupingConfiguration(msrest.serialization.Model):
    """Grouping configuration property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Grouping enabled.
    :vartype enabled: bool
    :ivar reopen_closed_incident: Required. Re-open closed matching incidents.
    :vartype reopen_closed_incident: bool
    :ivar lookback_duration: Required. Limit the group to alerts created within the lookback
     duration (in ISO 8601 duration format).
    :vartype lookback_duration: ~datetime.timedelta
    :ivar matching_method: Required. Grouping matching method. When method is Selected at least one
     of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     Possible values include: "AllEntities", "AnyAlert", "Selected".
    :vartype matching_method: str or ~azure.mgmt.securityinsight.models.MatchingMethod
    :ivar group_by_entities: A list of entity types to group by (when matchingMethod is Selected).
     Only entities defined in the current alert rule may be used.
    :vartype group_by_entities: list[str or ~azure.mgmt.securityinsight.models.EntityMappingType]
    :ivar group_by_alert_details: A list of alert details to group by (when matchingMethod is
     Selected).
    :vartype group_by_alert_details: list[str or ~azure.mgmt.securityinsight.models.AlertDetail]
    :ivar group_by_custom_details: A list of custom details keys to group by (when matchingMethod
     is Selected). Only keys defined in the current alert rule may be used.
    :vartype group_by_custom_details: list[str]
    """

    _validation = {
        'enabled': {'required': True},
        'reopen_closed_incident': {'required': True},
        'lookback_duration': {'required': True},
        'matching_method': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'reopen_closed_incident': {'key': 'reopenClosedIncident', 'type': 'bool'},
        'lookback_duration': {'key': 'lookbackDuration', 'type': 'duration'},
        'matching_method': {'key': 'matchingMethod', 'type': 'str'},
        'group_by_entities': {'key': 'groupByEntities', 'type': '[str]'},
        'group_by_alert_details': {'key': 'groupByAlertDetails', 'type': '[str]'},
        'group_by_custom_details': {'key': 'groupByCustomDetails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        reopen_closed_incident: bool,
        lookback_duration: datetime.timedelta,
        matching_method: Union[str, "MatchingMethod"],
        group_by_entities: Optional[List[Union[str, "EntityMappingType"]]] = None,
        group_by_alert_details: Optional[List[Union[str, "AlertDetail"]]] = None,
        group_by_custom_details: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Required. Grouping enabled.
        :paramtype enabled: bool
        :keyword reopen_closed_incident: Required. Re-open closed matching incidents.
        :paramtype reopen_closed_incident: bool
        :keyword lookback_duration: Required. Limit the group to alerts created within the lookback
         duration (in ISO 8601 duration format).
        :paramtype lookback_duration: ~datetime.timedelta
        :keyword matching_method: Required. Grouping matching method. When method is Selected at least
         one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not
         empty. Possible values include: "AllEntities", "AnyAlert", "Selected".
        :paramtype matching_method: str or ~azure.mgmt.securityinsight.models.MatchingMethod
        :keyword group_by_entities: A list of entity types to group by (when matchingMethod is
         Selected). Only entities defined in the current alert rule may be used.
        :paramtype group_by_entities: list[str or ~azure.mgmt.securityinsight.models.EntityMappingType]
        :keyword group_by_alert_details: A list of alert details to group by (when matchingMethod is
         Selected).
        :paramtype group_by_alert_details: list[str or ~azure.mgmt.securityinsight.models.AlertDetail]
        :keyword group_by_custom_details: A list of custom details keys to group by (when
         matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :paramtype group_by_custom_details: list[str]
        """
        super(GroupingConfiguration, self).__init__(**kwargs)
        self.enabled = enabled
        self.reopen_closed_incident = reopen_closed_incident
        self.lookback_duration = lookback_duration
        self.matching_method = matching_method
        self.group_by_entities = group_by_entities
        self.group_by_alert_details = group_by_alert_details
        self.group_by_custom_details = group_by_custom_details


class HostEntity(Entity):
    """Represents a host entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar azure_id: The azure resource id of the VM.
    :vartype azure_id: str
    :ivar dns_domain: The DNS domain that this host belongs to. Should contain the compete DNS
     suffix for the domain.
    :vartype dns_domain: str
    :ivar host_name: The hostname without the domain suffix.
    :vartype host_name: str
    :ivar is_domain_joined: Determines whether this host belongs to a domain.
    :vartype is_domain_joined: bool
    :ivar net_bios_name: The host name (pre-windows2000).
    :vartype net_bios_name: str
    :ivar nt_domain: The NT domain that this host belongs to.
    :vartype nt_domain: str
    :ivar oms_agent_id: The OMS agent id, if the host has OMS agent installed.
    :vartype oms_agent_id: str
    :ivar os_family: The operating system type. Possible values include: "Linux", "Windows",
     "Android", "IOS", "Unknown".
    :vartype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
    :ivar os_version: A free text representation of the operating system. This field is meant to
     hold specific versions the are more fine grained than OSFamily or future values not supported
     by OSFamily enumeration.
    :vartype os_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'azure_id': {'readonly': True},
        'dns_domain': {'readonly': True},
        'host_name': {'readonly': True},
        'is_domain_joined': {'readonly': True},
        'net_bios_name': {'readonly': True},
        'nt_domain': {'readonly': True},
        'oms_agent_id': {'readonly': True},
        'os_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'azure_id': {'key': 'properties.azureID', 'type': 'str'},
        'dns_domain': {'key': 'properties.dnsDomain', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'is_domain_joined': {'key': 'properties.isDomainJoined', 'type': 'bool'},
        'net_bios_name': {'key': 'properties.netBiosName', 'type': 'str'},
        'nt_domain': {'key': 'properties.ntDomain', 'type': 'str'},
        'oms_agent_id': {'key': 'properties.omsAgentID', 'type': 'str'},
        'os_family': {'key': 'properties.osFamily', 'type': 'str'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_family: Optional[Union[str, "OSFamily"]] = None,
        **kwargs
    ):
        """
        :keyword os_family: The operating system type. Possible values include: "Linux", "Windows",
         "Android", "IOS", "Unknown".
        :paramtype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
        """
        super(HostEntity, self).__init__(**kwargs)
        self.kind = 'Host'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.azure_id = None
        self.dns_domain = None
        self.host_name = None
        self.is_domain_joined = None
        self.net_bios_name = None
        self.nt_domain = None
        self.oms_agent_id = None
        self.os_family = os_family
        self.os_version = None


class HostEntityProperties(EntityCommonProperties):
    """Host entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar azure_id: The azure resource id of the VM.
    :vartype azure_id: str
    :ivar dns_domain: The DNS domain that this host belongs to. Should contain the compete DNS
     suffix for the domain.
    :vartype dns_domain: str
    :ivar host_name: The hostname without the domain suffix.
    :vartype host_name: str
    :ivar is_domain_joined: Determines whether this host belongs to a domain.
    :vartype is_domain_joined: bool
    :ivar net_bios_name: The host name (pre-windows2000).
    :vartype net_bios_name: str
    :ivar nt_domain: The NT domain that this host belongs to.
    :vartype nt_domain: str
    :ivar oms_agent_id: The OMS agent id, if the host has OMS agent installed.
    :vartype oms_agent_id: str
    :ivar os_family: The operating system type. Possible values include: "Linux", "Windows",
     "Android", "IOS", "Unknown".
    :vartype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
    :ivar os_version: A free text representation of the operating system. This field is meant to
     hold specific versions the are more fine grained than OSFamily or future values not supported
     by OSFamily enumeration.
    :vartype os_version: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'azure_id': {'readonly': True},
        'dns_domain': {'readonly': True},
        'host_name': {'readonly': True},
        'is_domain_joined': {'readonly': True},
        'net_bios_name': {'readonly': True},
        'nt_domain': {'readonly': True},
        'oms_agent_id': {'readonly': True},
        'os_version': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'azure_id': {'key': 'azureID', 'type': 'str'},
        'dns_domain': {'key': 'dnsDomain', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'is_domain_joined': {'key': 'isDomainJoined', 'type': 'bool'},
        'net_bios_name': {'key': 'netBiosName', 'type': 'str'},
        'nt_domain': {'key': 'ntDomain', 'type': 'str'},
        'oms_agent_id': {'key': 'omsAgentID', 'type': 'str'},
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_family: Optional[Union[str, "OSFamily"]] = None,
        **kwargs
    ):
        """
        :keyword os_family: The operating system type. Possible values include: "Linux", "Windows",
         "Android", "IOS", "Unknown".
        :paramtype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
        """
        super(HostEntityProperties, self).__init__(**kwargs)
        self.azure_id = None
        self.dns_domain = None
        self.host_name = None
        self.is_domain_joined = None
        self.net_bios_name = None
        self.nt_domain = None
        self.oms_agent_id = None
        self.os_family = os_family
        self.os_version = None


class HuntingBookmark(Entity):
    """Represents a Hunting bookmark entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: The display name of the bookmark.
    :vartype display_name: str
    :ivar event_time: The time of the event.
    :vartype event_time: ~datetime.datetime
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: The query of the bookmark.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'UserInfo'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'event_time': {'key': 'properties.eventTime', 'type': 'iso-8601'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_result': {'key': 'properties.queryResult', 'type': 'str'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'UserInfo'},
        'incident_info': {'key': 'properties.incidentInfo', 'type': 'IncidentInfo'},
    }

    def __init__(
        self,
        *,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        display_name: Optional[str] = None,
        event_time: Optional[datetime.datetime] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["UserInfo"] = None,
        incident_info: Optional["IncidentInfo"] = None,
        **kwargs
    ):
        """
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: The display name of the bookmark.
        :paramtype display_name: str
        :keyword event_time: The time of the event.
        :paramtype event_time: ~datetime.datetime
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: The query of the bookmark.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        """
        super(HuntingBookmark, self).__init__(**kwargs)
        self.kind = 'Bookmark'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.event_time = event_time
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.incident_info = incident_info


class HuntingBookmarkProperties(EntityCommonProperties):
    """Describes bookmark properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: Required. The display name of the bookmark.
    :vartype display_name: str
    :ivar event_time: The time of the event.
    :vartype event_time: ~datetime.datetime
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: Required. The query of the bookmark.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'display_name': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'UserInfo'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'notes': {'key': 'notes', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
        'query_result': {'key': 'queryResult', 'type': 'str'},
        'updated': {'key': 'updated', 'type': 'iso-8601'},
        'updated_by': {'key': 'updatedBy', 'type': 'UserInfo'},
        'incident_info': {'key': 'incidentInfo', 'type': 'IncidentInfo'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        query: str,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        event_time: Optional[datetime.datetime] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["UserInfo"] = None,
        incident_info: Optional["IncidentInfo"] = None,
        **kwargs
    ):
        """
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: Required. The display name of the bookmark.
        :paramtype display_name: str
        :keyword event_time: The time of the event.
        :paramtype event_time: ~datetime.datetime
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: Required. The query of the bookmark.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        """
        super(HuntingBookmarkProperties, self).__init__(**kwargs)
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.event_time = event_time
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.incident_info = incident_info


class Incident(ResourceWithEtag):
    """Represents an incident in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar additional_data: Additional data on the incident.
    :vartype additional_data: ~azure.mgmt.securityinsight.models.IncidentAdditionalData
    :ivar classification: The reason the incident was closed. Possible values include:
     "Undetermined", "TruePositive", "BenignPositive", "FalsePositive".
    :vartype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
    :ivar classification_comment: Describes the reason the incident was closed.
    :vartype classification_comment: str
    :ivar classification_reason: The classification reason the incident was closed with. Possible
     values include: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic",
     "InaccurateData".
    :vartype classification_reason: str or
     ~azure.mgmt.securityinsight.models.IncidentClassificationReason
    :ivar created_time_utc: The time the incident was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar description: The description of the incident.
    :vartype description: str
    :ivar first_activity_time_utc: The time of the first activity in the incident.
    :vartype first_activity_time_utc: ~datetime.datetime
    :ivar incident_url: The deep-link url to the incident in Azure portal.
    :vartype incident_url: str
    :ivar incident_number: A sequential number.
    :vartype incident_number: int
    :ivar labels: List of labels relevant to this incident.
    :vartype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
    :ivar provider_name: The name of the source provider that generated the incident.
    :vartype provider_name: str
    :ivar provider_incident_id: The incident ID assigned by the incident provider.
    :vartype provider_incident_id: str
    :ivar last_activity_time_utc: The time of the last activity in the incident.
    :vartype last_activity_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the incident was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar owner: Describes a user that the incident is assigned to.
    :vartype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
    :ivar related_analytic_rule_ids: List of resource ids of Analytic rules related to the
     incident.
    :vartype related_analytic_rule_ids: list[str]
    :ivar severity: The severity of the incident. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar status: The status of the incident. Possible values include: "New", "Active", "Closed".
    :vartype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
    :ivar team_information: Describes a team for the incident.
    :vartype team_information: ~azure.mgmt.securityinsight.models.TeamInformation
    :ivar title: The title of the incident.
    :vartype title: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'additional_data': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'incident_url': {'readonly': True},
        'incident_number': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'related_analytic_rule_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': 'IncidentAdditionalData'},
        'classification': {'key': 'properties.classification', 'type': 'str'},
        'classification_comment': {'key': 'properties.classificationComment', 'type': 'str'},
        'classification_reason': {'key': 'properties.classificationReason', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'first_activity_time_utc': {'key': 'properties.firstActivityTimeUtc', 'type': 'iso-8601'},
        'incident_url': {'key': 'properties.incidentUrl', 'type': 'str'},
        'incident_number': {'key': 'properties.incidentNumber', 'type': 'int'},
        'labels': {'key': 'properties.labels', 'type': '[IncidentLabel]'},
        'provider_name': {'key': 'properties.providerName', 'type': 'str'},
        'provider_incident_id': {'key': 'properties.providerIncidentId', 'type': 'str'},
        'last_activity_time_utc': {'key': 'properties.lastActivityTimeUtc', 'type': 'iso-8601'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'owner': {'key': 'properties.owner', 'type': 'IncidentOwnerInfo'},
        'related_analytic_rule_ids': {'key': 'properties.relatedAnalyticRuleIds', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'team_information': {'key': 'properties.teamInformation', 'type': 'TeamInformation'},
        'title': {'key': 'properties.title', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        classification: Optional[Union[str, "IncidentClassification"]] = None,
        classification_comment: Optional[str] = None,
        classification_reason: Optional[Union[str, "IncidentClassificationReason"]] = None,
        description: Optional[str] = None,
        first_activity_time_utc: Optional[datetime.datetime] = None,
        labels: Optional[List["IncidentLabel"]] = None,
        provider_name: Optional[str] = None,
        provider_incident_id: Optional[str] = None,
        last_activity_time_utc: Optional[datetime.datetime] = None,
        owner: Optional["IncidentOwnerInfo"] = None,
        severity: Optional[Union[str, "IncidentSeverity"]] = None,
        status: Optional[Union[str, "IncidentStatus"]] = None,
        team_information: Optional["TeamInformation"] = None,
        title: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword classification: The reason the incident was closed. Possible values include:
         "Undetermined", "TruePositive", "BenignPositive", "FalsePositive".
        :paramtype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
        :keyword classification_comment: Describes the reason the incident was closed.
        :paramtype classification_comment: str
        :keyword classification_reason: The classification reason the incident was closed with.
         Possible values include: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic",
         "InaccurateData".
        :paramtype classification_reason: str or
         ~azure.mgmt.securityinsight.models.IncidentClassificationReason
        :keyword description: The description of the incident.
        :paramtype description: str
        :keyword first_activity_time_utc: The time of the first activity in the incident.
        :paramtype first_activity_time_utc: ~datetime.datetime
        :keyword labels: List of labels relevant to this incident.
        :paramtype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
        :keyword provider_name: The name of the source provider that generated the incident.
        :paramtype provider_name: str
        :keyword provider_incident_id: The incident ID assigned by the incident provider.
        :paramtype provider_incident_id: str
        :keyword last_activity_time_utc: The time of the last activity in the incident.
        :paramtype last_activity_time_utc: ~datetime.datetime
        :keyword owner: Describes a user that the incident is assigned to.
        :paramtype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
        :keyword severity: The severity of the incident. Possible values include: "High", "Medium",
         "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword status: The status of the incident. Possible values include: "New", "Active",
         "Closed".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
        :keyword team_information: Describes a team for the incident.
        :paramtype team_information: ~azure.mgmt.securityinsight.models.TeamInformation
        :keyword title: The title of the incident.
        :paramtype title: str
        """
        super(Incident, self).__init__(etag=etag, **kwargs)
        self.additional_data = None
        self.classification = classification
        self.classification_comment = classification_comment
        self.classification_reason = classification_reason
        self.created_time_utc = None
        self.description = description
        self.first_activity_time_utc = first_activity_time_utc
        self.incident_url = None
        self.incident_number = None
        self.labels = labels
        self.provider_name = provider_name
        self.provider_incident_id = provider_incident_id
        self.last_activity_time_utc = last_activity_time_utc
        self.last_modified_time_utc = None
        self.owner = owner
        self.related_analytic_rule_ids = None
        self.severity = severity
        self.status = status
        self.team_information = team_information
        self.title = title


class IncidentAdditionalData(msrest.serialization.Model):
    """Incident additional data property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alerts_count: The number of alerts in the incident.
    :vartype alerts_count: int
    :ivar bookmarks_count: The number of bookmarks in the incident.
    :vartype bookmarks_count: int
    :ivar comments_count: The number of comments in the incident.
    :vartype comments_count: int
    :ivar alert_product_names: List of product names of alerts in the incident.
    :vartype alert_product_names: list[str]
    :ivar provider_incident_url: The provider incident url to the incident in Microsoft 365
     Defender portal.
    :vartype provider_incident_url: str
    :ivar tactics: The tactics associated with incident.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques associated with incident's tactics'.
    :vartype techniques: list[str]
    """

    _validation = {
        'alerts_count': {'readonly': True},
        'bookmarks_count': {'readonly': True},
        'comments_count': {'readonly': True},
        'alert_product_names': {'readonly': True},
        'provider_incident_url': {'readonly': True},
        'tactics': {'readonly': True},
        'techniques': {'readonly': True},
    }

    _attribute_map = {
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
        'bookmarks_count': {'key': 'bookmarksCount', 'type': 'int'},
        'comments_count': {'key': 'commentsCount', 'type': 'int'},
        'alert_product_names': {'key': 'alertProductNames', 'type': '[str]'},
        'provider_incident_url': {'key': 'providerIncidentUrl', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IncidentAdditionalData, self).__init__(**kwargs)
        self.alerts_count = None
        self.bookmarks_count = None
        self.comments_count = None
        self.alert_product_names = None
        self.provider_incident_url = None
        self.tactics = None
        self.techniques = None


class IncidentAlertList(msrest.serialization.Model):
    """List of incident alerts.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of incident alerts.
    :vartype value: list[~azure.mgmt.securityinsight.models.SecurityAlert]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityAlert]'},
    }

    def __init__(
        self,
        *,
        value: List["SecurityAlert"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of incident alerts.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SecurityAlert]
        """
        super(IncidentAlertList, self).__init__(**kwargs)
        self.value = value


class IncidentBookmarkList(msrest.serialization.Model):
    """List of incident bookmarks.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of incident bookmarks.
    :vartype value: list[~azure.mgmt.securityinsight.models.HuntingBookmark]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HuntingBookmark]'},
    }

    def __init__(
        self,
        *,
        value: List["HuntingBookmark"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of incident bookmarks.
        :paramtype value: list[~azure.mgmt.securityinsight.models.HuntingBookmark]
        """
        super(IncidentBookmarkList, self).__init__(**kwargs)
        self.value = value


class IncidentComment(ResourceWithEtag):
    """Represents an incident comment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar created_time_utc: The time the comment was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The time the comment was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar message: The comment message.
    :vartype message: str
    :ivar author: Describes the client that created the comment.
    :vartype author: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'author': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'ClientInfo'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword message: The comment message.
        :paramtype message: str
        """
        super(IncidentComment, self).__init__(etag=etag, **kwargs)
        self.created_time_utc = None
        self.last_modified_time_utc = None
        self.message = message
        self.author = None


class IncidentCommentList(msrest.serialization.Model):
    """List of incident comments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of comments.
    :vartype next_link: str
    :ivar value: Required. Array of comments.
    :vartype value: list[~azure.mgmt.securityinsight.models.IncidentComment]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IncidentComment]'},
    }

    def __init__(
        self,
        *,
        value: List["IncidentComment"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of comments.
        :paramtype value: list[~azure.mgmt.securityinsight.models.IncidentComment]
        """
        super(IncidentCommentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class IncidentConfiguration(msrest.serialization.Model):
    """Incident Configuration property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar create_incident: Required. Create incidents from alerts triggered by this analytics rule.
    :vartype create_incident: bool
    :ivar grouping_configuration: Set how the alerts that are triggered by this analytics rule, are
     grouped into incidents.
    :vartype grouping_configuration: ~azure.mgmt.securityinsight.models.GroupingConfiguration
    """

    _validation = {
        'create_incident': {'required': True},
    }

    _attribute_map = {
        'create_incident': {'key': 'createIncident', 'type': 'bool'},
        'grouping_configuration': {'key': 'groupingConfiguration', 'type': 'GroupingConfiguration'},
    }

    def __init__(
        self,
        *,
        create_incident: bool,
        grouping_configuration: Optional["GroupingConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword create_incident: Required. Create incidents from alerts triggered by this analytics
         rule.
        :paramtype create_incident: bool
        :keyword grouping_configuration: Set how the alerts that are triggered by this analytics rule,
         are grouped into incidents.
        :paramtype grouping_configuration: ~azure.mgmt.securityinsight.models.GroupingConfiguration
        """
        super(IncidentConfiguration, self).__init__(**kwargs)
        self.create_incident = create_incident
        self.grouping_configuration = grouping_configuration


class IncidentEntitiesResponse(msrest.serialization.Model):
    """The incident related entities response.

    :ivar entities: Array of the incident related entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar meta_data: The metadata from the incident related entities results.
    :vartype meta_data: list[~azure.mgmt.securityinsight.models.IncidentEntitiesResultsMetadata]
    """

    _attribute_map = {
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'meta_data': {'key': 'metaData', 'type': '[IncidentEntitiesResultsMetadata]'},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["Entity"]] = None,
        meta_data: Optional[List["IncidentEntitiesResultsMetadata"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the incident related entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword meta_data: The metadata from the incident related entities results.
        :paramtype meta_data: list[~azure.mgmt.securityinsight.models.IncidentEntitiesResultsMetadata]
        """
        super(IncidentEntitiesResponse, self).__init__(**kwargs)
        self.entities = entities
        self.meta_data = meta_data


class IncidentEntitiesResultsMetadata(msrest.serialization.Model):
    """Information of a specific aggregation in the incident related entities result.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Total number of aggregations of the given kind in the incident related
     entities result.
    :vartype count: int
    :ivar entity_kind: Required. The kind of the aggregated entity. Possible values include:
     "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash",
     "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    """

    _validation = {
        'count': {'required': True},
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'entity_kind': {'key': 'entityKind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: int,
        entity_kind: Union[str, "EntityKind"],
        **kwargs
    ):
        """
        :keyword count: Required. Total number of aggregations of the given kind in the incident
         related entities result.
        :paramtype count: int
        :keyword entity_kind: Required. The kind of the aggregated entity. Possible values include:
         "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash",
         "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
         "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
         "SubmissionMail".
        :paramtype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
        """
        super(IncidentEntitiesResultsMetadata, self).__init__(**kwargs)
        self.count = count
        self.entity_kind = entity_kind


class IncidentInfo(msrest.serialization.Model):
    """Describes related incident information for the bookmark.

    :ivar incident_id: Incident Id.
    :vartype incident_id: str
    :ivar severity: The severity of the incident. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar title: The title of the incident.
    :vartype title: str
    :ivar relation_name: Relation Name.
    :vartype relation_name: str
    """

    _attribute_map = {
        'incident_id': {'key': 'incidentId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'relation_name': {'key': 'relationName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        incident_id: Optional[str] = None,
        severity: Optional[Union[str, "IncidentSeverity"]] = None,
        title: Optional[str] = None,
        relation_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword incident_id: Incident Id.
        :paramtype incident_id: str
        :keyword severity: The severity of the incident. Possible values include: "High", "Medium",
         "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword title: The title of the incident.
        :paramtype title: str
        :keyword relation_name: Relation Name.
        :paramtype relation_name: str
        """
        super(IncidentInfo, self).__init__(**kwargs)
        self.incident_id = incident_id
        self.severity = severity
        self.title = title
        self.relation_name = relation_name


class IncidentLabel(msrest.serialization.Model):
    """Represents an incident label.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar label_name: Required. The name of the label.
    :vartype label_name: str
    :ivar label_type: The type of the label. Possible values include: "User", "AutoAssigned".
    :vartype label_type: str or ~azure.mgmt.securityinsight.models.IncidentLabelType
    """

    _validation = {
        'label_name': {'required': True},
        'label_type': {'readonly': True},
    }

    _attribute_map = {
        'label_name': {'key': 'labelName', 'type': 'str'},
        'label_type': {'key': 'labelType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        label_name: str,
        **kwargs
    ):
        """
        :keyword label_name: Required. The name of the label.
        :paramtype label_name: str
        """
        super(IncidentLabel, self).__init__(**kwargs)
        self.label_name = label_name
        self.label_type = None


class IncidentList(msrest.serialization.Model):
    """List all the incidents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of incidents.
    :vartype next_link: str
    :ivar value: Required. Array of incidents.
    :vartype value: list[~azure.mgmt.securityinsight.models.Incident]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Incident]'},
    }

    def __init__(
        self,
        *,
        value: List["Incident"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of incidents.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Incident]
        """
        super(IncidentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class IncidentOwnerInfo(msrest.serialization.Model):
    """Information on the user an incident is assigned to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar email: The email of the user the incident is assigned to.
    :vartype email: str
    :ivar assigned_to: The name of the user the incident is assigned to.
    :vartype assigned_to: str
    :ivar object_id: The object id of the user the incident is assigned to.
    :vartype object_id: str
    :ivar user_principal_name: The user principal name of the user the incident is assigned to.
    :vartype user_principal_name: str
    :ivar owner_type: The type of the owner the incident is assigned to. Possible values include:
     "Unknown", "User", "Group".
    :vartype owner_type: str or ~azure.mgmt.securityinsight.models.OwnerType
    """

    _validation = {
        'owner_type': {'readonly': True},
    }

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'assigned_to': {'key': 'assignedTo', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'user_principal_name': {'key': 'userPrincipalName', 'type': 'str'},
        'owner_type': {'key': 'ownerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        assigned_to: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email: The email of the user the incident is assigned to.
        :paramtype email: str
        :keyword assigned_to: The name of the user the incident is assigned to.
        :paramtype assigned_to: str
        :keyword object_id: The object id of the user the incident is assigned to.
        :paramtype object_id: str
        :keyword user_principal_name: The user principal name of the user the incident is assigned to.
        :paramtype user_principal_name: str
        """
        super(IncidentOwnerInfo, self).__init__(**kwargs)
        self.email = email
        self.assigned_to = assigned_to
        self.object_id = object_id
        self.user_principal_name = user_principal_name
        self.owner_type = None


class IncidentPropertiesAction(msrest.serialization.Model):
    """IncidentPropertiesAction.

    :ivar severity: The severity of the incident. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar status: The status of the incident. Possible values include: "New", "Active", "Closed".
    :vartype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
    :ivar classification: The reason the incident was closed. Possible values include:
     "Undetermined", "TruePositive", "BenignPositive", "FalsePositive".
    :vartype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
    :ivar classification_reason: The classification reason the incident was closed with. Possible
     values include: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic",
     "InaccurateData".
    :vartype classification_reason: str or
     ~azure.mgmt.securityinsight.models.IncidentClassificationReason
    :ivar classification_comment: Describes the reason the incident was closed.
    :vartype classification_comment: str
    :ivar owner: Information on the user an incident is assigned to.
    :vartype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
    :ivar labels: List of labels to add to the incident.
    :vartype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
    """

    _attribute_map = {
        'severity': {'key': 'severity', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'classification': {'key': 'classification', 'type': 'str'},
        'classification_reason': {'key': 'classificationReason', 'type': 'str'},
        'classification_comment': {'key': 'classificationComment', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'IncidentOwnerInfo'},
        'labels': {'key': 'labels', 'type': '[IncidentLabel]'},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "IncidentSeverity"]] = None,
        status: Optional[Union[str, "IncidentStatus"]] = None,
        classification: Optional[Union[str, "IncidentClassification"]] = None,
        classification_reason: Optional[Union[str, "IncidentClassificationReason"]] = None,
        classification_comment: Optional[str] = None,
        owner: Optional["IncidentOwnerInfo"] = None,
        labels: Optional[List["IncidentLabel"]] = None,
        **kwargs
    ):
        """
        :keyword severity: The severity of the incident. Possible values include: "High", "Medium",
         "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword status: The status of the incident. Possible values include: "New", "Active",
         "Closed".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
        :keyword classification: The reason the incident was closed. Possible values include:
         "Undetermined", "TruePositive", "BenignPositive", "FalsePositive".
        :paramtype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
        :keyword classification_reason: The classification reason the incident was closed with.
         Possible values include: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic",
         "InaccurateData".
        :paramtype classification_reason: str or
         ~azure.mgmt.securityinsight.models.IncidentClassificationReason
        :keyword classification_comment: Describes the reason the incident was closed.
        :paramtype classification_comment: str
        :keyword owner: Information on the user an incident is assigned to.
        :paramtype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
        :keyword labels: List of labels to add to the incident.
        :paramtype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
        """
        super(IncidentPropertiesAction, self).__init__(**kwargs)
        self.severity = severity
        self.status = status
        self.classification = classification
        self.classification_reason = classification_reason
        self.classification_comment = classification_comment
        self.owner = owner
        self.labels = labels


class InsightQueryItem(EntityQueryItem):
    """Represents Insight Query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Query Template ARM ID.
    :vartype id: str
    :ivar name: Query Template ARM Name.
    :vartype name: str
    :ivar type: ARM Type.
    :vartype type: str
    :ivar kind: Required. The kind of the entity query.Constant filled by server. Possible values
     include: "Expansion", "Insight", "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar properties: Properties bag for InsightQueryItem.
    :vartype properties: ~azure.mgmt.securityinsight.models.InsightQueryItemProperties
    """

    _validation = {
        'id': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'InsightQueryItemProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        properties: Optional["InsightQueryItemProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: Query Template ARM Name.
        :paramtype name: str
        :keyword type: ARM Type.
        :paramtype type: str
        :keyword properties: Properties bag for InsightQueryItem.
        :paramtype properties: ~azure.mgmt.securityinsight.models.InsightQueryItemProperties
        """
        super(InsightQueryItem, self).__init__(name=name, type=type, **kwargs)
        self.kind = 'Insight'  # type: str
        self.properties = properties


class InsightQueryItemProperties(EntityQueryItemProperties):
    """Represents Insight Query.

    :ivar data_types: Data types for template.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
    :ivar input_entity_type: The type of the entity. Possible values include: "Account", "Host",
     "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
     "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: Data types for template.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: any
    :ivar display_name: The insight display name.
    :vartype display_name: str
    :ivar description: The insight description.
    :vartype description: str
    :ivar base_query: The base query of the insight.
    :vartype base_query: str
    :ivar table_query: The insight table query.
    :vartype table_query: ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQuery
    :ivar chart_query: The insight chart query.
    :vartype chart_query: any
    :ivar additional_query: The activity query definitions.
    :vartype additional_query:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesAdditionalQuery
    :ivar default_time_range: The insight chart query.
    :vartype default_time_range:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesDefaultTimeRange
    :ivar reference_time_range: The insight chart query.
    :vartype reference_time_range:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesReferenceTimeRange
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': '[EntityQueryItemPropertiesDataTypesItem]'},
        'input_entity_type': {'key': 'inputEntityType', 'type': 'str'},
        'required_input_fields_sets': {'key': 'requiredInputFieldsSets', 'type': '[[str]]'},
        'entities_filter': {'key': 'entitiesFilter', 'type': 'object'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'base_query': {'key': 'baseQuery', 'type': 'str'},
        'table_query': {'key': 'tableQuery', 'type': 'InsightQueryItemPropertiesTableQuery'},
        'chart_query': {'key': 'chartQuery', 'type': 'object'},
        'additional_query': {'key': 'additionalQuery', 'type': 'InsightQueryItemPropertiesAdditionalQuery'},
        'default_time_range': {'key': 'defaultTimeRange', 'type': 'InsightQueryItemPropertiesDefaultTimeRange'},
        'reference_time_range': {'key': 'referenceTimeRange', 'type': 'InsightQueryItemPropertiesReferenceTimeRange'},
    }

    def __init__(
        self,
        *,
        data_types: Optional[List["EntityQueryItemPropertiesDataTypesItem"]] = None,
        input_entity_type: Optional[Union[str, "EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Any] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        base_query: Optional[str] = None,
        table_query: Optional["InsightQueryItemPropertiesTableQuery"] = None,
        chart_query: Optional[Any] = None,
        additional_query: Optional["InsightQueryItemPropertiesAdditionalQuery"] = None,
        default_time_range: Optional["InsightQueryItemPropertiesDefaultTimeRange"] = None,
        reference_time_range: Optional["InsightQueryItemPropertiesReferenceTimeRange"] = None,
        **kwargs
    ):
        """
        :keyword data_types: Data types for template.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
        :keyword input_entity_type: The type of the entity. Possible values include: "Account", "Host",
         "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
         "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
         "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: Data types for template.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: any
        :keyword display_name: The insight display name.
        :paramtype display_name: str
        :keyword description: The insight description.
        :paramtype description: str
        :keyword base_query: The base query of the insight.
        :paramtype base_query: str
        :keyword table_query: The insight table query.
        :paramtype table_query: ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQuery
        :keyword chart_query: The insight chart query.
        :paramtype chart_query: any
        :keyword additional_query: The activity query definitions.
        :paramtype additional_query:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesAdditionalQuery
        :keyword default_time_range: The insight chart query.
        :paramtype default_time_range:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesDefaultTimeRange
        :keyword reference_time_range: The insight chart query.
        :paramtype reference_time_range:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesReferenceTimeRange
        """
        super(InsightQueryItemProperties, self).__init__(data_types=data_types, input_entity_type=input_entity_type, required_input_fields_sets=required_input_fields_sets, entities_filter=entities_filter, **kwargs)
        self.display_name = display_name
        self.description = description
        self.base_query = base_query
        self.table_query = table_query
        self.chart_query = chart_query
        self.additional_query = additional_query
        self.default_time_range = default_time_range
        self.reference_time_range = reference_time_range


class InsightQueryItemPropertiesAdditionalQuery(msrest.serialization.Model):
    """The activity query definitions.

    :ivar query: The insight query.
    :vartype query: str
    :ivar text: The insight text.
    :vartype text: str
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query: The insight query.
        :paramtype query: str
        :keyword text: The insight text.
        :paramtype text: str
        """
        super(InsightQueryItemPropertiesAdditionalQuery, self).__init__(**kwargs)
        self.query = query
        self.text = text


class InsightQueryItemPropertiesDefaultTimeRange(msrest.serialization.Model):
    """The insight chart query.

    :ivar before_range: The padding for the start time of the query.
    :vartype before_range: str
    :ivar after_range: The padding for the end time of the query.
    :vartype after_range: str
    """

    _attribute_map = {
        'before_range': {'key': 'beforeRange', 'type': 'str'},
        'after_range': {'key': 'afterRange', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        before_range: Optional[str] = None,
        after_range: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword before_range: The padding for the start time of the query.
        :paramtype before_range: str
        :keyword after_range: The padding for the end time of the query.
        :paramtype after_range: str
        """
        super(InsightQueryItemPropertiesDefaultTimeRange, self).__init__(**kwargs)
        self.before_range = before_range
        self.after_range = after_range


class InsightQueryItemPropertiesReferenceTimeRange(msrest.serialization.Model):
    """The insight chart query.

    :ivar before_range: Additional query time for looking back.
    :vartype before_range: str
    """

    _attribute_map = {
        'before_range': {'key': 'beforeRange', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        before_range: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword before_range: Additional query time for looking back.
        :paramtype before_range: str
        """
        super(InsightQueryItemPropertiesReferenceTimeRange, self).__init__(**kwargs)
        self.before_range = before_range


class InsightQueryItemPropertiesTableQuery(msrest.serialization.Model):
    """The insight table query.

    :ivar columns_definitions: List of insight column definitions.
    :vartype columns_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]
    :ivar queries_definitions: List of insight queries definitions.
    :vartype queries_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]
    """

    _attribute_map = {
        'columns_definitions': {'key': 'columnsDefinitions', 'type': '[InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]'},
        'queries_definitions': {'key': 'queriesDefinitions', 'type': '[InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]'},
    }

    def __init__(
        self,
        *,
        columns_definitions: Optional[List["InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem"]] = None,
        queries_definitions: Optional[List["InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword columns_definitions: List of insight column definitions.
        :paramtype columns_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]
        :keyword queries_definitions: List of insight queries definitions.
        :paramtype queries_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]
        """
        super(InsightQueryItemPropertiesTableQuery, self).__init__(**kwargs)
        self.columns_definitions = columns_definitions
        self.queries_definitions = queries_definitions


class InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(msrest.serialization.Model):
    """InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem.

    :ivar header: Insight column header.
    :vartype header: str
    :ivar output_type: Insights Column type. Possible values include: "Number", "String", "Date",
     "Entity".
    :vartype output_type: str or ~azure.mgmt.securityinsight.models.OutputType
    :ivar support_deep_link: Is query supports deep-link.
    :vartype support_deep_link: bool
    """

    _attribute_map = {
        'header': {'key': 'header', 'type': 'str'},
        'output_type': {'key': 'outputType', 'type': 'str'},
        'support_deep_link': {'key': 'supportDeepLink', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        header: Optional[str] = None,
        output_type: Optional[Union[str, "OutputType"]] = None,
        support_deep_link: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword header: Insight column header.
        :paramtype header: str
        :keyword output_type: Insights Column type. Possible values include: "Number", "String",
         "Date", "Entity".
        :paramtype output_type: str or ~azure.mgmt.securityinsight.models.OutputType
        :keyword support_deep_link: Is query supports deep-link.
        :paramtype support_deep_link: bool
        """
        super(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem, self).__init__(**kwargs)
        self.header = header
        self.output_type = output_type
        self.support_deep_link = support_deep_link


class InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(msrest.serialization.Model):
    """InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem.

    :ivar filter: Insight column header.
    :vartype filter: str
    :ivar summarize: Insight column header.
    :vartype summarize: str
    :ivar project: Insight column header.
    :vartype project: str
    :ivar link_columns_definitions: Insight column header.
    :vartype link_columns_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]
    """

    _attribute_map = {
        'filter': {'key': 'filter', 'type': 'str'},
        'summarize': {'key': 'summarize', 'type': 'str'},
        'project': {'key': 'project', 'type': 'str'},
        'link_columns_definitions': {'key': 'linkColumnsDefinitions', 'type': '[InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]'},
    }

    def __init__(
        self,
        *,
        filter: Optional[str] = None,
        summarize: Optional[str] = None,
        project: Optional[str] = None,
        link_columns_definitions: Optional[List["InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem"]] = None,
        **kwargs
    ):
        """
        :keyword filter: Insight column header.
        :paramtype filter: str
        :keyword summarize: Insight column header.
        :paramtype summarize: str
        :keyword project: Insight column header.
        :paramtype project: str
        :keyword link_columns_definitions: Insight column header.
        :paramtype link_columns_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]
        """
        super(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem, self).__init__(**kwargs)
        self.filter = filter
        self.summarize = summarize
        self.project = project
        self.link_columns_definitions = link_columns_definitions


class InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(msrest.serialization.Model):
    """InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem.

    :ivar projected_name: Insight Link Definition Projected Name.
    :vartype projected_name: str
    :ivar query: Insight Link Definition Query.
    :vartype query: str
    """

    _attribute_map = {
        'projected_name': {'key': 'projectedName', 'type': 'str'},
        'query': {'key': 'Query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        projected_name: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword projected_name: Insight Link Definition Projected Name.
        :paramtype projected_name: str
        :keyword query: Insight Link Definition Query.
        :paramtype query: str
        """
        super(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem, self).__init__(**kwargs)
        self.projected_name = projected_name
        self.query = query


class InsightsTableResult(msrest.serialization.Model):
    """Query results for table insights query.

    :ivar columns: Columns Metadata of the table.
    :vartype columns: list[~azure.mgmt.securityinsight.models.InsightsTableResultColumnsItem]
    :ivar rows: Rows data of the table.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[InsightsTableResultColumnsItem]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(
        self,
        *,
        columns: Optional[List["InsightsTableResultColumnsItem"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs
    ):
        """
        :keyword columns: Columns Metadata of the table.
        :paramtype columns: list[~azure.mgmt.securityinsight.models.InsightsTableResultColumnsItem]
        :keyword rows: Rows data of the table.
        :paramtype rows: list[list[str]]
        """
        super(InsightsTableResult, self).__init__(**kwargs)
        self.columns = columns
        self.rows = rows


class InsightsTableResultColumnsItem(msrest.serialization.Model):
    """InsightsTableResultColumnsItem.

    :ivar type: the type of the colum.
    :vartype type: str
    :ivar name: the name of the colum.
    :vartype name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: the type of the colum.
        :paramtype type: str
        :keyword name: the name of the colum.
        :paramtype name: str
        """
        super(InsightsTableResultColumnsItem, self).__init__(**kwargs)
        self.type = type
        self.name = name


class InstructionStepsInstructionsItem(ConnectorInstructionModelBase):
    """InstructionStepsInstructionsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar parameters: The parameters for the setting.
    :vartype parameters: any
    :ivar type: Required. The kind of the setting. Possible values include: "CopyableLabel",
     "InstructionStepsGroup", "InfoMessage".
    :vartype type: str or ~azure.mgmt.securityinsight.models.SettingType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "SettingType"],
        parameters: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword parameters: The parameters for the setting.
        :paramtype parameters: any
        :keyword type: Required. The kind of the setting. Possible values include: "CopyableLabel",
         "InstructionStepsGroup", "InfoMessage".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.SettingType
        """
        super(InstructionStepsInstructionsItem, self).__init__(parameters=parameters, type=type, **kwargs)


class IoTCheckRequirements(DataConnectorsCheckRequirements):
    """Represents IoT requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(IoTCheckRequirements, self).__init__(**kwargs)
        self.kind = 'IOT'  # type: str
        self.subscription_id = subscription_id


class IoTDataConnector(DataConnector):
    """Represents IoT data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(IoTDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'IOT'  # type: str
        self.data_types = data_types
        self.subscription_id = subscription_id


class IoTDataConnectorProperties(DataConnectorWithAlertsProperties):
    """IoT data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super(IoTDataConnectorProperties, self).__init__(data_types=data_types, **kwargs)
        self.subscription_id = subscription_id


class IoTDeviceEntity(Entity):
    """Represents an IoT device entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar device_id: The ID of the IoT Device in the IoT Hub.
    :vartype device_id: str
    :ivar device_name: The friendly name of the device.
    :vartype device_name: str
    :ivar source: The source of the device.
    :vartype source: str
    :ivar iot_security_agent_id: The ID of the security agent running on the device.
    :vartype iot_security_agent_id: str
    :ivar device_type: The type of the device.
    :vartype device_type: str
    :ivar vendor: The vendor of the device.
    :vartype vendor: str
    :ivar edge_id: The ID of the edge device.
    :vartype edge_id: str
    :ivar mac_address: The MAC address of the device.
    :vartype mac_address: str
    :ivar model: The model of the device.
    :vartype model: str
    :ivar serial_number: The serial number of the device.
    :vartype serial_number: str
    :ivar firmware_version: The firmware version of the device.
    :vartype firmware_version: str
    :ivar operating_system: The operating system of the device.
    :vartype operating_system: str
    :ivar iot_hub_entity_id: The AzureResource entity id of the IoT Hub.
    :vartype iot_hub_entity_id: str
    :ivar host_entity_id: The Host entity id of this device.
    :vartype host_entity_id: str
    :ivar ip_address_entity_id: The IP entity if of this device.
    :vartype ip_address_entity_id: str
    :ivar threat_intelligence: A list of TI contexts attached to the IoTDevice entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    :ivar protocols: A list of protocols of the IoTDevice entity.
    :vartype protocols: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'device_id': {'readonly': True},
        'device_name': {'readonly': True},
        'source': {'readonly': True},
        'iot_security_agent_id': {'readonly': True},
        'device_type': {'readonly': True},
        'vendor': {'readonly': True},
        'edge_id': {'readonly': True},
        'mac_address': {'readonly': True},
        'model': {'readonly': True},
        'serial_number': {'readonly': True},
        'firmware_version': {'readonly': True},
        'operating_system': {'readonly': True},
        'iot_hub_entity_id': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'ip_address_entity_id': {'readonly': True},
        'threat_intelligence': {'readonly': True},
        'protocols': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'device_id': {'key': 'properties.deviceId', 'type': 'str'},
        'device_name': {'key': 'properties.deviceName', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'iot_security_agent_id': {'key': 'properties.iotSecurityAgentId', 'type': 'str'},
        'device_type': {'key': 'properties.deviceType', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'edge_id': {'key': 'properties.edgeId', 'type': 'str'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'model': {'key': 'properties.model', 'type': 'str'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'firmware_version': {'key': 'properties.firmwareVersion', 'type': 'str'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'iot_hub_entity_id': {'key': 'properties.iotHubEntityId', 'type': 'str'},
        'host_entity_id': {'key': 'properties.hostEntityId', 'type': 'str'},
        'ip_address_entity_id': {'key': 'properties.ipAddressEntityId', 'type': 'str'},
        'threat_intelligence': {'key': 'properties.threatIntelligence', 'type': '[ThreatIntelligence]'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IoTDeviceEntity, self).__init__(**kwargs)
        self.kind = 'IoTDevice'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.device_id = None
        self.device_name = None
        self.source = None
        self.iot_security_agent_id = None
        self.device_type = None
        self.vendor = None
        self.edge_id = None
        self.mac_address = None
        self.model = None
        self.serial_number = None
        self.firmware_version = None
        self.operating_system = None
        self.iot_hub_entity_id = None
        self.host_entity_id = None
        self.ip_address_entity_id = None
        self.threat_intelligence = None
        self.protocols = None


class IoTDeviceEntityProperties(EntityCommonProperties):
    """IoTDevice entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar device_id: The ID of the IoT Device in the IoT Hub.
    :vartype device_id: str
    :ivar device_name: The friendly name of the device.
    :vartype device_name: str
    :ivar source: The source of the device.
    :vartype source: str
    :ivar iot_security_agent_id: The ID of the security agent running on the device.
    :vartype iot_security_agent_id: str
    :ivar device_type: The type of the device.
    :vartype device_type: str
    :ivar vendor: The vendor of the device.
    :vartype vendor: str
    :ivar edge_id: The ID of the edge device.
    :vartype edge_id: str
    :ivar mac_address: The MAC address of the device.
    :vartype mac_address: str
    :ivar model: The model of the device.
    :vartype model: str
    :ivar serial_number: The serial number of the device.
    :vartype serial_number: str
    :ivar firmware_version: The firmware version of the device.
    :vartype firmware_version: str
    :ivar operating_system: The operating system of the device.
    :vartype operating_system: str
    :ivar iot_hub_entity_id: The AzureResource entity id of the IoT Hub.
    :vartype iot_hub_entity_id: str
    :ivar host_entity_id: The Host entity id of this device.
    :vartype host_entity_id: str
    :ivar ip_address_entity_id: The IP entity if of this device.
    :vartype ip_address_entity_id: str
    :ivar threat_intelligence: A list of TI contexts attached to the IoTDevice entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    :ivar protocols: A list of protocols of the IoTDevice entity.
    :vartype protocols: list[str]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'device_id': {'readonly': True},
        'device_name': {'readonly': True},
        'source': {'readonly': True},
        'iot_security_agent_id': {'readonly': True},
        'device_type': {'readonly': True},
        'vendor': {'readonly': True},
        'edge_id': {'readonly': True},
        'mac_address': {'readonly': True},
        'model': {'readonly': True},
        'serial_number': {'readonly': True},
        'firmware_version': {'readonly': True},
        'operating_system': {'readonly': True},
        'iot_hub_entity_id': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'ip_address_entity_id': {'readonly': True},
        'threat_intelligence': {'readonly': True},
        'protocols': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'device_name': {'key': 'deviceName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'iot_security_agent_id': {'key': 'iotSecurityAgentId', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'vendor': {'key': 'vendor', 'type': 'str'},
        'edge_id': {'key': 'edgeId', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'firmware_version': {'key': 'firmwareVersion', 'type': 'str'},
        'operating_system': {'key': 'operatingSystem', 'type': 'str'},
        'iot_hub_entity_id': {'key': 'iotHubEntityId', 'type': 'str'},
        'host_entity_id': {'key': 'hostEntityId', 'type': 'str'},
        'ip_address_entity_id': {'key': 'ipAddressEntityId', 'type': 'str'},
        'threat_intelligence': {'key': 'threatIntelligence', 'type': '[ThreatIntelligence]'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IoTDeviceEntityProperties, self).__init__(**kwargs)
        self.device_id = None
        self.device_name = None
        self.source = None
        self.iot_security_agent_id = None
        self.device_type = None
        self.vendor = None
        self.edge_id = None
        self.mac_address = None
        self.model = None
        self.serial_number = None
        self.firmware_version = None
        self.operating_system = None
        self.iot_hub_entity_id = None
        self.host_entity_id = None
        self.ip_address_entity_id = None
        self.threat_intelligence = None
        self.protocols = None


class IpEntity(Entity):
    """Represents an ip entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar address: The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6).
    :vartype address: str
    :ivar location: The geo-location context attached to the ip entity.
    :vartype location: ~azure.mgmt.securityinsight.models.GeoLocation
    :ivar threat_intelligence: A list of TI contexts attached to the ip entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'address': {'readonly': True},
        'location': {'readonly': True},
        'threat_intelligence': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'address': {'key': 'properties.address', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'GeoLocation'},
        'threat_intelligence': {'key': 'properties.threatIntelligence', 'type': '[ThreatIntelligence]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IpEntity, self).__init__(**kwargs)
        self.kind = 'Ip'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.address = None
        self.location = None
        self.threat_intelligence = None


class IpEntityProperties(EntityCommonProperties):
    """Ip entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar address: The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6).
    :vartype address: str
    :ivar location: The geo-location context attached to the ip entity.
    :vartype location: ~azure.mgmt.securityinsight.models.GeoLocation
    :ivar threat_intelligence: A list of TI contexts attached to the ip entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'address': {'readonly': True},
        'location': {'readonly': True},
        'threat_intelligence': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'location': {'key': 'location', 'type': 'GeoLocation'},
        'threat_intelligence': {'key': 'threatIntelligence', 'type': '[ThreatIntelligence]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IpEntityProperties, self).__init__(**kwargs)
        self.address = None
        self.location = None
        self.threat_intelligence = None


class MailboxEntity(Entity):
    """Represents a mailbox entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mailbox_primary_address: The mailbox's primary address.
    :vartype mailbox_primary_address: str
    :ivar display_name: The mailbox's display name.
    :vartype display_name: str
    :ivar upn: The mailbox's UPN.
    :vartype upn: str
    :ivar external_directory_object_id: The AzureAD identifier of mailbox. Similar to AadUserId in
     account entity but this property is specific to mailbox object on office side.
    :vartype external_directory_object_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'mailbox_primary_address': {'readonly': True},
        'display_name': {'readonly': True},
        'upn': {'readonly': True},
        'external_directory_object_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'mailbox_primary_address': {'key': 'properties.mailboxPrimaryAddress', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'upn': {'key': 'properties.upn', 'type': 'str'},
        'external_directory_object_id': {'key': 'properties.externalDirectoryObjectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MailboxEntity, self).__init__(**kwargs)
        self.kind = 'Mailbox'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.mailbox_primary_address = None
        self.display_name = None
        self.upn = None
        self.external_directory_object_id = None


class MailboxEntityProperties(EntityCommonProperties):
    """Mailbox entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mailbox_primary_address: The mailbox's primary address.
    :vartype mailbox_primary_address: str
    :ivar display_name: The mailbox's display name.
    :vartype display_name: str
    :ivar upn: The mailbox's UPN.
    :vartype upn: str
    :ivar external_directory_object_id: The AzureAD identifier of mailbox. Similar to AadUserId in
     account entity but this property is specific to mailbox object on office side.
    :vartype external_directory_object_id: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'mailbox_primary_address': {'readonly': True},
        'display_name': {'readonly': True},
        'upn': {'readonly': True},
        'external_directory_object_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'mailbox_primary_address': {'key': 'mailboxPrimaryAddress', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
        'external_directory_object_id': {'key': 'externalDirectoryObjectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MailboxEntityProperties, self).__init__(**kwargs)
        self.mailbox_primary_address = None
        self.display_name = None
        self.upn = None
        self.external_directory_object_id = None


class MailClusterEntity(Entity):
    """Represents a mail cluster entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_ids: The mail message IDs that are part of the mail cluster.
    :vartype network_message_ids: list[str]
    :ivar count_by_delivery_status: Count of mail messages by DeliveryStatus string representation.
    :vartype count_by_delivery_status: any
    :ivar count_by_threat_type: Count of mail messages by ThreatType string representation.
    :vartype count_by_threat_type: any
    :ivar count_by_protection_status: Count of mail messages by ProtectionStatus string
     representation.
    :vartype count_by_protection_status: any
    :ivar threats: The threats of mail messages that are part of the mail cluster.
    :vartype threats: list[str]
    :ivar query: The query that was used to identify the messages of the mail cluster.
    :vartype query: str
    :ivar query_time: The query time.
    :vartype query_time: ~datetime.datetime
    :ivar mail_count: The number of mail messages that are part of the mail cluster.
    :vartype mail_count: int
    :ivar is_volume_anomaly: Is this a volume anomaly mail cluster.
    :vartype is_volume_anomaly: bool
    :ivar source: The source of the mail cluster (default is 'O365 ATP').
    :vartype source: str
    :ivar cluster_source_identifier: The id of the cluster source.
    :vartype cluster_source_identifier: str
    :ivar cluster_source_type: The type of the cluster source.
    :vartype cluster_source_type: str
    :ivar cluster_query_start_time: The cluster query start time.
    :vartype cluster_query_start_time: ~datetime.datetime
    :ivar cluster_query_end_time: The cluster query end time.
    :vartype cluster_query_end_time: ~datetime.datetime
    :ivar cluster_group: The cluster group.
    :vartype cluster_group: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'network_message_ids': {'readonly': True},
        'count_by_delivery_status': {'readonly': True},
        'count_by_threat_type': {'readonly': True},
        'count_by_protection_status': {'readonly': True},
        'threats': {'readonly': True},
        'query': {'readonly': True},
        'query_time': {'readonly': True},
        'mail_count': {'readonly': True},
        'is_volume_anomaly': {'readonly': True},
        'source': {'readonly': True},
        'cluster_source_identifier': {'readonly': True},
        'cluster_source_type': {'readonly': True},
        'cluster_query_start_time': {'readonly': True},
        'cluster_query_end_time': {'readonly': True},
        'cluster_group': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'network_message_ids': {'key': 'properties.networkMessageIds', 'type': '[str]'},
        'count_by_delivery_status': {'key': 'properties.countByDeliveryStatus', 'type': 'object'},
        'count_by_threat_type': {'key': 'properties.countByThreatType', 'type': 'object'},
        'count_by_protection_status': {'key': 'properties.countByProtectionStatus', 'type': 'object'},
        'threats': {'key': 'properties.threats', 'type': '[str]'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_time': {'key': 'properties.queryTime', 'type': 'iso-8601'},
        'mail_count': {'key': 'properties.mailCount', 'type': 'int'},
        'is_volume_anomaly': {'key': 'properties.isVolumeAnomaly', 'type': 'bool'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'cluster_source_identifier': {'key': 'properties.clusterSourceIdentifier', 'type': 'str'},
        'cluster_source_type': {'key': 'properties.clusterSourceType', 'type': 'str'},
        'cluster_query_start_time': {'key': 'properties.clusterQueryStartTime', 'type': 'iso-8601'},
        'cluster_query_end_time': {'key': 'properties.clusterQueryEndTime', 'type': 'iso-8601'},
        'cluster_group': {'key': 'properties.clusterGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MailClusterEntity, self).__init__(**kwargs)
        self.kind = 'MailCluster'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.network_message_ids = None
        self.count_by_delivery_status = None
        self.count_by_threat_type = None
        self.count_by_protection_status = None
        self.threats = None
        self.query = None
        self.query_time = None
        self.mail_count = None
        self.is_volume_anomaly = None
        self.source = None
        self.cluster_source_identifier = None
        self.cluster_source_type = None
        self.cluster_query_start_time = None
        self.cluster_query_end_time = None
        self.cluster_group = None


class MailClusterEntityProperties(EntityCommonProperties):
    """Mail cluster entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_ids: The mail message IDs that are part of the mail cluster.
    :vartype network_message_ids: list[str]
    :ivar count_by_delivery_status: Count of mail messages by DeliveryStatus string representation.
    :vartype count_by_delivery_status: any
    :ivar count_by_threat_type: Count of mail messages by ThreatType string representation.
    :vartype count_by_threat_type: any
    :ivar count_by_protection_status: Count of mail messages by ProtectionStatus string
     representation.
    :vartype count_by_protection_status: any
    :ivar threats: The threats of mail messages that are part of the mail cluster.
    :vartype threats: list[str]
    :ivar query: The query that was used to identify the messages of the mail cluster.
    :vartype query: str
    :ivar query_time: The query time.
    :vartype query_time: ~datetime.datetime
    :ivar mail_count: The number of mail messages that are part of the mail cluster.
    :vartype mail_count: int
    :ivar is_volume_anomaly: Is this a volume anomaly mail cluster.
    :vartype is_volume_anomaly: bool
    :ivar source: The source of the mail cluster (default is 'O365 ATP').
    :vartype source: str
    :ivar cluster_source_identifier: The id of the cluster source.
    :vartype cluster_source_identifier: str
    :ivar cluster_source_type: The type of the cluster source.
    :vartype cluster_source_type: str
    :ivar cluster_query_start_time: The cluster query start time.
    :vartype cluster_query_start_time: ~datetime.datetime
    :ivar cluster_query_end_time: The cluster query end time.
    :vartype cluster_query_end_time: ~datetime.datetime
    :ivar cluster_group: The cluster group.
    :vartype cluster_group: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'network_message_ids': {'readonly': True},
        'count_by_delivery_status': {'readonly': True},
        'count_by_threat_type': {'readonly': True},
        'count_by_protection_status': {'readonly': True},
        'threats': {'readonly': True},
        'query': {'readonly': True},
        'query_time': {'readonly': True},
        'mail_count': {'readonly': True},
        'is_volume_anomaly': {'readonly': True},
        'source': {'readonly': True},
        'cluster_source_identifier': {'readonly': True},
        'cluster_source_type': {'readonly': True},
        'cluster_query_start_time': {'readonly': True},
        'cluster_query_end_time': {'readonly': True},
        'cluster_group': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'network_message_ids': {'key': 'networkMessageIds', 'type': '[str]'},
        'count_by_delivery_status': {'key': 'countByDeliveryStatus', 'type': 'object'},
        'count_by_threat_type': {'key': 'countByThreatType', 'type': 'object'},
        'count_by_protection_status': {'key': 'countByProtectionStatus', 'type': 'object'},
        'threats': {'key': 'threats', 'type': '[str]'},
        'query': {'key': 'query', 'type': 'str'},
        'query_time': {'key': 'queryTime', 'type': 'iso-8601'},
        'mail_count': {'key': 'mailCount', 'type': 'int'},
        'is_volume_anomaly': {'key': 'isVolumeAnomaly', 'type': 'bool'},
        'source': {'key': 'source', 'type': 'str'},
        'cluster_source_identifier': {'key': 'clusterSourceIdentifier', 'type': 'str'},
        'cluster_source_type': {'key': 'clusterSourceType', 'type': 'str'},
        'cluster_query_start_time': {'key': 'clusterQueryStartTime', 'type': 'iso-8601'},
        'cluster_query_end_time': {'key': 'clusterQueryEndTime', 'type': 'iso-8601'},
        'cluster_group': {'key': 'clusterGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MailClusterEntityProperties, self).__init__(**kwargs)
        self.network_message_ids = None
        self.count_by_delivery_status = None
        self.count_by_threat_type = None
        self.count_by_protection_status = None
        self.threats = None
        self.query = None
        self.query_time = None
        self.mail_count = None
        self.is_volume_anomaly = None
        self.source = None
        self.cluster_source_identifier = None
        self.cluster_source_type = None
        self.cluster_query_start_time = None
        self.cluster_query_end_time = None
        self.cluster_group = None


class MailMessageEntity(Entity):
    """Represents a mail message entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar file_entity_ids: The File entity ids of this mail message's attachments.
    :vartype file_entity_ids: list[str]
    :ivar recipient: The recipient of this mail message. Note that in case of multiple recipients
     the mail message is forked and each copy has one recipient.
    :vartype recipient: str
    :ivar urls: The Urls contained in this mail message.
    :vartype urls: list[str]
    :ivar threats: The threats of this mail message.
    :vartype threats: list[str]
    :ivar p1_sender: The p1 sender's email address.
    :vartype p1_sender: str
    :ivar p1_sender_display_name: The p1 sender's display name.
    :vartype p1_sender_display_name: str
    :ivar p1_sender_domain: The p1 sender's domain.
    :vartype p1_sender_domain: str
    :ivar sender_ip: The sender's IP address.
    :vartype sender_ip: str
    :ivar p2_sender: The p2 sender's email address.
    :vartype p2_sender: str
    :ivar p2_sender_display_name: The p2 sender's display name.
    :vartype p2_sender_display_name: str
    :ivar p2_sender_domain: The p2 sender's domain.
    :vartype p2_sender_domain: str
    :ivar receive_date: The receive date of this message.
    :vartype receive_date: ~datetime.datetime
    :ivar network_message_id: The network message id of this mail message.
    :vartype network_message_id: str
    :ivar internet_message_id: The internet message id of this mail message.
    :vartype internet_message_id: str
    :ivar subject: The subject of this mail message.
    :vartype subject: str
    :ivar language: The language of this mail message.
    :vartype language: str
    :ivar threat_detection_methods: The threat detection methods.
    :vartype threat_detection_methods: list[str]
    :ivar body_fingerprint_bin1: The bodyFingerprintBin1.
    :vartype body_fingerprint_bin1: int
    :ivar body_fingerprint_bin2: The bodyFingerprintBin2.
    :vartype body_fingerprint_bin2: int
    :ivar body_fingerprint_bin3: The bodyFingerprintBin3.
    :vartype body_fingerprint_bin3: int
    :ivar body_fingerprint_bin4: The bodyFingerprintBin4.
    :vartype body_fingerprint_bin4: int
    :ivar body_fingerprint_bin5: The bodyFingerprintBin5.
    :vartype body_fingerprint_bin5: int
    :ivar antispam_direction: The directionality of this mail message. Possible values include:
     "Unknown", "Inbound", "Outbound", "Intraorg".
    :vartype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
    :ivar delivery_action: The delivery action of this mail message like Delivered, Blocked,
     Replaced etc. Possible values include: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked",
     "Replaced".
    :vartype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
    :ivar delivery_location: The delivery location of this mail message like Inbox, JunkFolder etc.
     Possible values include: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
     "External", "Failed", "Dropped", "Forwarded".
    :vartype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'file_entity_ids': {'readonly': True},
        'recipient': {'readonly': True},
        'urls': {'readonly': True},
        'threats': {'readonly': True},
        'p1_sender': {'readonly': True},
        'p1_sender_display_name': {'readonly': True},
        'p1_sender_domain': {'readonly': True},
        'sender_ip': {'readonly': True},
        'p2_sender': {'readonly': True},
        'p2_sender_display_name': {'readonly': True},
        'p2_sender_domain': {'readonly': True},
        'receive_date': {'readonly': True},
        'network_message_id': {'readonly': True},
        'internet_message_id': {'readonly': True},
        'subject': {'readonly': True},
        'language': {'readonly': True},
        'threat_detection_methods': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'file_entity_ids': {'key': 'properties.fileEntityIds', 'type': '[str]'},
        'recipient': {'key': 'properties.recipient', 'type': 'str'},
        'urls': {'key': 'properties.urls', 'type': '[str]'},
        'threats': {'key': 'properties.threats', 'type': '[str]'},
        'p1_sender': {'key': 'properties.p1Sender', 'type': 'str'},
        'p1_sender_display_name': {'key': 'properties.p1SenderDisplayName', 'type': 'str'},
        'p1_sender_domain': {'key': 'properties.p1SenderDomain', 'type': 'str'},
        'sender_ip': {'key': 'properties.senderIP', 'type': 'str'},
        'p2_sender': {'key': 'properties.p2Sender', 'type': 'str'},
        'p2_sender_display_name': {'key': 'properties.p2SenderDisplayName', 'type': 'str'},
        'p2_sender_domain': {'key': 'properties.p2SenderDomain', 'type': 'str'},
        'receive_date': {'key': 'properties.receiveDate', 'type': 'iso-8601'},
        'network_message_id': {'key': 'properties.networkMessageId', 'type': 'str'},
        'internet_message_id': {'key': 'properties.internetMessageId', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'language': {'key': 'properties.language', 'type': 'str'},
        'threat_detection_methods': {'key': 'properties.threatDetectionMethods', 'type': '[str]'},
        'body_fingerprint_bin1': {'key': 'properties.bodyFingerprintBin1', 'type': 'int'},
        'body_fingerprint_bin2': {'key': 'properties.bodyFingerprintBin2', 'type': 'int'},
        'body_fingerprint_bin3': {'key': 'properties.bodyFingerprintBin3', 'type': 'int'},
        'body_fingerprint_bin4': {'key': 'properties.bodyFingerprintBin4', 'type': 'int'},
        'body_fingerprint_bin5': {'key': 'properties.bodyFingerprintBin5', 'type': 'int'},
        'antispam_direction': {'key': 'properties.antispamDirection', 'type': 'str'},
        'delivery_action': {'key': 'properties.deliveryAction', 'type': 'str'},
        'delivery_location': {'key': 'properties.deliveryLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        body_fingerprint_bin1: Optional[int] = None,
        body_fingerprint_bin2: Optional[int] = None,
        body_fingerprint_bin3: Optional[int] = None,
        body_fingerprint_bin4: Optional[int] = None,
        body_fingerprint_bin5: Optional[int] = None,
        antispam_direction: Optional[Union[str, "AntispamMailDirection"]] = None,
        delivery_action: Optional[Union[str, "DeliveryAction"]] = None,
        delivery_location: Optional[Union[str, "DeliveryLocation"]] = None,
        **kwargs
    ):
        """
        :keyword body_fingerprint_bin1: The bodyFingerprintBin1.
        :paramtype body_fingerprint_bin1: int
        :keyword body_fingerprint_bin2: The bodyFingerprintBin2.
        :paramtype body_fingerprint_bin2: int
        :keyword body_fingerprint_bin3: The bodyFingerprintBin3.
        :paramtype body_fingerprint_bin3: int
        :keyword body_fingerprint_bin4: The bodyFingerprintBin4.
        :paramtype body_fingerprint_bin4: int
        :keyword body_fingerprint_bin5: The bodyFingerprintBin5.
        :paramtype body_fingerprint_bin5: int
        :keyword antispam_direction: The directionality of this mail message. Possible values include:
         "Unknown", "Inbound", "Outbound", "Intraorg".
        :paramtype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
        :keyword delivery_action: The delivery action of this mail message like Delivered, Blocked,
         Replaced etc. Possible values include: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked",
         "Replaced".
        :paramtype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
        :keyword delivery_location: The delivery location of this mail message like Inbox, JunkFolder
         etc. Possible values include: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
         "External", "Failed", "Dropped", "Forwarded".
        :paramtype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
        """
        super(MailMessageEntity, self).__init__(**kwargs)
        self.kind = 'MailMessage'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.file_entity_ids = None
        self.recipient = None
        self.urls = None
        self.threats = None
        self.p1_sender = None
        self.p1_sender_display_name = None
        self.p1_sender_domain = None
        self.sender_ip = None
        self.p2_sender = None
        self.p2_sender_display_name = None
        self.p2_sender_domain = None
        self.receive_date = None
        self.network_message_id = None
        self.internet_message_id = None
        self.subject = None
        self.language = None
        self.threat_detection_methods = None
        self.body_fingerprint_bin1 = body_fingerprint_bin1
        self.body_fingerprint_bin2 = body_fingerprint_bin2
        self.body_fingerprint_bin3 = body_fingerprint_bin3
        self.body_fingerprint_bin4 = body_fingerprint_bin4
        self.body_fingerprint_bin5 = body_fingerprint_bin5
        self.antispam_direction = antispam_direction
        self.delivery_action = delivery_action
        self.delivery_location = delivery_location


class MailMessageEntityProperties(EntityCommonProperties):
    """Mail message entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar file_entity_ids: The File entity ids of this mail message's attachments.
    :vartype file_entity_ids: list[str]
    :ivar recipient: The recipient of this mail message. Note that in case of multiple recipients
     the mail message is forked and each copy has one recipient.
    :vartype recipient: str
    :ivar urls: The Urls contained in this mail message.
    :vartype urls: list[str]
    :ivar threats: The threats of this mail message.
    :vartype threats: list[str]
    :ivar p1_sender: The p1 sender's email address.
    :vartype p1_sender: str
    :ivar p1_sender_display_name: The p1 sender's display name.
    :vartype p1_sender_display_name: str
    :ivar p1_sender_domain: The p1 sender's domain.
    :vartype p1_sender_domain: str
    :ivar sender_ip: The sender's IP address.
    :vartype sender_ip: str
    :ivar p2_sender: The p2 sender's email address.
    :vartype p2_sender: str
    :ivar p2_sender_display_name: The p2 sender's display name.
    :vartype p2_sender_display_name: str
    :ivar p2_sender_domain: The p2 sender's domain.
    :vartype p2_sender_domain: str
    :ivar receive_date: The receive date of this message.
    :vartype receive_date: ~datetime.datetime
    :ivar network_message_id: The network message id of this mail message.
    :vartype network_message_id: str
    :ivar internet_message_id: The internet message id of this mail message.
    :vartype internet_message_id: str
    :ivar subject: The subject of this mail message.
    :vartype subject: str
    :ivar language: The language of this mail message.
    :vartype language: str
    :ivar threat_detection_methods: The threat detection methods.
    :vartype threat_detection_methods: list[str]
    :ivar body_fingerprint_bin1: The bodyFingerprintBin1.
    :vartype body_fingerprint_bin1: int
    :ivar body_fingerprint_bin2: The bodyFingerprintBin2.
    :vartype body_fingerprint_bin2: int
    :ivar body_fingerprint_bin3: The bodyFingerprintBin3.
    :vartype body_fingerprint_bin3: int
    :ivar body_fingerprint_bin4: The bodyFingerprintBin4.
    :vartype body_fingerprint_bin4: int
    :ivar body_fingerprint_bin5: The bodyFingerprintBin5.
    :vartype body_fingerprint_bin5: int
    :ivar antispam_direction: The directionality of this mail message. Possible values include:
     "Unknown", "Inbound", "Outbound", "Intraorg".
    :vartype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
    :ivar delivery_action: The delivery action of this mail message like Delivered, Blocked,
     Replaced etc. Possible values include: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked",
     "Replaced".
    :vartype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
    :ivar delivery_location: The delivery location of this mail message like Inbox, JunkFolder etc.
     Possible values include: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
     "External", "Failed", "Dropped", "Forwarded".
    :vartype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'file_entity_ids': {'readonly': True},
        'recipient': {'readonly': True},
        'urls': {'readonly': True},
        'threats': {'readonly': True},
        'p1_sender': {'readonly': True},
        'p1_sender_display_name': {'readonly': True},
        'p1_sender_domain': {'readonly': True},
        'sender_ip': {'readonly': True},
        'p2_sender': {'readonly': True},
        'p2_sender_display_name': {'readonly': True},
        'p2_sender_domain': {'readonly': True},
        'receive_date': {'readonly': True},
        'network_message_id': {'readonly': True},
        'internet_message_id': {'readonly': True},
        'subject': {'readonly': True},
        'language': {'readonly': True},
        'threat_detection_methods': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'file_entity_ids': {'key': 'fileEntityIds', 'type': '[str]'},
        'recipient': {'key': 'recipient', 'type': 'str'},
        'urls': {'key': 'urls', 'type': '[str]'},
        'threats': {'key': 'threats', 'type': '[str]'},
        'p1_sender': {'key': 'p1Sender', 'type': 'str'},
        'p1_sender_display_name': {'key': 'p1SenderDisplayName', 'type': 'str'},
        'p1_sender_domain': {'key': 'p1SenderDomain', 'type': 'str'},
        'sender_ip': {'key': 'senderIP', 'type': 'str'},
        'p2_sender': {'key': 'p2Sender', 'type': 'str'},
        'p2_sender_display_name': {'key': 'p2SenderDisplayName', 'type': 'str'},
        'p2_sender_domain': {'key': 'p2SenderDomain', 'type': 'str'},
        'receive_date': {'key': 'receiveDate', 'type': 'iso-8601'},
        'network_message_id': {'key': 'networkMessageId', 'type': 'str'},
        'internet_message_id': {'key': 'internetMessageId', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'threat_detection_methods': {'key': 'threatDetectionMethods', 'type': '[str]'},
        'body_fingerprint_bin1': {'key': 'bodyFingerprintBin1', 'type': 'int'},
        'body_fingerprint_bin2': {'key': 'bodyFingerprintBin2', 'type': 'int'},
        'body_fingerprint_bin3': {'key': 'bodyFingerprintBin3', 'type': 'int'},
        'body_fingerprint_bin4': {'key': 'bodyFingerprintBin4', 'type': 'int'},
        'body_fingerprint_bin5': {'key': 'bodyFingerprintBin5', 'type': 'int'},
        'antispam_direction': {'key': 'antispamDirection', 'type': 'str'},
        'delivery_action': {'key': 'deliveryAction', 'type': 'str'},
        'delivery_location': {'key': 'deliveryLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        body_fingerprint_bin1: Optional[int] = None,
        body_fingerprint_bin2: Optional[int] = None,
        body_fingerprint_bin3: Optional[int] = None,
        body_fingerprint_bin4: Optional[int] = None,
        body_fingerprint_bin5: Optional[int] = None,
        antispam_direction: Optional[Union[str, "AntispamMailDirection"]] = None,
        delivery_action: Optional[Union[str, "DeliveryAction"]] = None,
        delivery_location: Optional[Union[str, "DeliveryLocation"]] = None,
        **kwargs
    ):
        """
        :keyword body_fingerprint_bin1: The bodyFingerprintBin1.
        :paramtype body_fingerprint_bin1: int
        :keyword body_fingerprint_bin2: The bodyFingerprintBin2.
        :paramtype body_fingerprint_bin2: int
        :keyword body_fingerprint_bin3: The bodyFingerprintBin3.
        :paramtype body_fingerprint_bin3: int
        :keyword body_fingerprint_bin4: The bodyFingerprintBin4.
        :paramtype body_fingerprint_bin4: int
        :keyword body_fingerprint_bin5: The bodyFingerprintBin5.
        :paramtype body_fingerprint_bin5: int
        :keyword antispam_direction: The directionality of this mail message. Possible values include:
         "Unknown", "Inbound", "Outbound", "Intraorg".
        :paramtype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
        :keyword delivery_action: The delivery action of this mail message like Delivered, Blocked,
         Replaced etc. Possible values include: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked",
         "Replaced".
        :paramtype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
        :keyword delivery_location: The delivery location of this mail message like Inbox, JunkFolder
         etc. Possible values include: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
         "External", "Failed", "Dropped", "Forwarded".
        :paramtype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
        """
        super(MailMessageEntityProperties, self).__init__(**kwargs)
        self.file_entity_ids = None
        self.recipient = None
        self.urls = None
        self.threats = None
        self.p1_sender = None
        self.p1_sender_display_name = None
        self.p1_sender_domain = None
        self.sender_ip = None
        self.p2_sender = None
        self.p2_sender_display_name = None
        self.p2_sender_domain = None
        self.receive_date = None
        self.network_message_id = None
        self.internet_message_id = None
        self.subject = None
        self.language = None
        self.threat_detection_methods = None
        self.body_fingerprint_bin1 = body_fingerprint_bin1
        self.body_fingerprint_bin2 = body_fingerprint_bin2
        self.body_fingerprint_bin3 = body_fingerprint_bin3
        self.body_fingerprint_bin4 = body_fingerprint_bin4
        self.body_fingerprint_bin5 = body_fingerprint_bin5
        self.antispam_direction = antispam_direction
        self.delivery_action = delivery_action
        self.delivery_location = delivery_location


class MalwareEntity(Entity):
    """Represents a malware entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar category: The malware category by the vendor, e.g. Trojan.
    :vartype category: str
    :ivar file_entity_ids: List of linked file entity identifiers on which the malware was found.
    :vartype file_entity_ids: list[str]
    :ivar malware_name: The malware name by the vendor, e.g. Win32/Toga!rfn.
    :vartype malware_name: str
    :ivar process_entity_ids: List of linked process entity identifiers on which the malware was
     found.
    :vartype process_entity_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'category': {'readonly': True},
        'file_entity_ids': {'readonly': True},
        'malware_name': {'readonly': True},
        'process_entity_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'file_entity_ids': {'key': 'properties.fileEntityIds', 'type': '[str]'},
        'malware_name': {'key': 'properties.malwareName', 'type': 'str'},
        'process_entity_ids': {'key': 'properties.processEntityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MalwareEntity, self).__init__(**kwargs)
        self.kind = 'Malware'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.category = None
        self.file_entity_ids = None
        self.malware_name = None
        self.process_entity_ids = None


class MalwareEntityProperties(EntityCommonProperties):
    """Malware entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar category: The malware category by the vendor, e.g. Trojan.
    :vartype category: str
    :ivar file_entity_ids: List of linked file entity identifiers on which the malware was found.
    :vartype file_entity_ids: list[str]
    :ivar malware_name: The malware name by the vendor, e.g. Win32/Toga!rfn.
    :vartype malware_name: str
    :ivar process_entity_ids: List of linked process entity identifiers on which the malware was
     found.
    :vartype process_entity_ids: list[str]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'category': {'readonly': True},
        'file_entity_ids': {'readonly': True},
        'malware_name': {'readonly': True},
        'process_entity_ids': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'file_entity_ids': {'key': 'fileEntityIds', 'type': '[str]'},
        'malware_name': {'key': 'malwareName', 'type': 'str'},
        'process_entity_ids': {'key': 'processEntityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MalwareEntityProperties, self).__init__(**kwargs)
        self.category = None
        self.file_entity_ids = None
        self.malware_name = None
        self.process_entity_ids = None


class ManualTriggerRequestBody(msrest.serialization.Model):
    """ManualTriggerRequestBody.

    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar logic_apps_resource_id:
    :vartype logic_apps_resource_id: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'logic_apps_resource_id': {'key': 'logicAppsResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        logic_apps_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword logic_apps_resource_id:
        :paramtype logic_apps_resource_id: str
        """
        super(ManualTriggerRequestBody, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.logic_apps_resource_id = logic_apps_resource_id


class MCASCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MCAS (Microsoft Cloud App Security) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MCASCheckRequirements, self).__init__(**kwargs)
        self.kind = 'MicrosoftCloudAppSecurity'  # type: str
        self.tenant_id = tenant_id


class MCASCheckRequirementsProperties(DataConnectorTenantId):
    """MCAS (Microsoft Cloud App Security) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MCASCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class MCASDataConnector(DataConnector):
    """Represents MCAS (Microsoft Cloud App Security) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'MCASDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["MCASDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
        """
        super(MCASDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftCloudAppSecurity'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MCASDataConnectorDataTypes(AlertsDataTypeOfDataConnector):
    """The available data types for MCAS (Microsoft Cloud App Security) data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar alerts: Required. Alerts data type connection.
    :vartype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    :ivar discovery_logs: Discovery log data type connection.
    :vartype discovery_logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _validation = {
        'alerts': {'required': True},
    }

    _attribute_map = {
        'alerts': {'key': 'alerts', 'type': 'DataConnectorDataTypeCommon'},
        'discovery_logs': {'key': 'discoveryLogs', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        alerts: "DataConnectorDataTypeCommon",
        discovery_logs: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        """
        :keyword alerts: Required. Alerts data type connection.
        :paramtype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        :keyword discovery_logs: Discovery log data type connection.
        :paramtype discovery_logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        """
        super(MCASDataConnectorDataTypes, self).__init__(alerts=alerts, **kwargs)
        self.discovery_logs = discovery_logs


class MCASDataConnectorProperties(DataConnectorTenantId):
    """MCAS (Microsoft Cloud App Security) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'MCASDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "MCASDataConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
        """
        super(MCASDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class MDATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MDATP (Microsoft Defender Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MDATPCheckRequirements, self).__init__(**kwargs)
        self.kind = 'MicrosoftDefenderAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id


class MDATPCheckRequirementsProperties(DataConnectorTenantId):
    """MDATP (Microsoft Defender Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MDATPCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class MDATPDataConnector(DataConnector):
    """Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(MDATPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftDefenderAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MDATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MDATPDataConnectorProperties, self).__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class MetadataAuthor(msrest.serialization.Model):
    """Publisher or creator of the content item.

    :ivar name: Name of the author. Company or person.
    :vartype name: str
    :ivar email: Email of author contact.
    :vartype email: str
    :ivar link: Link for author/vendor page.
    :vartype link: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        email: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the author. Company or person.
        :paramtype name: str
        :keyword email: Email of author contact.
        :paramtype email: str
        :keyword link: Link for author/vendor page.
        :paramtype link: str
        """
        super(MetadataAuthor, self).__init__(**kwargs)
        self.name = name
        self.email = email
        self.link = link


class MetadataCategories(msrest.serialization.Model):
    """ies for the solution content item.

    :ivar domains: domain for the solution content item.
    :vartype domains: list[str]
    :ivar verticals: Industry verticals for the solution content item.
    :vartype verticals: list[str]
    """

    _attribute_map = {
        'domains': {'key': 'domains', 'type': '[str]'},
        'verticals': {'key': 'verticals', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        domains: Optional[List[str]] = None,
        verticals: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword domains: domain for the solution content item.
        :paramtype domains: list[str]
        :keyword verticals: Industry verticals for the solution content item.
        :paramtype verticals: list[str]
        """
        super(MetadataCategories, self).__init__(**kwargs)
        self.domains = domains
        self.verticals = verticals


class MetadataDependencies(msrest.serialization.Model):
    """Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.

    :ivar content_id: Id of the content item we depend on.
    :vartype content_id: str
    :ivar kind: Type of the content item we depend on. Possible values include: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar version: Version of the the content item we depend on.  Can be blank, * or missing to
     indicate any version fulfills the dependency.  If version does not match our defined numeric
     format then an exact match is required.
    :vartype version: str
    :ivar name: Name of the content item.
    :vartype name: str
    :ivar operator: Operator used for list of dependencies in criteria array. Possible values
     include: "AND", "OR".
    :vartype operator: str or ~azure.mgmt.securityinsight.models.Operator
    :ivar criteria: This is the list of dependencies we must fulfill, according to the AND/OR
     operator.
    :vartype criteria: list[~azure.mgmt.securityinsight.models.MetadataDependencies]
    """

    _attribute_map = {
        'content_id': {'key': 'contentId', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'criteria': {'key': 'criteria', 'type': '[MetadataDependencies]'},
    }

    def __init__(
        self,
        *,
        content_id: Optional[str] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        version: Optional[str] = None,
        name: Optional[str] = None,
        operator: Optional[Union[str, "Operator"]] = None,
        criteria: Optional[List["MetadataDependencies"]] = None,
        **kwargs
    ):
        """
        :keyword content_id: Id of the content item we depend on.
        :paramtype content_id: str
        :keyword kind: Type of the content item we depend on. Possible values include: "DataConnector",
         "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword version: Version of the the content item we depend on.  Can be blank, * or missing to
         indicate any version fulfills the dependency.  If version does not match our defined numeric
         format then an exact match is required.
        :paramtype version: str
        :keyword name: Name of the content item.
        :paramtype name: str
        :keyword operator: Operator used for list of dependencies in criteria array. Possible values
         include: "AND", "OR".
        :paramtype operator: str or ~azure.mgmt.securityinsight.models.Operator
        :keyword criteria: This is the list of dependencies we must fulfill, according to the AND/OR
         operator.
        :paramtype criteria: list[~azure.mgmt.securityinsight.models.MetadataDependencies]
        """
        super(MetadataDependencies, self).__init__(**kwargs)
        self.content_id = content_id
        self.kind = kind
        self.version = version
        self.name = name
        self.operator = operator
        self.criteria = criteria


class MetadataList(msrest.serialization.Model):
    """List of all the metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of metadata.
    :vartype value: list[~azure.mgmt.securityinsight.models.MetadataModel]
    :ivar next_link: URL to fetch the next page of metadata.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetadataModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["MetadataModel"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of metadata.
        :paramtype value: list[~azure.mgmt.securityinsight.models.MetadataModel]
        """
        super(MetadataList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MetadataModel(ResourceWithEtag):
    """Metadata resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar content_id: Static ID for the content.  Used to identify dependencies and content from
     solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
     for user-created.  This is the resource name.
    :vartype content_id: str
    :ivar parent_id: Full parent resource ID of the content item the metadata is for.  This is the
     full resource ID including the scope (subscription and resource group).
    :vartype parent_id: str
    :ivar version: Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0,
     1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we
     cannot guarantee any version checks.
    :vartype version: str
    :ivar kind: The kind of content the metadata is for. Possible values include: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar source: Source of the content.  This is where/how it was created.
    :vartype source: ~azure.mgmt.securityinsight.models.MetadataSource
    :ivar author: The creator of the content item.
    :vartype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
    :ivar support: Support information for the metadata - type, name, contact information.
    :vartype support: ~azure.mgmt.securityinsight.models.MetadataSupport
    :ivar dependencies: Dependencies for the content item, what other content items it requires to
     work.  Can describe more complex dependencies using a recursive/nested structure. For a single
     dependency an id/kind/version can be supplied or operator/criteria for complex formats.
    :vartype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
    :ivar categories: Categories for the solution content item.
    :vartype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
    :ivar providers: Providers for the solution content item.
    :vartype providers: list[str]
    :ivar first_publish_date: first publish date solution content item.
    :vartype first_publish_date: ~datetime.date
    :ivar last_publish_date: last publish date for the solution content item.
    :vartype last_publish_date: ~datetime.date
    :ivar custom_version: The custom version of the content. A optional free text.
    :vartype custom_version: str
    :ivar content_schema_version: Schema version of the content. Can be used to distinguish between
     different flow based on the schema version.
    :vartype content_schema_version: str
    :ivar icon: the icon identifier. this id can later be fetched from the solution template.
    :vartype icon: str
    :ivar threat_analysis_tactics: the tactics the resource covers.
    :vartype threat_analysis_tactics: list[str]
    :ivar threat_analysis_techniques: the techniques the resource covers, these have to be aligned
     with the tactics being used.
    :vartype threat_analysis_techniques: list[str]
    :ivar preview_images: preview image file names. These will be taken from the solution
     artifacts.
    :vartype preview_images: list[str]
    :ivar preview_images_dark: preview image file names. These will be taken from the solution
     artifacts. used for dark theme support.
    :vartype preview_images_dark: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'content_id': {'key': 'properties.contentId', 'type': 'str'},
        'parent_id': {'key': 'properties.parentId', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'kind': {'key': 'properties.kind', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'MetadataSource'},
        'author': {'key': 'properties.author', 'type': 'MetadataAuthor'},
        'support': {'key': 'properties.support', 'type': 'MetadataSupport'},
        'dependencies': {'key': 'properties.dependencies', 'type': 'MetadataDependencies'},
        'categories': {'key': 'properties.categories', 'type': 'MetadataCategories'},
        'providers': {'key': 'properties.providers', 'type': '[str]'},
        'first_publish_date': {'key': 'properties.firstPublishDate', 'type': 'date'},
        'last_publish_date': {'key': 'properties.lastPublishDate', 'type': 'date'},
        'custom_version': {'key': 'properties.customVersion', 'type': 'str'},
        'content_schema_version': {'key': 'properties.contentSchemaVersion', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'threat_analysis_tactics': {'key': 'properties.threatAnalysisTactics', 'type': '[str]'},
        'threat_analysis_techniques': {'key': 'properties.threatAnalysisTechniques', 'type': '[str]'},
        'preview_images': {'key': 'properties.previewImages', 'type': '[str]'},
        'preview_images_dark': {'key': 'properties.previewImagesDark', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        content_id: Optional[str] = None,
        parent_id: Optional[str] = None,
        version: Optional[str] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        source: Optional["MetadataSource"] = None,
        author: Optional["MetadataAuthor"] = None,
        support: Optional["MetadataSupport"] = None,
        dependencies: Optional["MetadataDependencies"] = None,
        categories: Optional["MetadataCategories"] = None,
        providers: Optional[List[str]] = None,
        first_publish_date: Optional[datetime.date] = None,
        last_publish_date: Optional[datetime.date] = None,
        custom_version: Optional[str] = None,
        content_schema_version: Optional[str] = None,
        icon: Optional[str] = None,
        threat_analysis_tactics: Optional[List[str]] = None,
        threat_analysis_techniques: Optional[List[str]] = None,
        preview_images: Optional[List[str]] = None,
        preview_images_dark: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword content_id: Static ID for the content.  Used to identify dependencies and content from
         solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
         for user-created.  This is the resource name.
        :paramtype content_id: str
        :keyword parent_id: Full parent resource ID of the content item the metadata is for.  This is
         the full resource ID including the scope (subscription and resource group).
        :paramtype parent_id: str
        :keyword version: Version of the content.  Default and recommended format is numeric (e.g. 1,
         1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then
         we cannot guarantee any version checks.
        :paramtype version: str
        :keyword kind: The kind of content the metadata is for. Possible values include:
         "DataConnector", "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword source: Source of the content.  This is where/how it was created.
        :paramtype source: ~azure.mgmt.securityinsight.models.MetadataSource
        :keyword author: The creator of the content item.
        :paramtype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
        :keyword support: Support information for the metadata - type, name, contact information.
        :paramtype support: ~azure.mgmt.securityinsight.models.MetadataSupport
        :keyword dependencies: Dependencies for the content item, what other content items it requires
         to work.  Can describe more complex dependencies using a recursive/nested structure. For a
         single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
        :paramtype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
        :keyword categories: Categories for the solution content item.
        :paramtype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
        :keyword providers: Providers for the solution content item.
        :paramtype providers: list[str]
        :keyword first_publish_date: first publish date solution content item.
        :paramtype first_publish_date: ~datetime.date
        :keyword last_publish_date: last publish date for the solution content item.
        :paramtype last_publish_date: ~datetime.date
        :keyword custom_version: The custom version of the content. A optional free text.
        :paramtype custom_version: str
        :keyword content_schema_version: Schema version of the content. Can be used to distinguish
         between different flow based on the schema version.
        :paramtype content_schema_version: str
        :keyword icon: the icon identifier. this id can later be fetched from the solution template.
        :paramtype icon: str
        :keyword threat_analysis_tactics: the tactics the resource covers.
        :paramtype threat_analysis_tactics: list[str]
        :keyword threat_analysis_techniques: the techniques the resource covers, these have to be
         aligned with the tactics being used.
        :paramtype threat_analysis_techniques: list[str]
        :keyword preview_images: preview image file names. These will be taken from the solution
         artifacts.
        :paramtype preview_images: list[str]
        :keyword preview_images_dark: preview image file names. These will be taken from the solution
         artifacts. used for dark theme support.
        :paramtype preview_images_dark: list[str]
        """
        super(MetadataModel, self).__init__(etag=etag, **kwargs)
        self.content_id = content_id
        self.parent_id = parent_id
        self.version = version
        self.kind = kind
        self.source = source
        self.author = author
        self.support = support
        self.dependencies = dependencies
        self.categories = categories
        self.providers = providers
        self.first_publish_date = first_publish_date
        self.last_publish_date = last_publish_date
        self.custom_version = custom_version
        self.content_schema_version = content_schema_version
        self.icon = icon
        self.threat_analysis_tactics = threat_analysis_tactics
        self.threat_analysis_techniques = threat_analysis_techniques
        self.preview_images = preview_images
        self.preview_images_dark = preview_images_dark


class MetadataPatch(ResourceWithEtag):
    """Metadata patch request body.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar content_id: Static ID for the content.  Used to identify dependencies and content from
     solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
     for user-created.  This is the resource name.
    :vartype content_id: str
    :ivar parent_id: Full parent resource ID of the content item the metadata is for.  This is the
     full resource ID including the scope (subscription and resource group).
    :vartype parent_id: str
    :ivar version: Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0,
     1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we
     cannot guarantee any version checks.
    :vartype version: str
    :ivar kind: The kind of content the metadata is for. Possible values include: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar source: Source of the content.  This is where/how it was created.
    :vartype source: ~azure.mgmt.securityinsight.models.MetadataSource
    :ivar author: The creator of the content item.
    :vartype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
    :ivar support: Support information for the metadata - type, name, contact information.
    :vartype support: ~azure.mgmt.securityinsight.models.MetadataSupport
    :ivar dependencies: Dependencies for the content item, what other content items it requires to
     work.  Can describe more complex dependencies using a recursive/nested structure. For a single
     dependency an id/kind/version can be supplied or operator/criteria for complex formats.
    :vartype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
    :ivar categories: Categories for the solution content item.
    :vartype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
    :ivar providers: Providers for the solution content item.
    :vartype providers: list[str]
    :ivar first_publish_date: first publish date solution content item.
    :vartype first_publish_date: ~datetime.date
    :ivar last_publish_date: last publish date for the solution content item.
    :vartype last_publish_date: ~datetime.date
    :ivar custom_version: The custom version of the content. A optional free text.
    :vartype custom_version: str
    :ivar content_schema_version: Schema version of the content. Can be used to distinguish between
     different flow based on the schema version.
    :vartype content_schema_version: str
    :ivar icon: the icon identifier. this id can later be fetched from the solution template.
    :vartype icon: str
    :ivar threat_analysis_tactics: the tactics the resource covers.
    :vartype threat_analysis_tactics: list[str]
    :ivar threat_analysis_techniques: the techniques the resource covers, these have to be aligned
     with the tactics being used.
    :vartype threat_analysis_techniques: list[str]
    :ivar preview_images: preview image file names. These will be taken from the solution
     artifacts.
    :vartype preview_images: list[str]
    :ivar preview_images_dark: preview image file names. These will be taken from the solution
     artifacts. used for dark theme support.
    :vartype preview_images_dark: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'content_id': {'key': 'properties.contentId', 'type': 'str'},
        'parent_id': {'key': 'properties.parentId', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'kind': {'key': 'properties.kind', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'MetadataSource'},
        'author': {'key': 'properties.author', 'type': 'MetadataAuthor'},
        'support': {'key': 'properties.support', 'type': 'MetadataSupport'},
        'dependencies': {'key': 'properties.dependencies', 'type': 'MetadataDependencies'},
        'categories': {'key': 'properties.categories', 'type': 'MetadataCategories'},
        'providers': {'key': 'properties.providers', 'type': '[str]'},
        'first_publish_date': {'key': 'properties.firstPublishDate', 'type': 'date'},
        'last_publish_date': {'key': 'properties.lastPublishDate', 'type': 'date'},
        'custom_version': {'key': 'properties.customVersion', 'type': 'str'},
        'content_schema_version': {'key': 'properties.contentSchemaVersion', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'threat_analysis_tactics': {'key': 'properties.threatAnalysisTactics', 'type': '[str]'},
        'threat_analysis_techniques': {'key': 'properties.threatAnalysisTechniques', 'type': '[str]'},
        'preview_images': {'key': 'properties.previewImages', 'type': '[str]'},
        'preview_images_dark': {'key': 'properties.previewImagesDark', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        content_id: Optional[str] = None,
        parent_id: Optional[str] = None,
        version: Optional[str] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        source: Optional["MetadataSource"] = None,
        author: Optional["MetadataAuthor"] = None,
        support: Optional["MetadataSupport"] = None,
        dependencies: Optional["MetadataDependencies"] = None,
        categories: Optional["MetadataCategories"] = None,
        providers: Optional[List[str]] = None,
        first_publish_date: Optional[datetime.date] = None,
        last_publish_date: Optional[datetime.date] = None,
        custom_version: Optional[str] = None,
        content_schema_version: Optional[str] = None,
        icon: Optional[str] = None,
        threat_analysis_tactics: Optional[List[str]] = None,
        threat_analysis_techniques: Optional[List[str]] = None,
        preview_images: Optional[List[str]] = None,
        preview_images_dark: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword content_id: Static ID for the content.  Used to identify dependencies and content from
         solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
         for user-created.  This is the resource name.
        :paramtype content_id: str
        :keyword parent_id: Full parent resource ID of the content item the metadata is for.  This is
         the full resource ID including the scope (subscription and resource group).
        :paramtype parent_id: str
        :keyword version: Version of the content.  Default and recommended format is numeric (e.g. 1,
         1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then
         we cannot guarantee any version checks.
        :paramtype version: str
        :keyword kind: The kind of content the metadata is for. Possible values include:
         "DataConnector", "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector",
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword source: Source of the content.  This is where/how it was created.
        :paramtype source: ~azure.mgmt.securityinsight.models.MetadataSource
        :keyword author: The creator of the content item.
        :paramtype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
        :keyword support: Support information for the metadata - type, name, contact information.
        :paramtype support: ~azure.mgmt.securityinsight.models.MetadataSupport
        :keyword dependencies: Dependencies for the content item, what other content items it requires
         to work.  Can describe more complex dependencies using a recursive/nested structure. For a
         single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
        :paramtype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
        :keyword categories: Categories for the solution content item.
        :paramtype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
        :keyword providers: Providers for the solution content item.
        :paramtype providers: list[str]
        :keyword first_publish_date: first publish date solution content item.
        :paramtype first_publish_date: ~datetime.date
        :keyword last_publish_date: last publish date for the solution content item.
        :paramtype last_publish_date: ~datetime.date
        :keyword custom_version: The custom version of the content. A optional free text.
        :paramtype custom_version: str
        :keyword content_schema_version: Schema version of the content. Can be used to distinguish
         between different flow based on the schema version.
        :paramtype content_schema_version: str
        :keyword icon: the icon identifier. this id can later be fetched from the solution template.
        :paramtype icon: str
        :keyword threat_analysis_tactics: the tactics the resource covers.
        :paramtype threat_analysis_tactics: list[str]
        :keyword threat_analysis_techniques: the techniques the resource covers, these have to be
         aligned with the tactics being used.
        :paramtype threat_analysis_techniques: list[str]
        :keyword preview_images: preview image file names. These will be taken from the solution
         artifacts.
        :paramtype preview_images: list[str]
        :keyword preview_images_dark: preview image file names. These will be taken from the solution
         artifacts. used for dark theme support.
        :paramtype preview_images_dark: list[str]
        """
        super(MetadataPatch, self).__init__(etag=etag, **kwargs)
        self.content_id = content_id
        self.parent_id = parent_id
        self.version = version
        self.kind = kind
        self.source = source
        self.author = author
        self.support = support
        self.dependencies = dependencies
        self.categories = categories
        self.providers = providers
        self.first_publish_date = first_publish_date
        self.last_publish_date = last_publish_date
        self.custom_version = custom_version
        self.content_schema_version = content_schema_version
        self.icon = icon
        self.threat_analysis_tactics = threat_analysis_tactics
        self.threat_analysis_techniques = threat_analysis_techniques
        self.preview_images = preview_images
        self.preview_images_dark = preview_images_dark


class MetadataSource(msrest.serialization.Model):
    """The original source of the content item, where it comes from.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Source type of the content. Possible values include: "LocalWorkspace",
     "Community", "Solution", "SourceRepository".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SourceKind
    :ivar name: Name of the content source.  The repo name, solution name, LA workspace name etc.
    :vartype name: str
    :ivar source_id: ID of the content source.  The solution ID, workspace ID, etc.
    :vartype source_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'source_id': {'key': 'sourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "SourceKind"],
        name: Optional[str] = None,
        source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Required. Source type of the content. Possible values include: "LocalWorkspace",
         "Community", "Solution", "SourceRepository".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.SourceKind
        :keyword name: Name of the content source.  The repo name, solution name, LA workspace name
         etc.
        :paramtype name: str
        :keyword source_id: ID of the content source.  The solution ID, workspace ID, etc.
        :paramtype source_id: str
        """
        super(MetadataSource, self).__init__(**kwargs)
        self.kind = kind
        self.name = name
        self.source_id = source_id


class MetadataSupport(msrest.serialization.Model):
    """Support information for the content item.

    All required parameters must be populated in order to send to Azure.

    :ivar tier: Required. Type of support for content item. Possible values include: "Microsoft",
     "Partner", "Community".
    :vartype tier: str or ~azure.mgmt.securityinsight.models.SupportTier
    :ivar name: Name of the support contact. Company or person.
    :vartype name: str
    :ivar email: Email of support contact.
    :vartype email: str
    :ivar link: Link for support help, like to support page to open a ticket etc.
    :vartype link: str
    """

    _validation = {
        'tier': {'required': True},
    }

    _attribute_map = {
        'tier': {'key': 'tier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tier: Union[str, "SupportTier"],
        name: Optional[str] = None,
        email: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tier: Required. Type of support for content item. Possible values include:
         "Microsoft", "Partner", "Community".
        :paramtype tier: str or ~azure.mgmt.securityinsight.models.SupportTier
        :keyword name: Name of the support contact. Company or person.
        :paramtype name: str
        :keyword email: Email of support contact.
        :paramtype email: str
        :keyword link: Link for support help, like to support page to open a ticket etc.
        :paramtype link: str
        """
        super(MetadataSupport, self).__init__(**kwargs)
        self.tier = tier
        self.name = name
        self.email = email
        self.link = link


class MicrosoftSecurityIncidentCreationAlertRule(AlertRule):
    """Represents MicrosoftSecurityIncidentCreation rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Possible
     values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_names_filter': {'key': 'properties.displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'properties.displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'properties.productFilter', 'type': 'str'},
        'severities_filter': {'key': 'properties.severitiesFilter', 'type': '[str]'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Possible
         values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super(MicrosoftSecurityIncidentCreationAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftSecurityIncidentCreation'  # type: str
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleCommonProperties(msrest.serialization.Model):
    """MicrosoftSecurityIncidentCreation rule common property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: Required. The alerts' productName on which the cases will be generated.
     Possible values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure
     Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
     Center for IoT", "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat
     Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'product_filter': {'required': True},
    }

    _attribute_map = {
        'display_names_filter': {'key': 'displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'productFilter', 'type': 'str'},
        'severities_filter': {'key': 'severitiesFilter', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "MicrosoftSecurityProductName"],
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: Required. The alerts' productName on which the cases will be
         generated. Possible values include: "Microsoft Cloud App Security", "Azure Security Center",
         "Azure Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure
         Security Center for IoT", "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced
         Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super(MicrosoftSecurityIncidentCreationAlertRuleCommonProperties, self).__init__(**kwargs)
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MicrosoftSecurityIncidentCreationAlertRuleProperties(MicrosoftSecurityIncidentCreationAlertRuleCommonProperties):
    """MicrosoftSecurityIncidentCreation rule property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: Required. The alerts' productName on which the cases will be generated.
     Possible values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure
     Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
     Center for IoT", "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat
     Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: Required. The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Required. Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        'product_filter': {'required': True},
        'display_name': {'required': True},
        'enabled': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'display_names_filter': {'key': 'displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'productFilter', 'type': 'str'},
        'severities_filter': {'key': 'severitiesFilter', 'type': '[str]'},
        'alert_rule_template_name': {'key': 'alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'lastModifiedUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "MicrosoftSecurityProductName"],
        display_name: str,
        enabled: bool,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: Required. The alerts' productName on which the cases will be
         generated. Possible values include: "Microsoft Cloud App Security", "Azure Security Center",
         "Azure Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure
         Security Center for IoT", "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced
         Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: Required. The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Required. Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super(MicrosoftSecurityIncidentCreationAlertRuleProperties, self).__init__(display_names_filter=display_names_filter, display_names_exclude_filter=display_names_exclude_filter, product_filter=product_filter, severities_filter=severities_filter, **kwargs)
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleTemplate(AlertRuleTemplate):
    """Represents MicrosoftSecurityIncidentCreation rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Possible
     values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'display_names_filter': {'key': 'properties.displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'properties.displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'properties.productFilter', 'type': 'str'},
        'severities_filter': {'key': 'properties.severitiesFilter', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Possible
         values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super(MicrosoftSecurityIncidentCreationAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'MicrosoftSecurityIncidentCreation'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties(AlertRuleTemplatePropertiesBase):
    """MicrosoftSecurityIncidentCreation rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Possible
     values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
        'display_names_filter': {'key': 'displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'productFilter', 'type': 'str'},
        'severities_filter': {'key': 'severitiesFilter', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Possible
         values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super(MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties, self).__init__(alert_rules_created_by_template_count=alert_rules_created_by_template_count, description=description, display_name=display_name, required_data_connectors=required_data_connectors, status=status, **kwargs)
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MLBehaviorAnalyticsAlertRule(AlertRule):
    """Represents MLBehaviorAnalytics alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'last_modified_utc': {'readonly': True},
        'severity': {'readonly': True},
        'tactics': {'readonly': True},
        'techniques': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super(MLBehaviorAnalyticsAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'MLBehaviorAnalytics'  # type: str
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class MLBehaviorAnalyticsAlertRuleTemplate(AlertRuleTemplate):
    """Represents MLBehaviorAnalytics alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(MLBehaviorAnalyticsAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'MLBehaviorAnalytics'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.severity = severity


class MLBehaviorAnalyticsAlertRuleTemplateProperties(AlertRuleTemplateWithMitreProperties):
    """MLBehaviorAnalytics alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: Required. The severity for alerts created by this alert rule. Possible values
     include: "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
        'severity': {'required': True},
    }

    _attribute_map = {
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "AlertSeverity"],
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: Required. The severity for alerts created by this alert rule. Possible
         values include: "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(MLBehaviorAnalyticsAlertRuleTemplateProperties, self).__init__(alert_rules_created_by_template_count=alert_rules_created_by_template_count, description=description, display_name=display_name, required_data_connectors=required_data_connectors, status=status, tactics=tactics, techniques=techniques, **kwargs)
        self.severity = severity


class MSTICheckRequirements(DataConnectorsCheckRequirements):
    """Represents Microsoft Threat Intelligence requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MSTICheckRequirements, self).__init__(**kwargs)
        self.kind = 'MicrosoftThreatIntelligence'  # type: str
        self.tenant_id = tenant_id


class MSTICheckRequirementsProperties(DataConnectorTenantId):
    """Microsoft Threat Intelligence requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MSTICheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class MSTIDataConnector(DataConnector):
    """Represents Microsoft Threat Intelligence data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'MSTIDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["MSTIDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
        """
        super(MSTIDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftThreatIntelligence'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MSTIDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar bing_safety_phishing_url: Required. Data type for Microsoft Threat Intelligence Platforms
     data connector.
    :vartype bing_safety_phishing_url:
     ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesBingSafetyPhishingURL
    :ivar microsoft_emerging_threat_feed: Required. Data type for Microsoft Threat Intelligence
     Platforms data connector.
    :vartype microsoft_emerging_threat_feed:
     ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed
    """

    _validation = {
        'bing_safety_phishing_url': {'required': True},
        'microsoft_emerging_threat_feed': {'required': True},
    }

    _attribute_map = {
        'bing_safety_phishing_url': {'key': 'bingSafetyPhishingURL', 'type': 'MSTIDataConnectorDataTypesBingSafetyPhishingURL'},
        'microsoft_emerging_threat_feed': {'key': 'microsoftEmergingThreatFeed', 'type': 'MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed'},
    }

    def __init__(
        self,
        *,
        bing_safety_phishing_url: "MSTIDataConnectorDataTypesBingSafetyPhishingURL",
        microsoft_emerging_threat_feed: "MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed",
        **kwargs
    ):
        """
        :keyword bing_safety_phishing_url: Required. Data type for Microsoft Threat Intelligence
         Platforms data connector.
        :paramtype bing_safety_phishing_url:
         ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesBingSafetyPhishingURL
        :keyword microsoft_emerging_threat_feed: Required. Data type for Microsoft Threat Intelligence
         Platforms data connector.
        :paramtype microsoft_emerging_threat_feed:
         ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed
        """
        super(MSTIDataConnectorDataTypes, self).__init__(**kwargs)
        self.bing_safety_phishing_url = bing_safety_phishing_url
        self.microsoft_emerging_threat_feed = microsoft_emerging_threat_feed


class MSTIDataConnectorDataTypesBingSafetyPhishingURL(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    :ivar lookback_period: Required. lookback period.
    :vartype lookback_period: str
    """

    _validation = {
        'state': {'required': True},
        'lookback_period': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'lookback_period': {'key': 'lookbackPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        lookback_period: str,
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        :keyword lookback_period: Required. lookback period.
        :paramtype lookback_period: str
        """
        super(MSTIDataConnectorDataTypesBingSafetyPhishingURL, self).__init__(state=state, **kwargs)
        self.lookback_period = lookback_period


class MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    :ivar lookback_period: Required. lookback period.
    :vartype lookback_period: str
    """

    _validation = {
        'state': {'required': True},
        'lookback_period': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'lookback_period': {'key': 'lookbackPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        lookback_period: str,
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        :keyword lookback_period: Required. lookback period.
        :paramtype lookback_period: str
        """
        super(MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed, self).__init__(state=state, **kwargs)
        self.lookback_period = lookback_period


class MSTIDataConnectorProperties(DataConnectorTenantId):
    """Microsoft Threat Intelligence data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'MSTIDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "MSTIDataConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
        """
        super(MSTIDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class MtpCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MTP (Microsoft Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MtpCheckRequirements, self).__init__(**kwargs)
        self.kind = 'MicrosoftThreatProtection'  # type: str
        self.tenant_id = tenant_id


class MTPCheckRequirementsProperties(DataConnectorTenantId):
    """MTP (Microsoft Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(MTPCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class MTPDataConnector(DataConnector):
    """Represents MTP (Microsoft Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'MTPDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["MTPDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
        """
        super(MTPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftThreatProtection'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MTPDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Microsoft Threat Protection Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar incidents: Required. Data type for Microsoft Threat Protection Platforms data connector.
    :vartype incidents: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypesIncidents
    """

    _validation = {
        'incidents': {'required': True},
    }

    _attribute_map = {
        'incidents': {'key': 'incidents', 'type': 'MTPDataConnectorDataTypesIncidents'},
    }

    def __init__(
        self,
        *,
        incidents: "MTPDataConnectorDataTypesIncidents",
        **kwargs
    ):
        """
        :keyword incidents: Required. Data type for Microsoft Threat Protection Platforms data
         connector.
        :paramtype incidents: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypesIncidents
        """
        super(MTPDataConnectorDataTypes, self).__init__(**kwargs)
        self.incidents = incidents


class MTPDataConnectorDataTypesIncidents(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Protection Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(MTPDataConnectorDataTypesIncidents, self).__init__(state=state, **kwargs)


class MTPDataConnectorProperties(DataConnectorTenantId):
    """MTP (Microsoft Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'MTPDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "MTPDataConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
        """
        super(MTPDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class NrtAlertRule(AlertRule):
    """Represents NRT alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Determines whether the suppression for this alert rule is enabled or
     disabled.
    :vartype suppression_enabled: bool
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'template_version': {'key': 'properties.templateVersion', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'suppression_duration': {'key': 'properties.suppressionDuration', 'type': 'duration'},
        'suppression_enabled': {'key': 'properties.suppressionEnabled', 'type': 'bool'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'incident_configuration': {'key': 'properties.incidentConfiguration', 'type': 'IncidentConfiguration'},
        'custom_details': {'key': 'properties.customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'properties.entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'properties.alertDetailsOverride', 'type': 'AlertDetailsOverride'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        query: Optional[str] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        suppression_duration: Optional[datetime.timedelta] = None,
        suppression_enabled: Optional[bool] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        incident_configuration: Optional["IncidentConfiguration"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
         time this alert rule been triggered.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Determines whether the suppression for this alert rule is enabled
         or disabled.
        :paramtype suppression_enabled: bool
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        """
        super(NrtAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'NRT'  # type: str
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.query = query
        self.tactics = tactics
        self.techniques = techniques
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.severity = severity
        self.incident_configuration = incident_configuration
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override


class NrtAlertRuleTemplate(AlertRuleTemplate):
    """Represents NRT alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'custom_details': {'key': 'properties.customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'properties.entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'properties.alertDetailsOverride', 'type': 'AlertDetailsOverride'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        query: Optional[str] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        """
        super(NrtAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'NRT'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override


class QueryBasedAlertRuleTemplateProperties(msrest.serialization.Model):
    """Query based alert rule template base property bag.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'custom_details': {'key': 'customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'alertDetailsOverride', 'type': 'AlertDetailsOverride'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        """
        super(QueryBasedAlertRuleTemplateProperties, self).__init__(**kwargs)
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override


class NrtAlertRuleTemplateProperties(AlertRuleTemplateWithMitreProperties, QueryBasedAlertRuleTemplateProperties):
    """NRT alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'custom_details': {'key': 'customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'alertDetailsOverride', 'type': 'AlertDetailsOverride'},
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        """
        super(NrtAlertRuleTemplateProperties, self).__init__(alert_rules_created_by_template_count=alert_rules_created_by_template_count, description=description, display_name=display_name, required_data_connectors=required_data_connectors, status=status, tactics=tactics, techniques=techniques, query=query, severity=severity, version=version, custom_details=custom_details, entity_mappings=entity_mappings, alert_details_override=alert_details_override, **kwargs)
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques


class Office365ProjectCheckRequirements(DataConnectorsCheckRequirements):
    """Represents Office365 Project requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(Office365ProjectCheckRequirements, self).__init__(**kwargs)
        self.kind = 'Office365Project'  # type: str
        self.tenant_id = tenant_id


class Office365ProjectCheckRequirementsProperties(DataConnectorTenantId):
    """Office365 Project requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(Office365ProjectCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class Office365ProjectConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Office Microsoft Project data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Required. Logs data type.
    :vartype logs: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypesLogs
    """

    _validation = {
        'logs': {'required': True},
    }

    _attribute_map = {
        'logs': {'key': 'logs', 'type': 'Office365ProjectConnectorDataTypesLogs'},
    }

    def __init__(
        self,
        *,
        logs: "Office365ProjectConnectorDataTypesLogs",
        **kwargs
    ):
        """
        :keyword logs: Required. Logs data type.
        :paramtype logs: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypesLogs
        """
        super(Office365ProjectConnectorDataTypes, self).__init__(**kwargs)
        self.logs = logs


class Office365ProjectConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(Office365ProjectConnectorDataTypesLogs, self).__init__(state=state, **kwargs)


class Office365ProjectDataConnector(DataConnector):
    """Represents Office Microsoft Project data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'Office365ProjectConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["Office365ProjectConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
        """
        super(Office365ProjectDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'Office365Project'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class Office365ProjectDataConnectorProperties(DataConnectorTenantId):
    """Office Microsoft Project data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'Office365ProjectConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "Office365ProjectConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
        """
        super(Office365ProjectDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class OfficeATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents OfficeATP (Office 365 Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeATPCheckRequirements, self).__init__(**kwargs)
        self.kind = 'OfficeATP'  # type: str
        self.tenant_id = tenant_id


class OfficeATPCheckRequirementsProperties(DataConnectorTenantId):
    """OfficeATP (Office 365 Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeATPCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class OfficeATPDataConnector(DataConnector):
    """Represents OfficeATP (Office 365 Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(OfficeATPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'OfficeATP'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """OfficeATP (Office 365 Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeATPDataConnectorProperties, self).__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class OfficeConsent(Resource):
    """Consent for Office365 tenant that already made.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar tenant_id: The tenantId of the Office365 with the consent.
    :vartype tenant_id: str
    :ivar consent_id: Help to easily cascade among the data layers.
    :vartype consent_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'consent_id': {'key': 'properties.consentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        consent_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenantId of the Office365 with the consent.
        :paramtype tenant_id: str
        :keyword consent_id: Help to easily cascade among the data layers.
        :paramtype consent_id: str
        """
        super(OfficeConsent, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.consent_id = consent_id


class OfficeConsentList(msrest.serialization.Model):
    """List of all the office365 consents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of office consents.
    :vartype next_link: str
    :ivar value: Required. Array of the consents.
    :vartype value: list[~azure.mgmt.securityinsight.models.OfficeConsent]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OfficeConsent]'},
    }

    def __init__(
        self,
        *,
        value: List["OfficeConsent"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of the consents.
        :paramtype value: list[~azure.mgmt.securityinsight.models.OfficeConsent]
        """
        super(OfficeConsentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class OfficeDataConnector(DataConnector):
    """Represents office data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'OfficeDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["OfficeDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
        """
        super(OfficeDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'Office365'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for office data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar exchange: Required. Exchange data type connection.
    :vartype exchange: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesExchange
    :ivar share_point: Required. SharePoint data type connection.
    :vartype share_point: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesSharePoint
    :ivar teams: Required. Teams data type connection.
    :vartype teams: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesTeams
    """

    _validation = {
        'exchange': {'required': True},
        'share_point': {'required': True},
        'teams': {'required': True},
    }

    _attribute_map = {
        'exchange': {'key': 'exchange', 'type': 'OfficeDataConnectorDataTypesExchange'},
        'share_point': {'key': 'sharePoint', 'type': 'OfficeDataConnectorDataTypesSharePoint'},
        'teams': {'key': 'teams', 'type': 'OfficeDataConnectorDataTypesTeams'},
    }

    def __init__(
        self,
        *,
        exchange: "OfficeDataConnectorDataTypesExchange",
        share_point: "OfficeDataConnectorDataTypesSharePoint",
        teams: "OfficeDataConnectorDataTypesTeams",
        **kwargs
    ):
        """
        :keyword exchange: Required. Exchange data type connection.
        :paramtype exchange: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesExchange
        :keyword share_point: Required. SharePoint data type connection.
        :paramtype share_point:
         ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesSharePoint
        :keyword teams: Required. Teams data type connection.
        :paramtype teams: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesTeams
        """
        super(OfficeDataConnectorDataTypes, self).__init__(**kwargs)
        self.exchange = exchange
        self.share_point = share_point
        self.teams = teams


class OfficeDataConnectorDataTypesExchange(DataConnectorDataTypeCommon):
    """Exchange data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(OfficeDataConnectorDataTypesExchange, self).__init__(state=state, **kwargs)


class OfficeDataConnectorDataTypesSharePoint(DataConnectorDataTypeCommon):
    """SharePoint data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(OfficeDataConnectorDataTypesSharePoint, self).__init__(state=state, **kwargs)


class OfficeDataConnectorDataTypesTeams(DataConnectorDataTypeCommon):
    """Teams data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(OfficeDataConnectorDataTypesTeams, self).__init__(state=state, **kwargs)


class OfficeDataConnectorProperties(DataConnectorTenantId):
    """Office data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'OfficeDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "OfficeDataConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
        """
        super(OfficeDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class OfficeIRMCheckRequirements(DataConnectorsCheckRequirements):
    """Represents OfficeIRM (Microsoft Insider Risk Management) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeIRMCheckRequirements, self).__init__(**kwargs)
        self.kind = 'OfficeIRM'  # type: str
        self.tenant_id = tenant_id


class OfficeIRMCheckRequirementsProperties(DataConnectorTenantId):
    """OfficeIRM (Microsoft Insider Risk Management) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeIRMCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class OfficeIRMDataConnector(DataConnector):
    """Represents OfficeIRM (Microsoft Insider Risk Management) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super(OfficeIRMDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'OfficeIRM'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeIRMDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """OfficeIRM (Microsoft Insider Risk Management) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficeIRMDataConnectorProperties, self).__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class OfficePowerBICheckRequirements(DataConnectorsCheckRequirements):
    """Represents Office PowerBI requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficePowerBICheckRequirements, self).__init__(**kwargs)
        self.kind = 'OfficePowerBI'  # type: str
        self.tenant_id = tenant_id


class OfficePowerBICheckRequirementsProperties(DataConnectorTenantId):
    """Office PowerBI requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(OfficePowerBICheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class OfficePowerBIConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Office Microsoft PowerBI data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Required. Logs data type.
    :vartype logs: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypesLogs
    """

    _validation = {
        'logs': {'required': True},
    }

    _attribute_map = {
        'logs': {'key': 'logs', 'type': 'OfficePowerBIConnectorDataTypesLogs'},
    }

    def __init__(
        self,
        *,
        logs: "OfficePowerBIConnectorDataTypesLogs",
        **kwargs
    ):
        """
        :keyword logs: Required. Logs data type.
        :paramtype logs: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypesLogs
        """
        super(OfficePowerBIConnectorDataTypes, self).__init__(**kwargs)
        self.logs = logs


class OfficePowerBIConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(OfficePowerBIConnectorDataTypesLogs, self).__init__(state=state, **kwargs)


class OfficePowerBIDataConnector(DataConnector):
    """Represents Office Microsoft PowerBI data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'OfficePowerBIConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["OfficePowerBIConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
        """
        super(OfficePowerBIDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'OfficePowerBI'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficePowerBIDataConnectorProperties(DataConnectorTenantId):
    """Office Microsoft PowerBI data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'OfficePowerBIConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "OfficePowerBIConnectorDataTypes",
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
        """
        super(OfficePowerBIDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class Operation(msrest.serialization.Model):
    """Operation provided by provider.

    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.securityinsight.models.OperationDisplay
    :ivar name: Name of the operation.
    :vartype name: str
    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.securityinsight.models.OperationDisplay
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword origin: The origin of the operation.
        :paramtype origin: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super(Operation, self).__init__(**kwargs)
        self.display = display
        self.name = name
        self.origin = origin
        self.is_data_action = is_data_action


class OperationDisplay(msrest.serialization.Model):
    """Properties of the operation.

    :ivar description: Description of the operation.
    :vartype description: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the operation.
        :paramtype description: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationsList(msrest.serialization.Model):
    """Lists the operations available in the SecurityInsights RP.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of operations.
    :vartype next_link: str
    :ivar value: Required. Array of operations.
    :vartype value: list[~azure.mgmt.securityinsight.models.Operation]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: List["Operation"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of operations.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Operation]
        """
        super(OperationsList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class Permissions(msrest.serialization.Model):
    """Permissions required for the connector.

    :ivar resource_provider: Resource provider permissions required for the connector.
    :vartype resource_provider:
     list[~azure.mgmt.securityinsight.models.PermissionsResourceProviderItem]
    :ivar customs: Customs permissions required for the connector.
    :vartype customs: list[~azure.mgmt.securityinsight.models.PermissionsCustomsItem]
    """

    _attribute_map = {
        'resource_provider': {'key': 'resourceProvider', 'type': '[PermissionsResourceProviderItem]'},
        'customs': {'key': 'customs', 'type': '[PermissionsCustomsItem]'},
    }

    def __init__(
        self,
        *,
        resource_provider: Optional[List["PermissionsResourceProviderItem"]] = None,
        customs: Optional[List["PermissionsCustomsItem"]] = None,
        **kwargs
    ):
        """
        :keyword resource_provider: Resource provider permissions required for the connector.
        :paramtype resource_provider:
         list[~azure.mgmt.securityinsight.models.PermissionsResourceProviderItem]
        :keyword customs: Customs permissions required for the connector.
        :paramtype customs: list[~azure.mgmt.securityinsight.models.PermissionsCustomsItem]
        """
        super(Permissions, self).__init__(**kwargs)
        self.resource_provider = resource_provider
        self.customs = customs


class PermissionsCustomsItem(Customs):
    """PermissionsCustomsItem.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super(PermissionsCustomsItem, self).__init__(name=name, description=description, **kwargs)


class ResourceProvider(msrest.serialization.Model):
    """Resource provider permissions required for the connector.

    :ivar provider: Provider name. Possible values include:
     "Microsoft.OperationalInsights/solutions", "Microsoft.OperationalInsights/workspaces",
     "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
     "Microsoft.OperationalInsights/workspaces/sharedKeys",
     "Microsoft.Authorization/policyAssignments".
    :vartype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
    :ivar permissions_display_text: Permission description text.
    :vartype permissions_display_text: str
    :ivar provider_display_name: Permission provider display name.
    :vartype provider_display_name: str
    :ivar scope: Permission provider scope. Possible values include: "ResourceGroup",
     "Subscription", "Workspace".
    :vartype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
    :ivar required_permissions: Required permissions for the connector.
    :vartype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'permissions_display_text': {'key': 'permissionsDisplayText', 'type': 'str'},
        'provider_display_name': {'key': 'providerDisplayName', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'required_permissions': {'key': 'requiredPermissions', 'type': 'RequiredPermissions'},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "ProviderName"]] = None,
        permissions_display_text: Optional[str] = None,
        provider_display_name: Optional[str] = None,
        scope: Optional[Union[str, "PermissionProviderScope"]] = None,
        required_permissions: Optional["RequiredPermissions"] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name. Possible values include:
         "Microsoft.OperationalInsights/solutions", "Microsoft.OperationalInsights/workspaces",
         "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
         "Microsoft.OperationalInsights/workspaces/sharedKeys",
         "Microsoft.Authorization/policyAssignments".
        :paramtype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
        :keyword permissions_display_text: Permission description text.
        :paramtype permissions_display_text: str
        :keyword provider_display_name: Permission provider display name.
        :paramtype provider_display_name: str
        :keyword scope: Permission provider scope. Possible values include: "ResourceGroup",
         "Subscription", "Workspace".
        :paramtype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
        :keyword required_permissions: Required permissions for the connector.
        :paramtype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
        """
        super(ResourceProvider, self).__init__(**kwargs)
        self.provider = provider
        self.permissions_display_text = permissions_display_text
        self.provider_display_name = provider_display_name
        self.scope = scope
        self.required_permissions = required_permissions


class PermissionsResourceProviderItem(ResourceProvider):
    """PermissionsResourceProviderItem.

    :ivar provider: Provider name. Possible values include:
     "Microsoft.OperationalInsights/solutions", "Microsoft.OperationalInsights/workspaces",
     "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
     "Microsoft.OperationalInsights/workspaces/sharedKeys",
     "Microsoft.Authorization/policyAssignments".
    :vartype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
    :ivar permissions_display_text: Permission description text.
    :vartype permissions_display_text: str
    :ivar provider_display_name: Permission provider display name.
    :vartype provider_display_name: str
    :ivar scope: Permission provider scope. Possible values include: "ResourceGroup",
     "Subscription", "Workspace".
    :vartype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
    :ivar required_permissions: Required permissions for the connector.
    :vartype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'permissions_display_text': {'key': 'permissionsDisplayText', 'type': 'str'},
        'provider_display_name': {'key': 'providerDisplayName', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'required_permissions': {'key': 'requiredPermissions', 'type': 'RequiredPermissions'},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "ProviderName"]] = None,
        permissions_display_text: Optional[str] = None,
        provider_display_name: Optional[str] = None,
        scope: Optional[Union[str, "PermissionProviderScope"]] = None,
        required_permissions: Optional["RequiredPermissions"] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name. Possible values include:
         "Microsoft.OperationalInsights/solutions", "Microsoft.OperationalInsights/workspaces",
         "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
         "Microsoft.OperationalInsights/workspaces/sharedKeys",
         "Microsoft.Authorization/policyAssignments".
        :paramtype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
        :keyword permissions_display_text: Permission description text.
        :paramtype permissions_display_text: str
        :keyword provider_display_name: Permission provider display name.
        :paramtype provider_display_name: str
        :keyword scope: Permission provider scope. Possible values include: "ResourceGroup",
         "Subscription", "Workspace".
        :paramtype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
        :keyword required_permissions: Required permissions for the connector.
        :paramtype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
        """
        super(PermissionsResourceProviderItem, self).__init__(provider=provider, permissions_display_text=permissions_display_text, provider_display_name=provider_display_name, scope=scope, required_permissions=required_permissions, **kwargs)


class PlaybookActionProperties(msrest.serialization.Model):
    """PlaybookActionProperties.

    :ivar logic_app_resource_id: The resource id of the playbook resource.
    :vartype logic_app_resource_id: str
    :ivar tenant_id: The tenant id of the playbook resource.
    :vartype tenant_id: str
    """

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword logic_app_resource_id: The resource id of the playbook resource.
        :paramtype logic_app_resource_id: str
        :keyword tenant_id: The tenant id of the playbook resource.
        :paramtype tenant_id: str
        """
        super(PlaybookActionProperties, self).__init__(**kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.tenant_id = tenant_id


class ProcessEntity(Entity):
    """Represents a process entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar account_entity_id: The account entity id running the processes.
    :vartype account_entity_id: str
    :ivar command_line: The command line used to create the process.
    :vartype command_line: str
    :ivar creation_time_utc: The time when the process started to run.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar elevation_token: The elevation token associated with the process. Possible values
     include: "Default", "Full", "Limited".
    :vartype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
    :ivar host_entity_id: The host entity id on which the process was running.
    :vartype host_entity_id: str
    :ivar host_logon_session_entity_id: The session entity id in which the process was running.
    :vartype host_logon_session_entity_id: str
    :ivar image_file_entity_id: Image file entity id.
    :vartype image_file_entity_id: str
    :ivar parent_process_entity_id: The parent process entity id.
    :vartype parent_process_entity_id: str
    :ivar process_id: The process ID.
    :vartype process_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'account_entity_id': {'readonly': True},
        'command_line': {'readonly': True},
        'creation_time_utc': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'host_logon_session_entity_id': {'readonly': True},
        'image_file_entity_id': {'readonly': True},
        'parent_process_entity_id': {'readonly': True},
        'process_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'account_entity_id': {'key': 'properties.accountEntityId', 'type': 'str'},
        'command_line': {'key': 'properties.commandLine', 'type': 'str'},
        'creation_time_utc': {'key': 'properties.creationTimeUtc', 'type': 'iso-8601'},
        'elevation_token': {'key': 'properties.elevationToken', 'type': 'str'},
        'host_entity_id': {'key': 'properties.hostEntityId', 'type': 'str'},
        'host_logon_session_entity_id': {'key': 'properties.hostLogonSessionEntityId', 'type': 'str'},
        'image_file_entity_id': {'key': 'properties.imageFileEntityId', 'type': 'str'},
        'parent_process_entity_id': {'key': 'properties.parentProcessEntityId', 'type': 'str'},
        'process_id': {'key': 'properties.processId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        elevation_token: Optional[Union[str, "ElevationToken"]] = None,
        **kwargs
    ):
        """
        :keyword elevation_token: The elevation token associated with the process. Possible values
         include: "Default", "Full", "Limited".
        :paramtype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
        """
        super(ProcessEntity, self).__init__(**kwargs)
        self.kind = 'Process'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.account_entity_id = None
        self.command_line = None
        self.creation_time_utc = None
        self.elevation_token = elevation_token
        self.host_entity_id = None
        self.host_logon_session_entity_id = None
        self.image_file_entity_id = None
        self.parent_process_entity_id = None
        self.process_id = None


class ProcessEntityProperties(EntityCommonProperties):
    """Process entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar account_entity_id: The account entity id running the processes.
    :vartype account_entity_id: str
    :ivar command_line: The command line used to create the process.
    :vartype command_line: str
    :ivar creation_time_utc: The time when the process started to run.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar elevation_token: The elevation token associated with the process. Possible values
     include: "Default", "Full", "Limited".
    :vartype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
    :ivar host_entity_id: The host entity id on which the process was running.
    :vartype host_entity_id: str
    :ivar host_logon_session_entity_id: The session entity id in which the process was running.
    :vartype host_logon_session_entity_id: str
    :ivar image_file_entity_id: Image file entity id.
    :vartype image_file_entity_id: str
    :ivar parent_process_entity_id: The parent process entity id.
    :vartype parent_process_entity_id: str
    :ivar process_id: The process ID.
    :vartype process_id: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'account_entity_id': {'readonly': True},
        'command_line': {'readonly': True},
        'creation_time_utc': {'readonly': True},
        'host_entity_id': {'readonly': True},
        'host_logon_session_entity_id': {'readonly': True},
        'image_file_entity_id': {'readonly': True},
        'parent_process_entity_id': {'readonly': True},
        'process_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'account_entity_id': {'key': 'accountEntityId', 'type': 'str'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'creation_time_utc': {'key': 'creationTimeUtc', 'type': 'iso-8601'},
        'elevation_token': {'key': 'elevationToken', 'type': 'str'},
        'host_entity_id': {'key': 'hostEntityId', 'type': 'str'},
        'host_logon_session_entity_id': {'key': 'hostLogonSessionEntityId', 'type': 'str'},
        'image_file_entity_id': {'key': 'imageFileEntityId', 'type': 'str'},
        'parent_process_entity_id': {'key': 'parentProcessEntityId', 'type': 'str'},
        'process_id': {'key': 'processId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        elevation_token: Optional[Union[str, "ElevationToken"]] = None,
        **kwargs
    ):
        """
        :keyword elevation_token: The elevation token associated with the process. Possible values
         include: "Default", "Full", "Limited".
        :paramtype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
        """
        super(ProcessEntityProperties, self).__init__(**kwargs)
        self.account_entity_id = None
        self.command_line = None
        self.creation_time_utc = None
        self.elevation_token = elevation_token
        self.host_entity_id = None
        self.host_logon_session_entity_id = None
        self.image_file_entity_id = None
        self.parent_process_entity_id = None
        self.process_id = None


class PropertyConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that evaluates a property's value.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Constant filled by server. Possible values include: "Property".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesCondition
    """

    _validation = {
        'condition_type': {'required': True},
    }

    _attribute_map = {
        'condition_type': {'key': 'conditionType', 'type': 'str'},
        'condition_properties': {'key': 'conditionProperties', 'type': 'AutomationRulePropertyValuesCondition'},
    }

    def __init__(
        self,
        *,
        condition_properties: Optional["AutomationRulePropertyValuesCondition"] = None,
        **kwargs
    ):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesCondition
        """
        super(PropertyConditionProperties, self).__init__(**kwargs)
        self.condition_type = 'Property'  # type: str
        self.condition_properties = condition_properties


class RegistryKeyEntity(Entity):
    """Represents a registry key entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar hive: the hive that holds the registry key. Possible values include:
     "HKEY_LOCAL_MACHINE", "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_USERS",
     "HKEY_CURRENT_USER_LOCAL_SETTINGS", "HKEY_PERFORMANCE_DATA", "HKEY_PERFORMANCE_NLSTEXT",
     "HKEY_PERFORMANCE_TEXT", "HKEY_A", "HKEY_CURRENT_USER".
    :vartype hive: str or ~azure.mgmt.securityinsight.models.RegistryHive
    :ivar key: The registry key path.
    :vartype key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'hive': {'readonly': True},
        'key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'hive': {'key': 'properties.hive', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryKeyEntity, self).__init__(**kwargs)
        self.kind = 'RegistryKey'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.hive = None
        self.key = None


class RegistryKeyEntityProperties(EntityCommonProperties):
    """RegistryKey entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar hive: the hive that holds the registry key. Possible values include:
     "HKEY_LOCAL_MACHINE", "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_USERS",
     "HKEY_CURRENT_USER_LOCAL_SETTINGS", "HKEY_PERFORMANCE_DATA", "HKEY_PERFORMANCE_NLSTEXT",
     "HKEY_PERFORMANCE_TEXT", "HKEY_A", "HKEY_CURRENT_USER".
    :vartype hive: str or ~azure.mgmt.securityinsight.models.RegistryHive
    :ivar key: The registry key path.
    :vartype key: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'hive': {'readonly': True},
        'key': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'hive': {'key': 'hive', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryKeyEntityProperties, self).__init__(**kwargs)
        self.hive = None
        self.key = None


class RegistryValueEntity(Entity):
    """Represents a registry value entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar key_entity_id: The registry key entity id.
    :vartype key_entity_id: str
    :ivar value_data: String formatted representation of the value data.
    :vartype value_data: str
    :ivar value_name: The registry value name.
    :vartype value_name: str
    :ivar value_type: Specifies the data types to use when storing values in the registry, or
     identifies the data type of a value in the registry. Possible values include: "None",
     "Unknown", "String", "ExpandString", "Binary", "DWord", "MultiString", "QWord".
    :vartype value_type: str or ~azure.mgmt.securityinsight.models.RegistryValueKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'key_entity_id': {'readonly': True},
        'value_data': {'readonly': True},
        'value_name': {'readonly': True},
        'value_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'key_entity_id': {'key': 'properties.keyEntityId', 'type': 'str'},
        'value_data': {'key': 'properties.valueData', 'type': 'str'},
        'value_name': {'key': 'properties.valueName', 'type': 'str'},
        'value_type': {'key': 'properties.valueType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryValueEntity, self).__init__(**kwargs)
        self.kind = 'RegistryValue'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.key_entity_id = None
        self.value_data = None
        self.value_name = None
        self.value_type = None


class RegistryValueEntityProperties(EntityCommonProperties):
    """RegistryValue entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar key_entity_id: The registry key entity id.
    :vartype key_entity_id: str
    :ivar value_data: String formatted representation of the value data.
    :vartype value_data: str
    :ivar value_name: The registry value name.
    :vartype value_name: str
    :ivar value_type: Specifies the data types to use when storing values in the registry, or
     identifies the data type of a value in the registry. Possible values include: "None",
     "Unknown", "String", "ExpandString", "Binary", "DWord", "MultiString", "QWord".
    :vartype value_type: str or ~azure.mgmt.securityinsight.models.RegistryValueKind
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'key_entity_id': {'readonly': True},
        'value_data': {'readonly': True},
        'value_name': {'readonly': True},
        'value_type': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'key_entity_id': {'key': 'keyEntityId', 'type': 'str'},
        'value_data': {'key': 'valueData', 'type': 'str'},
        'value_name': {'key': 'valueName', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryValueEntityProperties, self).__init__(**kwargs)
        self.key_entity_id = None
        self.value_data = None
        self.value_name = None
        self.value_type = None


class Relation(ResourceWithEtag):
    """Represents a relation between two resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar related_resource_id: The resource ID of the related resource.
    :vartype related_resource_id: str
    :ivar related_resource_name: The name of the related resource.
    :vartype related_resource_name: str
    :ivar related_resource_type: The resource type of the related resource.
    :vartype related_resource_type: str
    :ivar related_resource_kind: The resource kind of the related resource.
    :vartype related_resource_kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'related_resource_name': {'readonly': True},
        'related_resource_type': {'readonly': True},
        'related_resource_kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'related_resource_id': {'key': 'properties.relatedResourceId', 'type': 'str'},
        'related_resource_name': {'key': 'properties.relatedResourceName', 'type': 'str'},
        'related_resource_type': {'key': 'properties.relatedResourceType', 'type': 'str'},
        'related_resource_kind': {'key': 'properties.relatedResourceKind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        related_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword related_resource_id: The resource ID of the related resource.
        :paramtype related_resource_id: str
        """
        super(Relation, self).__init__(etag=etag, **kwargs)
        self.related_resource_id = related_resource_id
        self.related_resource_name = None
        self.related_resource_type = None
        self.related_resource_kind = None


class RelationList(msrest.serialization.Model):
    """List of relations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of relations.
    :vartype next_link: str
    :ivar value: Required. Array of relations.
    :vartype value: list[~azure.mgmt.securityinsight.models.Relation]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Relation]'},
    }

    def __init__(
        self,
        *,
        value: List["Relation"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of relations.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Relation]
        """
        super(RelationList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class Repo(msrest.serialization.Model):
    """Represents a repository.

    :ivar url: The url to access the repository.
    :vartype url: str
    :ivar full_name: The name of the repository.
    :vartype full_name: str
    :ivar branches: Array of branches.
    :vartype branches: list[str]
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'full_name': {'key': 'fullName', 'type': 'str'},
        'branches': {'key': 'branches', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        full_name: Optional[str] = None,
        branches: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword url: The url to access the repository.
        :paramtype url: str
        :keyword full_name: The name of the repository.
        :paramtype full_name: str
        :keyword branches: Array of branches.
        :paramtype branches: list[str]
        """
        super(Repo, self).__init__(**kwargs)
        self.url = url
        self.full_name = full_name
        self.branches = branches


class RepoList(msrest.serialization.Model):
    """List all the source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of repositories.
    :vartype next_link: str
    :ivar value: Required. Array of repositories.
    :vartype value: list[~azure.mgmt.securityinsight.models.Repo]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Repo]'},
    }

    def __init__(
        self,
        *,
        value: List["Repo"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of repositories.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Repo]
        """
        super(RepoList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class Repository(msrest.serialization.Model):
    """metadata of a repository.

    :ivar url: Url of repository.
    :vartype url: str
    :ivar branch: Branch name of repository.
    :vartype branch: str
    :ivar display_url: Display url of repository.
    :vartype display_url: str
    :ivar deployment_logs_url: Url to access repository action logs.
    :vartype deployment_logs_url: str
    :ivar path_mapping: Dictionary of source control content type and path mapping.
    :vartype path_mapping: list[~azure.mgmt.securityinsight.models.ContentPathMap]
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'display_url': {'key': 'displayUrl', 'type': 'str'},
        'deployment_logs_url': {'key': 'deploymentLogsUrl', 'type': 'str'},
        'path_mapping': {'key': 'pathMapping', 'type': '[ContentPathMap]'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        branch: Optional[str] = None,
        display_url: Optional[str] = None,
        deployment_logs_url: Optional[str] = None,
        path_mapping: Optional[List["ContentPathMap"]] = None,
        **kwargs
    ):
        """
        :keyword url: Url of repository.
        :paramtype url: str
        :keyword branch: Branch name of repository.
        :paramtype branch: str
        :keyword display_url: Display url of repository.
        :paramtype display_url: str
        :keyword deployment_logs_url: Url to access repository action logs.
        :paramtype deployment_logs_url: str
        :keyword path_mapping: Dictionary of source control content type and path mapping.
        :paramtype path_mapping: list[~azure.mgmt.securityinsight.models.ContentPathMap]
        """
        super(Repository, self).__init__(**kwargs)
        self.url = url
        self.branch = branch
        self.display_url = display_url
        self.deployment_logs_url = deployment_logs_url
        self.path_mapping = path_mapping


class RepositoryResourceInfo(msrest.serialization.Model):
    """Resources created in user's repository for the source-control.

    :ivar webhook: The webhook object created for the source-control.
    :vartype webhook: ~azure.mgmt.securityinsight.models.Webhook
    :ivar git_hub_resource_info: Resources created in GitHub for this source-control.
    :vartype git_hub_resource_info: ~azure.mgmt.securityinsight.models.GitHubResourceInfo
    :ivar azure_dev_ops_resource_info: Resources created in Azure DevOps for this source-control.
    :vartype azure_dev_ops_resource_info:
     ~azure.mgmt.securityinsight.models.AzureDevOpsResourceInfo
    """

    _attribute_map = {
        'webhook': {'key': 'webhook', 'type': 'Webhook'},
        'git_hub_resource_info': {'key': 'gitHubResourceInfo', 'type': 'GitHubResourceInfo'},
        'azure_dev_ops_resource_info': {'key': 'azureDevOpsResourceInfo', 'type': 'AzureDevOpsResourceInfo'},
    }

    def __init__(
        self,
        *,
        webhook: Optional["Webhook"] = None,
        git_hub_resource_info: Optional["GitHubResourceInfo"] = None,
        azure_dev_ops_resource_info: Optional["AzureDevOpsResourceInfo"] = None,
        **kwargs
    ):
        """
        :keyword webhook: The webhook object created for the source-control.
        :paramtype webhook: ~azure.mgmt.securityinsight.models.Webhook
        :keyword git_hub_resource_info: Resources created in GitHub for this source-control.
        :paramtype git_hub_resource_info: ~azure.mgmt.securityinsight.models.GitHubResourceInfo
        :keyword azure_dev_ops_resource_info: Resources created in Azure DevOps for this
         source-control.
        :paramtype azure_dev_ops_resource_info:
         ~azure.mgmt.securityinsight.models.AzureDevOpsResourceInfo
        """
        super(RepositoryResourceInfo, self).__init__(**kwargs)
        self.webhook = webhook
        self.git_hub_resource_info = git_hub_resource_info
        self.azure_dev_ops_resource_info = azure_dev_ops_resource_info


class RequiredPermissions(msrest.serialization.Model):
    """Required permissions for the connector.

    :ivar action: action permission.
    :vartype action: bool
    :ivar write: write permission.
    :vartype write: bool
    :ivar read: read permission.
    :vartype read: bool
    :ivar delete: delete permission.
    :vartype delete: bool
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'bool'},
        'write': {'key': 'write', 'type': 'bool'},
        'read': {'key': 'read', 'type': 'bool'},
        'delete': {'key': 'delete', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        action: Optional[bool] = None,
        write: Optional[bool] = None,
        read: Optional[bool] = None,
        delete: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword action: action permission.
        :paramtype action: bool
        :keyword write: write permission.
        :paramtype write: bool
        :keyword read: read permission.
        :paramtype read: bool
        :keyword delete: delete permission.
        :paramtype delete: bool
        """
        super(RequiredPermissions, self).__init__(**kwargs)
        self.action = action
        self.write = write
        self.read = read
        self.delete = delete


class ScheduledAlertRule(AlertRule):
    """Represents scheduled alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Determines whether the suppression for this alert rule is enabled or
     disabled.
    :vartype suppression_enabled: bool
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_frequency': {'key': 'properties.queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'properties.queryPeriod', 'type': 'duration'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'trigger_operator': {'key': 'properties.triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'properties.triggerThreshold', 'type': 'int'},
        'event_grouping_settings': {'key': 'properties.eventGroupingSettings', 'type': 'EventGroupingSettings'},
        'custom_details': {'key': 'properties.customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'properties.entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'properties.alertDetailsOverride', 'type': 'AlertDetailsOverride'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'template_version': {'key': 'properties.templateVersion', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'suppression_duration': {'key': 'properties.suppressionDuration', 'type': 'duration'},
        'suppression_enabled': {'key': 'properties.suppressionEnabled', 'type': 'bool'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'incident_configuration': {'key': 'properties.incidentConfiguration', 'type': 'IncidentConfiguration'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        suppression_duration: Optional[datetime.timedelta] = None,
        suppression_enabled: Optional[bool] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        incident_configuration: Optional["IncidentConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule.
         Possible values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
         time this alert rule been triggered.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Determines whether the suppression for this alert rule is enabled
         or disabled.
        :paramtype suppression_enabled: bool
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        """
        super(ScheduledAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'Scheduled'  # type: str
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics
        self.techniques = techniques
        self.incident_configuration = incident_configuration


class ScheduledAlertRuleCommonProperties(msrest.serialization.Model):
    """Scheduled alert rule template property bag.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_frequency': {'key': 'queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'queryPeriod', 'type': 'duration'},
        'severity': {'key': 'severity', 'type': 'str'},
        'trigger_operator': {'key': 'triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'triggerThreshold', 'type': 'int'},
        'event_grouping_settings': {'key': 'eventGroupingSettings', 'type': 'EventGroupingSettings'},
        'custom_details': {'key': 'customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'alertDetailsOverride', 'type': 'AlertDetailsOverride'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule.
         Possible values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        """
        super(ScheduledAlertRuleCommonProperties, self).__init__(**kwargs)
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override


class ScheduledAlertRuleProperties(ScheduledAlertRuleCommonProperties):
    """Scheduled alert rule base property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: Required. The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Required. Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: Required. The suppression (in ISO 8601 duration format) to wait
     since last time this alert rule been triggered.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Required. Determines whether the suppression for this alert rule is
     enabled or disabled.
    :vartype suppression_enabled: bool
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    """

    _validation = {
        'display_name': {'required': True},
        'enabled': {'required': True},
        'last_modified_utc': {'readonly': True},
        'suppression_duration': {'required': True},
        'suppression_enabled': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_frequency': {'key': 'queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'queryPeriod', 'type': 'duration'},
        'severity': {'key': 'severity', 'type': 'str'},
        'trigger_operator': {'key': 'triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'triggerThreshold', 'type': 'int'},
        'event_grouping_settings': {'key': 'eventGroupingSettings', 'type': 'EventGroupingSettings'},
        'custom_details': {'key': 'customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'alertDetailsOverride', 'type': 'AlertDetailsOverride'},
        'alert_rule_template_name': {'key': 'alertRuleTemplateName', 'type': 'str'},
        'template_version': {'key': 'templateVersion', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'lastModifiedUtc', 'type': 'iso-8601'},
        'suppression_duration': {'key': 'suppressionDuration', 'type': 'duration'},
        'suppression_enabled': {'key': 'suppressionEnabled', 'type': 'bool'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
        'incident_configuration': {'key': 'incidentConfiguration', 'type': 'IncidentConfiguration'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        enabled: bool,
        suppression_duration: datetime.timedelta,
        suppression_enabled: bool,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        incident_configuration: Optional["IncidentConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule.
         Possible values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: Required. The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Required. Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword suppression_duration: Required. The suppression (in ISO 8601 duration format) to wait
         since last time this alert rule been triggered.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Required. Determines whether the suppression for this alert rule
         is enabled or disabled.
        :paramtype suppression_enabled: bool
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        """
        super(ScheduledAlertRuleProperties, self).__init__(query=query, query_frequency=query_frequency, query_period=query_period, severity=severity, trigger_operator=trigger_operator, trigger_threshold=trigger_threshold, event_grouping_settings=event_grouping_settings, custom_details=custom_details, entity_mappings=entity_mappings, alert_details_override=alert_details_override, **kwargs)
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics
        self.techniques = techniques
        self.incident_configuration = incident_configuration


class ScheduledAlertRuleTemplate(AlertRuleTemplate):
    """Represents scheduled alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar last_updated_date_utc: The time that this alert rule template was last updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data connectors for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar tactics: The tactics of the alert rule template.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'created_date_utc': {'readonly': True},
        'last_updated_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_frequency': {'key': 'properties.queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'properties.queryPeriod', 'type': 'duration'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'trigger_operator': {'key': 'properties.triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'properties.triggerThreshold', 'type': 'int'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'event_grouping_settings': {'key': 'properties.eventGroupingSettings', 'type': 'EventGroupingSettings'},
        'custom_details': {'key': 'properties.customDetails', 'type': '{str}'},
        'entity_mappings': {'key': 'properties.entityMappings', 'type': '[EntityMapping]'},
        'alert_details_override': {'key': 'properties.alertDetailsOverride', 'type': 'AlertDetailsOverride'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        version: Optional[str] = None,
        event_grouping_settings: Optional["EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["EntityMapping"]] = None,
        alert_details_override: Optional["AlertDetailsOverride"] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data connectors for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule.
         Possible values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword tactics: The tactics of the alert rule template.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        """
        super(ScheduledAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'Scheduled'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.last_updated_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.tactics = tactics
        self.techniques = techniques
        self.version = version
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override


class SecurityAlert(Entity):
    """Represents a security alert entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar alert_display_name: The display name of the alert.
    :vartype alert_display_name: str
    :ivar alert_type: The type name of the alert.
    :vartype alert_type: str
    :ivar compromised_entity: Display name of the main entity being reported on.
    :vartype compromised_entity: str
    :ivar confidence_level: The confidence level of this alert. Possible values include: "Unknown",
     "Low", "High".
    :vartype confidence_level: str or ~azure.mgmt.securityinsight.models.ConfidenceLevel
    :ivar confidence_reasons: The confidence reasons.
    :vartype confidence_reasons:
     list[~azure.mgmt.securityinsight.models.SecurityAlertPropertiesConfidenceReasonsItem]
    :ivar confidence_score: The confidence score of the alert.
    :vartype confidence_score: float
    :ivar confidence_score_status: The confidence score calculation status, i.e. indicating if
     score calculation is pending for this alert, not applicable or final. Possible values include:
     "NotApplicable", "InProcess", "NotFinal", "Final".
    :vartype confidence_score_status: str or
     ~azure.mgmt.securityinsight.models.ConfidenceScoreStatus
    :ivar description: Alert description.
    :vartype description: str
    :ivar end_time_utc: The impact end time of the alert (the time of the last event contributing
     to the alert).
    :vartype end_time_utc: ~datetime.datetime
    :ivar intent: Holds the alert intent stage(s) mapping for this alert. Possible values include:
     "Unknown", "Probing", "Exploitation", "Persistence", "PrivilegeEscalation", "DefenseEvasion",
     "CredentialAccess", "Discovery", "LateralMovement", "Execution", "Collection", "Exfiltration",
     "CommandAndControl", "Impact".
    :vartype intent: str or ~azure.mgmt.securityinsight.models.KillChainIntent
    :ivar provider_alert_id: The identifier of the alert inside the product which generated the
     alert.
    :vartype provider_alert_id: str
    :ivar processing_end_time: The time the alert was made available for consumption.
    :vartype processing_end_time: ~datetime.datetime
    :ivar product_component_name: The name of a component inside the product which generated the
     alert.
    :vartype product_component_name: str
    :ivar product_name: The name of the product which published this alert.
    :vartype product_name: str
    :ivar product_version: The version of the product generating the alert.
    :vartype product_version: str
    :ivar remediation_steps: Manual action items to take to remediate the alert.
    :vartype remediation_steps: list[str]
    :ivar severity: The severity of the alert. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar start_time_utc: The impact start time of the alert (the time of the first event
     contributing to the alert).
    :vartype start_time_utc: ~datetime.datetime
    :ivar status: The lifecycle status of the alert. Possible values include: "Unknown", "New",
     "Resolved", "Dismissed", "InProgress".
    :vartype status: str or ~azure.mgmt.securityinsight.models.AlertStatus
    :ivar system_alert_id: Holds the product identifier of the alert for the product.
    :vartype system_alert_id: str
    :ivar tactics: The tactics of the alert.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar time_generated: The time the alert was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar vendor_name: The name of the vendor that raise the alert.
    :vartype vendor_name: str
    :ivar alert_link: The uri link of the alert.
    :vartype alert_link: str
    :ivar resource_identifiers: The list of resource identifiers of the alert.
    :vartype resource_identifiers: list[any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'alert_type': {'readonly': True},
        'compromised_entity': {'readonly': True},
        'confidence_level': {'readonly': True},
        'confidence_reasons': {'readonly': True},
        'confidence_score': {'readonly': True},
        'confidence_score_status': {'readonly': True},
        'description': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'intent': {'readonly': True},
        'provider_alert_id': {'readonly': True},
        'processing_end_time': {'readonly': True},
        'product_component_name': {'readonly': True},
        'product_name': {'readonly': True},
        'product_version': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'status': {'readonly': True},
        'system_alert_id': {'readonly': True},
        'tactics': {'readonly': True},
        'time_generated': {'readonly': True},
        'vendor_name': {'readonly': True},
        'alert_link': {'readonly': True},
        'resource_identifiers': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'alert_display_name': {'key': 'properties.alertDisplayName', 'type': 'str'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'compromised_entity': {'key': 'properties.compromisedEntity', 'type': 'str'},
        'confidence_level': {'key': 'properties.confidenceLevel', 'type': 'str'},
        'confidence_reasons': {'key': 'properties.confidenceReasons', 'type': '[SecurityAlertPropertiesConfidenceReasonsItem]'},
        'confidence_score': {'key': 'properties.confidenceScore', 'type': 'float'},
        'confidence_score_status': {'key': 'properties.confidenceScoreStatus', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'end_time_utc': {'key': 'properties.endTimeUtc', 'type': 'iso-8601'},
        'intent': {'key': 'properties.intent', 'type': 'str'},
        'provider_alert_id': {'key': 'properties.providerAlertId', 'type': 'str'},
        'processing_end_time': {'key': 'properties.processingEndTime', 'type': 'iso-8601'},
        'product_component_name': {'key': 'properties.productComponentName', 'type': 'str'},
        'product_name': {'key': 'properties.productName', 'type': 'str'},
        'product_version': {'key': 'properties.productVersion', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'start_time_utc': {'key': 'properties.startTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'system_alert_id': {'key': 'properties.systemAlertId', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'time_generated': {'key': 'properties.timeGenerated', 'type': 'iso-8601'},
        'vendor_name': {'key': 'properties.vendorName', 'type': 'str'},
        'alert_link': {'key': 'properties.alertLink', 'type': 'str'},
        'resource_identifiers': {'key': 'properties.resourceIdentifiers', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword severity: The severity of the alert. Possible values include: "High", "Medium", "Low",
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(SecurityAlert, self).__init__(**kwargs)
        self.kind = 'SecurityAlert'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.alert_display_name = None
        self.alert_type = None
        self.compromised_entity = None
        self.confidence_level = None
        self.confidence_reasons = None
        self.confidence_score = None
        self.confidence_score_status = None
        self.description = None
        self.end_time_utc = None
        self.intent = None
        self.provider_alert_id = None
        self.processing_end_time = None
        self.product_component_name = None
        self.product_name = None
        self.product_version = None
        self.remediation_steps = None
        self.severity = severity
        self.start_time_utc = None
        self.status = None
        self.system_alert_id = None
        self.tactics = None
        self.time_generated = None
        self.vendor_name = None
        self.alert_link = None
        self.resource_identifiers = None


class SecurityAlertProperties(EntityCommonProperties):
    """SecurityAlert entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar alert_display_name: The display name of the alert.
    :vartype alert_display_name: str
    :ivar alert_type: The type name of the alert.
    :vartype alert_type: str
    :ivar compromised_entity: Display name of the main entity being reported on.
    :vartype compromised_entity: str
    :ivar confidence_level: The confidence level of this alert. Possible values include: "Unknown",
     "Low", "High".
    :vartype confidence_level: str or ~azure.mgmt.securityinsight.models.ConfidenceLevel
    :ivar confidence_reasons: The confidence reasons.
    :vartype confidence_reasons:
     list[~azure.mgmt.securityinsight.models.SecurityAlertPropertiesConfidenceReasonsItem]
    :ivar confidence_score: The confidence score of the alert.
    :vartype confidence_score: float
    :ivar confidence_score_status: The confidence score calculation status, i.e. indicating if
     score calculation is pending for this alert, not applicable or final. Possible values include:
     "NotApplicable", "InProcess", "NotFinal", "Final".
    :vartype confidence_score_status: str or
     ~azure.mgmt.securityinsight.models.ConfidenceScoreStatus
    :ivar description: Alert description.
    :vartype description: str
    :ivar end_time_utc: The impact end time of the alert (the time of the last event contributing
     to the alert).
    :vartype end_time_utc: ~datetime.datetime
    :ivar intent: Holds the alert intent stage(s) mapping for this alert. Possible values include:
     "Unknown", "Probing", "Exploitation", "Persistence", "PrivilegeEscalation", "DefenseEvasion",
     "CredentialAccess", "Discovery", "LateralMovement", "Execution", "Collection", "Exfiltration",
     "CommandAndControl", "Impact".
    :vartype intent: str or ~azure.mgmt.securityinsight.models.KillChainIntent
    :ivar provider_alert_id: The identifier of the alert inside the product which generated the
     alert.
    :vartype provider_alert_id: str
    :ivar processing_end_time: The time the alert was made available for consumption.
    :vartype processing_end_time: ~datetime.datetime
    :ivar product_component_name: The name of a component inside the product which generated the
     alert.
    :vartype product_component_name: str
    :ivar product_name: The name of the product which published this alert.
    :vartype product_name: str
    :ivar product_version: The version of the product generating the alert.
    :vartype product_version: str
    :ivar remediation_steps: Manual action items to take to remediate the alert.
    :vartype remediation_steps: list[str]
    :ivar severity: The severity of the alert. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar start_time_utc: The impact start time of the alert (the time of the first event
     contributing to the alert).
    :vartype start_time_utc: ~datetime.datetime
    :ivar status: The lifecycle status of the alert. Possible values include: "Unknown", "New",
     "Resolved", "Dismissed", "InProgress".
    :vartype status: str or ~azure.mgmt.securityinsight.models.AlertStatus
    :ivar system_alert_id: Holds the product identifier of the alert for the product.
    :vartype system_alert_id: str
    :ivar tactics: The tactics of the alert.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar time_generated: The time the alert was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar vendor_name: The name of the vendor that raise the alert.
    :vartype vendor_name: str
    :ivar alert_link: The uri link of the alert.
    :vartype alert_link: str
    :ivar resource_identifiers: The list of resource identifiers of the alert.
    :vartype resource_identifiers: list[any]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'alert_type': {'readonly': True},
        'compromised_entity': {'readonly': True},
        'confidence_level': {'readonly': True},
        'confidence_reasons': {'readonly': True},
        'confidence_score': {'readonly': True},
        'confidence_score_status': {'readonly': True},
        'description': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'intent': {'readonly': True},
        'provider_alert_id': {'readonly': True},
        'processing_end_time': {'readonly': True},
        'product_component_name': {'readonly': True},
        'product_name': {'readonly': True},
        'product_version': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'status': {'readonly': True},
        'system_alert_id': {'readonly': True},
        'tactics': {'readonly': True},
        'time_generated': {'readonly': True},
        'vendor_name': {'readonly': True},
        'alert_link': {'readonly': True},
        'resource_identifiers': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'alert_display_name': {'key': 'alertDisplayName', 'type': 'str'},
        'alert_type': {'key': 'alertType', 'type': 'str'},
        'compromised_entity': {'key': 'compromisedEntity', 'type': 'str'},
        'confidence_level': {'key': 'confidenceLevel', 'type': 'str'},
        'confidence_reasons': {'key': 'confidenceReasons', 'type': '[SecurityAlertPropertiesConfidenceReasonsItem]'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'confidence_score_status': {'key': 'confidenceScoreStatus', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'intent': {'key': 'intent', 'type': 'str'},
        'provider_alert_id': {'key': 'providerAlertId', 'type': 'str'},
        'processing_end_time': {'key': 'processingEndTime', 'type': 'iso-8601'},
        'product_component_name': {'key': 'productComponentName', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'product_version': {'key': 'productVersion', 'type': 'str'},
        'remediation_steps': {'key': 'remediationSteps', 'type': '[str]'},
        'severity': {'key': 'severity', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'system_alert_id': {'key': 'systemAlertId', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'time_generated': {'key': 'timeGenerated', 'type': 'iso-8601'},
        'vendor_name': {'key': 'vendorName', 'type': 'str'},
        'alert_link': {'key': 'alertLink', 'type': 'str'},
        'resource_identifiers': {'key': 'resourceIdentifiers', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword severity: The severity of the alert. Possible values include: "High", "Medium", "Low",
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(SecurityAlertProperties, self).__init__(**kwargs)
        self.alert_display_name = None
        self.alert_type = None
        self.compromised_entity = None
        self.confidence_level = None
        self.confidence_reasons = None
        self.confidence_score = None
        self.confidence_score_status = None
        self.description = None
        self.end_time_utc = None
        self.intent = None
        self.provider_alert_id = None
        self.processing_end_time = None
        self.product_component_name = None
        self.product_name = None
        self.product_version = None
        self.remediation_steps = None
        self.severity = severity
        self.start_time_utc = None
        self.status = None
        self.system_alert_id = None
        self.tactics = None
        self.time_generated = None
        self.vendor_name = None
        self.alert_link = None
        self.resource_identifiers = None


class SecurityAlertPropertiesConfidenceReasonsItem(msrest.serialization.Model):
    """confidence reason item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar reason: The reason's description.
    :vartype reason: str
    :ivar reason_type: The type (category) of the reason.
    :vartype reason_type: str
    """

    _validation = {
        'reason': {'readonly': True},
        'reason_type': {'readonly': True},
    }

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecurityAlertPropertiesConfidenceReasonsItem, self).__init__(**kwargs)
        self.reason = None
        self.reason_type = None


class SecurityAlertTimelineItem(EntityTimelineItem):
    """Represents security alert timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. The entity query kind type.Constant filled by server. Possible values
     include: "Activity", "Bookmark", "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar azure_resource_id: Required. The alert azure resource id.
    :vartype azure_resource_id: str
    :ivar product_name: The alert product name.
    :vartype product_name: str
    :ivar description: The alert description.
    :vartype description: str
    :ivar display_name: Required. The alert name.
    :vartype display_name: str
    :ivar severity: Required. The alert severity. Possible values include: "High", "Medium", "Low",
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar end_time_utc: Required. The alert end time.
    :vartype end_time_utc: ~datetime.datetime
    :ivar start_time_utc: Required. The alert start time.
    :vartype start_time_utc: ~datetime.datetime
    :ivar time_generated: Required. The alert generated time.
    :vartype time_generated: ~datetime.datetime
    :ivar alert_type: Required. The name of the alert type.
    :vartype alert_type: str
    """

    _validation = {
        'kind': {'required': True},
        'azure_resource_id': {'required': True},
        'display_name': {'required': True},
        'severity': {'required': True},
        'end_time_utc': {'required': True},
        'start_time_utc': {'required': True},
        'time_generated': {'required': True},
        'alert_type': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'azure_resource_id': {'key': 'azureResourceId', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'time_generated': {'key': 'timeGenerated', 'type': 'iso-8601'},
        'alert_type': {'key': 'alertType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_resource_id: str,
        display_name: str,
        severity: Union[str, "AlertSeverity"],
        end_time_utc: datetime.datetime,
        start_time_utc: datetime.datetime,
        time_generated: datetime.datetime,
        alert_type: str,
        product_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword azure_resource_id: Required. The alert azure resource id.
        :paramtype azure_resource_id: str
        :keyword product_name: The alert product name.
        :paramtype product_name: str
        :keyword description: The alert description.
        :paramtype description: str
        :keyword display_name: Required. The alert name.
        :paramtype display_name: str
        :keyword severity: Required. The alert severity. Possible values include: "High", "Medium",
         "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword end_time_utc: Required. The alert end time.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword start_time_utc: Required. The alert start time.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword time_generated: Required. The alert generated time.
        :paramtype time_generated: ~datetime.datetime
        :keyword alert_type: Required. The name of the alert type.
        :paramtype alert_type: str
        """
        super(SecurityAlertTimelineItem, self).__init__(**kwargs)
        self.kind = 'SecurityAlert'  # type: str
        self.azure_resource_id = azure_resource_id
        self.product_name = product_name
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.end_time_utc = end_time_utc
        self.start_time_utc = start_time_utc
        self.time_generated = time_generated
        self.alert_type = alert_type


class SecurityGroupEntity(Entity):
    """Represents a security group entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar distinguished_name: The group distinguished name.
    :vartype distinguished_name: str
    :ivar object_guid: A single-value attribute that is the unique identifier for the object,
     assigned by active directory.
    :vartype object_guid: str
    :ivar sid: The SID attribute is a single-value attribute that specifies the security identifier
     (SID) of the group.
    :vartype sid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'distinguished_name': {'readonly': True},
        'object_guid': {'readonly': True},
        'sid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'object_guid': {'key': 'properties.objectGuid', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecurityGroupEntity, self).__init__(**kwargs)
        self.kind = 'SecurityGroup'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.distinguished_name = None
        self.object_guid = None
        self.sid = None


class SecurityGroupEntityProperties(EntityCommonProperties):
    """SecurityGroup entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar distinguished_name: The group distinguished name.
    :vartype distinguished_name: str
    :ivar object_guid: A single-value attribute that is the unique identifier for the object,
     assigned by active directory.
    :vartype object_guid: str
    :ivar sid: The SID attribute is a single-value attribute that specifies the security identifier
     (SID) of the group.
    :vartype sid: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'distinguished_name': {'readonly': True},
        'object_guid': {'readonly': True},
        'sid': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'distinguished_name': {'key': 'distinguishedName', 'type': 'str'},
        'object_guid': {'key': 'objectGuid', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecurityGroupEntityProperties, self).__init__(**kwargs)
        self.distinguished_name = None
        self.object_guid = None
        self.sid = None


class SentinelOnboardingState(ResourceWithEtag):
    """Sentinel onboarding state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar customer_managed_key: Flag that indicates the status of the CMK setting.
    :vartype customer_managed_key: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'customer_managed_key': {'key': 'properties.customerManagedKey', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        customer_managed_key: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword customer_managed_key: Flag that indicates the status of the CMK setting.
        :paramtype customer_managed_key: bool
        """
        super(SentinelOnboardingState, self).__init__(etag=etag, **kwargs)
        self.customer_managed_key = customer_managed_key


class SentinelOnboardingStatesList(msrest.serialization.Model):
    """List of the Sentinel onboarding states.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of Sentinel onboarding states.
    :vartype value: list[~azure.mgmt.securityinsight.models.SentinelOnboardingState]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SentinelOnboardingState]'},
    }

    def __init__(
        self,
        *,
        value: List["SentinelOnboardingState"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of Sentinel onboarding states.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SentinelOnboardingState]
        """
        super(SentinelOnboardingStatesList, self).__init__(**kwargs)
        self.value = value


class SettingList(msrest.serialization.Model):
    """List of all the settings.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of settings.
    :vartype value: list[~azure.mgmt.securityinsight.models.Settings]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Settings]'},
    }

    def __init__(
        self,
        *,
        value: List["Settings"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of settings.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Settings]
        """
        super(SettingList, self).__init__(**kwargs)
        self.value = value


class Sku(msrest.serialization.Model):
    """The pricing tier of the solution.

    :ivar name: The kind of the tier. Possible values include: "PerGB", "CapacityReservation".
    :vartype name: str or ~azure.mgmt.securityinsight.models.SkuKind
    :ivar capacity_reservation_level: The amount of reservation level.
    :vartype capacity_reservation_level: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuKind"]] = None,
        capacity_reservation_level: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The kind of the tier. Possible values include: "PerGB", "CapacityReservation".
        :paramtype name: str or ~azure.mgmt.securityinsight.models.SkuKind
        :keyword capacity_reservation_level: The amount of reservation level.
        :paramtype capacity_reservation_level: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.capacity_reservation_level = capacity_reservation_level


class SourceControl(ResourceWithEtag):
    """Represents a SourceControl in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar id_properties_id: The id (a Guid) of the source control.
    :vartype id_properties_id: str
    :ivar version: The version number associated with the source control. Possible values include:
     "V1", "V2".
    :vartype version: str or ~azure.mgmt.securityinsight.models.Version
    :ivar display_name: The display name of the source control.
    :vartype display_name: str
    :ivar description: A description of the source control.
    :vartype description: str
    :ivar repo_type: The repository type of the source control. Possible values include: "Github",
     "DevOps".
    :vartype repo_type: str or ~azure.mgmt.securityinsight.models.RepoType
    :ivar content_types: Array of source control content types.
    :vartype content_types: list[str or ~azure.mgmt.securityinsight.models.ContentType]
    :ivar repository: Repository metadata.
    :vartype repository: ~azure.mgmt.securityinsight.models.Repository
    :ivar repository_resource_info: Information regarding the resources created in user's
     repository.
    :vartype repository_resource_info: ~azure.mgmt.securityinsight.models.RepositoryResourceInfo
    :ivar last_deployment_info: Information regarding the latest deployment for the source control.
    :vartype last_deployment_info: ~azure.mgmt.securityinsight.models.DeploymentInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'repo_type': {'key': 'properties.repoType', 'type': 'str'},
        'content_types': {'key': 'properties.contentTypes', 'type': '[str]'},
        'repository': {'key': 'properties.repository', 'type': 'Repository'},
        'repository_resource_info': {'key': 'properties.repositoryResourceInfo', 'type': 'RepositoryResourceInfo'},
        'last_deployment_info': {'key': 'properties.lastDeploymentInfo', 'type': 'DeploymentInfo'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        version: Optional[Union[str, "Version"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        repo_type: Optional[Union[str, "RepoType"]] = None,
        content_types: Optional[List[Union[str, "ContentType"]]] = None,
        repository: Optional["Repository"] = None,
        repository_resource_info: Optional["RepositoryResourceInfo"] = None,
        last_deployment_info: Optional["DeploymentInfo"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword id_properties_id: The id (a Guid) of the source control.
        :paramtype id_properties_id: str
        :keyword version: The version number associated with the source control. Possible values
         include: "V1", "V2".
        :paramtype version: str or ~azure.mgmt.securityinsight.models.Version
        :keyword display_name: The display name of the source control.
        :paramtype display_name: str
        :keyword description: A description of the source control.
        :paramtype description: str
        :keyword repo_type: The repository type of the source control. Possible values include:
         "Github", "DevOps".
        :paramtype repo_type: str or ~azure.mgmt.securityinsight.models.RepoType
        :keyword content_types: Array of source control content types.
        :paramtype content_types: list[str or ~azure.mgmt.securityinsight.models.ContentType]
        :keyword repository: Repository metadata.
        :paramtype repository: ~azure.mgmt.securityinsight.models.Repository
        :keyword repository_resource_info: Information regarding the resources created in user's
         repository.
        :paramtype repository_resource_info: ~azure.mgmt.securityinsight.models.RepositoryResourceInfo
        :keyword last_deployment_info: Information regarding the latest deployment for the source
         control.
        :paramtype last_deployment_info: ~azure.mgmt.securityinsight.models.DeploymentInfo
        """
        super(SourceControl, self).__init__(etag=etag, **kwargs)
        self.id_properties_id = id_properties_id
        self.version = version
        self.display_name = display_name
        self.description = description
        self.repo_type = repo_type
        self.content_types = content_types
        self.repository = repository
        self.repository_resource_info = repository_resource_info
        self.last_deployment_info = last_deployment_info


class SourceControlList(msrest.serialization.Model):
    """List all the source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of source controls.
    :vartype next_link: str
    :ivar value: Required. Array of source controls.
    :vartype value: list[~azure.mgmt.securityinsight.models.SourceControl]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SourceControl]'},
    }

    def __init__(
        self,
        *,
        value: List["SourceControl"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of source controls.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SourceControl]
        """
        super(SourceControlList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class SubmissionMailEntity(Entity):
    """Represents a submission mail entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_id: The network message id of email to which submission belongs.
    :vartype network_message_id: str
    :ivar submission_id: The submission id.
    :vartype submission_id: str
    :ivar submitter: The submitter.
    :vartype submitter: str
    :ivar submission_date: The submission date.
    :vartype submission_date: ~datetime.datetime
    :ivar timestamp: The Time stamp when the message is received (Mail).
    :vartype timestamp: ~datetime.datetime
    :ivar recipient: The recipient of the mail.
    :vartype recipient: str
    :ivar sender: The sender of the mail.
    :vartype sender: str
    :ivar sender_ip: The sender's IP.
    :vartype sender_ip: str
    :ivar subject: The subject of submission mail.
    :vartype subject: str
    :ivar report_type: The submission type for the given instance. This maps to Junk, Phish,
     Malware or NotJunk.
    :vartype report_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'network_message_id': {'readonly': True},
        'submission_id': {'readonly': True},
        'submitter': {'readonly': True},
        'submission_date': {'readonly': True},
        'timestamp': {'readonly': True},
        'recipient': {'readonly': True},
        'sender': {'readonly': True},
        'sender_ip': {'readonly': True},
        'subject': {'readonly': True},
        'report_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'network_message_id': {'key': 'properties.networkMessageId', 'type': 'str'},
        'submission_id': {'key': 'properties.submissionId', 'type': 'str'},
        'submitter': {'key': 'properties.submitter', 'type': 'str'},
        'submission_date': {'key': 'properties.submissionDate', 'type': 'iso-8601'},
        'timestamp': {'key': 'properties.timestamp', 'type': 'iso-8601'},
        'recipient': {'key': 'properties.recipient', 'type': 'str'},
        'sender': {'key': 'properties.sender', 'type': 'str'},
        'sender_ip': {'key': 'properties.senderIp', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'report_type': {'key': 'properties.reportType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SubmissionMailEntity, self).__init__(**kwargs)
        self.kind = 'SubmissionMail'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.network_message_id = None
        self.submission_id = None
        self.submitter = None
        self.submission_date = None
        self.timestamp = None
        self.recipient = None
        self.sender = None
        self.sender_ip = None
        self.subject = None
        self.report_type = None


class SubmissionMailEntityProperties(EntityCommonProperties):
    """Submission mail entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_id: The network message id of email to which submission belongs.
    :vartype network_message_id: str
    :ivar submission_id: The submission id.
    :vartype submission_id: str
    :ivar submitter: The submitter.
    :vartype submitter: str
    :ivar submission_date: The submission date.
    :vartype submission_date: ~datetime.datetime
    :ivar timestamp: The Time stamp when the message is received (Mail).
    :vartype timestamp: ~datetime.datetime
    :ivar recipient: The recipient of the mail.
    :vartype recipient: str
    :ivar sender: The sender of the mail.
    :vartype sender: str
    :ivar sender_ip: The sender's IP.
    :vartype sender_ip: str
    :ivar subject: The subject of submission mail.
    :vartype subject: str
    :ivar report_type: The submission type for the given instance. This maps to Junk, Phish,
     Malware or NotJunk.
    :vartype report_type: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'network_message_id': {'readonly': True},
        'submission_id': {'readonly': True},
        'submitter': {'readonly': True},
        'submission_date': {'readonly': True},
        'timestamp': {'readonly': True},
        'recipient': {'readonly': True},
        'sender': {'readonly': True},
        'sender_ip': {'readonly': True},
        'subject': {'readonly': True},
        'report_type': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'network_message_id': {'key': 'networkMessageId', 'type': 'str'},
        'submission_id': {'key': 'submissionId', 'type': 'str'},
        'submitter': {'key': 'submitter', 'type': 'str'},
        'submission_date': {'key': 'submissionDate', 'type': 'iso-8601'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'recipient': {'key': 'recipient', 'type': 'str'},
        'sender': {'key': 'sender', 'type': 'str'},
        'sender_ip': {'key': 'senderIp', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'report_type': {'key': 'reportType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SubmissionMailEntityProperties, self).__init__(**kwargs)
        self.network_message_id = None
        self.submission_id = None
        self.submitter = None
        self.submission_date = None
        self.timestamp = None
        self.recipient = None
        self.sender = None
        self.sender_ip = None
        self.subject = None
        self.report_type = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TeamInformation(msrest.serialization.Model):
    """Describes team information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar team_id: Team ID.
    :vartype team_id: str
    :ivar primary_channel_url: The primary channel URL of the team.
    :vartype primary_channel_url: str
    :ivar team_creation_time_utc: The time the team was created.
    :vartype team_creation_time_utc: ~datetime.datetime
    :ivar name: The name of the team.
    :vartype name: str
    :ivar description: The description of the team.
    :vartype description: str
    """

    _validation = {
        'team_id': {'readonly': True},
        'primary_channel_url': {'readonly': True},
        'team_creation_time_utc': {'readonly': True},
        'name': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'team_id': {'key': 'teamId', 'type': 'str'},
        'primary_channel_url': {'key': 'primaryChannelUrl', 'type': 'str'},
        'team_creation_time_utc': {'key': 'teamCreationTimeUtc', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TeamInformation, self).__init__(**kwargs)
        self.team_id = None
        self.primary_channel_url = None
        self.team_creation_time_utc = None
        self.name = None
        self.description = None


class TeamProperties(msrest.serialization.Model):
    """Describes team properties.

    All required parameters must be populated in order to send to Azure.

    :ivar team_name: Required. The name of the team.
    :vartype team_name: str
    :ivar team_description: The description of the team.
    :vartype team_description: str
    :ivar member_ids: List of member IDs to add to the team.
    :vartype member_ids: list[str]
    :ivar group_ids: List of group IDs to add their members to the team.
    :vartype group_ids: list[str]
    """

    _validation = {
        'team_name': {'required': True},
    }

    _attribute_map = {
        'team_name': {'key': 'teamName', 'type': 'str'},
        'team_description': {'key': 'teamDescription', 'type': 'str'},
        'member_ids': {'key': 'memberIds', 'type': '[str]'},
        'group_ids': {'key': 'groupIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        team_name: str,
        team_description: Optional[str] = None,
        member_ids: Optional[List[str]] = None,
        group_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword team_name: Required. The name of the team.
        :paramtype team_name: str
        :keyword team_description: The description of the team.
        :paramtype team_description: str
        :keyword member_ids: List of member IDs to add to the team.
        :paramtype member_ids: list[str]
        :keyword group_ids: List of group IDs to add their members to the team.
        :paramtype group_ids: list[str]
        """
        super(TeamProperties, self).__init__(**kwargs)
        self.team_name = team_name
        self.team_description = team_description
        self.member_ids = member_ids
        self.group_ids = group_ids


class ThreatIntelligence(msrest.serialization.Model):
    """ThreatIntelligence property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confidence: Confidence (must be between 0 and 1).
    :vartype confidence: float
    :ivar provider_name: Name of the provider from whom this Threat Intelligence information was
     received.
    :vartype provider_name: str
    :ivar report_link: Report link.
    :vartype report_link: str
    :ivar threat_description: Threat description (free text).
    :vartype threat_description: str
    :ivar threat_name: Threat name (e.g. "Jedobot malware").
    :vartype threat_name: str
    :ivar threat_type: Threat type (e.g. "Botnet").
    :vartype threat_type: str
    """

    _validation = {
        'confidence': {'readonly': True},
        'provider_name': {'readonly': True},
        'report_link': {'readonly': True},
        'threat_description': {'readonly': True},
        'threat_name': {'readonly': True},
        'threat_type': {'readonly': True},
    }

    _attribute_map = {
        'confidence': {'key': 'confidence', 'type': 'float'},
        'provider_name': {'key': 'providerName', 'type': 'str'},
        'report_link': {'key': 'reportLink', 'type': 'str'},
        'threat_description': {'key': 'threatDescription', 'type': 'str'},
        'threat_name': {'key': 'threatName', 'type': 'str'},
        'threat_type': {'key': 'threatType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ThreatIntelligence, self).__init__(**kwargs)
        self.confidence = None
        self.provider_name = None
        self.report_link = None
        self.threat_description = None
        self.threat_name = None
        self.threat_type = None


class ThreatIntelligenceAlertRule(AlertRule):
    """Represents Threat Intelligence alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'last_modified_utc': {'readonly': True},
        'severity': {'readonly': True},
        'tactics': {'readonly': True},
        'techniques': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super(ThreatIntelligenceAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'ThreatIntelligence'  # type: str
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class ThreatIntelligenceAlertRuleTemplate(AlertRuleTemplate):
    """Represents Threat Intelligence alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the alert rule.Constant filled by server. Possible values
     include: "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics",
     "ThreatIntelligence", "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'properties.lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
        'techniques': {'key': 'properties.techniques', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Possible values include:
         "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(ThreatIntelligenceAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'ThreatIntelligence'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.severity = severity


class ThreatIntelligenceAlertRuleTemplateProperties(AlertRuleTemplateWithMitreProperties):
    """Threat Intelligence alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: Required. The severity for alerts created by this alert rule. Possible values
     include: "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        'last_updated_date_utc': {'readonly': True},
        'created_date_utc': {'readonly': True},
        'severity': {'required': True},
    }

    _attribute_map = {
        'alert_rules_created_by_template_count': {'key': 'alertRulesCreatedByTemplateCount', 'type': 'int'},
        'last_updated_date_utc': {'key': 'lastUpdatedDateUTC', 'type': 'iso-8601'},
        'created_date_utc': {'key': 'createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'status', 'type': 'str'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
        'techniques': {'key': 'techniques', 'type': '[str]'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "AlertSeverity"],
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Possible values include: "Installed",
         "Available", "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: Required. The severity for alerts created by this alert rule. Possible
         values include: "High", "Medium", "Low", "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super(ThreatIntelligenceAlertRuleTemplateProperties, self).__init__(alert_rules_created_by_template_count=alert_rules_created_by_template_count, description=description, display_name=display_name, required_data_connectors=required_data_connectors, status=status, tactics=tactics, techniques=techniques, **kwargs)
        self.severity = severity


class ThreatIntelligenceAppendTags(msrest.serialization.Model):
    """Array of tags to be appended to the threat intelligence indicator.

    :ivar threat_intelligence_tags: List of tags to be appended.
    :vartype threat_intelligence_tags: list[str]
    """

    _attribute_map = {
        'threat_intelligence_tags': {'key': 'threatIntelligenceTags', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        threat_intelligence_tags: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword threat_intelligence_tags: List of tags to be appended.
        :paramtype threat_intelligence_tags: list[str]
        """
        super(ThreatIntelligenceAppendTags, self).__init__(**kwargs)
        self.threat_intelligence_tags = threat_intelligence_tags


class ThreatIntelligenceExternalReference(msrest.serialization.Model):
    """Describes external reference.

    :ivar description: External reference description.
    :vartype description: str
    :ivar external_id: External reference ID.
    :vartype external_id: str
    :ivar source_name: External reference source name.
    :vartype source_name: str
    :ivar url: External reference URL.
    :vartype url: str
    :ivar hashes: External reference hashes.
    :vartype hashes: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'external_id': {'key': 'externalId', 'type': 'str'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'hashes': {'key': 'hashes', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_id: Optional[str] = None,
        source_name: Optional[str] = None,
        url: Optional[str] = None,
        hashes: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: External reference description.
        :paramtype description: str
        :keyword external_id: External reference ID.
        :paramtype external_id: str
        :keyword source_name: External reference source name.
        :paramtype source_name: str
        :keyword url: External reference URL.
        :paramtype url: str
        :keyword hashes: External reference hashes.
        :paramtype hashes: dict[str, str]
        """
        super(ThreatIntelligenceExternalReference, self).__init__(**kwargs)
        self.description = description
        self.external_id = external_id
        self.source_name = source_name
        self.url = url
        self.hashes = hashes


class ThreatIntelligenceFilteringCriteria(msrest.serialization.Model):
    """Filtering criteria for querying threat intelligence indicators.

    :ivar page_size: Page size.
    :vartype page_size: int
    :ivar min_confidence: Minimum confidence.
    :vartype min_confidence: int
    :ivar max_confidence: Maximum confidence.
    :vartype max_confidence: int
    :ivar min_valid_until: Start time for ValidUntil filter.
    :vartype min_valid_until: str
    :ivar max_valid_until: End time for ValidUntil filter.
    :vartype max_valid_until: str
    :ivar include_disabled: Parameter to include/exclude disabled indicators.
    :vartype include_disabled: bool
    :ivar sort_by: Columns to sort by and sorting order.
    :vartype sort_by: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteria]
    :ivar sources: Sources of threat intelligence indicators.
    :vartype sources: list[str]
    :ivar pattern_types: Pattern types.
    :vartype pattern_types: list[str]
    :ivar threat_types: Threat types of threat intelligence indicators.
    :vartype threat_types: list[str]
    :ivar ids: Ids of threat intelligence indicators.
    :vartype ids: list[str]
    :ivar keywords: Keywords for searching threat intelligence indicators.
    :vartype keywords: list[str]
    :ivar skip_token: Skip token.
    :vartype skip_token: str
    """

    _attribute_map = {
        'page_size': {'key': 'pageSize', 'type': 'int'},
        'min_confidence': {'key': 'minConfidence', 'type': 'int'},
        'max_confidence': {'key': 'maxConfidence', 'type': 'int'},
        'min_valid_until': {'key': 'minValidUntil', 'type': 'str'},
        'max_valid_until': {'key': 'maxValidUntil', 'type': 'str'},
        'include_disabled': {'key': 'includeDisabled', 'type': 'bool'},
        'sort_by': {'key': 'sortBy', 'type': '[ThreatIntelligenceSortingCriteria]'},
        'sources': {'key': 'sources', 'type': '[str]'},
        'pattern_types': {'key': 'patternTypes', 'type': '[str]'},
        'threat_types': {'key': 'threatTypes', 'type': '[str]'},
        'ids': {'key': 'ids', 'type': '[str]'},
        'keywords': {'key': 'keywords', 'type': '[str]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        page_size: Optional[int] = None,
        min_confidence: Optional[int] = None,
        max_confidence: Optional[int] = None,
        min_valid_until: Optional[str] = None,
        max_valid_until: Optional[str] = None,
        include_disabled: Optional[bool] = None,
        sort_by: Optional[List["ThreatIntelligenceSortingCriteria"]] = None,
        sources: Optional[List[str]] = None,
        pattern_types: Optional[List[str]] = None,
        threat_types: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        keywords: Optional[List[str]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword page_size: Page size.
        :paramtype page_size: int
        :keyword min_confidence: Minimum confidence.
        :paramtype min_confidence: int
        :keyword max_confidence: Maximum confidence.
        :paramtype max_confidence: int
        :keyword min_valid_until: Start time for ValidUntil filter.
        :paramtype min_valid_until: str
        :keyword max_valid_until: End time for ValidUntil filter.
        :paramtype max_valid_until: str
        :keyword include_disabled: Parameter to include/exclude disabled indicators.
        :paramtype include_disabled: bool
        :keyword sort_by: Columns to sort by and sorting order.
        :paramtype sort_by: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteria]
        :keyword sources: Sources of threat intelligence indicators.
        :paramtype sources: list[str]
        :keyword pattern_types: Pattern types.
        :paramtype pattern_types: list[str]
        :keyword threat_types: Threat types of threat intelligence indicators.
        :paramtype threat_types: list[str]
        :keyword ids: Ids of threat intelligence indicators.
        :paramtype ids: list[str]
        :keyword keywords: Keywords for searching threat intelligence indicators.
        :paramtype keywords: list[str]
        :keyword skip_token: Skip token.
        :paramtype skip_token: str
        """
        super(ThreatIntelligenceFilteringCriteria, self).__init__(**kwargs)
        self.page_size = page_size
        self.min_confidence = min_confidence
        self.max_confidence = max_confidence
        self.min_valid_until = min_valid_until
        self.max_valid_until = max_valid_until
        self.include_disabled = include_disabled
        self.sort_by = sort_by
        self.sources = sources
        self.pattern_types = pattern_types
        self.threat_types = threat_types
        self.ids = ids
        self.keywords = keywords
        self.skip_token = skip_token


class ThreatIntelligenceGranularMarkingModel(msrest.serialization.Model):
    """Describes threat granular marking model entity.

    :ivar language: Language granular marking model.
    :vartype language: str
    :ivar marking_ref: marking reference granular marking model.
    :vartype marking_ref: int
    :ivar selectors: granular marking model selectors.
    :vartype selectors: list[str]
    """

    _attribute_map = {
        'language': {'key': 'language', 'type': 'str'},
        'marking_ref': {'key': 'markingRef', 'type': 'int'},
        'selectors': {'key': 'selectors', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        language: Optional[str] = None,
        marking_ref: Optional[int] = None,
        selectors: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword language: Language granular marking model.
        :paramtype language: str
        :keyword marking_ref: marking reference granular marking model.
        :paramtype marking_ref: int
        :keyword selectors: granular marking model selectors.
        :paramtype selectors: list[str]
        """
        super(ThreatIntelligenceGranularMarkingModel, self).__init__(**kwargs)
        self.language = language
        self.marking_ref = marking_ref
        self.selectors = selectors


class ThreatIntelligenceInformation(ResourceWithEtag):
    """Threat intelligence information object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ThreatIntelligenceIndicatorModel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "indicator".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ThreatIntelligenceResourceKindEnum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'indicator': 'ThreatIntelligenceIndicatorModel'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super(ThreatIntelligenceInformation, self).__init__(etag=etag, **kwargs)
        self.kind = 'ThreatIntelligenceInformation'  # type: str


class ThreatIntelligenceIndicatorModel(ThreatIntelligenceInformation):
    """Threat intelligence indicator entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "indicator".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ThreatIntelligenceResourceKindEnum
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar threat_intelligence_tags: List of tags.
    :vartype threat_intelligence_tags: list[str]
    :ivar last_updated_time_utc: Last updated time in UTC.
    :vartype last_updated_time_utc: str
    :ivar source: Source of a threat intelligence entity.
    :vartype source: str
    :ivar display_name: Display name of a threat intelligence entity.
    :vartype display_name: str
    :ivar description: Description of a threat intelligence entity.
    :vartype description: str
    :ivar indicator_types: Indicator types of threat intelligence entities.
    :vartype indicator_types: list[str]
    :ivar pattern: Pattern of a threat intelligence entity.
    :vartype pattern: str
    :ivar pattern_type: Pattern type of a threat intelligence entity.
    :vartype pattern_type: str
    :ivar pattern_version: Pattern version of a threat intelligence entity.
    :vartype pattern_version: str
    :ivar kill_chain_phases: Kill chain phases.
    :vartype kill_chain_phases:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
    :ivar parsed_pattern: Parsed patterns.
    :vartype parsed_pattern:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
    :ivar external_id: External ID of threat intelligence entity.
    :vartype external_id: str
    :ivar created_by_ref: Created by reference of threat intelligence entity.
    :vartype created_by_ref: str
    :ivar defanged: Is threat intelligence entity defanged.
    :vartype defanged: bool
    :ivar external_last_updated_time_utc: External last updated time in UTC.
    :vartype external_last_updated_time_utc: str
    :ivar external_references: External References.
    :vartype external_references:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
    :ivar granular_markings: Granular Markings.
    :vartype granular_markings:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
    :ivar labels: Labels  of threat intelligence entity.
    :vartype labels: list[str]
    :ivar revoked: Is threat intelligence entity revoked.
    :vartype revoked: bool
    :ivar confidence: Confidence of threat intelligence entity.
    :vartype confidence: int
    :ivar object_marking_refs: Threat intelligence entity object marking references.
    :vartype object_marking_refs: list[str]
    :ivar language: Language of threat intelligence entity.
    :vartype language: str
    :ivar threat_types: Threat types.
    :vartype threat_types: list[str]
    :ivar valid_from: Valid from.
    :vartype valid_from: str
    :ivar valid_until: Valid until.
    :vartype valid_until: str
    :ivar created: Created by.
    :vartype created: str
    :ivar modified: Modified by.
    :vartype modified: str
    :ivar extensions: Extensions map.
    :vartype extensions: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'threat_intelligence_tags': {'key': 'properties.threatIntelligenceTags', 'type': '[str]'},
        'last_updated_time_utc': {'key': 'properties.lastUpdatedTimeUtc', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'indicator_types': {'key': 'properties.indicatorTypes', 'type': '[str]'},
        'pattern': {'key': 'properties.pattern', 'type': 'str'},
        'pattern_type': {'key': 'properties.patternType', 'type': 'str'},
        'pattern_version': {'key': 'properties.patternVersion', 'type': 'str'},
        'kill_chain_phases': {'key': 'properties.killChainPhases', 'type': '[ThreatIntelligenceKillChainPhase]'},
        'parsed_pattern': {'key': 'properties.parsedPattern', 'type': '[ThreatIntelligenceParsedPattern]'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
        'created_by_ref': {'key': 'properties.createdByRef', 'type': 'str'},
        'defanged': {'key': 'properties.defanged', 'type': 'bool'},
        'external_last_updated_time_utc': {'key': 'properties.externalLastUpdatedTimeUtc', 'type': 'str'},
        'external_references': {'key': 'properties.externalReferences', 'type': '[ThreatIntelligenceExternalReference]'},
        'granular_markings': {'key': 'properties.granularMarkings', 'type': '[ThreatIntelligenceGranularMarkingModel]'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'revoked': {'key': 'properties.revoked', 'type': 'bool'},
        'confidence': {'key': 'properties.confidence', 'type': 'int'},
        'object_marking_refs': {'key': 'properties.objectMarkingRefs', 'type': '[str]'},
        'language': {'key': 'properties.language', 'type': 'str'},
        'threat_types': {'key': 'properties.threatTypes', 'type': '[str]'},
        'valid_from': {'key': 'properties.validFrom', 'type': 'str'},
        'valid_until': {'key': 'properties.validUntil', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'str'},
        'modified': {'key': 'properties.modified', 'type': 'str'},
        'extensions': {'key': 'properties.extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        threat_intelligence_tags: Optional[List[str]] = None,
        last_updated_time_utc: Optional[str] = None,
        source: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        indicator_types: Optional[List[str]] = None,
        pattern: Optional[str] = None,
        pattern_type: Optional[str] = None,
        pattern_version: Optional[str] = None,
        kill_chain_phases: Optional[List["ThreatIntelligenceKillChainPhase"]] = None,
        parsed_pattern: Optional[List["ThreatIntelligenceParsedPattern"]] = None,
        external_id: Optional[str] = None,
        created_by_ref: Optional[str] = None,
        defanged: Optional[bool] = None,
        external_last_updated_time_utc: Optional[str] = None,
        external_references: Optional[List["ThreatIntelligenceExternalReference"]] = None,
        granular_markings: Optional[List["ThreatIntelligenceGranularMarkingModel"]] = None,
        labels: Optional[List[str]] = None,
        revoked: Optional[bool] = None,
        confidence: Optional[int] = None,
        object_marking_refs: Optional[List[str]] = None,
        language: Optional[str] = None,
        threat_types: Optional[List[str]] = None,
        valid_from: Optional[str] = None,
        valid_until: Optional[str] = None,
        created: Optional[str] = None,
        modified: Optional[str] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword threat_intelligence_tags: List of tags.
        :paramtype threat_intelligence_tags: list[str]
        :keyword last_updated_time_utc: Last updated time in UTC.
        :paramtype last_updated_time_utc: str
        :keyword source: Source of a threat intelligence entity.
        :paramtype source: str
        :keyword display_name: Display name of a threat intelligence entity.
        :paramtype display_name: str
        :keyword description: Description of a threat intelligence entity.
        :paramtype description: str
        :keyword indicator_types: Indicator types of threat intelligence entities.
        :paramtype indicator_types: list[str]
        :keyword pattern: Pattern of a threat intelligence entity.
        :paramtype pattern: str
        :keyword pattern_type: Pattern type of a threat intelligence entity.
        :paramtype pattern_type: str
        :keyword pattern_version: Pattern version of a threat intelligence entity.
        :paramtype pattern_version: str
        :keyword kill_chain_phases: Kill chain phases.
        :paramtype kill_chain_phases:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
        :keyword parsed_pattern: Parsed patterns.
        :paramtype parsed_pattern:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
        :keyword external_id: External ID of threat intelligence entity.
        :paramtype external_id: str
        :keyword created_by_ref: Created by reference of threat intelligence entity.
        :paramtype created_by_ref: str
        :keyword defanged: Is threat intelligence entity defanged.
        :paramtype defanged: bool
        :keyword external_last_updated_time_utc: External last updated time in UTC.
        :paramtype external_last_updated_time_utc: str
        :keyword external_references: External References.
        :paramtype external_references:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
        :keyword granular_markings: Granular Markings.
        :paramtype granular_markings:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
        :keyword labels: Labels  of threat intelligence entity.
        :paramtype labels: list[str]
        :keyword revoked: Is threat intelligence entity revoked.
        :paramtype revoked: bool
        :keyword confidence: Confidence of threat intelligence entity.
        :paramtype confidence: int
        :keyword object_marking_refs: Threat intelligence entity object marking references.
        :paramtype object_marking_refs: list[str]
        :keyword language: Language of threat intelligence entity.
        :paramtype language: str
        :keyword threat_types: Threat types.
        :paramtype threat_types: list[str]
        :keyword valid_from: Valid from.
        :paramtype valid_from: str
        :keyword valid_until: Valid until.
        :paramtype valid_until: str
        :keyword created: Created by.
        :paramtype created: str
        :keyword modified: Modified by.
        :paramtype modified: str
        :keyword extensions: Extensions map.
        :paramtype extensions: dict[str, any]
        """
        super(ThreatIntelligenceIndicatorModel, self).__init__(etag=etag, **kwargs)
        self.kind = 'indicator'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.threat_intelligence_tags = threat_intelligence_tags
        self.last_updated_time_utc = last_updated_time_utc
        self.source = source
        self.display_name = display_name
        self.description = description
        self.indicator_types = indicator_types
        self.pattern = pattern
        self.pattern_type = pattern_type
        self.pattern_version = pattern_version
        self.kill_chain_phases = kill_chain_phases
        self.parsed_pattern = parsed_pattern
        self.external_id = external_id
        self.created_by_ref = created_by_ref
        self.defanged = defanged
        self.external_last_updated_time_utc = external_last_updated_time_utc
        self.external_references = external_references
        self.granular_markings = granular_markings
        self.labels = labels
        self.revoked = revoked
        self.confidence = confidence
        self.object_marking_refs = object_marking_refs
        self.language = language
        self.threat_types = threat_types
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.created = created
        self.modified = modified
        self.extensions = extensions


class ThreatIntelligenceIndicatorProperties(EntityCommonProperties):
    """Describes threat intelligence entity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar threat_intelligence_tags: List of tags.
    :vartype threat_intelligence_tags: list[str]
    :ivar last_updated_time_utc: Last updated time in UTC.
    :vartype last_updated_time_utc: str
    :ivar source: Source of a threat intelligence entity.
    :vartype source: str
    :ivar display_name: Display name of a threat intelligence entity.
    :vartype display_name: str
    :ivar description: Description of a threat intelligence entity.
    :vartype description: str
    :ivar indicator_types: Indicator types of threat intelligence entities.
    :vartype indicator_types: list[str]
    :ivar pattern: Pattern of a threat intelligence entity.
    :vartype pattern: str
    :ivar pattern_type: Pattern type of a threat intelligence entity.
    :vartype pattern_type: str
    :ivar pattern_version: Pattern version of a threat intelligence entity.
    :vartype pattern_version: str
    :ivar kill_chain_phases: Kill chain phases.
    :vartype kill_chain_phases:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
    :ivar parsed_pattern: Parsed patterns.
    :vartype parsed_pattern:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
    :ivar external_id: External ID of threat intelligence entity.
    :vartype external_id: str
    :ivar created_by_ref: Created by reference of threat intelligence entity.
    :vartype created_by_ref: str
    :ivar defanged: Is threat intelligence entity defanged.
    :vartype defanged: bool
    :ivar external_last_updated_time_utc: External last updated time in UTC.
    :vartype external_last_updated_time_utc: str
    :ivar external_references: External References.
    :vartype external_references:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
    :ivar granular_markings: Granular Markings.
    :vartype granular_markings:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
    :ivar labels: Labels  of threat intelligence entity.
    :vartype labels: list[str]
    :ivar revoked: Is threat intelligence entity revoked.
    :vartype revoked: bool
    :ivar confidence: Confidence of threat intelligence entity.
    :vartype confidence: int
    :ivar object_marking_refs: Threat intelligence entity object marking references.
    :vartype object_marking_refs: list[str]
    :ivar language: Language of threat intelligence entity.
    :vartype language: str
    :ivar threat_types: Threat types.
    :vartype threat_types: list[str]
    :ivar valid_from: Valid from.
    :vartype valid_from: str
    :ivar valid_until: Valid until.
    :vartype valid_until: str
    :ivar created: Created by.
    :vartype created: str
    :ivar modified: Modified by.
    :vartype modified: str
    :ivar extensions: Extensions map.
    :vartype extensions: dict[str, any]
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'threat_intelligence_tags': {'key': 'threatIntelligenceTags', 'type': '[str]'},
        'last_updated_time_utc': {'key': 'lastUpdatedTimeUtc', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'indicator_types': {'key': 'indicatorTypes', 'type': '[str]'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'pattern_type': {'key': 'patternType', 'type': 'str'},
        'pattern_version': {'key': 'patternVersion', 'type': 'str'},
        'kill_chain_phases': {'key': 'killChainPhases', 'type': '[ThreatIntelligenceKillChainPhase]'},
        'parsed_pattern': {'key': 'parsedPattern', 'type': '[ThreatIntelligenceParsedPattern]'},
        'external_id': {'key': 'externalId', 'type': 'str'},
        'created_by_ref': {'key': 'createdByRef', 'type': 'str'},
        'defanged': {'key': 'defanged', 'type': 'bool'},
        'external_last_updated_time_utc': {'key': 'externalLastUpdatedTimeUtc', 'type': 'str'},
        'external_references': {'key': 'externalReferences', 'type': '[ThreatIntelligenceExternalReference]'},
        'granular_markings': {'key': 'granularMarkings', 'type': '[ThreatIntelligenceGranularMarkingModel]'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'revoked': {'key': 'revoked', 'type': 'bool'},
        'confidence': {'key': 'confidence', 'type': 'int'},
        'object_marking_refs': {'key': 'objectMarkingRefs', 'type': '[str]'},
        'language': {'key': 'language', 'type': 'str'},
        'threat_types': {'key': 'threatTypes', 'type': '[str]'},
        'valid_from': {'key': 'validFrom', 'type': 'str'},
        'valid_until': {'key': 'validUntil', 'type': 'str'},
        'created': {'key': 'created', 'type': 'str'},
        'modified': {'key': 'modified', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        threat_intelligence_tags: Optional[List[str]] = None,
        last_updated_time_utc: Optional[str] = None,
        source: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        indicator_types: Optional[List[str]] = None,
        pattern: Optional[str] = None,
        pattern_type: Optional[str] = None,
        pattern_version: Optional[str] = None,
        kill_chain_phases: Optional[List["ThreatIntelligenceKillChainPhase"]] = None,
        parsed_pattern: Optional[List["ThreatIntelligenceParsedPattern"]] = None,
        external_id: Optional[str] = None,
        created_by_ref: Optional[str] = None,
        defanged: Optional[bool] = None,
        external_last_updated_time_utc: Optional[str] = None,
        external_references: Optional[List["ThreatIntelligenceExternalReference"]] = None,
        granular_markings: Optional[List["ThreatIntelligenceGranularMarkingModel"]] = None,
        labels: Optional[List[str]] = None,
        revoked: Optional[bool] = None,
        confidence: Optional[int] = None,
        object_marking_refs: Optional[List[str]] = None,
        language: Optional[str] = None,
        threat_types: Optional[List[str]] = None,
        valid_from: Optional[str] = None,
        valid_until: Optional[str] = None,
        created: Optional[str] = None,
        modified: Optional[str] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword threat_intelligence_tags: List of tags.
        :paramtype threat_intelligence_tags: list[str]
        :keyword last_updated_time_utc: Last updated time in UTC.
        :paramtype last_updated_time_utc: str
        :keyword source: Source of a threat intelligence entity.
        :paramtype source: str
        :keyword display_name: Display name of a threat intelligence entity.
        :paramtype display_name: str
        :keyword description: Description of a threat intelligence entity.
        :paramtype description: str
        :keyword indicator_types: Indicator types of threat intelligence entities.
        :paramtype indicator_types: list[str]
        :keyword pattern: Pattern of a threat intelligence entity.
        :paramtype pattern: str
        :keyword pattern_type: Pattern type of a threat intelligence entity.
        :paramtype pattern_type: str
        :keyword pattern_version: Pattern version of a threat intelligence entity.
        :paramtype pattern_version: str
        :keyword kill_chain_phases: Kill chain phases.
        :paramtype kill_chain_phases:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
        :keyword parsed_pattern: Parsed patterns.
        :paramtype parsed_pattern:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
        :keyword external_id: External ID of threat intelligence entity.
        :paramtype external_id: str
        :keyword created_by_ref: Created by reference of threat intelligence entity.
        :paramtype created_by_ref: str
        :keyword defanged: Is threat intelligence entity defanged.
        :paramtype defanged: bool
        :keyword external_last_updated_time_utc: External last updated time in UTC.
        :paramtype external_last_updated_time_utc: str
        :keyword external_references: External References.
        :paramtype external_references:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
        :keyword granular_markings: Granular Markings.
        :paramtype granular_markings:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
        :keyword labels: Labels  of threat intelligence entity.
        :paramtype labels: list[str]
        :keyword revoked: Is threat intelligence entity revoked.
        :paramtype revoked: bool
        :keyword confidence: Confidence of threat intelligence entity.
        :paramtype confidence: int
        :keyword object_marking_refs: Threat intelligence entity object marking references.
        :paramtype object_marking_refs: list[str]
        :keyword language: Language of threat intelligence entity.
        :paramtype language: str
        :keyword threat_types: Threat types.
        :paramtype threat_types: list[str]
        :keyword valid_from: Valid from.
        :paramtype valid_from: str
        :keyword valid_until: Valid until.
        :paramtype valid_until: str
        :keyword created: Created by.
        :paramtype created: str
        :keyword modified: Modified by.
        :paramtype modified: str
        :keyword extensions: Extensions map.
        :paramtype extensions: dict[str, any]
        """
        super(ThreatIntelligenceIndicatorProperties, self).__init__(**kwargs)
        self.threat_intelligence_tags = threat_intelligence_tags
        self.last_updated_time_utc = last_updated_time_utc
        self.source = source
        self.display_name = display_name
        self.description = description
        self.indicator_types = indicator_types
        self.pattern = pattern
        self.pattern_type = pattern_type
        self.pattern_version = pattern_version
        self.kill_chain_phases = kill_chain_phases
        self.parsed_pattern = parsed_pattern
        self.external_id = external_id
        self.created_by_ref = created_by_ref
        self.defanged = defanged
        self.external_last_updated_time_utc = external_last_updated_time_utc
        self.external_references = external_references
        self.granular_markings = granular_markings
        self.labels = labels
        self.revoked = revoked
        self.confidence = confidence
        self.object_marking_refs = object_marking_refs
        self.language = language
        self.threat_types = threat_types
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.created = created
        self.modified = modified
        self.extensions = extensions


class ThreatIntelligenceInformationList(msrest.serialization.Model):
    """List of all the threat intelligence information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of information objects.
    :vartype next_link: str
    :ivar value: Required. Array of threat intelligence information objects.
    :vartype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ThreatIntelligenceInformation]'},
    }

    def __init__(
        self,
        *,
        value: List["ThreatIntelligenceInformation"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of threat intelligence information objects.
        :paramtype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
        """
        super(ThreatIntelligenceInformationList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class ThreatIntelligenceKillChainPhase(msrest.serialization.Model):
    """Describes threat kill chain phase entity.

    :ivar kill_chain_name: Kill chainName name.
    :vartype kill_chain_name: str
    :ivar phase_name: Phase name.
    :vartype phase_name: str
    """

    _attribute_map = {
        'kill_chain_name': {'key': 'killChainName', 'type': 'str'},
        'phase_name': {'key': 'phaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kill_chain_name: Optional[str] = None,
        phase_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kill_chain_name: Kill chainName name.
        :paramtype kill_chain_name: str
        :keyword phase_name: Phase name.
        :paramtype phase_name: str
        """
        super(ThreatIntelligenceKillChainPhase, self).__init__(**kwargs)
        self.kill_chain_name = kill_chain_name
        self.phase_name = phase_name


class ThreatIntelligenceMetric(msrest.serialization.Model):
    """Describes threat intelligence metric.

    :ivar last_updated_time_utc: Last updated indicator metric.
    :vartype last_updated_time_utc: str
    :ivar threat_type_metrics: Threat type metrics.
    :vartype threat_type_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    :ivar pattern_type_metrics: Pattern type metrics.
    :vartype pattern_type_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    :ivar source_metrics: Source metrics.
    :vartype source_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    """

    _attribute_map = {
        'last_updated_time_utc': {'key': 'lastUpdatedTimeUtc', 'type': 'str'},
        'threat_type_metrics': {'key': 'threatTypeMetrics', 'type': '[ThreatIntelligenceMetricEntity]'},
        'pattern_type_metrics': {'key': 'patternTypeMetrics', 'type': '[ThreatIntelligenceMetricEntity]'},
        'source_metrics': {'key': 'sourceMetrics', 'type': '[ThreatIntelligenceMetricEntity]'},
    }

    def __init__(
        self,
        *,
        last_updated_time_utc: Optional[str] = None,
        threat_type_metrics: Optional[List["ThreatIntelligenceMetricEntity"]] = None,
        pattern_type_metrics: Optional[List["ThreatIntelligenceMetricEntity"]] = None,
        source_metrics: Optional[List["ThreatIntelligenceMetricEntity"]] = None,
        **kwargs
    ):
        """
        :keyword last_updated_time_utc: Last updated indicator metric.
        :paramtype last_updated_time_utc: str
        :keyword threat_type_metrics: Threat type metrics.
        :paramtype threat_type_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        :keyword pattern_type_metrics: Pattern type metrics.
        :paramtype pattern_type_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        :keyword source_metrics: Source metrics.
        :paramtype source_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        """
        super(ThreatIntelligenceMetric, self).__init__(**kwargs)
        self.last_updated_time_utc = last_updated_time_utc
        self.threat_type_metrics = threat_type_metrics
        self.pattern_type_metrics = pattern_type_metrics
        self.source_metrics = source_metrics


class ThreatIntelligenceMetricEntity(msrest.serialization.Model):
    """Describes threat intelligence metric entity.

    :ivar metric_name: Metric name.
    :vartype metric_name: str
    :ivar metric_value: Metric value.
    :vartype metric_value: int
    """

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_value': {'key': 'metricValue', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        metric_value: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword metric_name: Metric name.
        :paramtype metric_name: str
        :keyword metric_value: Metric value.
        :paramtype metric_value: int
        """
        super(ThreatIntelligenceMetricEntity, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.metric_value = metric_value


class ThreatIntelligenceMetrics(msrest.serialization.Model):
    """Threat intelligence metrics.

    :ivar properties: Threat intelligence metrics.
    :vartype properties: ~azure.mgmt.securityinsight.models.ThreatIntelligenceMetric
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ThreatIntelligenceMetric'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ThreatIntelligenceMetric"] = None,
        **kwargs
    ):
        """
        :keyword properties: Threat intelligence metrics.
        :paramtype properties: ~azure.mgmt.securityinsight.models.ThreatIntelligenceMetric
        """
        super(ThreatIntelligenceMetrics, self).__init__(**kwargs)
        self.properties = properties


class ThreatIntelligenceMetricsList(msrest.serialization.Model):
    """List of all the threat intelligence metric fields (type/threat type/source).

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Array of threat intelligence metric fields (type/threat type/source).
    :vartype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetrics]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ThreatIntelligenceMetrics]'},
    }

    def __init__(
        self,
        *,
        value: List["ThreatIntelligenceMetrics"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of threat intelligence metric fields (type/threat type/source).
        :paramtype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetrics]
        """
        super(ThreatIntelligenceMetricsList, self).__init__(**kwargs)
        self.value = value


class ThreatIntelligenceParsedPattern(msrest.serialization.Model):
    """Describes parsed pattern entity.

    :ivar pattern_type_key: Pattern type key.
    :vartype pattern_type_key: str
    :ivar pattern_type_values: Pattern type keys.
    :vartype pattern_type_values:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPatternTypeValue]
    """

    _attribute_map = {
        'pattern_type_key': {'key': 'patternTypeKey', 'type': 'str'},
        'pattern_type_values': {'key': 'patternTypeValues', 'type': '[ThreatIntelligenceParsedPatternTypeValue]'},
    }

    def __init__(
        self,
        *,
        pattern_type_key: Optional[str] = None,
        pattern_type_values: Optional[List["ThreatIntelligenceParsedPatternTypeValue"]] = None,
        **kwargs
    ):
        """
        :keyword pattern_type_key: Pattern type key.
        :paramtype pattern_type_key: str
        :keyword pattern_type_values: Pattern type keys.
        :paramtype pattern_type_values:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPatternTypeValue]
        """
        super(ThreatIntelligenceParsedPattern, self).__init__(**kwargs)
        self.pattern_type_key = pattern_type_key
        self.pattern_type_values = pattern_type_values


class ThreatIntelligenceParsedPatternTypeValue(msrest.serialization.Model):
    """Describes threat kill chain phase entity.

    :ivar value_type: Type of the value.
    :vartype value_type: str
    :ivar value: Value of parsed pattern.
    :vartype value: str
    """

    _attribute_map = {
        'value_type': {'key': 'valueType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value_type: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value_type: Type of the value.
        :paramtype value_type: str
        :keyword value: Value of parsed pattern.
        :paramtype value: str
        """
        super(ThreatIntelligenceParsedPatternTypeValue, self).__init__(**kwargs)
        self.value_type = value_type
        self.value = value


class ThreatIntelligenceSortingCriteria(msrest.serialization.Model):
    """List of available columns for sorting.

    :ivar item_key: Column name.
    :vartype item_key: str
    :ivar sort_order: Sorting order (ascending/descending/unsorted). Possible values include:
     "unsorted", "ascending", "descending".
    :vartype sort_order: str or
     ~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteriaEnum
    """

    _attribute_map = {
        'item_key': {'key': 'itemKey', 'type': 'str'},
        'sort_order': {'key': 'sortOrder', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        item_key: Optional[str] = None,
        sort_order: Optional[Union[str, "ThreatIntelligenceSortingCriteriaEnum"]] = None,
        **kwargs
    ):
        """
        :keyword item_key: Column name.
        :paramtype item_key: str
        :keyword sort_order: Sorting order (ascending/descending/unsorted). Possible values include:
         "unsorted", "ascending", "descending".
        :paramtype sort_order: str or
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteriaEnum
        """
        super(ThreatIntelligenceSortingCriteria, self).__init__(**kwargs)
        self.item_key = item_key
        self.sort_order = sort_order


class TICheckRequirements(DataConnectorsCheckRequirements):
    """Threat Intelligence Platforms data connector check requirements.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(TICheckRequirements, self).__init__(**kwargs)
        self.kind = 'ThreatIntelligence'  # type: str
        self.tenant_id = tenant_id


class TICheckRequirementsProperties(DataConnectorTenantId):
    """Threat Intelligence Platforms data connector required properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(TICheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class TIDataConnector(DataConnector):
    """Represents threat intelligence data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar tip_lookback_period: The lookback period for the feed to be imported.
    :vartype tip_lookback_period: ~datetime.datetime
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'tip_lookback_period': {'key': 'properties.tipLookbackPeriod', 'type': 'iso-8601'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'TIDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        tip_lookback_period: Optional[datetime.datetime] = None,
        data_types: Optional["TIDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword tip_lookback_period: The lookback period for the feed to be imported.
        :paramtype tip_lookback_period: ~datetime.datetime
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypes
        """
        super(TIDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'ThreatIntelligence'  # type: str
        self.tenant_id = tenant_id
        self.tip_lookback_period = tip_lookback_period
        self.data_types = data_types


class TIDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for TI (Threat Intelligence) data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar indicators: Required. Data type for indicators connection.
    :vartype indicators: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypesIndicators
    """

    _validation = {
        'indicators': {'required': True},
    }

    _attribute_map = {
        'indicators': {'key': 'indicators', 'type': 'TIDataConnectorDataTypesIndicators'},
    }

    def __init__(
        self,
        *,
        indicators: "TIDataConnectorDataTypesIndicators",
        **kwargs
    ):
        """
        :keyword indicators: Required. Data type for indicators connection.
        :paramtype indicators: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypesIndicators
        """
        super(TIDataConnectorDataTypes, self).__init__(**kwargs)
        self.indicators = indicators


class TIDataConnectorDataTypesIndicators(DataConnectorDataTypeCommon):
    """Data type for indicators connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(TIDataConnectorDataTypesIndicators, self).__init__(state=state, **kwargs)


class TIDataConnectorProperties(DataConnectorTenantId):
    """TI (Threat Intelligence) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar tip_lookback_period: The lookback period for the feed to be imported.
    :vartype tip_lookback_period: ~datetime.datetime
    :ivar data_types: Required. The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'tip_lookback_period': {'key': 'tipLookbackPeriod', 'type': 'iso-8601'},
        'data_types': {'key': 'dataTypes', 'type': 'TIDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        data_types: "TIDataConnectorDataTypes",
        tip_lookback_period: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword tip_lookback_period: The lookback period for the feed to be imported.
        :paramtype tip_lookback_period: ~datetime.datetime
        :keyword data_types: Required. The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypes
        """
        super(TIDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.tip_lookback_period = tip_lookback_period
        self.data_types = data_types


class TimelineAggregation(msrest.serialization.Model):
    """timeline aggregation information per kind.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. the total items found for a kind.
    :vartype count: int
    :ivar kind: Required. the query kind. Possible values include: "Activity", "Bookmark",
     "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    """

    _validation = {
        'count': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: int,
        kind: Union[str, "EntityTimelineKind"],
        **kwargs
    ):
        """
        :keyword count: Required. the total items found for a kind.
        :paramtype count: int
        :keyword kind: Required. the query kind. Possible values include: "Activity", "Bookmark",
         "SecurityAlert".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
        """
        super(TimelineAggregation, self).__init__(**kwargs)
        self.count = count
        self.kind = kind


class TimelineError(msrest.serialization.Model):
    """Timeline Query Errors.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. the query kind. Possible values include: "Activity", "Bookmark",
     "SecurityAlert".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar query_id: the query id.
    :vartype query_id: str
    :ivar error_message: Required. the error message.
    :vartype error_message: str
    """

    _validation = {
        'kind': {'required': True},
        'error_message': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'query_id': {'key': 'queryId', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "EntityTimelineKind"],
        error_message: str,
        query_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Required. the query kind. Possible values include: "Activity", "Bookmark",
         "SecurityAlert".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
        :keyword query_id: the query id.
        :paramtype query_id: str
        :keyword error_message: Required. the error message.
        :paramtype error_message: str
        """
        super(TimelineError, self).__init__(**kwargs)
        self.kind = kind
        self.query_id = query_id
        self.error_message = error_message


class TimelineResultsMetadata(msrest.serialization.Model):
    """Expansion result metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar total_count: Required. the total items found for the timeline request.
    :vartype total_count: int
    :ivar aggregations: Required. timeline aggregation per kind.
    :vartype aggregations: list[~azure.mgmt.securityinsight.models.TimelineAggregation]
    :ivar errors: information about the failure queries.
    :vartype errors: list[~azure.mgmt.securityinsight.models.TimelineError]
    """

    _validation = {
        'total_count': {'required': True},
        'aggregations': {'required': True},
    }

    _attribute_map = {
        'total_count': {'key': 'totalCount', 'type': 'int'},
        'aggregations': {'key': 'aggregations', 'type': '[TimelineAggregation]'},
        'errors': {'key': 'errors', 'type': '[TimelineError]'},
    }

    def __init__(
        self,
        *,
        total_count: int,
        aggregations: List["TimelineAggregation"],
        errors: Optional[List["TimelineError"]] = None,
        **kwargs
    ):
        """
        :keyword total_count: Required. the total items found for the timeline request.
        :paramtype total_count: int
        :keyword aggregations: Required. timeline aggregation per kind.
        :paramtype aggregations: list[~azure.mgmt.securityinsight.models.TimelineAggregation]
        :keyword errors: information about the failure queries.
        :paramtype errors: list[~azure.mgmt.securityinsight.models.TimelineError]
        """
        super(TimelineResultsMetadata, self).__init__(**kwargs)
        self.total_count = total_count
        self.aggregations = aggregations
        self.errors = errors


class TiTaxiiCheckRequirements(DataConnectorsCheckRequirements):
    """Threat Intelligence TAXII data connector check requirements.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Describes the kind of connector to be checked.Constant filled by server.
     Possible values include: "AzureActiveDirectory", "AzureSecurityCenter",
     "MicrosoftCloudAppSecurity", "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365",
     "OfficeATP", "OfficeIRM", "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail",
     "AmazonWebServicesS3", "AzureAdvancedThreatProtection",
     "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365", "MicrosoftThreatProtection",
     "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(TiTaxiiCheckRequirements, self).__init__(**kwargs)
        self.kind = 'ThreatIntelligenceTaxii'  # type: str
        self.tenant_id = tenant_id


class TiTaxiiCheckRequirementsProperties(DataConnectorTenantId):
    """Threat Intelligence TAXII data connector required properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super(TiTaxiiCheckRequirementsProperties, self).__init__(tenant_id=tenant_id, **kwargs)


class TiTaxiiDataConnector(DataConnector):
    """Data connector to pull Threat intelligence data from TAXII 2.0/2.1 server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The data connector kind.Constant filled by server. Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar workspace_id: The workspace id.
    :vartype workspace_id: str
    :ivar friendly_name: The friendly name for the TAXII server.
    :vartype friendly_name: str
    :ivar taxii_server: The API root for the TAXII server.
    :vartype taxii_server: str
    :ivar collection_id: The collection id of the TAXII server.
    :vartype collection_id: str
    :ivar user_name: The userName for the TAXII server.
    :vartype user_name: str
    :ivar password: The password for the TAXII server.
    :vartype password: str
    :ivar taxii_lookback_period: The lookback period for the TAXII server.
    :vartype taxii_lookback_period: ~datetime.datetime
    :ivar polling_frequency: The polling frequency for the TAXII server. Possible values include:
     "OnceAMinute", "OnceAnHour", "OnceADay".
    :vartype polling_frequency: str or ~azure.mgmt.securityinsight.models.PollingFrequency
    :ivar data_types: The available data types for Threat Intelligence TAXII data connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'taxii_server': {'key': 'properties.taxiiServer', 'type': 'str'},
        'collection_id': {'key': 'properties.collectionId', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'taxii_lookback_period': {'key': 'properties.taxiiLookbackPeriod', 'type': 'iso-8601'},
        'polling_frequency': {'key': 'properties.pollingFrequency', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'TiTaxiiDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        workspace_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        taxii_server: Optional[str] = None,
        collection_id: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        taxii_lookback_period: Optional[datetime.datetime] = None,
        polling_frequency: Optional[Union[str, "PollingFrequency"]] = None,
        data_types: Optional["TiTaxiiDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword workspace_id: The workspace id.
        :paramtype workspace_id: str
        :keyword friendly_name: The friendly name for the TAXII server.
        :paramtype friendly_name: str
        :keyword taxii_server: The API root for the TAXII server.
        :paramtype taxii_server: str
        :keyword collection_id: The collection id of the TAXII server.
        :paramtype collection_id: str
        :keyword user_name: The userName for the TAXII server.
        :paramtype user_name: str
        :keyword password: The password for the TAXII server.
        :paramtype password: str
        :keyword taxii_lookback_period: The lookback period for the TAXII server.
        :paramtype taxii_lookback_period: ~datetime.datetime
        :keyword polling_frequency: The polling frequency for the TAXII server. Possible values
         include: "OnceAMinute", "OnceAnHour", "OnceADay".
        :paramtype polling_frequency: str or ~azure.mgmt.securityinsight.models.PollingFrequency
        :keyword data_types: The available data types for Threat Intelligence TAXII data connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypes
        """
        super(TiTaxiiDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'ThreatIntelligenceTaxii'  # type: str
        self.tenant_id = tenant_id
        self.workspace_id = workspace_id
        self.friendly_name = friendly_name
        self.taxii_server = taxii_server
        self.collection_id = collection_id
        self.user_name = user_name
        self.password = password
        self.taxii_lookback_period = taxii_lookback_period
        self.polling_frequency = polling_frequency
        self.data_types = data_types


class TiTaxiiDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Threat Intelligence TAXII data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar taxii_client: Required. Data type for TAXII connector.
    :vartype taxii_client:
     ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypesTaxiiClient
    """

    _validation = {
        'taxii_client': {'required': True},
    }

    _attribute_map = {
        'taxii_client': {'key': 'taxiiClient', 'type': 'TiTaxiiDataConnectorDataTypesTaxiiClient'},
    }

    def __init__(
        self,
        *,
        taxii_client: "TiTaxiiDataConnectorDataTypesTaxiiClient",
        **kwargs
    ):
        """
        :keyword taxii_client: Required. Data type for TAXII connector.
        :paramtype taxii_client:
         ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypesTaxiiClient
        """
        super(TiTaxiiDataConnectorDataTypes, self).__init__(**kwargs)
        self.taxii_client = taxii_client


class TiTaxiiDataConnectorDataTypesTaxiiClient(DataConnectorDataTypeCommon):
    """Data type for TAXII connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. Describe whether this data type connection is enabled or not. Possible
     values include: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "DataTypeState"],
        **kwargs
    ):
        """
        :keyword state: Required. Describe whether this data type connection is enabled or not.
         Possible values include: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super(TiTaxiiDataConnectorDataTypesTaxiiClient, self).__init__(state=state, **kwargs)


class TiTaxiiDataConnectorProperties(DataConnectorTenantId):
    """Threat Intelligence TAXII data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required. The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar workspace_id: The workspace id.
    :vartype workspace_id: str
    :ivar friendly_name: The friendly name for the TAXII server.
    :vartype friendly_name: str
    :ivar taxii_server: The API root for the TAXII server.
    :vartype taxii_server: str
    :ivar collection_id: The collection id of the TAXII server.
    :vartype collection_id: str
    :ivar user_name: The userName for the TAXII server.
    :vartype user_name: str
    :ivar password: The password for the TAXII server.
    :vartype password: str
    :ivar taxii_lookback_period: The lookback period for the TAXII server.
    :vartype taxii_lookback_period: ~datetime.datetime
    :ivar polling_frequency: Required. The polling frequency for the TAXII server. Possible values
     include: "OnceAMinute", "OnceAnHour", "OnceADay".
    :vartype polling_frequency: str or ~azure.mgmt.securityinsight.models.PollingFrequency
    :ivar data_types: Required. The available data types for Threat Intelligence TAXII data
     connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypes
    """

    _validation = {
        'tenant_id': {'required': True},
        'polling_frequency': {'required': True},
        'data_types': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'taxii_server': {'key': 'taxiiServer', 'type': 'str'},
        'collection_id': {'key': 'collectionId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'taxii_lookback_period': {'key': 'taxiiLookbackPeriod', 'type': 'iso-8601'},
        'polling_frequency': {'key': 'pollingFrequency', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': 'TiTaxiiDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        polling_frequency: Union[str, "PollingFrequency"],
        data_types: "TiTaxiiDataConnectorDataTypes",
        workspace_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        taxii_server: Optional[str] = None,
        collection_id: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        taxii_lookback_period: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: Required. The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword workspace_id: The workspace id.
        :paramtype workspace_id: str
        :keyword friendly_name: The friendly name for the TAXII server.
        :paramtype friendly_name: str
        :keyword taxii_server: The API root for the TAXII server.
        :paramtype taxii_server: str
        :keyword collection_id: The collection id of the TAXII server.
        :paramtype collection_id: str
        :keyword user_name: The userName for the TAXII server.
        :paramtype user_name: str
        :keyword password: The password for the TAXII server.
        :paramtype password: str
        :keyword taxii_lookback_period: The lookback period for the TAXII server.
        :paramtype taxii_lookback_period: ~datetime.datetime
        :keyword polling_frequency: Required. The polling frequency for the TAXII server. Possible
         values include: "OnceAMinute", "OnceAnHour", "OnceADay".
        :paramtype polling_frequency: str or ~azure.mgmt.securityinsight.models.PollingFrequency
        :keyword data_types: Required. The available data types for Threat Intelligence TAXII data
         connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.TiTaxiiDataConnectorDataTypes
        """
        super(TiTaxiiDataConnectorProperties, self).__init__(tenant_id=tenant_id, **kwargs)
        self.workspace_id = workspace_id
        self.friendly_name = friendly_name
        self.taxii_server = taxii_server
        self.collection_id = collection_id
        self.user_name = user_name
        self.password = password
        self.taxii_lookback_period = taxii_lookback_period
        self.polling_frequency = polling_frequency
        self.data_types = data_types


class Ueba(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: Required. The kind of the setting.Constant filled by server. Possible values
     include: "Anomalies", "EyesOn", "EntityAnalytics", "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar data_sources: The relevant data sources that enriched by ueba.
    :vartype data_sources: list[str or ~azure.mgmt.securityinsight.models.UebaDataSources]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_sources: Optional[List[Union[str, "UebaDataSources"]]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_sources: The relevant data sources that enriched by ueba.
        :paramtype data_sources: list[str or ~azure.mgmt.securityinsight.models.UebaDataSources]
        """
        super(Ueba, self).__init__(etag=etag, **kwargs)
        self.kind = 'Ueba'  # type: str
        self.data_sources = data_sources


class UrlEntity(Entity):
    """Represents a url entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: Required. The kind of the entity.Constant filled by server. Possible values
     include: "Account", "Host", "File", "AzureResource", "CloudApplication", "DnsResolution",
     "FileHash", "Ip", "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url",
     "IoTDevice", "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox",
     "SubmissionMail".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar url: A full URL the entity points to.
    :vartype url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UrlEntity, self).__init__(**kwargs)
        self.kind = 'Url'  # type: str
        self.additional_data = None
        self.friendly_name = None
        self.url = None


class UrlEntityProperties(EntityCommonProperties):
    """Url entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar url: A full URL the entity points to.
    :vartype url: str
    """

    _validation = {
        'additional_data': {'readonly': True},
        'friendly_name': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        'additional_data': {'key': 'additionalData', 'type': '{object}'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UrlEntityProperties, self).__init__(**kwargs)
        self.url = None


class UserInfo(msrest.serialization.Model):
    """User information that made some action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar email: The email of the user.
    :vartype email: str
    :ivar name: The name of the user.
    :vartype name: str
    :ivar object_id: The object id of the user.
    :vartype object_id: str
    """

    _validation = {
        'email': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword object_id: The object id of the user.
        :paramtype object_id: str
        """
        super(UserInfo, self).__init__(**kwargs)
        self.email = None
        self.name = None
        self.object_id = object_id


class Watchlist(ResourceWithEtag):
    """Represents a Watchlist in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar watchlist_id: The id (a Guid) of the watchlist.
    :vartype watchlist_id: str
    :ivar display_name: The display name of the watchlist.
    :vartype display_name: str
    :ivar provider: The provider of the watchlist.
    :vartype provider: str
    :ivar source: The filename of the watchlist, called 'source'.
    :vartype source: str
    :ivar source_type: The sourceType of the watchlist. Possible values include: "Local file",
     "Remote storage".
    :vartype source_type: str or ~azure.mgmt.securityinsight.models.SourceType
    :ivar created: The time the watchlist was created.
    :vartype created: ~datetime.datetime
    :ivar updated: The last time the watchlist was updated.
    :vartype updated: ~datetime.datetime
    :ivar created_by: Describes a user that created the watchlist.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar updated_by: Describes a user that updated the watchlist.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar description: A description of the watchlist.
    :vartype description: str
    :ivar watchlist_type: The type of the watchlist.
    :vartype watchlist_type: str
    :ivar watchlist_alias: The alias of the watchlist.
    :vartype watchlist_alias: str
    :ivar is_deleted: A flag that indicates if the watchlist is deleted or not.
    :vartype is_deleted: bool
    :ivar labels: List of labels relevant to this watchlist.
    :vartype labels: list[str]
    :ivar default_duration: The default duration of a watchlist (in ISO 8601 duration format).
    :vartype default_duration: ~datetime.timedelta
    :ivar tenant_id: The tenantId where the watchlist belongs to.
    :vartype tenant_id: str
    :ivar number_of_lines_to_skip: The number of lines in a csv/tsv content to skip before the
     header.
    :vartype number_of_lines_to_skip: int
    :ivar raw_content: The raw content that represents to watchlist items to create. In case of
     csv/tsv content type, it's the content of the file that will parsed by the endpoint.
    :vartype raw_content: str
    :ivar items_search_key: The search key is used to optimize query performance when using
     watchlists for joins with other data. For example, enable a column with IP addresses to be the
     designated SearchKey field, then use this field as the key field when joining to other event
     data by IP address.
    :vartype items_search_key: str
    :ivar content_type: The content type of the raw content. Example : text/csv or text/tsv.
    :vartype content_type: str
    :ivar upload_status: The status of the Watchlist upload : New, InProgress or Complete. Pls note
     : When a Watchlist upload status is equal to InProgress, the Watchlist cannot be deleted.
    :vartype upload_status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'watchlist_id': {'key': 'properties.watchlistId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'UserInfo'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'UserInfo'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'watchlist_type': {'key': 'properties.watchlistType', 'type': 'str'},
        'watchlist_alias': {'key': 'properties.watchlistAlias', 'type': 'str'},
        'is_deleted': {'key': 'properties.isDeleted', 'type': 'bool'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'default_duration': {'key': 'properties.defaultDuration', 'type': 'duration'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'number_of_lines_to_skip': {'key': 'properties.numberOfLinesToSkip', 'type': 'int'},
        'raw_content': {'key': 'properties.rawContent', 'type': 'str'},
        'items_search_key': {'key': 'properties.itemsSearchKey', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'upload_status': {'key': 'properties.uploadStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        watchlist_id: Optional[str] = None,
        display_name: Optional[str] = None,
        provider: Optional[str] = None,
        source: Optional[str] = None,
        source_type: Optional[Union[str, "SourceType"]] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        updated_by: Optional["UserInfo"] = None,
        description: Optional[str] = None,
        watchlist_type: Optional[str] = None,
        watchlist_alias: Optional[str] = None,
        is_deleted: Optional[bool] = None,
        labels: Optional[List[str]] = None,
        default_duration: Optional[datetime.timedelta] = None,
        tenant_id: Optional[str] = None,
        number_of_lines_to_skip: Optional[int] = None,
        raw_content: Optional[str] = None,
        items_search_key: Optional[str] = None,
        content_type: Optional[str] = None,
        upload_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword watchlist_id: The id (a Guid) of the watchlist.
        :paramtype watchlist_id: str
        :keyword display_name: The display name of the watchlist.
        :paramtype display_name: str
        :keyword provider: The provider of the watchlist.
        :paramtype provider: str
        :keyword source: The filename of the watchlist, called 'source'.
        :paramtype source: str
        :keyword source_type: The sourceType of the watchlist. Possible values include: "Local file",
         "Remote storage".
        :paramtype source_type: str or ~azure.mgmt.securityinsight.models.SourceType
        :keyword created: The time the watchlist was created.
        :paramtype created: ~datetime.datetime
        :keyword updated: The last time the watchlist was updated.
        :paramtype updated: ~datetime.datetime
        :keyword created_by: Describes a user that created the watchlist.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword updated_by: Describes a user that updated the watchlist.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword description: A description of the watchlist.
        :paramtype description: str
        :keyword watchlist_type: The type of the watchlist.
        :paramtype watchlist_type: str
        :keyword watchlist_alias: The alias of the watchlist.
        :paramtype watchlist_alias: str
        :keyword is_deleted: A flag that indicates if the watchlist is deleted or not.
        :paramtype is_deleted: bool
        :keyword labels: List of labels relevant to this watchlist.
        :paramtype labels: list[str]
        :keyword default_duration: The default duration of a watchlist (in ISO 8601 duration format).
        :paramtype default_duration: ~datetime.timedelta
        :keyword tenant_id: The tenantId where the watchlist belongs to.
        :paramtype tenant_id: str
        :keyword number_of_lines_to_skip: The number of lines in a csv/tsv content to skip before the
         header.
        :paramtype number_of_lines_to_skip: int
        :keyword raw_content: The raw content that represents to watchlist items to create. In case of
         csv/tsv content type, it's the content of the file that will parsed by the endpoint.
        :paramtype raw_content: str
        :keyword items_search_key: The search key is used to optimize query performance when using
         watchlists for joins with other data. For example, enable a column with IP addresses to be the
         designated SearchKey field, then use this field as the key field when joining to other event
         data by IP address.
        :paramtype items_search_key: str
        :keyword content_type: The content type of the raw content. Example : text/csv or text/tsv.
        :paramtype content_type: str
        :keyword upload_status: The status of the Watchlist upload : New, InProgress or Complete. Pls
         note : When a Watchlist upload status is equal to InProgress, the Watchlist cannot be deleted.
        :paramtype upload_status: str
        """
        super(Watchlist, self).__init__(etag=etag, **kwargs)
        self.watchlist_id = watchlist_id
        self.display_name = display_name
        self.provider = provider
        self.source = source
        self.source_type = source_type
        self.created = created
        self.updated = updated
        self.created_by = created_by
        self.updated_by = updated_by
        self.description = description
        self.watchlist_type = watchlist_type
        self.watchlist_alias = watchlist_alias
        self.is_deleted = is_deleted
        self.labels = labels
        self.default_duration = default_duration
        self.tenant_id = tenant_id
        self.number_of_lines_to_skip = number_of_lines_to_skip
        self.raw_content = raw_content
        self.items_search_key = items_search_key
        self.content_type = content_type
        self.upload_status = upload_status


class WatchlistItem(ResourceWithEtag):
    """Represents a Watchlist item in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar watchlist_item_type: The type of the watchlist item.
    :vartype watchlist_item_type: str
    :ivar watchlist_item_id: The id (a Guid) of the watchlist item.
    :vartype watchlist_item_id: str
    :ivar tenant_id: The tenantId to which the watchlist item belongs to.
    :vartype tenant_id: str
    :ivar is_deleted: A flag that indicates if the watchlist item is deleted or not.
    :vartype is_deleted: bool
    :ivar created: The time the watchlist item was created.
    :vartype created: ~datetime.datetime
    :ivar updated: The last time the watchlist item was updated.
    :vartype updated: ~datetime.datetime
    :ivar created_by: Describes a user that created the watchlist item.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar updated_by: Describes a user that updated the watchlist item.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar items_key_value: key-value pairs for a watchlist item.
    :vartype items_key_value: any
    :ivar entity_mapping: key-value pairs for a watchlist item entity mapping.
    :vartype entity_mapping: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'watchlist_item_type': {'key': 'properties.watchlistItemType', 'type': 'str'},
        'watchlist_item_id': {'key': 'properties.watchlistItemId', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'is_deleted': {'key': 'properties.isDeleted', 'type': 'bool'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'UserInfo'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'UserInfo'},
        'items_key_value': {'key': 'properties.itemsKeyValue', 'type': 'object'},
        'entity_mapping': {'key': 'properties.entityMapping', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        watchlist_item_type: Optional[str] = None,
        watchlist_item_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        is_deleted: Optional[bool] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        updated_by: Optional["UserInfo"] = None,
        items_key_value: Optional[Any] = None,
        entity_mapping: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword watchlist_item_type: The type of the watchlist item.
        :paramtype watchlist_item_type: str
        :keyword watchlist_item_id: The id (a Guid) of the watchlist item.
        :paramtype watchlist_item_id: str
        :keyword tenant_id: The tenantId to which the watchlist item belongs to.
        :paramtype tenant_id: str
        :keyword is_deleted: A flag that indicates if the watchlist item is deleted or not.
        :paramtype is_deleted: bool
        :keyword created: The time the watchlist item was created.
        :paramtype created: ~datetime.datetime
        :keyword updated: The last time the watchlist item was updated.
        :paramtype updated: ~datetime.datetime
        :keyword created_by: Describes a user that created the watchlist item.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword updated_by: Describes a user that updated the watchlist item.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword items_key_value: key-value pairs for a watchlist item.
        :paramtype items_key_value: any
        :keyword entity_mapping: key-value pairs for a watchlist item entity mapping.
        :paramtype entity_mapping: any
        """
        super(WatchlistItem, self).__init__(etag=etag, **kwargs)
        self.watchlist_item_type = watchlist_item_type
        self.watchlist_item_id = watchlist_item_id
        self.tenant_id = tenant_id
        self.is_deleted = is_deleted
        self.created = created
        self.updated = updated
        self.created_by = created_by
        self.updated_by = updated_by
        self.items_key_value = items_key_value
        self.entity_mapping = entity_mapping


class WatchlistItemList(msrest.serialization.Model):
    """List all the watchlist items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of watchlist item.
    :vartype next_link: str
    :ivar value: Required. Array of watchlist items.
    :vartype value: list[~azure.mgmt.securityinsight.models.WatchlistItem]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[WatchlistItem]'},
    }

    def __init__(
        self,
        *,
        value: List["WatchlistItem"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of watchlist items.
        :paramtype value: list[~azure.mgmt.securityinsight.models.WatchlistItem]
        """
        super(WatchlistItemList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class WatchlistList(msrest.serialization.Model):
    """List all the watchlists.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of watchlists.
    :vartype next_link: str
    :ivar value: Required. Array of watchlist.
    :vartype value: list[~azure.mgmt.securityinsight.models.Watchlist]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Watchlist]'},
    }

    def __init__(
        self,
        *,
        value: List["Watchlist"],
        **kwargs
    ):
        """
        :keyword value: Required. Array of watchlist.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Watchlist]
        """
        super(WatchlistList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class Webhook(msrest.serialization.Model):
    """Detail about the webhook object.

    :ivar webhook_id: Unique identifier for the webhook.
    :vartype webhook_id: str
    :ivar webhook_url: URL that gets invoked by the webhook.
    :vartype webhook_url: str
    :ivar webhook_secret_update_time: Time when the webhook secret was updated.
    :vartype webhook_secret_update_time: str
    :ivar rotate_webhook_secret: A flag to instruct the backend service to rotate webhook secret.
    :vartype rotate_webhook_secret: bool
    """

    _attribute_map = {
        'webhook_id': {'key': 'webhookId', 'type': 'str'},
        'webhook_url': {'key': 'webhookUrl', 'type': 'str'},
        'webhook_secret_update_time': {'key': 'webhookSecretUpdateTime', 'type': 'str'},
        'rotate_webhook_secret': {'key': 'rotateWebhookSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        webhook_id: Optional[str] = None,
        webhook_url: Optional[str] = None,
        webhook_secret_update_time: Optional[str] = None,
        rotate_webhook_secret: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword webhook_id: Unique identifier for the webhook.
        :paramtype webhook_id: str
        :keyword webhook_url: URL that gets invoked by the webhook.
        :paramtype webhook_url: str
        :keyword webhook_secret_update_time: Time when the webhook secret was updated.
        :paramtype webhook_secret_update_time: str
        :keyword rotate_webhook_secret: A flag to instruct the backend service to rotate webhook
         secret.
        :paramtype rotate_webhook_secret: bool
        """
        super(Webhook, self).__init__(**kwargs)
        self.webhook_id = webhook_id
        self.webhook_url = webhook_url
        self.webhook_secret_update_time = webhook_secret_update_time
        self.rotate_webhook_secret = rotate_webhook_secret
