# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class PolicyStatesOperations(object):
    """PolicyStatesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.policyinsights.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def list_query_results_for_management_group(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        management_group_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the resources under the management group.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param management_group_name: Management group name.
        :type management_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        management_groups_namespace = "Microsoft.Management"
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_management_group.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'managementGroupsNamespace': self._serialize.url("management_groups_namespace", management_groups_namespace, 'str'),
                    'managementGroupName': self._serialize.url("management_group_name", management_group_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_management_group(
        self,
        management_group_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the resources under the management group.

        :param management_group_name: Management group name.
        :type management_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        management_groups_namespace = "Microsoft.Management"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_management_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'managementGroupsNamespace': self._serialize.url("management_groups_namespace", management_groups_namespace, 'str'),
            'managementGroupName': self._serialize.url("management_group_name", management_group_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_subscription(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the resources under the subscription.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_subscription.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_subscription(
        self,
        subscription_id,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the resources under the subscription.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_subscription.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_resource_group(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        resource_group_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the resources under the resource group.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_resource_group.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_resource_group(
        self,
        subscription_id,  # type: str
        resource_group_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the resources under the resource group.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_resource_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_resource(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        resource_id,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the resource.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _expand = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _expand = query_options.expand
            _skip_token = query_options.skip_token
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_resource.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", _expand, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_resource(
        self,
        resource_id,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the resource.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_resource.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def _trigger_subscription_evaluation_initial(
        self,
        subscription_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self._trigger_subscription_evaluation_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _trigger_subscription_evaluation_initial.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation'}  # type: ignore

    def begin_trigger_subscription_evaluation(
        self,
        subscription_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Triggers a policy evaluation scan for all the resources under the subscription.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._trigger_subscription_evaluation_initial(
                subscription_id=subscription_id,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_trigger_subscription_evaluation.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation'}  # type: ignore

    def _trigger_resource_group_evaluation_initial(
        self,
        subscription_id,  # type: str
        resource_group_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self._trigger_resource_group_evaluation_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _trigger_resource_group_evaluation_initial.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation'}  # type: ignore

    def begin_trigger_resource_group_evaluation(
        self,
        subscription_id,  # type: str
        resource_group_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Triggers a policy evaluation scan for all the resources under the resource group.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._trigger_resource_group_evaluation_initial(
                subscription_id=subscription_id,
                resource_group_name=resource_group_name,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_trigger_resource_group_evaluation.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation'}  # type: ignore

    def list_query_results_for_policy_set_definition(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        policy_set_definition_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the subscription level policy set definition.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name.
        :type policy_set_definition_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_policy_set_definition.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
                    'policySetDefinitionName': self._serialize.url("policy_set_definition_name", policy_set_definition_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_policy_set_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_policy_set_definition(
        self,
        subscription_id,  # type: str
        policy_set_definition_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the subscription level policy set definition.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name.
        :type policy_set_definition_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_policy_set_definition.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
            'policySetDefinitionName': self._serialize.url("policy_set_definition_name", policy_set_definition_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_policy_set_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_policy_definition(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        policy_definition_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the subscription level policy definition.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name.
        :type policy_definition_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_policy_definition.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
                    'policyDefinitionName': self._serialize.url("policy_definition_name", policy_definition_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_policy_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_policy_definition(
        self,
        subscription_id,  # type: str
        policy_definition_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the subscription level policy definition.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name.
        :type policy_definition_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_policy_definition.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
            'policyDefinitionName': self._serialize.url("policy_definition_name", policy_definition_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_policy_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_subscription_level_policy_assignment(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        policy_assignment_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the subscription level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_subscription_level_policy_assignment.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
                    'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_subscription_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_subscription_level_policy_assignment(
        self,
        subscription_id,  # type: str
        policy_assignment_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the subscription level policy assignment.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_subscription_level_policy_assignment.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_subscription_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore

    def list_query_results_for_resource_group_level_policy_assignment(
        self,
        policy_states_resource,  # type: Union[str, "_models.PolicyStatesResource"]
        subscription_id,  # type: str
        resource_group_name,  # type: str
        policy_assignment_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PolicyStatesQueryResults"]
        """Queries policy states for the resource group level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s).
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyStatesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyStatesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyStatesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _order_by = None
        _select = None
        _from_property = None
        _to = None
        _filter = None
        _apply = None
        _skip_token = None
        if query_options is not None:
            _top = query_options.top
            _order_by = query_options.order_by
            _select = query_options.select
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
            _apply = query_options.apply
            _skip_token = query_options.skip_token
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_resource_group_level_policy_assignment.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
                    'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
                    'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _order_by is not None:
                    query_parameters['$orderby'] = self._serialize.query("order_by", _order_by, 'str')
                if _select is not None:
                    query_parameters['$select'] = self._serialize.query("select", _select, 'str')
                if _from_property is not None:
                    query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
                if _to is not None:
                    query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                if _apply is not None:
                    query_parameters['$apply'] = self._serialize.query("apply", _apply, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = '{nextLink}'
                path_format_arguments = {
                    'nextLink': self._serialize.url("next_link", next_link, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if _skip_token is not None:
                    query_parameters['$skiptoken'] = self._serialize.query("skip_token", _skip_token, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyStatesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_resource_group_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}  # type: ignore

    def summarize_for_resource_group_level_policy_assignment(
        self,
        subscription_id,  # type: str
        resource_group_name,  # type: str
        policy_assignment_name,  # type: str
        query_options=None,  # type: Optional["_models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SummarizeResults"
        """Summarizes policy states for the resource group level policy assignment.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SummarizeResults, or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SummarizeResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _from_property = query_options.from_property
            _to = query_options.to
            _filter = query_options.filter
        policy_states_summary_resource = "latest"
        authorization_namespace = "Microsoft.Authorization"
        api_version = "2019-10-01"
        accept = "application/json"

        # Construct URL
        url = self.summarize_for_resource_group_level_policy_assignment.metadata['url']  # type: ignore
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("policy_states_summary_resource", policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'authorizationNamespace': self._serialize.url("authorization_namespace", authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if _top is not None:
            query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
        if _from_property is not None:
            query_parameters['$from'] = self._serialize.query("from_property", _from_property, 'iso-8601')
        if _to is not None:
            query_parameters['$to'] = self._serialize.query("to", _to, 'iso-8601')
        if _filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SummarizeResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    summarize_for_resource_group_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}  # type: ignore
