# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._mobile_network_management_client_enums import *


class Ambr(msrest.serialization.Model):
    """Aggregate Maximum Bit Rate.

    All required parameters must be populated in order to send to Azure.

    :ivar uplink: Required. Uplink bit rate.
    :vartype uplink: str
    :ivar downlink: Required. Downlink bit rate.
    :vartype downlink: str
    """

    _validation = {
        'uplink': {'required': True, 'pattern': r'^\d+(\.\d+)? (bps|Kbps|Mbps|Gbps|Tbps)$'},
        'downlink': {'required': True, 'pattern': r'^\d+(\.\d+)? (bps|Kbps|Mbps|Gbps|Tbps)$'},
    }

    _attribute_map = {
        'uplink': {'key': 'uplink', 'type': 'str'},
        'downlink': {'key': 'downlink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uplink: str,
        downlink: str,
        **kwargs
    ):
        """
        :keyword uplink: Required. Uplink bit rate.
        :paramtype uplink: str
        :keyword downlink: Required. Downlink bit rate.
        :paramtype downlink: str
        """
        super(Ambr, self).__init__(**kwargs)
        self.uplink = uplink
        self.downlink = downlink


class Arp(msrest.serialization.Model):
    """Allocation and Retention Priority (ARP) parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar priority_level: Required. ARP priority level.
    :vartype priority_level: int
    :ivar preempt_cap: Required. ARP preemption capability. Possible values include: "NotPreempt",
     "MayPreempt".
    :vartype preempt_cap: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preempt_vuln: Required. ARP preemption vulnerability. Possible values include:
     "NotPreemptable", "Preemptable".
    :vartype preempt_vuln: str or ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    """

    _validation = {
        'priority_level': {'required': True, 'maximum': 15, 'minimum': 1},
        'preempt_cap': {'required': True},
        'preempt_vuln': {'required': True},
    }

    _attribute_map = {
        'priority_level': {'key': 'priorityLevel', 'type': 'int'},
        'preempt_cap': {'key': 'preemptCap', 'type': 'str'},
        'preempt_vuln': {'key': 'preemptVuln', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        priority_level: int,
        preempt_cap: Union[str, "PreemptionCapability"],
        preempt_vuln: Union[str, "PreemptionVulnerability"],
        **kwargs
    ):
        """
        :keyword priority_level: Required. ARP priority level.
        :paramtype priority_level: int
        :keyword preempt_cap: Required. ARP preemption capability. Possible values include:
         "NotPreempt", "MayPreempt".
        :paramtype preempt_cap: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preempt_vuln: Required. ARP preemption vulnerability. Possible values include:
         "NotPreemptable", "Preemptable".
        :paramtype preempt_vuln: str or ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        """
        super(Arp, self).__init__(**kwargs)
        self.priority_level = priority_level
        self.preempt_cap = preempt_cap
        self.preempt_vuln = preempt_vuln


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class AttachedDataNetwork(TrackedResource):
    """Attached data network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the attached data network resource.
     Possible values include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled",
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar user_plane_data_interface: Required. The user plane interface on the data network. In 5G
     networks this is called as N6 interface whereas in 4G networks this is called as SGi interface.
    :vartype user_plane_data_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    :ivar napt_configuration: The Network Address and Port Translation configuration.
     If not specified the attached data network uses a default NAPT configuration with NAPT
     enabled.
    :vartype napt_configuration: ~azure.mgmt.mobilenetwork.models.NaptConfiguration
    :ivar user_equipment_address_pool_prefix: The user equipment address pool prefixes for the
     attached data network that are dynamically assigned by the core to UEs when they set up a PDU
     session.
     At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
     be defined. If both are defined then they must be the same size.
    :vartype user_equipment_address_pool_prefix: list[str]
    :ivar user_equipment_static_address_pool_prefix: The user equipment address pool prefixes for
     the attached data network that are statically assigned by the core to UEs when they set up a
     PDU session.
     The mapping of static IP to sim is configured in staticIpConfiguration on the sim resource.
     At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
     be defined. If both are defined then they must be the same size.
    :vartype user_equipment_static_address_pool_prefix: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'user_plane_data_interface': {'required': True},
        'user_equipment_address_pool_prefix': {'min_items': 1, 'unique': True},
        'user_equipment_static_address_pool_prefix': {'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'user_plane_data_interface': {'key': 'properties.userPlaneDataInterface', 'type': 'InterfaceProperties'},
        'napt_configuration': {'key': 'properties.naptConfiguration', 'type': 'NaptConfiguration'},
        'user_equipment_address_pool_prefix': {'key': 'properties.userEquipmentAddressPoolPrefix', 'type': '[str]'},
        'user_equipment_static_address_pool_prefix': {'key': 'properties.userEquipmentStaticAddressPoolPrefix', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        user_plane_data_interface: "InterfaceProperties",
        tags: Optional[Dict[str, str]] = None,
        napt_configuration: Optional["NaptConfiguration"] = None,
        user_equipment_address_pool_prefix: Optional[List[str]] = None,
        user_equipment_static_address_pool_prefix: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword user_plane_data_interface: Required. The user plane interface on the data network. In
         5G networks this is called as N6 interface whereas in 4G networks this is called as SGi
         interface.
        :paramtype user_plane_data_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        :keyword napt_configuration: The Network Address and Port Translation configuration.
         If not specified the attached data network uses a default NAPT configuration with NAPT
         enabled.
        :paramtype napt_configuration: ~azure.mgmt.mobilenetwork.models.NaptConfiguration
        :keyword user_equipment_address_pool_prefix: The user equipment address pool prefixes for the
         attached data network that are dynamically assigned by the core to UEs when they set up a PDU
         session.
         At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
         be defined. If both are defined then they must be the same size.
        :paramtype user_equipment_address_pool_prefix: list[str]
        :keyword user_equipment_static_address_pool_prefix: The user equipment address pool prefixes
         for the attached data network that are statically assigned by the core to UEs when they set up
         a PDU session.
         The mapping of static IP to sim is configured in staticIpConfiguration on the sim resource.
         At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
         be defined. If both are defined then they must be the same size.
        :paramtype user_equipment_static_address_pool_prefix: list[str]
        """
        super(AttachedDataNetwork, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.user_plane_data_interface = user_plane_data_interface
        self.napt_configuration = napt_configuration
        self.user_equipment_address_pool_prefix = user_equipment_address_pool_prefix
        self.user_equipment_static_address_pool_prefix = user_equipment_static_address_pool_prefix


class AttachedDataNetworkListResult(msrest.serialization.Model):
    """Response for attached data network API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of data networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.AttachedDataNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AttachedDataNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AttachedDataNetwork"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of data networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.AttachedDataNetwork]
        """
        super(AttachedDataNetworkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AttachedDataNetworkResourceId(msrest.serialization.Model):
    """Reference to an Attached Data Network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Attached Data Network resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[pP][aA][cC][kK][eE][tT][cC][oO][rR][eE][cC][oO][nN][tT][rR][oO][lL][pP][lL][aA][nN][eE][sS]/[^/?#]+/[pP][aA][cC][kK][eE][tT][cC][oO][rR][eE][dD][aA][tT][aA][pP][lL][aA][nN][eE][sS]/[^/?#]+/[aA][tT][tT][aA][cC][hH][eE][dD][dD][aA][tT][aA][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Attached Data Network resource ID.
        :paramtype id: str
        """
        super(AttachedDataNetworkResourceId, self).__init__(**kwargs)
        self.id = id


class CustomLocationResourceId(msrest.serialization.Model):
    """Reference to an Azure ARC custom location resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Azure ARC custom location resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[eE][xX][tT][eE][nN][dD][eE][dD][lL][oO][cC][aA][tT][iI][oO][nN]/[cC][uU][sS][tT][oO][mM][lL][oO][cC][aA][tT][iI][oO][nN][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Azure ARC custom location resource ID.
        :paramtype id: str
        """
        super(CustomLocationResourceId, self).__init__(**kwargs)
        self.id = id


class DataNetwork(TrackedResource):
    """Data network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the data network resource. Possible values
     include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar description: An optional description for this data network.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword description: An optional description for this data network.
        :paramtype description: str
        """
        super(DataNetwork, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.description = description


class DataNetworkConfiguration(msrest.serialization.Model):
    """Settings controlling Data Network use.

    All required parameters must be populated in order to send to Azure.

    :ivar data_network: Required. A reference to the Data Network that these settings apply to.
    :vartype data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
    :ivar session_ambr: Required. Aggregate maximum bit rate across all non-GBR QoS flows of a
     given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the
     Session-AMBR.
    :vartype session_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar five_qi: Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS
     forwarding treatment to be provided to a flow. This must not be a standardized 5QI value
     selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66,
     67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full
     description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI
     values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: Default QoS Flow allocation and retention
     priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the
     settings of ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest
     level of priority. If this field is not specified then ``5qi`` is used to derive the ARP value.
     See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: Default QoS Flow preemption capability.  The Preemption Capability
     of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See
     3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values
     include: "NotPreempt", "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: Default QoS Flow preemption vulnerability.  The Preemption
     Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
     priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     Possible values include: "NotPreemptable", "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar default_session_type: The default PDU session type, which is used if the UE does not
     request a specific session type. Possible values include: "IPv4", "IPv6".
    :vartype default_session_type: str or ~azure.mgmt.mobilenetwork.models.PduSessionType
    :ivar additional_allowed_session_types: Allowed session types in addition to the default
     session type.  Must not duplicate the default session type.
    :vartype additional_allowed_session_types: list[str or
     ~azure.mgmt.mobilenetwork.models.PduSessionType]
    :ivar allowed_services: Required. List of Services that can be used as part of this Sim Policy.
     The list must not contain duplicate items and must contain at least one item.
    :vartype allowed_services: list[~azure.mgmt.mobilenetwork.models.ServiceResourceId]
    """

    _validation = {
        'data_network': {'required': True},
        'session_ambr': {'required': True},
        'five_qi': {'maximum': 127, 'minimum': 1},
        'allocation_and_retention_priority_level': {'maximum': 15, 'minimum': 1},
        'additional_allowed_session_types': {'max_items': 1, 'min_items': 0},
        'allowed_services': {'required': True, 'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'data_network': {'key': 'dataNetwork', 'type': 'DataNetworkResourceId'},
        'session_ambr': {'key': 'sessionAmbr', 'type': 'Ambr'},
        'five_qi': {'key': '5qi', 'type': 'int'},
        'allocation_and_retention_priority_level': {'key': 'allocationAndRetentionPriorityLevel', 'type': 'int'},
        'preemption_capability': {'key': 'preemptionCapability', 'type': 'str'},
        'preemption_vulnerability': {'key': 'preemptionVulnerability', 'type': 'str'},
        'default_session_type': {'key': 'defaultSessionType', 'type': 'str'},
        'additional_allowed_session_types': {'key': 'additionalAllowedSessionTypes', 'type': '[str]'},
        'allowed_services': {'key': 'allowedServices', 'type': '[ServiceResourceId]'},
    }

    def __init__(
        self,
        *,
        data_network: "DataNetworkResourceId",
        session_ambr: "Ambr",
        allowed_services: List["ServiceResourceId"],
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "PreemptionVulnerability"]] = None,
        default_session_type: Optional[Union[str, "PduSessionType"]] = None,
        additional_allowed_session_types: Optional[List[Union[str, "PduSessionType"]]] = None,
        **kwargs
    ):
        """
        :keyword data_network: Required. A reference to the Data Network that these settings apply to.
        :paramtype data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
        :keyword session_ambr: Required. Aggregate maximum bit rate across all non-GBR QoS flows of a
         given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the
         Session-AMBR.
        :paramtype session_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword five_qi: Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS
         forwarding treatment to be provided to a flow. This must not be a standardized 5QI value
         selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66,
         67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full
         description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI
         values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: Default QoS Flow allocation and retention
         priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the
         settings of ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest
         level of priority. If this field is not specified then ``5qi`` is used to derive the ARP value.
         See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: Default QoS Flow preemption capability.  The Preemption
         Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority
         level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible
         values include: "NotPreempt", "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: Default QoS Flow preemption vulnerability.  The Preemption
         Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Possible values include: "NotPreemptable", "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword default_session_type: The default PDU session type, which is used if the UE does not
         request a specific session type. Possible values include: "IPv4", "IPv6".
        :paramtype default_session_type: str or ~azure.mgmt.mobilenetwork.models.PduSessionType
        :keyword additional_allowed_session_types: Allowed session types in addition to the default
         session type.  Must not duplicate the default session type.
        :paramtype additional_allowed_session_types: list[str or
         ~azure.mgmt.mobilenetwork.models.PduSessionType]
        :keyword allowed_services: Required. List of Services that can be used as part of this Sim
         Policy. The list must not contain duplicate items and must contain at least one item.
        :paramtype allowed_services: list[~azure.mgmt.mobilenetwork.models.ServiceResourceId]
        """
        super(DataNetworkConfiguration, self).__init__(**kwargs)
        self.data_network = data_network
        self.session_ambr = session_ambr
        self.five_qi = five_qi
        self.allocation_and_retention_priority_level = allocation_and_retention_priority_level
        self.preemption_capability = preemption_capability
        self.preemption_vulnerability = preemption_vulnerability
        self.default_session_type = default_session_type
        self.additional_allowed_session_types = additional_allowed_session_types
        self.allowed_services = allowed_services


class DataNetworkListResult(msrest.serialization.Model):
    """Response for data network API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of data networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.DataNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataNetwork"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of data networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.DataNetwork]
        """
        super(DataNetworkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DataNetworkResourceId(msrest.serialization.Model):
    """Reference to a Data Network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Data Network resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[dD][aA][tT][aA][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Data Network resource ID.
        :paramtype id: str
        """
        super(DataNetworkResourceId, self).__init__(**kwargs)
        self.id = id


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.mobilenetwork.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.mobilenetwork.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class InterfaceProperties(msrest.serialization.Model):
    """Interface properties.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The logical name for this interface. This should match one of the
     interfaces configured on your Azure Stack Edge machine.
    :vartype name: str
    :ivar ipv4_address: The IPv4 address.
    :vartype ipv4_address: str
    :ivar ipv4_subnet: The IPv4 subnet.
    :vartype ipv4_subnet: str
    :ivar ipv4_gateway: The default IPv4 gateway (router).
    :vartype ipv4_gateway: str
    """

    _validation = {
        'name': {'required': True},
        'ipv4_address': {'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$'},
        'ipv4_subnet': {'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\/([0-9]|[1-2][0-9]|3[0-2]))$'},
        'ipv4_gateway': {'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ipv4_address': {'key': 'ipv4Address', 'type': 'str'},
        'ipv4_subnet': {'key': 'ipv4Subnet', 'type': 'str'},
        'ipv4_gateway': {'key': 'ipv4Gateway', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        ipv4_address: Optional[str] = None,
        ipv4_subnet: Optional[str] = None,
        ipv4_gateway: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The logical name for this interface. This should match one of the
         interfaces configured on your Azure Stack Edge machine.
        :paramtype name: str
        :keyword ipv4_address: The IPv4 address.
        :paramtype ipv4_address: str
        :keyword ipv4_subnet: The IPv4 subnet.
        :paramtype ipv4_subnet: str
        :keyword ipv4_gateway: The default IPv4 gateway (router).
        :paramtype ipv4_gateway: str
        """
        super(InterfaceProperties, self).__init__(**kwargs)
        self.name = name
        self.ipv4_address = ipv4_address
        self.ipv4_subnet = ipv4_subnet
        self.ipv4_gateway = ipv4_gateway


class MobileNetwork(TrackedResource):
    """Mobile network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the mobile network resource. Possible
     values include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled",
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar public_land_mobile_network_identifier: Required. The unique public land mobile network
     identifier for the network. This is made up of the Mobile Country Code and Mobile Network Code,
     as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
     for testing and the values 999-99 and 999-999 can be used on internal private networks.
    :vartype public_land_mobile_network_identifier: ~azure.mgmt.mobilenetwork.models.PlmnId
    :ivar service_key: The mobile network resource identifier.
    :vartype service_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'public_land_mobile_network_identifier': {'required': True},
        'service_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_land_mobile_network_identifier': {'key': 'properties.publicLandMobileNetworkIdentifier', 'type': 'PlmnId'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        public_land_mobile_network_identifier: "PlmnId",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword public_land_mobile_network_identifier: Required. The unique public land mobile network
         identifier for the network. This is made up of the Mobile Country Code and Mobile Network Code,
         as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
         for testing and the values 999-99 and 999-999 can be used on internal private networks.
        :paramtype public_land_mobile_network_identifier: ~azure.mgmt.mobilenetwork.models.PlmnId
        """
        super(MobileNetwork, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.public_land_mobile_network_identifier = public_land_mobile_network_identifier
        self.service_key = None


class MobileNetworkListResult(msrest.serialization.Model):
    """Response for mobile networks API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of mobile networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.MobileNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MobileNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MobileNetwork"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of mobile networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.MobileNetwork]
        """
        super(MobileNetworkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MobileNetworkResourceId(msrest.serialization.Model):
    """Reference to a Mobile Network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Mobile Network resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Mobile Network resource ID.
        :paramtype id: str
        """
        super(MobileNetworkResourceId, self).__init__(**kwargs)
        self.id = id


class NaptConfiguration(msrest.serialization.Model):
    """The Network Address and Port Translation settings to use for the attached data network.

    :ivar enabled: Whether NAPT is enabled for connections to this attachedDataNetwork. Possible
     values include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype enabled: str or ~azure.mgmt.mobilenetwork.models.NaptEnabled
    :ivar port_range: Range of port numbers to use as translated ports on each translated address.
     If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under
     1,024 should not be used because these are special purpose ports reserved by IANA.).
    :vartype port_range: ~azure.mgmt.mobilenetwork.models.PortRange
    :ivar port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that was
     used by a closed pinhole can be recycled for use by another pinhole. All hold times must be
     minimum 1 second.
    :vartype port_reuse_hold_time: ~azure.mgmt.mobilenetwork.models.PortReuseHoldTimes
    :ivar pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously on
     the core interface.
    :vartype pinhole_limits: int
    :ivar pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must be
     at least 1 second.
    :vartype pinhole_timeouts: ~azure.mgmt.mobilenetwork.models.PinholeTimeouts
    """

    _validation = {
        'pinhole_limits': {'maximum': 65536, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'str'},
        'port_range': {'key': 'portRange', 'type': 'PortRange'},
        'port_reuse_hold_time': {'key': 'portReuseHoldTime', 'type': 'PortReuseHoldTimes'},
        'pinhole_limits': {'key': 'pinholeLimits', 'type': 'int'},
        'pinhole_timeouts': {'key': 'pinholeTimeouts', 'type': 'PinholeTimeouts'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[Union[str, "NaptEnabled"]] = "Enabled",
        port_range: Optional["PortRange"] = None,
        port_reuse_hold_time: Optional["PortReuseHoldTimes"] = None,
        pinhole_limits: Optional[int] = 65536,
        pinhole_timeouts: Optional["PinholeTimeouts"] = None,
        **kwargs
    ):
        """
        :keyword enabled: Whether NAPT is enabled for connections to this attachedDataNetwork. Possible
         values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype enabled: str or ~azure.mgmt.mobilenetwork.models.NaptEnabled
        :keyword port_range: Range of port numbers to use as translated ports on each translated
         address.
         If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under
         1,024 should not be used because these are special purpose ports reserved by IANA.).
        :paramtype port_range: ~azure.mgmt.mobilenetwork.models.PortRange
        :keyword port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that
         was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be
         minimum 1 second.
        :paramtype port_reuse_hold_time: ~azure.mgmt.mobilenetwork.models.PortReuseHoldTimes
        :keyword pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously
         on the core interface.
        :paramtype pinhole_limits: int
        :keyword pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must
         be at least 1 second.
        :paramtype pinhole_timeouts: ~azure.mgmt.mobilenetwork.models.PinholeTimeouts
        """
        super(NaptConfiguration, self).__init__(**kwargs)
        self.enabled = enabled
        self.port_range = port_range
        self.port_reuse_hold_time = port_reuse_hold_time
        self.pinhole_limits = pinhole_limits
        self.pinhole_timeouts = pinhole_timeouts


class Operation(msrest.serialization.Model):
    """Object that describes a single Microsoft.MobileNetwork operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: bool
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.mobilenetwork.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword is_data_action: Indicates whether the operation applies to data-plane.
        :paramtype is_data_action: bool
        """
        super(Operation, self).__init__(**kwargs)
        self.is_data_action = is_data_action
        self.name = None
        self.display = None


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.MobileNetwork.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Registration definition,
     registration assignment etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.MobileNetwork.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Registration definition,
         registration assignment etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(msrest.serialization.Model):
    """List of the operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Microsoft.MobileNetwork operations.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Operation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PacketCoreControlPlane(TrackedResource):
    """Packet core control plane resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the packet core control plane resource.
     Possible values include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled",
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar mobile_network: Required. Mobile network that this packet core control plane belongs to.
    :vartype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
    :ivar custom_location: Azure ARC custom location where the packet core is deployed.
    :vartype custom_location: ~azure.mgmt.mobilenetwork.models.CustomLocationResourceId
    :ivar core_network_technology: The core network technology generation. Possible values include:
     "5GC", "EPC".
    :vartype core_network_technology: str or ~azure.mgmt.mobilenetwork.models.CoreNetworkType
    :ivar version: The version of the packet core software that is deployed.
    :vartype version: str
    :ivar control_plane_access_interface: Required. The control plane interface on the access
     network. In 5G networks this is called as N2 interface whereas in 4G networks this is called as
     S1-MME interface.
    :vartype control_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'mobile_network': {'required': True},
        'control_plane_access_interface': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'mobile_network': {'key': 'properties.mobileNetwork', 'type': 'MobileNetworkResourceId'},
        'custom_location': {'key': 'properties.customLocation', 'type': 'CustomLocationResourceId'},
        'core_network_technology': {'key': 'properties.coreNetworkTechnology', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'control_plane_access_interface': {'key': 'properties.controlPlaneAccessInterface', 'type': 'InterfaceProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        mobile_network: "MobileNetworkResourceId",
        control_plane_access_interface: "InterfaceProperties",
        tags: Optional[Dict[str, str]] = None,
        custom_location: Optional["CustomLocationResourceId"] = None,
        core_network_technology: Optional[Union[str, "CoreNetworkType"]] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword mobile_network: Required. Mobile network that this packet core control plane belongs
         to.
        :paramtype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
        :keyword custom_location: Azure ARC custom location where the packet core is deployed.
        :paramtype custom_location: ~azure.mgmt.mobilenetwork.models.CustomLocationResourceId
        :keyword core_network_technology: The core network technology generation. Possible values
         include: "5GC", "EPC".
        :paramtype core_network_technology: str or ~azure.mgmt.mobilenetwork.models.CoreNetworkType
        :keyword version: The version of the packet core software that is deployed.
        :paramtype version: str
        :keyword control_plane_access_interface: Required. The control plane interface on the access
         network. In 5G networks this is called as N2 interface whereas in 4G networks this is called as
         S1-MME interface.
        :paramtype control_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        """
        super(PacketCoreControlPlane, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.mobile_network = mobile_network
        self.custom_location = custom_location
        self.core_network_technology = core_network_technology
        self.version = version
        self.control_plane_access_interface = control_plane_access_interface


class PacketCoreControlPlaneListResult(msrest.serialization.Model):
    """Response for packet core control planes API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of packet core control planes in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlane]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PacketCoreControlPlane]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PacketCoreControlPlane"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of packet core control planes in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlane]
        """
        super(PacketCoreControlPlaneListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PacketCoreDataPlane(TrackedResource):
    """Packet core data plane resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the packet core data plane resource.
     Possible values include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled",
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar user_plane_access_interface: Required. The user plane interface on the access network. In
     5G networks this is called as N3 interface whereas in 4G networks this is called the S1-U
     interface.
    :vartype user_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'user_plane_access_interface': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'user_plane_access_interface': {'key': 'properties.userPlaneAccessInterface', 'type': 'InterfaceProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        user_plane_access_interface: "InterfaceProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword user_plane_access_interface: Required. The user plane interface on the access network.
         In 5G networks this is called as N3 interface whereas in 4G networks this is called the S1-U
         interface.
        :paramtype user_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        """
        super(PacketCoreDataPlane, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.user_plane_access_interface = user_plane_access_interface


class PacketCoreDataPlaneListResult(msrest.serialization.Model):
    """Response for packet core data planes API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of packet core data planes in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreDataPlane]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PacketCoreDataPlane]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PacketCoreDataPlane"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of packet core data planes in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreDataPlane]
        """
        super(PacketCoreDataPlaneListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PccRuleConfiguration(msrest.serialization.Model):
    """PCC rule configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_name: Required. The name of the rule. This must be unique within the parent Service.
     You must not use any of the following reserved strings - ``default``\ , ``requested`` or
     ``service``.
    :vartype rule_name: str
    :ivar rule_precedence: Required. A precedence value that is used to decide between PCC Rules
     when identifying the QoS values to use for a particular Sim. A lower value means a higher
     priority. This value should be unique among all PCC Rules configured in the Mobile Network.
    :vartype rule_precedence: int
    :ivar rule_qos_policy: The QoS policy to use for packets matching this rule. If this field is
     null then the Service will define the QoS settings.
    :vartype rule_qos_policy: ~azure.mgmt.mobilenetwork.models.PccRuleQosPolicy
    :ivar traffic_control: Determines whether flows that match this PCC Rule are permitted.
     Possible values include: "Enabled", "Blocked".
    :vartype traffic_control: str or ~azure.mgmt.mobilenetwork.models.TrafficControlPermission
    :ivar service_data_flow_templates: Required. The set of service data flow templates to use for
     this PCC Rule.
    :vartype service_data_flow_templates:
     list[~azure.mgmt.mobilenetwork.models.ServiceDataFlowTemplate]
    """

    _validation = {
        'rule_name': {'required': True, 'max_length': 64, 'min_length': 0, 'pattern': r'^(?!(default|requested|service)$)[a-zA-Z0-9][a-zA-Z0-9_-]*$'},
        'rule_precedence': {'required': True, 'maximum': 255, 'minimum': 0},
        'service_data_flow_templates': {'required': True, 'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'rule_precedence': {'key': 'rulePrecedence', 'type': 'int'},
        'rule_qos_policy': {'key': 'ruleQosPolicy', 'type': 'PccRuleQosPolicy'},
        'traffic_control': {'key': 'trafficControl', 'type': 'str'},
        'service_data_flow_templates': {'key': 'serviceDataFlowTemplates', 'type': '[ServiceDataFlowTemplate]'},
    }

    def __init__(
        self,
        *,
        rule_name: str,
        rule_precedence: int,
        service_data_flow_templates: List["ServiceDataFlowTemplate"],
        rule_qos_policy: Optional["PccRuleQosPolicy"] = None,
        traffic_control: Optional[Union[str, "TrafficControlPermission"]] = None,
        **kwargs
    ):
        """
        :keyword rule_name: Required. The name of the rule. This must be unique within the parent
         Service. You must not use any of the following reserved strings - ``default``\ , ``requested``
         or ``service``.
        :paramtype rule_name: str
        :keyword rule_precedence: Required. A precedence value that is used to decide between PCC Rules
         when identifying the QoS values to use for a particular Sim. A lower value means a higher
         priority. This value should be unique among all PCC Rules configured in the Mobile Network.
        :paramtype rule_precedence: int
        :keyword rule_qos_policy: The QoS policy to use for packets matching this rule. If this field
         is null then the Service will define the QoS settings.
        :paramtype rule_qos_policy: ~azure.mgmt.mobilenetwork.models.PccRuleQosPolicy
        :keyword traffic_control: Determines whether flows that match this PCC Rule are permitted.
         Possible values include: "Enabled", "Blocked".
        :paramtype traffic_control: str or ~azure.mgmt.mobilenetwork.models.TrafficControlPermission
        :keyword service_data_flow_templates: Required. The set of service data flow templates to use
         for this PCC Rule.
        :paramtype service_data_flow_templates:
         list[~azure.mgmt.mobilenetwork.models.ServiceDataFlowTemplate]
        """
        super(PccRuleConfiguration, self).__init__(**kwargs)
        self.rule_name = rule_name
        self.rule_precedence = rule_precedence
        self.rule_qos_policy = rule_qos_policy
        self.traffic_control = traffic_control
        self.service_data_flow_templates = service_data_flow_templates


class QosPolicy(msrest.serialization.Model):
    """QoS policy.

    All required parameters must be populated in order to send to Azure.

    :ivar five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding
     treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR
     (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73,
     74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the
     5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP)
     level. Flows with higher priority preempt flows with lower priority, if the settings of
     ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
     priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a
     QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values include:
     "NotPreempt", "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption
     Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
     priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     Possible values include: "NotPreemptable", "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar maximum_bit_rate: Required. The Maximum Bit Rate (MBR) for all service data flows that
     use this PCC Rule or Service.
    :vartype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    """

    _validation = {
        'five_qi': {'maximum': 127, 'minimum': 1},
        'allocation_and_retention_priority_level': {'maximum': 15, 'minimum': 1},
        'maximum_bit_rate': {'required': True},
    }

    _attribute_map = {
        'five_qi': {'key': '5qi', 'type': 'int'},
        'allocation_and_retention_priority_level': {'key': 'allocationAndRetentionPriorityLevel', 'type': 'int'},
        'preemption_capability': {'key': 'preemptionCapability', 'type': 'str'},
        'preemption_vulnerability': {'key': 'preemptionVulnerability', 'type': 'str'},
        'maximum_bit_rate': {'key': 'maximumBitRate', 'type': 'Ambr'},
    }

    def __init__(
        self,
        *,
        maximum_bit_rate: "Ambr",
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "PreemptionVulnerability"]] = None,
        **kwargs
    ):
        """
        :keyword five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS
         forwarding treatment to be provided to a flow. This must not be a standardized 5QI value
         selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66,
         67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full
         description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI
         values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: QoS Flow allocation and retention priority
         (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of
         ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
         priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a
         QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values include:
         "NotPreempt", "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption
         Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Possible values include: "NotPreemptable", "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword maximum_bit_rate: Required. The Maximum Bit Rate (MBR) for all service data flows that
         use this PCC Rule or Service.
        :paramtype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        """
        super(QosPolicy, self).__init__(**kwargs)
        self.five_qi = five_qi
        self.allocation_and_retention_priority_level = allocation_and_retention_priority_level
        self.preemption_capability = preemption_capability
        self.preemption_vulnerability = preemption_vulnerability
        self.maximum_bit_rate = maximum_bit_rate


class PccRuleQosPolicy(QosPolicy):
    """PCC rule QoS policy.

    All required parameters must be populated in order to send to Azure.

    :ivar five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding
     treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR
     (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73,
     74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the
     5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP)
     level. Flows with higher priority preempt flows with lower priority, if the settings of
     ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
     priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a
     QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values include:
     "NotPreempt", "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption
     Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
     priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     Possible values include: "NotPreemptable", "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar maximum_bit_rate: Required. The Maximum Bit Rate (MBR) for all service data flows that
     use this PCC Rule or Service.
    :vartype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar guaranteed_bit_rate: The Guaranteed Bit Rate (GBR) for all service data flows that use
     this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR
     set for the PCC Rule that uses this QoS definition.
    :vartype guaranteed_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    """

    _validation = {
        'five_qi': {'maximum': 127, 'minimum': 1},
        'allocation_and_retention_priority_level': {'maximum': 15, 'minimum': 1},
        'maximum_bit_rate': {'required': True},
    }

    _attribute_map = {
        'five_qi': {'key': '5qi', 'type': 'int'},
        'allocation_and_retention_priority_level': {'key': 'allocationAndRetentionPriorityLevel', 'type': 'int'},
        'preemption_capability': {'key': 'preemptionCapability', 'type': 'str'},
        'preemption_vulnerability': {'key': 'preemptionVulnerability', 'type': 'str'},
        'maximum_bit_rate': {'key': 'maximumBitRate', 'type': 'Ambr'},
        'guaranteed_bit_rate': {'key': 'guaranteedBitRate', 'type': 'Ambr'},
    }

    def __init__(
        self,
        *,
        maximum_bit_rate: "Ambr",
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "PreemptionVulnerability"]] = None,
        guaranteed_bit_rate: Optional["Ambr"] = None,
        **kwargs
    ):
        """
        :keyword five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS
         forwarding treatment to be provided to a flow. This must not be a standardized 5QI value
         selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66,
         67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full
         description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI
         values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: QoS Flow allocation and retention priority
         (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of
         ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
         priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a
         QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values include:
         "NotPreempt", "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption
         Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Possible values include: "NotPreemptable", "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword maximum_bit_rate: Required. The Maximum Bit Rate (MBR) for all service data flows that
         use this PCC Rule or Service.
        :paramtype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword guaranteed_bit_rate: The Guaranteed Bit Rate (GBR) for all service data flows that use
         this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR
         set for the PCC Rule that uses this QoS definition.
        :paramtype guaranteed_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        """
        super(PccRuleQosPolicy, self).__init__(five_qi=five_qi, allocation_and_retention_priority_level=allocation_and_retention_priority_level, preemption_capability=preemption_capability, preemption_vulnerability=preemption_vulnerability, maximum_bit_rate=maximum_bit_rate, **kwargs)
        self.guaranteed_bit_rate = guaranteed_bit_rate


class PinholeTimeouts(msrest.serialization.Model):
    """Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.

    :ivar tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes
     per RFC 5382 section 5.
    :vartype tcp: int
    :ivar udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC
     4787 section 4.3.
    :vartype udp: int
    :ivar icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds
     per RFC 5508 section 3.2.
    :vartype icmp: int
    """

    _validation = {
        'tcp': {'minimum': 1},
        'udp': {'minimum': 1},
        'icmp': {'minimum': 1},
    }

    _attribute_map = {
        'tcp': {'key': 'tcp', 'type': 'int'},
        'udp': {'key': 'udp', 'type': 'int'},
        'icmp': {'key': 'icmp', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tcp: Optional[int] = 7440,
        udp: Optional[int] = 300,
        icmp: Optional[int] = 60,
        **kwargs
    ):
        """
        :keyword tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes
         per RFC 5382 section 5.
        :paramtype tcp: int
        :keyword udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC
         4787 section 4.3.
        :paramtype udp: int
        :keyword icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60
         seconds per RFC 5508 section 3.2.
        :paramtype icmp: int
        """
        super(PinholeTimeouts, self).__init__(**kwargs)
        self.tcp = tcp
        self.udp = udp
        self.icmp = icmp


class PlmnId(msrest.serialization.Model):
    """Public Land Mobile Network (PLMN) ID.

    All required parameters must be populated in order to send to Azure.

    :ivar mcc: Required. Mobile Country Code (MCC).
    :vartype mcc: str
    :ivar mnc: Required. Mobile Network Code (MNC).
    :vartype mnc: str
    """

    _validation = {
        'mcc': {'required': True, 'pattern': r'^\d{3}$'},
        'mnc': {'required': True, 'pattern': r'^\d{2,3}$'},
    }

    _attribute_map = {
        'mcc': {'key': 'mcc', 'type': 'str'},
        'mnc': {'key': 'mnc', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mcc: str,
        mnc: str,
        **kwargs
    ):
        """
        :keyword mcc: Required. Mobile Country Code (MCC).
        :paramtype mcc: str
        :keyword mnc: Required. Mobile Network Code (MNC).
        :paramtype mnc: str
        """
        super(PlmnId, self).__init__(**kwargs)
        self.mcc = mcc
        self.mnc = mnc


class PortRange(msrest.serialization.Model):
    """Range of port numbers to use as translated ports on each translated address.
If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.).

    :ivar min_port: The minimum port number.
    :vartype min_port: int
    :ivar max_port: The maximum port number.
    :vartype max_port: int
    """

    _validation = {
        'min_port': {'maximum': 65535, 'minimum': 1024},
        'max_port': {'maximum': 65535, 'minimum': 1024},
    }

    _attribute_map = {
        'min_port': {'key': 'minPort', 'type': 'int'},
        'max_port': {'key': 'maxPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_port: Optional[int] = 1024,
        max_port: Optional[int] = 65535,
        **kwargs
    ):
        """
        :keyword min_port: The minimum port number.
        :paramtype min_port: int
        :keyword max_port: The maximum port number.
        :paramtype max_port: int
        """
        super(PortRange, self).__init__(**kwargs)
        self.min_port = min_port
        self.max_port = max_port


class PortReuseHoldTimes(msrest.serialization.Model):
    """The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.

    :ivar tcp: Minimum time in seconds that will pass before a TCP port that was used by a closed
     pinhole can be reused. Default for TCP is 2 minutes.
    :vartype tcp: int
    :ivar udp: Minimum time in seconds that will pass before a UDP port that was used by a closed
     pinhole can be reused. Default for UDP is 1 minute.
    :vartype udp: int
    """

    _validation = {
        'tcp': {'minimum': 1},
        'udp': {'minimum': 1},
    }

    _attribute_map = {
        'tcp': {'key': 'tcp', 'type': 'int'},
        'udp': {'key': 'udp', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tcp: Optional[int] = 120,
        udp: Optional[int] = 60,
        **kwargs
    ):
        """
        :keyword tcp: Minimum time in seconds that will pass before a TCP port that was used by a
         closed pinhole can be reused. Default for TCP is 2 minutes.
        :paramtype tcp: int
        :keyword udp: Minimum time in seconds that will pass before a UDP port that was used by a
         closed pinhole can be reused. Default for UDP is 1 minute.
        :paramtype udp: int
        """
        super(PortReuseHoldTimes, self).__init__(**kwargs)
        self.tcp = tcp
        self.udp = udp


class Service(TrackedResource):
    """Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the service resource. Possible values
     include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar service_precedence: Required. A precedence value that is used to decide between services
     when identifying the QoS values to use for a particular Sim. A lower value means a higher
     priority. This value should be unique among all services configured in the Mobile Network.
    :vartype service_precedence: int
    :ivar service_qos_policy: The QoS policy to use for packets matching this service. This can be
     overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If
     this field is null then the UE's simPolicy will define the QoS settings.
    :vartype service_qos_policy: ~azure.mgmt.mobilenetwork.models.QosPolicy
    :ivar pcc_rules: Required. The set of PCC Rules that make up this service.
    :vartype pcc_rules: list[~azure.mgmt.mobilenetwork.models.PccRuleConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'service_precedence': {'required': True, 'maximum': 255, 'minimum': 0},
        'pcc_rules': {'required': True, 'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'service_precedence': {'key': 'properties.servicePrecedence', 'type': 'int'},
        'service_qos_policy': {'key': 'properties.serviceQosPolicy', 'type': 'QosPolicy'},
        'pcc_rules': {'key': 'properties.pccRules', 'type': '[PccRuleConfiguration]'},
    }

    def __init__(
        self,
        *,
        location: str,
        service_precedence: int,
        pcc_rules: List["PccRuleConfiguration"],
        tags: Optional[Dict[str, str]] = None,
        service_qos_policy: Optional["QosPolicy"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword service_precedence: Required. A precedence value that is used to decide between
         services when identifying the QoS values to use for a particular Sim. A lower value means a
         higher priority. This value should be unique among all services configured in the Mobile
         Network.
        :paramtype service_precedence: int
        :keyword service_qos_policy: The QoS policy to use for packets matching this service. This can
         be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If
         this field is null then the UE's simPolicy will define the QoS settings.
        :paramtype service_qos_policy: ~azure.mgmt.mobilenetwork.models.QosPolicy
        :keyword pcc_rules: Required. The set of PCC Rules that make up this service.
        :paramtype pcc_rules: list[~azure.mgmt.mobilenetwork.models.PccRuleConfiguration]
        """
        super(Service, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.service_precedence = service_precedence
        self.service_qos_policy = service_qos_policy
        self.pcc_rules = pcc_rules


class ServiceDataFlowTemplate(msrest.serialization.Model):
    """Service data flow (SDF) template.

    All required parameters must be populated in order to send to Azure.

    :ivar template_name: Required. The name of the SDF template. This must be unique within the
     parent PccRuleConfiguration. You must not use any of the following reserved strings -
     ``default``\ , ``requested`` or ``service``.
    :vartype template_name: str
    :ivar direction: Required. The direction of this flow. Possible values include: "Uplink",
     "Downlink", "Bidirectional".
    :vartype direction: str or ~azure.mgmt.mobilenetwork.models.SdfDirection
    :ivar protocol: Required. A list of the allowed protocol(s) for this flow. If you want this
     flow to be able to use any protocol within the internet protocol suite, use the value ``ip``.
     If you only want to allow a selection of protocols, you must use the corresponding IANA
     Assigned Internet Protocol Number for each protocol, as described in
     https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP,
     you must use 17. If you use the value ``ip`` then you must leave the field ``port``
     unspecified.
    :vartype protocol: list[str]
    :ivar remote_ip_list: Required. The remote IP address(es) to which UEs will connect for this
     flow. If you want to allow connections on any IP address, use the value ``any``. Otherwise, you
     must provide each of the remote IP addresses to which Fusion Core will connect for this flow.
     You must provide each IP address in CIDR notation, including the netmask (for example,
     192.0.2.54/24).
    :vartype remote_ip_list: list[str]
    :ivar ports: The port(s) to which UEs will connect for this flow. You can specify zero or more
     ports or port ranges. If you specify one or more ports or port ranges then you must specify a
     value other than ``ip`` in the ``protocol`` field. This is an optional setting. If you do not
     specify it then connections will be allowed on all ports. Port ranges must be specified as
     :code:`<FirstPort>`-:code:`<LastPort>`. For example: [\ ``8080``\ , ``8082-8085``\ ].
    :vartype ports: list[str]
    """

    _validation = {
        'template_name': {'required': True, 'max_length': 64, 'min_length': 0, 'pattern': r'^(?!(default|requested|service)$)[a-zA-Z0-9][a-zA-Z0-9_-]*$'},
        'direction': {'required': True},
        'protocol': {'required': True, 'min_items': 1, 'unique': True},
        'remote_ip_list': {'required': True, 'min_items': 1, 'unique': True},
        'ports': {'unique': True},
    }

    _attribute_map = {
        'template_name': {'key': 'templateName', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': '[str]'},
        'remote_ip_list': {'key': 'remoteIpList', 'type': '[str]'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        template_name: str,
        direction: Union[str, "SdfDirection"],
        protocol: List[str],
        remote_ip_list: List[str],
        ports: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword template_name: Required. The name of the SDF template. This must be unique within the
         parent PccRuleConfiguration. You must not use any of the following reserved strings -
         ``default``\ , ``requested`` or ``service``.
        :paramtype template_name: str
        :keyword direction: Required. The direction of this flow. Possible values include: "Uplink",
         "Downlink", "Bidirectional".
        :paramtype direction: str or ~azure.mgmt.mobilenetwork.models.SdfDirection
        :keyword protocol: Required. A list of the allowed protocol(s) for this flow. If you want this
         flow to be able to use any protocol within the internet protocol suite, use the value ``ip``.
         If you only want to allow a selection of protocols, you must use the corresponding IANA
         Assigned Internet Protocol Number for each protocol, as described in
         https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP,
         you must use 17. If you use the value ``ip`` then you must leave the field ``port``
         unspecified.
        :paramtype protocol: list[str]
        :keyword remote_ip_list: Required. The remote IP address(es) to which UEs will connect for this
         flow. If you want to allow connections on any IP address, use the value ``any``. Otherwise, you
         must provide each of the remote IP addresses to which Fusion Core will connect for this flow.
         You must provide each IP address in CIDR notation, including the netmask (for example,
         192.0.2.54/24).
        :paramtype remote_ip_list: list[str]
        :keyword ports: The port(s) to which UEs will connect for this flow. You can specify zero or
         more ports or port ranges. If you specify one or more ports or port ranges then you must
         specify a value other than ``ip`` in the ``protocol`` field. This is an optional setting. If
         you do not specify it then connections will be allowed on all ports. Port ranges must be
         specified as :code:`<FirstPort>`-:code:`<LastPort>`. For example: [\ ``8080``\ , ``8082-8085``\
         ].
        :paramtype ports: list[str]
        """
        super(ServiceDataFlowTemplate, self).__init__(**kwargs)
        self.template_name = template_name
        self.direction = direction
        self.protocol = protocol
        self.remote_ip_list = remote_ip_list
        self.ports = ports


class ServiceListResult(msrest.serialization.Model):
    """Response for Services API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of Services.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Service]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Service]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Service"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Services.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Service]
        """
        super(ServiceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceResourceId(msrest.serialization.Model):
    """Reference to a Service resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Service resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][eE][rR][vV][iI][cC][eE][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Service resource ID.
        :paramtype id: str
        """
        super(ServiceResourceId, self).__init__(**kwargs)
        self.id = id


class Sim(TrackedResource):
    """Sim resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the sim resource. Possible values include:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the sim resource. Possible values include: "Disabled", "Enabled",
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar international_mobile_subscriber_identity: Required. The International Mobile Subscriber
     Identity (IMSI) for the sim.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The Integrated Circuit Card ID (ICC Id) for the sim.
    :vartype integrated_circuit_card_identifier: str
    :ivar authentication_key: The ki value for the sim.
    :vartype authentication_key: str
    :ivar operator_key_code: The Opc value for the sim.
    :vartype operator_key_code: str
    :ivar mobile_network: Mobile network that this sim belongs to.
    :vartype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this sim is associated with, for example 'Video camera'. The Azure portal allows Sims to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The simPolicy used by this sim.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this sim. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'sim_state': {'readonly': True},
        'international_mobile_subscriber_identity': {'required': True, 'pattern': r'^[0-9]{5,15}$'},
        'integrated_circuit_card_identifier': {'pattern': r'^89[0-9]{17,18}$'},
        'authentication_key': {'pattern': r'^[0-9a-fA-F]{32}$'},
        'operator_key_code': {'pattern': r'^[0-9a-fA-F]{32}$'},
        'static_ip_configuration': {'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sim_state': {'key': 'properties.simState', 'type': 'str'},
        'international_mobile_subscriber_identity': {'key': 'properties.internationalMobileSubscriberIdentity', 'type': 'str'},
        'integrated_circuit_card_identifier': {'key': 'properties.integratedCircuitCardIdentifier', 'type': 'str'},
        'authentication_key': {'key': 'properties.authenticationKey', 'type': 'str'},
        'operator_key_code': {'key': 'properties.operatorKeyCode', 'type': 'str'},
        'mobile_network': {'key': 'properties.mobileNetwork', 'type': 'MobileNetworkResourceId'},
        'device_type': {'key': 'properties.deviceType', 'type': 'str'},
        'sim_policy': {'key': 'properties.simPolicy', 'type': 'SimPolicyResourceId'},
        'static_ip_configuration': {'key': 'properties.staticIpConfiguration', 'type': '[SimStaticIpProperties]'},
    }

    def __init__(
        self,
        *,
        location: str,
        international_mobile_subscriber_identity: str,
        tags: Optional[Dict[str, str]] = None,
        integrated_circuit_card_identifier: Optional[str] = None,
        authentication_key: Optional[str] = None,
        operator_key_code: Optional[str] = None,
        mobile_network: Optional["MobileNetworkResourceId"] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["SimStaticIpProperties"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword international_mobile_subscriber_identity: Required. The International Mobile
         Subscriber Identity (IMSI) for the sim.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The Integrated Circuit Card ID (ICC Id) for the
         sim.
        :paramtype integrated_circuit_card_identifier: str
        :keyword authentication_key: The ki value for the sim.
        :paramtype authentication_key: str
        :keyword operator_key_code: The Opc value for the sim.
        :paramtype operator_key_code: str
        :keyword mobile_network: Mobile network that this sim belongs to.
        :paramtype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this sim is associated with, for example 'Video camera'. The Azure portal allows Sims to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The simPolicy used by this sim.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this sim. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        """
        super(Sim, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.sim_state = None
        self.international_mobile_subscriber_identity = international_mobile_subscriber_identity
        self.integrated_circuit_card_identifier = integrated_circuit_card_identifier
        self.authentication_key = authentication_key
        self.operator_key_code = operator_key_code
        self.mobile_network = mobile_network
        self.device_type = device_type
        self.sim_policy = sim_policy
        self.static_ip_configuration = static_ip_configuration


class SimIdListResult(msrest.serialization.Model):
    """Response for list sim ids API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of sim profile ids in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.SubResource]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of sim profile ids in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.SubResource]
        """
        super(SimIdListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimListResult(msrest.serialization.Model):
    """Response for list Sims API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of Sims in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Sim]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Sim]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Sim"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Sims in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Sim]
        """
        super(SimListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimPolicy(TrackedResource):
    """Sim policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the sim policy resource. Possible values
     include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar ue_ambr: Required. Aggregate maximum bit rate across all non-GBR QoS flows of all PDU
     sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the
     UE-AMBR.
    :vartype ue_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar default_slice: Required. The default slice to use if the UE does not explicitly specify
     it.  This slice must exist in the ``sliceConfigurations`` map.
    :vartype default_slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar rfsp_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.  This is
     an optional setting and by default is unspecified.
    :vartype rfsp_index: int
    :ivar registration_timer: Interval for the UE periodic registration update procedure, in
     seconds.
    :vartype registration_timer: int
    :ivar slice_configurations: Required. The allowed slices and the settings to use for them. The
     list must not contain duplicate items and must contain at least one item.
    :vartype slice_configurations: list[~azure.mgmt.mobilenetwork.models.SliceConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'ue_ambr': {'required': True},
        'default_slice': {'required': True},
        'rfsp_index': {'maximum': 256, 'minimum': 1},
        'registration_timer': {'minimum': 30},
        'slice_configurations': {'required': True, 'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'ue_ambr': {'key': 'properties.ueAmbr', 'type': 'Ambr'},
        'default_slice': {'key': 'properties.defaultSlice', 'type': 'SliceResourceId'},
        'rfsp_index': {'key': 'properties.rfspIndex', 'type': 'int'},
        'registration_timer': {'key': 'properties.registrationTimer', 'type': 'int'},
        'slice_configurations': {'key': 'properties.sliceConfigurations', 'type': '[SliceConfiguration]'},
    }

    def __init__(
        self,
        *,
        location: str,
        ue_ambr: "Ambr",
        default_slice: "SliceResourceId",
        slice_configurations: List["SliceConfiguration"],
        tags: Optional[Dict[str, str]] = None,
        rfsp_index: Optional[int] = None,
        registration_timer: Optional[int] = 3240,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword ue_ambr: Required. Aggregate maximum bit rate across all non-GBR QoS flows of all PDU
         sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the
         UE-AMBR.
        :paramtype ue_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword default_slice: Required. The default slice to use if the UE does not explicitly
         specify it.  This slice must exist in the ``sliceConfigurations`` map.
        :paramtype default_slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword rfsp_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.  This
         is an optional setting and by default is unspecified.
        :paramtype rfsp_index: int
        :keyword registration_timer: Interval for the UE periodic registration update procedure, in
         seconds.
        :paramtype registration_timer: int
        :keyword slice_configurations: Required. The allowed slices and the settings to use for them.
         The list must not contain duplicate items and must contain at least one item.
        :paramtype slice_configurations: list[~azure.mgmt.mobilenetwork.models.SliceConfiguration]
        """
        super(SimPolicy, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.ue_ambr = ue_ambr
        self.default_slice = default_slice
        self.rfsp_index = rfsp_index
        self.registration_timer = registration_timer
        self.slice_configurations = slice_configurations


class SimPolicyListResult(msrest.serialization.Model):
    """Response for SimPolicies API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of SimPolicies.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.SimPolicy]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SimPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SimPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of SimPolicies.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.SimPolicy]
        """
        super(SimPolicyListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimPolicyResourceId(msrest.serialization.Model):
    """Reference to a SIM Policy resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. SIM Policy resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][iI][mM][pP][oO][lL][iI][cC][iI][eE][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. SIM Policy resource ID.
        :paramtype id: str
        """
        super(SimPolicyResourceId, self).__init__(**kwargs)
        self.id = id


class SimStaticIpProperties(msrest.serialization.Model):
    """Static IP configuration for a sim, scoped to a particular attached data network and slice.

    :ivar attached_data_network: The attached data network on which the static IP address will be
     used. The combination of attachedDataNetwork and slice defines the network scope of the IP
     address.
    :vartype attached_data_network: ~azure.mgmt.mobilenetwork.models.AttachedDataNetworkResourceId
    :ivar slice: The network slice on which the static IP address will be used. The combination of
     attachedDataNetwork and slice defines the network scope of the IP address.
    :vartype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar static_ip: The static IP configuration for the sim to use at the defined network scope.
    :vartype static_ip: ~azure.mgmt.mobilenetwork.models.SimStaticIpPropertiesStaticIp
    """

    _attribute_map = {
        'attached_data_network': {'key': 'attachedDataNetwork', 'type': 'AttachedDataNetworkResourceId'},
        'slice': {'key': 'slice', 'type': 'SliceResourceId'},
        'static_ip': {'key': 'staticIp', 'type': 'SimStaticIpPropertiesStaticIp'},
    }

    def __init__(
        self,
        *,
        attached_data_network: Optional["AttachedDataNetworkResourceId"] = None,
        slice: Optional["SliceResourceId"] = None,
        static_ip: Optional["SimStaticIpPropertiesStaticIp"] = None,
        **kwargs
    ):
        """
        :keyword attached_data_network: The attached data network on which the static IP address will
         be used. The combination of attachedDataNetwork and slice defines the network scope of the IP
         address.
        :paramtype attached_data_network:
         ~azure.mgmt.mobilenetwork.models.AttachedDataNetworkResourceId
        :keyword slice: The network slice on which the static IP address will be used. The combination
         of attachedDataNetwork and slice defines the network scope of the IP address.
        :paramtype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword static_ip: The static IP configuration for the sim to use at the defined network
         scope.
        :paramtype static_ip: ~azure.mgmt.mobilenetwork.models.SimStaticIpPropertiesStaticIp
        """
        super(SimStaticIpProperties, self).__init__(**kwargs)
        self.attached_data_network = attached_data_network
        self.slice = slice
        self.static_ip = static_ip


class SimStaticIpPropertiesStaticIp(msrest.serialization.Model):
    """The static IP configuration for the sim to use at the defined network scope.

    :ivar ipv4_address: The IPv4 address assigned to the sim at this network scope. This address
     must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
    :vartype ipv4_address: str
    """

    _validation = {
        'ipv4_address': {'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'ipv4_address': {'key': 'ipv4Address', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ipv4_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ipv4_address: The IPv4 address assigned to the sim at this network scope. This address
         must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
        :paramtype ipv4_address: str
        """
        super(SimStaticIpPropertiesStaticIp, self).__init__(**kwargs)
        self.ipv4_address = ipv4_address


class Site(TrackedResource):
    """Site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the site resource. **TODO**\ : Confirm if
     this is needed. Possible values include: "Unknown", "Succeeded", "Accepted", "Deleting",
     "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar network_functions: An array of ids of the network functions deployed on the site,
     maintained by the user.
    :vartype network_functions: list[~azure.mgmt.mobilenetwork.models.SubResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'network_functions': {'key': 'properties.networkFunctions', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        network_functions: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword network_functions: An array of ids of the network functions deployed on the site,
         maintained by the user.
        :paramtype network_functions: list[~azure.mgmt.mobilenetwork.models.SubResource]
        """
        super(Site, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.network_functions = network_functions


class SiteListResult(msrest.serialization.Model):
    """Response for sites API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of sites in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Site]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Site"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of sites in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Site]
        """
        super(SiteListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Slice(TrackedResource):
    """Network slice resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the network slice resource. Possible values
     include: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar snssai: Required. The S-NSSAI (single network slice selection assistance information).
     Unique at the scope of a MobileNetwork.
    :vartype snssai: ~azure.mgmt.mobilenetwork.models.Snssai
    :ivar description: An optional description for this network slice.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'snssai': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'snssai': {'key': 'properties.snssai', 'type': 'Snssai'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        snssai: "Snssai",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword snssai: Required. The S-NSSAI (single network slice selection assistance information).
         Unique at the scope of a MobileNetwork.
        :paramtype snssai: ~azure.mgmt.mobilenetwork.models.Snssai
        :keyword description: An optional description for this network slice.
        :paramtype description: str
        """
        super(Slice, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.snssai = snssai
        self.description = description


class SliceConfiguration(msrest.serialization.Model):
    """Per-slice settings.

    All required parameters must be populated in order to send to Azure.

    :ivar slice: Required. A reference to the Slice that these settings apply to.
    :vartype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar default_data_network: Required. The default data network to use if the UE does not
     explicitly specify it.  Configuration for this object must exist in the
     ``dataNetworkConfigurations`` map.
    :vartype default_data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
    :ivar data_network_configurations: Required. The allowed data networks and the settings to use
     for them. The list must not contain duplicate items and must contain at least one item.
    :vartype data_network_configurations:
     list[~azure.mgmt.mobilenetwork.models.DataNetworkConfiguration]
    """

    _validation = {
        'slice': {'required': True},
        'default_data_network': {'required': True},
        'data_network_configurations': {'required': True, 'min_items': 1, 'unique': True},
    }

    _attribute_map = {
        'slice': {'key': 'slice', 'type': 'SliceResourceId'},
        'default_data_network': {'key': 'defaultDataNetwork', 'type': 'DataNetworkResourceId'},
        'data_network_configurations': {'key': 'dataNetworkConfigurations', 'type': '[DataNetworkConfiguration]'},
    }

    def __init__(
        self,
        *,
        slice: "SliceResourceId",
        default_data_network: "DataNetworkResourceId",
        data_network_configurations: List["DataNetworkConfiguration"],
        **kwargs
    ):
        """
        :keyword slice: Required. A reference to the Slice that these settings apply to.
        :paramtype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword default_data_network: Required. The default data network to use if the UE does not
         explicitly specify it.  Configuration for this object must exist in the
         ``dataNetworkConfigurations`` map.
        :paramtype default_data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
        :keyword data_network_configurations: Required. The allowed data networks and the settings to
         use for them. The list must not contain duplicate items and must contain at least one item.
        :paramtype data_network_configurations:
         list[~azure.mgmt.mobilenetwork.models.DataNetworkConfiguration]
        """
        super(SliceConfiguration, self).__init__(**kwargs)
        self.slice = slice
        self.default_data_network = default_data_network
        self.data_network_configurations = data_network_configurations


class SliceListResult(msrest.serialization.Model):
    """Response for attached data network API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of data networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Slice]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Slice]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Slice"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of data networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Slice]
        """
        super(SliceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SliceResourceId(msrest.serialization.Model):
    """Reference to a Slice resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Slice resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True, 'pattern': r'^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][lL][iI][cC][eE][sS]/[^/?#]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Slice resource ID.
        :paramtype id: str
        """
        super(SliceResourceId, self).__init__(**kwargs)
        self.id = id


class Snssai(msrest.serialization.Model):
    """Single-Network Slice Selection Assistance Information (S-NSSAI).

    All required parameters must be populated in order to send to Azure.

    :ivar sst: Required. Slice/Service Type (SST).
    :vartype sst: int
    :ivar sd: Slice Differentiator (SD).
    :vartype sd: str
    """

    _validation = {
        'sst': {'required': True, 'maximum': 255, 'minimum': 0},
        'sd': {'pattern': r'^[A-Fa-f0-9]{6}$'},
    }

    _attribute_map = {
        'sst': {'key': 'sst', 'type': 'int'},
        'sd': {'key': 'sd', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sst: int,
        sd: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sst: Required. Slice/Service Type (SST).
        :paramtype sst: int
        :keyword sd: Slice Differentiator (SD).
        :paramtype sd: str
        """
        super(Snssai, self).__init__(**kwargs)
        self.sst = sst
        self.sd = sd


class SubResource(msrest.serialization.Model):
    """Reference to another sub resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Resource ID.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Resource ID.
        :paramtype id: str
        """
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags
