# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._avs_client_enums import *


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Addon(Resource):
    """An addon resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: The properties of an addon resource.
    :type properties: ~azure.mgmt.avs.models.AddonProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AddonProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AddonProperties"] = None,
        **kwargs
    ):
        super(Addon, self).__init__(**kwargs)
        self.properties = properties


class AddonProperties(msrest.serialization.Model):
    """The properties of an addon.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddonHcxProperties, AddonSrmProperties, AddonVrProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param addon_type: Required. The type of private cloud addon.Constant filled by server.
     Possible values include: "SRM", "VR", "HCX".
    :type addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    """

    _validation = {
        'addon_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    _subtype_map = {
        'addon_type': {'HCX': 'AddonHcxProperties', 'SRM': 'AddonSrmProperties', 'VR': 'AddonVrProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddonProperties, self).__init__(**kwargs)
        self.addon_type = None  # type: Optional[str]
        self.provisioning_state = None


class AddonHcxProperties(AddonProperties):
    """The properties of an HCX addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param addon_type: Required. The type of private cloud addon.Constant filled by server.
     Possible values include: "SRM", "VR", "HCX".
    :type addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :param offer: Required. The HCX offer, example VMware MaaS Cloud Provider (Enterprise).
    :type offer: str
    """

    _validation = {
        'addon_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'offer': {'required': True},
    }

    _attribute_map = {
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        offer: str,
        **kwargs
    ):
        super(AddonHcxProperties, self).__init__(**kwargs)
        self.addon_type = 'HCX'  # type: str
        self.offer = offer


class AddonList(msrest.serialization.Model):
    """A paged list of addons.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.Addon]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Addon]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddonList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class AddonSrmProperties(AddonProperties):
    """The properties of a Site Recovery Manager (SRM) addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param addon_type: Required. The type of private cloud addon.Constant filled by server.
     Possible values include: "SRM", "VR", "HCX".
    :type addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :param license_key: The Site Recovery Manager (SRM) license.
    :type license_key: str
    """

    _validation = {
        'addon_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'license_key': {'key': 'licenseKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        license_key: Optional[str] = None,
        **kwargs
    ):
        super(AddonSrmProperties, self).__init__(**kwargs)
        self.addon_type = 'SRM'  # type: str
        self.license_key = license_key


class AddonVrProperties(AddonProperties):
    """The properties of a vSphere Replication (VR) addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param addon_type: Required. The type of private cloud addon.Constant filled by server.
     Possible values include: "SRM", "VR", "HCX".
    :type addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :param vrs_count: Required. The vSphere Replication Server (VRS) count.
    :type vrs_count: int
    """

    _validation = {
        'addon_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'vrs_count': {'required': True},
    }

    _attribute_map = {
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'vrs_count': {'key': 'vrsCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        vrs_count: int,
        **kwargs
    ):
        super(AddonVrProperties, self).__init__(**kwargs)
        self.addon_type = 'VR'  # type: str
        self.vrs_count = vrs_count


class AdminCredentials(msrest.serialization.Model):
    """Administrative credentials for accessing vCenter and NSX-T.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nsxt_username: NSX-T Manager username.
    :vartype nsxt_username: str
    :ivar nsxt_password: NSX-T Manager password.
    :vartype nsxt_password: str
    :ivar vcenter_username: vCenter admin username.
    :vartype vcenter_username: str
    :ivar vcenter_password: vCenter admin password.
    :vartype vcenter_password: str
    """

    _validation = {
        'nsxt_username': {'readonly': True},
        'nsxt_password': {'readonly': True},
        'vcenter_username': {'readonly': True},
        'vcenter_password': {'readonly': True},
    }

    _attribute_map = {
        'nsxt_username': {'key': 'nsxtUsername', 'type': 'str'},
        'nsxt_password': {'key': 'nsxtPassword', 'type': 'str'},
        'vcenter_username': {'key': 'vcenterUsername', 'type': 'str'},
        'vcenter_password': {'key': 'vcenterPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdminCredentials, self).__init__(**kwargs)
        self.nsxt_username = None
        self.nsxt_password = None
        self.vcenter_username = None
        self.vcenter_password = None


class AvailabilityProperties(msrest.serialization.Model):
    """The properties describing private cloud availability zone distribution.

    :param strategy: The availability strategy for the private cloud. Possible values include:
     "SingleZone", "DualZone".
    :type strategy: str or ~azure.mgmt.avs.models.AvailabilityStrategy
    :param zone: The primary availability zone for the private cloud.
    :type zone: int
    :param secondary_zone: The secondary availability zone for the private cloud.
    :type secondary_zone: int
    """

    _attribute_map = {
        'strategy': {'key': 'strategy', 'type': 'str'},
        'zone': {'key': 'zone', 'type': 'int'},
        'secondary_zone': {'key': 'secondaryZone', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        strategy: Optional[Union[str, "AvailabilityStrategy"]] = None,
        zone: Optional[int] = None,
        secondary_zone: Optional[int] = None,
        **kwargs
    ):
        super(AvailabilityProperties, self).__init__(**kwargs)
        self.strategy = strategy
        self.zone = zone
        self.secondary_zone = secondary_zone


class Circuit(msrest.serialization.Model):
    """An ExpressRoute Circuit.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_subnet: CIDR of primary subnet.
    :vartype primary_subnet: str
    :ivar secondary_subnet: CIDR of secondary subnet.
    :vartype secondary_subnet: str
    :ivar express_route_id: Identifier of the ExpressRoute Circuit (Microsoft Colo only).
    :vartype express_route_id: str
    :ivar express_route_private_peering_id: ExpressRoute Circuit private peering identifier.
    :vartype express_route_private_peering_id: str
    """

    _validation = {
        'primary_subnet': {'readonly': True},
        'secondary_subnet': {'readonly': True},
        'express_route_id': {'readonly': True},
        'express_route_private_peering_id': {'readonly': True},
    }

    _attribute_map = {
        'primary_subnet': {'key': 'primarySubnet', 'type': 'str'},
        'secondary_subnet': {'key': 'secondarySubnet', 'type': 'str'},
        'express_route_id': {'key': 'expressRouteID', 'type': 'str'},
        'express_route_private_peering_id': {'key': 'expressRoutePrivatePeeringID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Circuit, self).__init__(**kwargs)
        self.primary_subnet = None
        self.secondary_subnet = None
        self.express_route_id = None
        self.express_route_private_peering_id = None


class CloudLink(Resource):
    """A cloud link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: The state of the cloud link. Possible values include: "Active", "Building",
     "Deleting", "Failed", "Disconnected".
    :vartype status: str or ~azure.mgmt.avs.models.CloudLinkStatus
    :param linked_cloud: Identifier of the other private cloud participating in the link.
    :type linked_cloud: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'linked_cloud': {'key': 'properties.linkedCloud', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linked_cloud: Optional[str] = None,
        **kwargs
    ):
        super(CloudLink, self).__init__(**kwargs)
        self.status = None
        self.linked_cloud = linked_cloud


class CloudLinkList(msrest.serialization.Model):
    """A paged list of cloud links.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.CloudLink]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CloudLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudLinkList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Cluster(Resource):
    """A cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Required. The cluster SKU.
    :type sku: ~azure.mgmt.avs.models.Sku
    :param cluster_size: The cluster size.
    :type cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :param hosts: The hosts.
    :type hosts: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'provisioning_state': {'readonly': True},
        'cluster_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'cluster_size': {'key': 'properties.clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        sku: "Sku",
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.sku = sku
        self.cluster_size = cluster_size
        self.provisioning_state = None
        self.cluster_id = None
        self.hosts = hosts


class ClusterList(msrest.serialization.Model):
    """A paged list of clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.Cluster]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CommonClusterProperties(msrest.serialization.Model):
    """The common properties of a cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cluster_size: The cluster size.
    :type cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :param hosts: The hosts.
    :type hosts: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'cluster_id': {'readonly': True},
    }

    _attribute_map = {
        'cluster_size': {'key': 'clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs
    ):
        super(CommonClusterProperties, self).__init__(**kwargs)
        self.cluster_size = cluster_size
        self.provisioning_state = None
        self.cluster_id = None
        self.hosts = hosts


class ClusterProperties(CommonClusterProperties):
    """The properties of a cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cluster_size: The cluster size.
    :type cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :param hosts: The hosts.
    :type hosts: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'cluster_id': {'readonly': True},
    }

    _attribute_map = {
        'cluster_size': {'key': 'clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs
    ):
        super(ClusterProperties, self).__init__(cluster_size=cluster_size, hosts=hosts, **kwargs)


class ClusterUpdate(msrest.serialization.Model):
    """An update of a cluster resource.

    :param cluster_size: The cluster size.
    :type cluster_size: int
    :param hosts: The hosts.
    :type hosts: list[str]
    """

    _attribute_map = {
        'cluster_size': {'key': 'properties.clusterSize', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs
    ):
        super(ClusterUpdate, self).__init__(**kwargs)
        self.cluster_size = cluster_size
        self.hosts = hosts


class Datastore(Resource):
    """A datastore resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the datastore provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Pending", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.DatastoreProvisioningState
    :param net_app_volume: An Azure NetApp Files volume.
    :type net_app_volume: ~azure.mgmt.avs.models.NetAppVolume
    :param disk_pool_volume: An iSCSI volume.
    :type disk_pool_volume: ~azure.mgmt.avs.models.DiskPoolVolume
    :ivar status: The operational status of the datastore. Possible values include: "Unknown",
     "Accessible", "Inaccessible", "Attached", "Detached", "LostCommunication", "DeadOrError".
    :vartype status: str or ~azure.mgmt.avs.models.DatastoreStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'net_app_volume': {'key': 'properties.netAppVolume', 'type': 'NetAppVolume'},
        'disk_pool_volume': {'key': 'properties.diskPoolVolume', 'type': 'DiskPoolVolume'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        net_app_volume: Optional["NetAppVolume"] = None,
        disk_pool_volume: Optional["DiskPoolVolume"] = None,
        **kwargs
    ):
        super(Datastore, self).__init__(**kwargs)
        self.provisioning_state = None
        self.net_app_volume = net_app_volume
        self.disk_pool_volume = disk_pool_volume
        self.status = None


class DatastoreList(msrest.serialization.Model):
    """A paged list of datastores.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.Datastore]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Datastore]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatastoreList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DiskPoolVolume(msrest.serialization.Model):
    """An iSCSI volume from Microsoft.StoragePool provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param target_id: Required. Azure resource ID of the iSCSI target.
    :type target_id: str
    :param lun_name: Required. Name of the LUN to be used for datastore.
    :type lun_name: str
    :param mount_option: Mode that describes whether the LUN has to be mounted as a datastore or
     attached as a LUN. Possible values include: "MOUNT", "ATTACH". Default value: "MOUNT".
    :type mount_option: str or ~azure.mgmt.avs.models.MountOptionEnum
    :ivar path: Device path.
    :vartype path: str
    """

    _validation = {
        'target_id': {'required': True},
        'lun_name': {'required': True},
        'path': {'readonly': True},
    }

    _attribute_map = {
        'target_id': {'key': 'targetId', 'type': 'str'},
        'lun_name': {'key': 'lunName', 'type': 'str'},
        'mount_option': {'key': 'mountOption', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_id: str,
        lun_name: str,
        mount_option: Optional[Union[str, "MountOptionEnum"]] = "MOUNT",
        **kwargs
    ):
        super(DiskPoolVolume, self).__init__(**kwargs)
        self.target_id = target_id
        self.lun_name = lun_name
        self.mount_option = mount_option
        self.path = None


class Encryption(msrest.serialization.Model):
    """The properties of customer managed encryption key.

    :param status: Status of customer managed encryption key. Possible values include: "Enabled",
     "Disabled".
    :type status: str or ~azure.mgmt.avs.models.EncryptionState
    :param key_vault_properties: The key vault where the encryption key is stored.
    :type key_vault_properties: ~azure.mgmt.avs.models.EncryptionKeyVaultProperties
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'EncryptionKeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "EncryptionState"]] = None,
        key_vault_properties: Optional["EncryptionKeyVaultProperties"] = None,
        **kwargs
    ):
        super(Encryption, self).__init__(**kwargs)
        self.status = status
        self.key_vault_properties = key_vault_properties


class EncryptionKeyVaultProperties(msrest.serialization.Model):
    """An Encryption Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_name: The name of the key.
    :type key_name: str
    :param key_version: The version of the key.
    :type key_version: str
    :param key_vault_url: The URL of the vault.
    :type key_vault_url: str
    :ivar key_state: The state of key provided. Possible values include: "Connected",
     "AccessDenied".
    :vartype key_state: str or ~azure.mgmt.avs.models.EncryptionKeyStatus
    :ivar version_type: Property of the key if user provided or auto detected. Possible values
     include: "Fixed", "AutoDetected".
    :vartype version_type: str or ~azure.mgmt.avs.models.EncryptionVersionType
    """

    _validation = {
        'key_state': {'readonly': True},
        'version_type': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'key_vault_url': {'key': 'keyVaultUrl', 'type': 'str'},
        'key_state': {'key': 'keyState', 'type': 'str'},
        'version_type': {'key': 'versionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_url: Optional[str] = None,
        **kwargs
    ):
        super(EncryptionKeyVaultProperties, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_url = key_vault_url
        self.key_state = None
        self.version_type = None


class Endpoints(msrest.serialization.Model):
    """Endpoint addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nsxt_manager: Endpoint for the NSX-T Data Center manager.
    :vartype nsxt_manager: str
    :ivar vcsa: Endpoint for Virtual Center Server Appliance.
    :vartype vcsa: str
    :ivar hcx_cloud_manager: Endpoint for the HCX Cloud Manager.
    :vartype hcx_cloud_manager: str
    """

    _validation = {
        'nsxt_manager': {'readonly': True},
        'vcsa': {'readonly': True},
        'hcx_cloud_manager': {'readonly': True},
    }

    _attribute_map = {
        'nsxt_manager': {'key': 'nsxtManager', 'type': 'str'},
        'vcsa': {'key': 'vcsa', 'type': 'str'},
        'hcx_cloud_manager': {'key': 'hcxCloudManager', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Endpoints, self).__init__(**kwargs)
        self.nsxt_manager = None
        self.vcsa = None
        self.hcx_cloud_manager = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.avs.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.avs.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExpressRouteAuthorization(Resource):
    """ExpressRoute Circuit Authorization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the  ExpressRoute Circuit Authorization provisioning.
     Possible values include: "Succeeded", "Failed", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.ExpressRouteAuthorizationProvisioningState
    :ivar express_route_authorization_id: The ID of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_id: str
    :ivar express_route_authorization_key: The key of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_key: str
    :param express_route_id: The ID of the ExpressRoute Circuit.
    :type express_route_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'express_route_authorization_id': {'readonly': True},
        'express_route_authorization_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_authorization_id': {'key': 'properties.expressRouteAuthorizationId', 'type': 'str'},
        'express_route_authorization_key': {'key': 'properties.expressRouteAuthorizationKey', 'type': 'str'},
        'express_route_id': {'key': 'properties.expressRouteId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        express_route_id: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteAuthorization, self).__init__(**kwargs)
        self.provisioning_state = None
        self.express_route_authorization_id = None
        self.express_route_authorization_key = None
        self.express_route_id = express_route_id


class ExpressRouteAuthorizationList(msrest.serialization.Model):
    """A paged list of ExpressRoute Circuit Authorizations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.ExpressRouteAuthorization]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteAuthorization]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteAuthorizationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GlobalReachConnection(Resource):
    """A global reach connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the  ExpressRoute Circuit Authorization provisioning.
     Possible values include: "Succeeded", "Failed", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.GlobalReachConnectionProvisioningState
    :ivar address_prefix: The network used for global reach carved out from the original network
     block provided for the private cloud.
    :vartype address_prefix: str
    :param authorization_key: Authorization key from the peer express route used for the global
     reach connection.
    :type authorization_key: str
    :ivar circuit_connection_status: The connection status of the global reach connection. Possible
     values include: "Connected", "Connecting", "Disconnected".
    :vartype circuit_connection_status: str or ~azure.mgmt.avs.models.GlobalReachConnectionStatus
    :param peer_express_route_circuit: Identifier of the ExpressRoute Circuit to peer with in the
     global reach connection.
    :type peer_express_route_circuit: str
    :param express_route_id: The ID of the Private Cloud's ExpressRoute Circuit that is
     participating in the global reach connection.
    :type express_route_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'address_prefix': {'readonly': True},
        'circuit_connection_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'peer_express_route_circuit': {'key': 'properties.peerExpressRouteCircuit', 'type': 'str'},
        'express_route_id': {'key': 'properties.expressRouteId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_key: Optional[str] = None,
        peer_express_route_circuit: Optional[str] = None,
        express_route_id: Optional[str] = None,
        **kwargs
    ):
        super(GlobalReachConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.address_prefix = None
        self.authorization_key = authorization_key
        self.circuit_connection_status = None
        self.peer_express_route_circuit = peer_express_route_circuit
        self.express_route_id = express_route_id


class GlobalReachConnectionList(msrest.serialization.Model):
    """A paged list of global reach connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.GlobalReachConnection]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GlobalReachConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GlobalReachConnectionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class HcxEnterpriseSite(Resource):
    """An HCX Enterprise Site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar activation_key: The activation key.
    :vartype activation_key: str
    :ivar status: The status of the HCX Enterprise Site. Possible values include: "Available",
     "Consumed", "Deactivated", "Deleted".
    :vartype status: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'activation_key': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'activation_key': {'key': 'properties.activationKey', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HcxEnterpriseSite, self).__init__(**kwargs)
        self.activation_key = None
        self.status = None


class HcxEnterpriseSiteList(msrest.serialization.Model):
    """A paged list of HCX Enterprise Sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on a page.
    :vartype value: list[~azure.mgmt.avs.models.HcxEnterpriseSite]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HcxEnterpriseSite]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HcxEnterpriseSiteList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class IdentitySource(msrest.serialization.Model):
    """vCenter Single Sign On Identity Source.

    :param name: The name of the identity source.
    :type name: str
    :param alias: The domain's NetBIOS name.
    :type alias: str
    :param domain: The domain's dns name.
    :type domain: str
    :param base_user_dn: The base distinguished name for users.
    :type base_user_dn: str
    :param base_group_dn: The base distinguished name for groups.
    :type base_group_dn: str
    :param primary_server: Primary server URL.
    :type primary_server: str
    :param secondary_server: Secondary server URL.
    :type secondary_server: str
    :param ssl: Protect LDAP communication using SSL certificate (LDAPS). Possible values include:
     "Enabled", "Disabled".
    :type ssl: str or ~azure.mgmt.avs.models.SslEnum
    :param username: The ID of an Active Directory user with a minimum of read-only access to Base
     DN for users and group.
    :type username: str
    :param password: The password of the Active Directory user with a minimum of read-only access
     to Base DN for users and groups.
    :type password: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'alias': {'key': 'alias', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'base_user_dn': {'key': 'baseUserDN', 'type': 'str'},
        'base_group_dn': {'key': 'baseGroupDN', 'type': 'str'},
        'primary_server': {'key': 'primaryServer', 'type': 'str'},
        'secondary_server': {'key': 'secondaryServer', 'type': 'str'},
        'ssl': {'key': 'ssl', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        alias: Optional[str] = None,
        domain: Optional[str] = None,
        base_user_dn: Optional[str] = None,
        base_group_dn: Optional[str] = None,
        primary_server: Optional[str] = None,
        secondary_server: Optional[str] = None,
        ssl: Optional[Union[str, "SslEnum"]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(IdentitySource, self).__init__(**kwargs)
        self.name = name
        self.alias = alias
        self.domain = domain
        self.base_user_dn = base_user_dn
        self.base_group_dn = base_group_dn
        self.primary_server = primary_server
        self.secondary_server = secondary_server
        self.ssl = ssl
        self.username = username
        self.password = password


class LogSpecification(msrest.serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized friendly display name of the log.
    :type display_name: str
    :param blob_duration: Blob duration of the log.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagementCluster(CommonClusterProperties):
    """The properties of a management cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cluster_size: The cluster size.
    :type cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :param hosts: The hosts.
    :type hosts: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'cluster_id': {'readonly': True},
    }

    _attribute_map = {
        'cluster_size': {'key': 'clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs
    ):
        super(ManagementCluster, self).__init__(cluster_size=cluster_size, hosts=hosts, **kwargs)


class MetricDimension(msrest.serialization.Model):
    """Specifications of the Dimension of metrics.

    :param name: Name of the dimension.
    :type name: str
    :param display_name: Localized friendly display name of the dimension.
    :type display_name: str
    :param internal_name: Name of the dimension as it appears in MDM.
    :type internal_name: str
    :param to_be_exported_for_shoebox: A boolean flag indicating whether this dimension should be
     included for the shoebox export scenario.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecification(msrest.serialization.Model):
    """Specifications of the Metrics for Azure Monitoring.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Localized friendly display name of the metric.
    :type display_name: str
    :param display_description: Localized friendly description of the metric.
    :type display_description: str
    :param unit: Unit that makes sense for the metric.
    :type unit: str
    :param category: Name of the metric category that the metric belongs to. A metric can only
     belong to a single category.
    :type category: str
    :param aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :type aggregation_type: str
    :param supported_aggregation_types: Supported aggregation types.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: Supported time grain types.
    :type supported_time_grain_types: list[str]
    :param fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :type fill_gap_with_zero: bool
    :param dimensions: Dimensions of the metric.
    :type dimensions: list[~azure.mgmt.avs.models.MetricDimension]
    :param enable_regional_mdm_account: Whether or not the service is using regional MDM accounts.
    :type enable_regional_mdm_account: str
    :param source_mdm_account: The name of the MDM account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The name of the MDM namespace.
    :type source_mdm_namespace: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'str'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        category: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        dimensions: Optional[List["MetricDimension"]] = None,
        enable_regional_mdm_account: Optional[str] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.category = category
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.fill_gap_with_zero = fill_gap_with_zero
        self.dimensions = dimensions
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace


class NetAppVolume(msrest.serialization.Model):
    """An Azure NetApp Files volume from Microsoft.NetApp provider.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Azure resource ID of the NetApp volume.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(NetAppVolume, self).__init__(**kwargs)
        self.id = id


class Operation(msrest.serialization.Model):
    """A REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation being performed on this object.
    :vartype name: str
    :ivar display: Contains the localized display information for this operation.
    :vartype display: ~azure.mgmt.avs.models.OperationDisplay
    :param is_data_action: Gets or sets a value indicating whether the operation is a data action
     or not.
    :type is_data_action: bool
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: ~azure.mgmt.avs.models.OperationProperties
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        origin: Optional[str] = None,
        properties: Optional["OperationProperties"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = is_data_action
        self.origin = origin
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """Contains the localized display information for this operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: Localized friendly form of the resource type related to this operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationList(msrest.serialization.Model):
    """Pageable list of operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations.
    :vartype value: list[~azure.mgmt.avs.models.Operation]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationProperties(msrest.serialization.Model):
    """Extra Operation properties.

    :param service_specification: Service specifications of the operation.
    :type service_specification: ~azure.mgmt.avs.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class PlacementPoliciesList(msrest.serialization.Model):
    """Represents list of placement policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.PlacementPolicy]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PlacementPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlacementPoliciesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PlacementPolicy(Resource):
    """A vSphere Distributed Resource Scheduler (DRS) placement policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: placement policy properties.
    :type properties: ~azure.mgmt.avs.models.PlacementPolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PlacementPolicyProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PlacementPolicyProperties"] = None,
        **kwargs
    ):
        super(PlacementPolicy, self).__init__(**kwargs)
        self.properties = properties


class PlacementPolicyProperties(msrest.serialization.Model):
    """Abstract placement policy properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VmHostPlacementPolicyProperties, VmPlacementPolicyProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. placement policy type.Constant filled by server.  Possible values
     include: "VmVm", "VmHost".
    :type type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :param state: Whether the placement policy is enabled or disabled. Possible values include:
     "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :param display_name: Display name of the placement policy.
    :type display_name: str
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    """

    _validation = {
        'type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'VmHost': 'VmHostPlacementPolicyProperties', 'VmVm': 'VmPlacementPolicyProperties'}
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(PlacementPolicyProperties, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.state = state
        self.display_name = display_name
        self.provisioning_state = None


class PlacementPolicyUpdate(msrest.serialization.Model):
    """An update of a DRS placement policy resource.

    :param state: Whether the placement policy is enabled or disabled. Possible values include:
     "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :param vm_members: Virtual machine members list.
    :type vm_members: list[str]
    :param host_members: Host members list.
    :type host_members: list[str]
    """

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'vm_members': {'key': 'properties.vmMembers', 'type': '[str]'},
        'host_members': {'key': 'properties.hostMembers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "PlacementPolicyState"]] = None,
        vm_members: Optional[List[str]] = None,
        host_members: Optional[List[str]] = None,
        **kwargs
    ):
        super(PlacementPolicyUpdate, self).__init__(**kwargs)
        self.state = state
        self.vm_members = vm_members
        self.host_members = host_members


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class PrivateCloud(TrackedResource):
    """A private cloud resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The private cloud SKU.
    :type sku: ~azure.mgmt.avs.models.Sku
    :param identity: The identity of the private cloud, if configured.
    :type identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :param management_cluster: The default cluster used for management.
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible values include:
     "Enabled", "Disabled". Default value: "Disabled".
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources.
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :param availability: Properties describing how the cloud is distributed across availability
     zones.
    :type availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :param encryption: Customer managed key encryption, can be enabled or disabled.
    :type encryption: ~azure.mgmt.avs.models.Encryption
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PrivateCloudProvisioningState
    :param circuit: An ExpressRoute Circuit.
    :type circuit: ~azure.mgmt.avs.models.Circuit
    :ivar endpoints: The endpoints.
    :vartype endpoints: ~azure.mgmt.avs.models.Endpoints
    :param network_block: The block of addresses should be unique across VNet in your subscription
     as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are
     between 0 and 255, and X is between 0 and 22.
    :type network_block: str
    :ivar management_network: Network used to access vCenter Server and NSX-T Manager.
    :vartype management_network: str
    :ivar provisioning_network: Used for virtual machine cold migration, cloning, and snapshot
     migration.
    :vartype provisioning_network: str
    :ivar vmotion_network: Used for live migration of virtual machines.
    :vartype vmotion_network: str
    :param vcenter_password: Optionally, set the vCenter admin password when the private cloud is
     created.
    :type vcenter_password: str
    :param nsxt_password: Optionally, set the NSX-T Manager password when the private cloud is
     created.
    :type nsxt_password: str
    :ivar vcenter_certificate_thumbprint: Thumbprint of the vCenter Server SSL certificate.
    :vartype vcenter_certificate_thumbprint: str
    :ivar nsxt_certificate_thumbprint: Thumbprint of the NSX-T Manager SSL certificate.
    :vartype nsxt_certificate_thumbprint: str
    :ivar external_cloud_links: Array of cloud link IDs from other clouds that connect to this one.
    :vartype external_cloud_links: list[str]
    :param secondary_circuit: A secondary expressRoute circuit from a separate AZ. Only present in
     a stretched private cloud.
    :type secondary_circuit: ~azure.mgmt.avs.models.Circuit
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoints': {'readonly': True},
        'management_network': {'readonly': True},
        'provisioning_network': {'readonly': True},
        'vmotion_network': {'readonly': True},
        'vcenter_certificate_thumbprint': {'readonly': True},
        'nsxt_certificate_thumbprint': {'readonly': True},
        'external_cloud_links': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'PrivateCloudIdentity'},
        'management_cluster': {'key': 'properties.managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'properties.internet', 'type': 'str'},
        'identity_sources': {'key': 'properties.identitySources', 'type': '[IdentitySource]'},
        'availability': {'key': 'properties.availability', 'type': 'AvailabilityProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'circuit': {'key': 'properties.circuit', 'type': 'Circuit'},
        'endpoints': {'key': 'properties.endpoints', 'type': 'Endpoints'},
        'network_block': {'key': 'properties.networkBlock', 'type': 'str'},
        'management_network': {'key': 'properties.managementNetwork', 'type': 'str'},
        'provisioning_network': {'key': 'properties.provisioningNetwork', 'type': 'str'},
        'vmotion_network': {'key': 'properties.vmotionNetwork', 'type': 'str'},
        'vcenter_password': {'key': 'properties.vcenterPassword', 'type': 'str'},
        'nsxt_password': {'key': 'properties.nsxtPassword', 'type': 'str'},
        'vcenter_certificate_thumbprint': {'key': 'properties.vcenterCertificateThumbprint', 'type': 'str'},
        'nsxt_certificate_thumbprint': {'key': 'properties.nsxtCertificateThumbprint', 'type': 'str'},
        'external_cloud_links': {'key': 'properties.externalCloudLinks', 'type': '[str]'},
        'secondary_circuit': {'key': 'properties.secondaryCircuit', 'type': 'Circuit'},
    }

    def __init__(
        self,
        *,
        sku: "Sku",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["PrivateCloudIdentity"] = None,
        management_cluster: Optional["ManagementCluster"] = None,
        internet: Optional[Union[str, "InternetEnum"]] = "Disabled",
        identity_sources: Optional[List["IdentitySource"]] = None,
        availability: Optional["AvailabilityProperties"] = None,
        encryption: Optional["Encryption"] = None,
        circuit: Optional["Circuit"] = None,
        network_block: Optional[str] = None,
        vcenter_password: Optional[str] = None,
        nsxt_password: Optional[str] = None,
        secondary_circuit: Optional["Circuit"] = None,
        **kwargs
    ):
        super(PrivateCloud, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.availability = availability
        self.encryption = encryption
        self.provisioning_state = None
        self.circuit = circuit
        self.endpoints = None
        self.network_block = network_block
        self.management_network = None
        self.provisioning_network = None
        self.vmotion_network = None
        self.vcenter_password = vcenter_password
        self.nsxt_password = nsxt_password
        self.vcenter_certificate_thumbprint = None
        self.nsxt_certificate_thumbprint = None
        self.external_cloud_links = None
        self.secondary_circuit = secondary_circuit


class PrivateCloudIdentity(msrest.serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of private cloud identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID associated with the private cloud. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the private cloud. The type 'SystemAssigned' refers
     to an implicitly created identity. The type 'None' will remove any identities from the Private
     Cloud. Possible values include: "SystemAssigned", "None".
    :type type: str or ~azure.mgmt.avs.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        **kwargs
    ):
        super(PrivateCloudIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class PrivateCloudList(msrest.serialization.Model):
    """A paged list of private clouds.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.PrivateCloud]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateCloud]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateCloudList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateCloudUpdateProperties(msrest.serialization.Model):
    """The properties of a private cloud resource that may be updated.

    :param management_cluster: The default cluster used for management.
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible values include:
     "Enabled", "Disabled". Default value: "Disabled".
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources.
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :param availability: Properties describing how the cloud is distributed across availability
     zones.
    :type availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :param encryption: Customer managed key encryption, can be enabled or disabled.
    :type encryption: ~azure.mgmt.avs.models.Encryption
    """

    _attribute_map = {
        'management_cluster': {'key': 'managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'internet', 'type': 'str'},
        'identity_sources': {'key': 'identitySources', 'type': '[IdentitySource]'},
        'availability': {'key': 'availability', 'type': 'AvailabilityProperties'},
        'encryption': {'key': 'encryption', 'type': 'Encryption'},
    }

    def __init__(
        self,
        *,
        management_cluster: Optional["ManagementCluster"] = None,
        internet: Optional[Union[str, "InternetEnum"]] = "Disabled",
        identity_sources: Optional[List["IdentitySource"]] = None,
        availability: Optional["AvailabilityProperties"] = None,
        encryption: Optional["Encryption"] = None,
        **kwargs
    ):
        super(PrivateCloudUpdateProperties, self).__init__(**kwargs)
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.availability = availability
        self.encryption = encryption


class PrivateCloudProperties(PrivateCloudUpdateProperties):
    """The properties of a private cloud resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param management_cluster: The default cluster used for management.
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible values include:
     "Enabled", "Disabled". Default value: "Disabled".
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources.
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :param availability: Properties describing how the cloud is distributed across availability
     zones.
    :type availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :param encryption: Customer managed key encryption, can be enabled or disabled.
    :type encryption: ~azure.mgmt.avs.models.Encryption
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PrivateCloudProvisioningState
    :param circuit: An ExpressRoute Circuit.
    :type circuit: ~azure.mgmt.avs.models.Circuit
    :ivar endpoints: The endpoints.
    :vartype endpoints: ~azure.mgmt.avs.models.Endpoints
    :param network_block: Required. The block of addresses should be unique across VNet in your
     subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where
     A,B,C,D are between 0 and 255, and X is between 0 and 22.
    :type network_block: str
    :ivar management_network: Network used to access vCenter Server and NSX-T Manager.
    :vartype management_network: str
    :ivar provisioning_network: Used for virtual machine cold migration, cloning, and snapshot
     migration.
    :vartype provisioning_network: str
    :ivar vmotion_network: Used for live migration of virtual machines.
    :vartype vmotion_network: str
    :param vcenter_password: Optionally, set the vCenter admin password when the private cloud is
     created.
    :type vcenter_password: str
    :param nsxt_password: Optionally, set the NSX-T Manager password when the private cloud is
     created.
    :type nsxt_password: str
    :ivar vcenter_certificate_thumbprint: Thumbprint of the vCenter Server SSL certificate.
    :vartype vcenter_certificate_thumbprint: str
    :ivar nsxt_certificate_thumbprint: Thumbprint of the NSX-T Manager SSL certificate.
    :vartype nsxt_certificate_thumbprint: str
    :ivar external_cloud_links: Array of cloud link IDs from other clouds that connect to this one.
    :vartype external_cloud_links: list[str]
    :param secondary_circuit: A secondary expressRoute circuit from a separate AZ. Only present in
     a stretched private cloud.
    :type secondary_circuit: ~azure.mgmt.avs.models.Circuit
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'endpoints': {'readonly': True},
        'network_block': {'required': True},
        'management_network': {'readonly': True},
        'provisioning_network': {'readonly': True},
        'vmotion_network': {'readonly': True},
        'vcenter_certificate_thumbprint': {'readonly': True},
        'nsxt_certificate_thumbprint': {'readonly': True},
        'external_cloud_links': {'readonly': True},
    }

    _attribute_map = {
        'management_cluster': {'key': 'managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'internet', 'type': 'str'},
        'identity_sources': {'key': 'identitySources', 'type': '[IdentitySource]'},
        'availability': {'key': 'availability', 'type': 'AvailabilityProperties'},
        'encryption': {'key': 'encryption', 'type': 'Encryption'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'circuit': {'key': 'circuit', 'type': 'Circuit'},
        'endpoints': {'key': 'endpoints', 'type': 'Endpoints'},
        'network_block': {'key': 'networkBlock', 'type': 'str'},
        'management_network': {'key': 'managementNetwork', 'type': 'str'},
        'provisioning_network': {'key': 'provisioningNetwork', 'type': 'str'},
        'vmotion_network': {'key': 'vmotionNetwork', 'type': 'str'},
        'vcenter_password': {'key': 'vcenterPassword', 'type': 'str'},
        'nsxt_password': {'key': 'nsxtPassword', 'type': 'str'},
        'vcenter_certificate_thumbprint': {'key': 'vcenterCertificateThumbprint', 'type': 'str'},
        'nsxt_certificate_thumbprint': {'key': 'nsxtCertificateThumbprint', 'type': 'str'},
        'external_cloud_links': {'key': 'externalCloudLinks', 'type': '[str]'},
        'secondary_circuit': {'key': 'secondaryCircuit', 'type': 'Circuit'},
    }

    def __init__(
        self,
        *,
        network_block: str,
        management_cluster: Optional["ManagementCluster"] = None,
        internet: Optional[Union[str, "InternetEnum"]] = "Disabled",
        identity_sources: Optional[List["IdentitySource"]] = None,
        availability: Optional["AvailabilityProperties"] = None,
        encryption: Optional["Encryption"] = None,
        circuit: Optional["Circuit"] = None,
        vcenter_password: Optional[str] = None,
        nsxt_password: Optional[str] = None,
        secondary_circuit: Optional["Circuit"] = None,
        **kwargs
    ):
        super(PrivateCloudProperties, self).__init__(management_cluster=management_cluster, internet=internet, identity_sources=identity_sources, availability=availability, encryption=encryption, **kwargs)
        self.provisioning_state = None
        self.circuit = circuit
        self.endpoints = None
        self.network_block = network_block
        self.management_network = None
        self.provisioning_network = None
        self.vmotion_network = None
        self.vcenter_password = vcenter_password
        self.nsxt_password = nsxt_password
        self.vcenter_certificate_thumbprint = None
        self.nsxt_certificate_thumbprint = None
        self.external_cloud_links = None
        self.secondary_circuit = secondary_circuit


class PrivateCloudUpdate(msrest.serialization.Model):
    """An update to a private cloud resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The identity of the private cloud, if configured.
    :type identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :param management_cluster: The default cluster used for management.
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible values include:
     "Enabled", "Disabled". Default value: "Disabled".
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources.
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :param availability: Properties describing how the cloud is distributed across availability
     zones.
    :type availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :param encryption: Customer managed key encryption, can be enabled or disabled.
    :type encryption: ~azure.mgmt.avs.models.Encryption
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'PrivateCloudIdentity'},
        'management_cluster': {'key': 'properties.managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'properties.internet', 'type': 'str'},
        'identity_sources': {'key': 'properties.identitySources', 'type': '[IdentitySource]'},
        'availability': {'key': 'properties.availability', 'type': 'AvailabilityProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["PrivateCloudIdentity"] = None,
        management_cluster: Optional["ManagementCluster"] = None,
        internet: Optional[Union[str, "InternetEnum"]] = "Disabled",
        identity_sources: Optional[List["IdentitySource"]] = None,
        availability: Optional["AvailabilityProperties"] = None,
        encryption: Optional["Encryption"] = None,
        **kwargs
    ):
        super(PrivateCloudUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.availability = availability
        self.encryption = encryption


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class ScriptExecutionParameter(msrest.serialization.Model):
    """The arguments passed in to the execution.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PSCredentialExecutionParameter, ScriptSecureStringExecutionParameter, ScriptStringExecutionParameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name.
    :type name: str
    :param type: Required. The type of execution parameter.Constant filled by server.  Possible
     values include: "Value", "SecureValue", "Credential".
    :type type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Credential': 'PSCredentialExecutionParameter', 'SecureValue': 'ScriptSecureStringExecutionParameter', 'Value': 'ScriptStringExecutionParameter'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(ScriptExecutionParameter, self).__init__(**kwargs)
        self.name = name
        self.type = None  # type: Optional[str]


class PSCredentialExecutionParameter(ScriptExecutionParameter):
    """a powershell credential object.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name.
    :type name: str
    :param type: Required. The type of execution parameter.Constant filled by server.  Possible
     values include: "Value", "SecureValue", "Credential".
    :type type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :param username: username for login.
    :type username: str
    :param password: password for login.
    :type password: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(PSCredentialExecutionParameter, self).__init__(name=name, **kwargs)
        self.type = 'Credential'  # type: str
        self.username = username
        self.password = password


class Quota(msrest.serialization.Model):
    """Subscription quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hosts_remaining: Remaining hosts quota by sku type.
    :vartype hosts_remaining: dict[str, int]
    :ivar quota_enabled: Host quota is active for current subscription. Possible values include:
     "Enabled", "Disabled".
    :vartype quota_enabled: str or ~azure.mgmt.avs.models.QuotaEnabled
    """

    _validation = {
        'hosts_remaining': {'readonly': True},
        'quota_enabled': {'readonly': True},
    }

    _attribute_map = {
        'hosts_remaining': {'key': 'hostsRemaining', 'type': '{int}'},
        'quota_enabled': {'key': 'quotaEnabled', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Quota, self).__init__(**kwargs)
        self.hosts_remaining = None
        self.quota_enabled = None


class ScriptCmdlet(ProxyResource):
    """A cmdlet available for script execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the scripts functionality.
    :vartype description: str
    :ivar timeout: Recommended time limit for execution.
    :vartype timeout: str
    :ivar parameters: Parameters the script will accept.
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'timeout': {'readonly': True},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ScriptParameter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptCmdlet, self).__init__(**kwargs)
        self.description = None
        self.timeout = None
        self.parameters = None


class ScriptCmdletsList(msrest.serialization.Model):
    """Pageable list of scripts/cmdlets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of scripts.
    :vartype value: list[~azure.mgmt.avs.models.ScriptCmdlet]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScriptCmdlet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptCmdletsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScriptExecution(ProxyResource):
    """An instance of a script executed by a user - custom or AVS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param script_cmdlet_id: A reference to the script cmdlet resource if user is running a AVS
     script.
    :type script_cmdlet_id: str
    :param parameters: Parameters the script will accept.
    :type parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :param hidden_parameters: Parameters that will be hidden/not visible to ARM, such as passwords
     and credentials.
    :type hidden_parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :param failure_reason: Error message if the script was able to run, but if the script itself
     had errors or powershell threw an exception.
    :type failure_reason: str
    :param timeout: Time limit for execution.
    :type timeout: str
    :param retention: Time to live for the resource. If not provided, will be available for 60
     days.
    :type retention: str
    :ivar submitted_at: Time the script execution was submitted.
    :vartype submitted_at: ~datetime.datetime
    :ivar started_at: Time the script execution was started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: Time the script execution was finished.
    :vartype finished_at: ~datetime.datetime
    :ivar provisioning_state: The state of the script execution resource. Possible values include:
     "Pending", "Running", "Succeeded", "Failed", "Cancelling", "Cancelled", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptExecutionProvisioningState
    :param output: Standard output stream from the powershell execution.
    :type output: list[str]
    :param named_outputs: User-defined dictionary.
    :type named_outputs: dict[str, any]
    :ivar information: Standard information out stream from the powershell execution.
    :vartype information: list[str]
    :ivar warnings: Standard warning out stream from the powershell execution.
    :vartype warnings: list[str]
    :ivar errors: Standard error output stream from the powershell execution.
    :vartype errors: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'submitted_at': {'readonly': True},
        'started_at': {'readonly': True},
        'finished_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'information': {'readonly': True},
        'warnings': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'script_cmdlet_id': {'key': 'properties.scriptCmdletId', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ScriptExecutionParameter]'},
        'hidden_parameters': {'key': 'properties.hiddenParameters', 'type': '[ScriptExecutionParameter]'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'str'},
        'retention': {'key': 'properties.retention', 'type': 'str'},
        'submitted_at': {'key': 'properties.submittedAt', 'type': 'iso-8601'},
        'started_at': {'key': 'properties.startedAt', 'type': 'iso-8601'},
        'finished_at': {'key': 'properties.finishedAt', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'output': {'key': 'properties.output', 'type': '[str]'},
        'named_outputs': {'key': 'properties.namedOutputs', 'type': '{object}'},
        'information': {'key': 'properties.information', 'type': '[str]'},
        'warnings': {'key': 'properties.warnings', 'type': '[str]'},
        'errors': {'key': 'properties.errors', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        script_cmdlet_id: Optional[str] = None,
        parameters: Optional[List["ScriptExecutionParameter"]] = None,
        hidden_parameters: Optional[List["ScriptExecutionParameter"]] = None,
        failure_reason: Optional[str] = None,
        timeout: Optional[str] = None,
        retention: Optional[str] = None,
        output: Optional[List[str]] = None,
        named_outputs: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ScriptExecution, self).__init__(**kwargs)
        self.script_cmdlet_id = script_cmdlet_id
        self.parameters = parameters
        self.hidden_parameters = hidden_parameters
        self.failure_reason = failure_reason
        self.timeout = timeout
        self.retention = retention
        self.submitted_at = None
        self.started_at = None
        self.finished_at = None
        self.provisioning_state = None
        self.output = output
        self.named_outputs = named_outputs
        self.information = None
        self.warnings = None
        self.errors = None


class ScriptExecutionsList(msrest.serialization.Model):
    """Pageable list of script executions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of scripts.
    :vartype value: list[~azure.mgmt.avs.models.ScriptExecution]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScriptExecution]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptExecutionsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScriptPackage(ProxyResource):
    """Script Package resources available for execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: User friendly description of the package.
    :vartype description: str
    :ivar version: Module version.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptPackage, self).__init__(**kwargs)
        self.description = None
        self.version = None


class ScriptPackagesList(msrest.serialization.Model):
    """A list of the available script packages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of script package resources.
    :vartype value: list[~azure.mgmt.avs.models.ScriptPackage]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScriptPackage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptPackagesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScriptParameter(msrest.serialization.Model):
    """An parameter that the script will accept.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of parameter the script is expecting. psCredential is a
     PSCredentialObject. Possible values include: "String", "SecureString", "Credential", "Int",
     "Bool", "Float".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptParameterTypes
    :param name: The parameter name that the script will expect a parameter value for.
    :type name: str
    :ivar description: User friendly description of the parameter.
    :vartype description: str
    :ivar visibility: Should this parameter be visible to arm and passed in the parameters argument
     when executing. Possible values include: "Visible", "Hidden".
    :vartype visibility: str or ~azure.mgmt.avs.models.VisibilityParameterEnum
    :ivar optional: Is this parameter required or optional. Possible values include: "Optional",
     "Required".
    :vartype optional: str or ~azure.mgmt.avs.models.OptionalParamEnum
    """

    _validation = {
        'type': {'readonly': True},
        'description': {'readonly': True},
        'visibility': {'readonly': True},
        'optional': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
        'optional': {'key': 'optional', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ScriptParameter, self).__init__(**kwargs)
        self.type = None
        self.name = name
        self.description = None
        self.visibility = None
        self.optional = None


class ScriptSecureStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name.
    :type name: str
    :param type: Required. The type of execution parameter.Constant filled by server.  Possible
     values include: "Value", "SecureValue", "Credential".
    :type type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :param secure_value: A secure value for the passed parameter, not to be stored in logs.
    :type secure_value: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'secure_value': {'key': 'secureValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        secure_value: Optional[str] = None,
        **kwargs
    ):
        super(ScriptSecureStringExecutionParameter, self).__init__(name=name, **kwargs)
        self.type = 'SecureValue'  # type: str
        self.secure_value = secure_value


class ScriptStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name.
    :type name: str
    :param type: Required. The type of execution parameter.Constant filled by server.  Possible
     values include: "Value", "SecureValue", "Credential".
    :type type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :param value: The value for the passed parameter.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ScriptStringExecutionParameter, self).__init__(name=name, **kwargs)
        self.type = 'Value'  # type: str
        self.value = value


class ServiceSpecification(msrest.serialization.Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring.
    :type log_specifications: list[~azure.mgmt.avs.models.LogSpecification]
    :param metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :type metric_specifications: list[~azure.mgmt.avs.models.MetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["LogSpecification"]] = None,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name


class Trial(msrest.serialization.Model):
    """Subscription trial availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Trial status. Possible values include: "TrialAvailable", "TrialUsed",
     "TrialDisabled".
    :vartype status: str or ~azure.mgmt.avs.models.TrialStatus
    :ivar available_hosts: Number of trial hosts available.
    :vartype available_hosts: int
    """

    _validation = {
        'status': {'readonly': True},
        'available_hosts': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'available_hosts': {'key': 'availableHosts', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Trial, self).__init__(**kwargs)
        self.status = None
        self.available_hosts = None


class VirtualMachine(ProxyResource):
    """Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the VM.
    :vartype display_name: str
    :ivar mo_ref_id: Virtual machine managed object reference id.
    :vartype mo_ref_id: str
    :ivar folder_path: Path to virtual machine's folder starting from datacenter virtual machine
     folder.
    :vartype folder_path: str
    :ivar restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Possible values include: "Enabled", "Disabled".
    :vartype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'mo_ref_id': {'readonly': True},
        'folder_path': {'readonly': True},
        'restrict_movement': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'restrict_movement': {'key': 'properties.restrictMovement', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(**kwargs)
        self.display_name = None
        self.mo_ref_id = None
        self.folder_path = None
        self.restrict_movement = None


class VirtualMachineRestrictMovement(msrest.serialization.Model):
    """Set VM DRS-driven movement to restricted (enabled) or not (disabled).

    :param restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Possible values include: "Enabled", "Disabled".
    :type restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    _attribute_map = {
        'restrict_movement': {'key': 'restrictMovement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        restrict_movement: Optional[Union[str, "VirtualMachineRestrictMovementState"]] = None,
        **kwargs
    ):
        super(VirtualMachineRestrictMovement, self).__init__(**kwargs)
        self.restrict_movement = restrict_movement


class VirtualMachinesList(msrest.serialization.Model):
    """A list of Virtual Machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items to be displayed on the page.
    :vartype value: list[~azure.mgmt.avs.models.VirtualMachine]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachinesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class VmHostPlacementPolicyProperties(PlacementPolicyProperties):
    """VM-Host placement policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. placement policy type.Constant filled by server.  Possible values
     include: "VmVm", "VmHost".
    :type type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :param state: Whether the placement policy is enabled or disabled. Possible values include:
     "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :param display_name: Display name of the placement policy.
    :type display_name: str
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :param vm_members: Required. Virtual machine members list.
    :type vm_members: list[str]
    :param host_members: Required. Host members list.
    :type host_members: list[str]
    :param affinity_type: Required. placement policy affinity type. Possible values include:
     "Affinity", "AntiAffinity".
    :type affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    """

    _validation = {
        'type': {'required': True},
        'provisioning_state': {'readonly': True},
        'vm_members': {'required': True},
        'host_members': {'required': True},
        'affinity_type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'vm_members': {'key': 'vmMembers', 'type': '[str]'},
        'host_members': {'key': 'hostMembers', 'type': '[str]'},
        'affinity_type': {'key': 'affinityType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_members: List[str],
        host_members: List[str],
        affinity_type: Union[str, "AffinityType"],
        state: Optional[Union[str, "PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(VmHostPlacementPolicyProperties, self).__init__(state=state, display_name=display_name, **kwargs)
        self.type = 'VmHost'  # type: str
        self.vm_members = vm_members
        self.host_members = host_members
        self.affinity_type = affinity_type


class VmPlacementPolicyProperties(PlacementPolicyProperties):
    """VM-VM placement policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. placement policy type.Constant filled by server.  Possible values
     include: "VmVm", "VmHost".
    :type type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :param state: Whether the placement policy is enabled or disabled. Possible values include:
     "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :param display_name: Display name of the placement policy.
    :type display_name: str
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :param vm_members: Required. Virtual machine members list.
    :type vm_members: list[str]
    :param affinity_type: Required. placement policy affinity type. Possible values include:
     "Affinity", "AntiAffinity".
    :type affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    """

    _validation = {
        'type': {'required': True},
        'provisioning_state': {'readonly': True},
        'vm_members': {'required': True},
        'affinity_type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'vm_members': {'key': 'vmMembers', 'type': '[str]'},
        'affinity_type': {'key': 'affinityType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_members: List[str],
        affinity_type: Union[str, "AffinityType"],
        state: Optional[Union[str, "PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(VmPlacementPolicyProperties, self).__init__(state=state, display_name=display_name, **kwargs)
        self.type = 'VmVm'  # type: str
        self.vm_members = vm_members
        self.affinity_type = affinity_type


class WorkloadNetworkDhcp(ProxyResource):
    """NSX DHCP.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: DHCP properties.
    :type properties: ~azure.mgmt.avs.models.WorkloadNetworkDhcpEntity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadNetworkDhcpEntity'},
    }

    def __init__(
        self,
        *,
        properties: Optional["WorkloadNetworkDhcpEntity"] = None,
        **kwargs
    ):
        super(WorkloadNetworkDhcp, self).__init__(**kwargs)
        self.properties = properties


class WorkloadNetworkDhcpEntity(msrest.serialization.Model):
    """Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit from.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WorkloadNetworkDhcpRelay, WorkloadNetworkDhcpServer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param dhcp_type: Required. Type of DHCP: SERVER or RELAY.Constant filled by server.  Possible
     values include: "SERVER", "RELAY".
    :type dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'dhcp_type': {'required': True},
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
    }

    _subtype_map = {
        'dhcp_type': {'RELAY': 'WorkloadNetworkDhcpRelay', 'SERVER': 'WorkloadNetworkDhcpServer'}
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkDhcpEntity, self).__init__(**kwargs)
        self.dhcp_type = None  # type: Optional[str]
        self.display_name = display_name
        self.segments = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDhcpList(msrest.serialization.Model):
    """A list of NSX dhcp entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDhcp]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkDhcp]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkDhcpList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkDhcpRelay(WorkloadNetworkDhcpEntity):
    """NSX DHCP Relay.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param dhcp_type: Required. Type of DHCP: SERVER or RELAY.Constant filled by server.  Possible
     values include: "SERVER", "RELAY".
    :type dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    :param server_addresses: DHCP Relay Addresses. Max 3.
    :type server_addresses: list[str]
    """

    _validation = {
        'dhcp_type': {'required': True},
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'server_addresses': {'max_items': 3, 'min_items': 1},
    }

    _attribute_map = {
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
        'server_addresses': {'key': 'serverAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_addresses: Optional[List[str]] = None,
        **kwargs
    ):
        super(WorkloadNetworkDhcpRelay, self).__init__(display_name=display_name, revision=revision, **kwargs)
        self.dhcp_type = 'RELAY'  # type: str
        self.server_addresses = server_addresses


class WorkloadNetworkDhcpServer(WorkloadNetworkDhcpEntity):
    """NSX DHCP Server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param dhcp_type: Required. Type of DHCP: SERVER or RELAY.Constant filled by server.  Possible
     values include: "SERVER", "RELAY".
    :type dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    :param server_address: DHCP Server Address.
    :type server_address: str
    :param lease_time: DHCP Server Lease Time.
    :type lease_time: long
    """

    _validation = {
        'dhcp_type': {'required': True},
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
        'server_address': {'key': 'serverAddress', 'type': 'str'},
        'lease_time': {'key': 'leaseTime', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_address: Optional[str] = None,
        lease_time: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkDhcpServer, self).__init__(display_name=display_name, revision=revision, **kwargs)
        self.dhcp_type = 'SERVER'  # type: str
        self.server_address = server_address
        self.lease_time = lease_time


class WorkloadNetworkDnsService(ProxyResource):
    """NSX DNS Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DNS Service.
    :type display_name: str
    :param dns_service_ip: DNS service IP of the DNS Service.
    :type dns_service_ip: str
    :param default_dns_zone: Default DNS zone of the DNS Service.
    :type default_dns_zone: str
    :param fqdn_zones: FQDN zones of the DNS Service.
    :type fqdn_zones: list[str]
    :param log_level: DNS Service log level. Possible values include: "DEBUG", "INFO", "WARNING",
     "ERROR", "FATAL".
    :type log_level: str or ~azure.mgmt.avs.models.DnsServiceLogLevelEnum
    :ivar status: DNS Service status. Possible values include: "SUCCESS", "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.DnsServiceStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsServiceProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'dns_service_ip': {'key': 'properties.dnsServiceIp', 'type': 'str'},
        'default_dns_zone': {'key': 'properties.defaultDnsZone', 'type': 'str'},
        'fqdn_zones': {'key': 'properties.fqdnZones', 'type': '[str]'},
        'log_level': {'key': 'properties.logLevel', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        default_dns_zone: Optional[str] = None,
        fqdn_zones: Optional[List[str]] = None,
        log_level: Optional[Union[str, "DnsServiceLogLevelEnum"]] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkDnsService, self).__init__(**kwargs)
        self.display_name = display_name
        self.dns_service_ip = dns_service_ip
        self.default_dns_zone = default_dns_zone
        self.fqdn_zones = fqdn_zones
        self.log_level = log_level
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDnsServicesList(msrest.serialization.Model):
    """A list of NSX DNS Services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsService]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkDnsService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkDnsServicesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkDnsZone(ProxyResource):
    """NSX DNS Zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DNS Zone.
    :type display_name: str
    :param domain: Domain names of the DNS Zone.
    :type domain: list[str]
    :param dns_server_ips: DNS Server IP array of the DNS Zone.
    :type dns_server_ips: list[str]
    :param source_ip: Source IP of the DNS Zone.
    :type source_ip: str
    :param dns_services: Number of DNS Services using the DNS zone.
    :type dns_services: long
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsZoneProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'domain': {'key': 'properties.domain', 'type': '[str]'},
        'dns_server_ips': {'key': 'properties.dnsServerIps', 'type': '[str]'},
        'source_ip': {'key': 'properties.sourceIp', 'type': 'str'},
        'dns_services': {'key': 'properties.dnsServices', 'type': 'long'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        domain: Optional[List[str]] = None,
        dns_server_ips: Optional[List[str]] = None,
        source_ip: Optional[str] = None,
        dns_services: Optional[int] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkDnsZone, self).__init__(**kwargs)
        self.display_name = display_name
        self.domain = domain
        self.dns_server_ips = dns_server_ips
        self.source_ip = source_ip
        self.dns_services = dns_services
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDnsZonesList(msrest.serialization.Model):
    """A list of NSX DNS Zones.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsZone]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkDnsZone]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkDnsZonesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkGateway(ProxyResource):
    """NSX Gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar path: NSX Gateway Path.
    :vartype path: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'path': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadNetworkGateway, self).__init__(**kwargs)
        self.display_name = display_name
        self.path = None


class WorkloadNetworkGatewayList(msrest.serialization.Model):
    """A list of NSX Gateways.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkGateway]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkGatewayList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkPortMirroring(ProxyResource):
    """NSX Port Mirroring.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the port mirroring profile.
    :type display_name: str
    :param direction: Direction of port mirroring profile. Possible values include: "INGRESS",
     "EGRESS", "BIDIRECTIONAL".
    :type direction: str or ~azure.mgmt.avs.models.PortMirroringDirectionEnum
    :param source: Source VM Group.
    :type source: str
    :param destination: Destination VM Group.
    :type destination: str
    :ivar status: Port Mirroring Status. Possible values include: "SUCCESS", "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.PortMirroringStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPortMirroringProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        direction: Optional[Union[str, "PortMirroringDirectionEnum"]] = None,
        source: Optional[str] = None,
        destination: Optional[str] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkPortMirroring, self).__init__(**kwargs)
        self.display_name = display_name
        self.direction = direction
        self.source = source
        self.destination = destination
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkPortMirroringList(msrest.serialization.Model):
    """A list of NSX Port Mirroring.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkPortMirroring]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkPortMirroring]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkPortMirroringList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkPublicIP(ProxyResource):
    """NSX Public IP Block.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the Public IP Block.
    :type display_name: str
    :param number_of_public_i_ps: Number of Public IPs requested.
    :type number_of_public_i_ps: long
    :ivar public_ip_block: CIDR Block of the Public IP Block.
    :vartype public_ip_block: str
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPublicIPProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'public_ip_block': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'number_of_public_i_ps': {'key': 'properties.numberOfPublicIPs', 'type': 'long'},
        'public_ip_block': {'key': 'properties.publicIPBlock', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        number_of_public_i_ps: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkPublicIP, self).__init__(**kwargs)
        self.display_name = display_name
        self.number_of_public_i_ps = number_of_public_i_ps
        self.public_ip_block = None
        self.provisioning_state = None


class WorkloadNetworkPublicIPsList(msrest.serialization.Model):
    """A list of NSX Public IP Blocks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkPublicIP]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkPublicIP]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkPublicIPsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkSegment(ProxyResource):
    """NSX Segment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the segment.
    :type display_name: str
    :param connected_gateway: Gateway which to connect segment to.
    :type connected_gateway: str
    :param subnet: Subnet which to connect segment to.
    :type subnet: ~azure.mgmt.avs.models.WorkloadNetworkSegmentSubnet
    :ivar port_vif: Port Vif which segment is associated with.
    :vartype port_vif: list[~azure.mgmt.avs.models.WorkloadNetworkSegmentPortVif]
    :ivar status: Segment status. Possible values include: "SUCCESS", "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.SegmentStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkSegmentProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'port_vif': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'connected_gateway': {'key': 'properties.connectedGateway', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'WorkloadNetworkSegmentSubnet'},
        'port_vif': {'key': 'properties.portVif', 'type': '[WorkloadNetworkSegmentPortVif]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        connected_gateway: Optional[str] = None,
        subnet: Optional["WorkloadNetworkSegmentSubnet"] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkSegment, self).__init__(**kwargs)
        self.display_name = display_name
        self.connected_gateway = connected_gateway
        self.subnet = subnet
        self.port_vif = None
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkSegmentPortVif(msrest.serialization.Model):
    """Ports and any VIF attached to segment.

    :param port_name: Name of port or VIF attached to segment.
    :type port_name: str
    """

    _attribute_map = {
        'port_name': {'key': 'portName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        port_name: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadNetworkSegmentPortVif, self).__init__(**kwargs)
        self.port_name = port_name


class WorkloadNetworkSegmentsList(msrest.serialization.Model):
    """A list of NSX Segments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkSegment]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkSegment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkSegmentsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkSegmentSubnet(msrest.serialization.Model):
    """Subnet configuration for segment.

    :param dhcp_ranges: DHCP Range assigned for subnet.
    :type dhcp_ranges: list[str]
    :param gateway_address: Gateway address.
    :type gateway_address: str
    """

    _attribute_map = {
        'dhcp_ranges': {'key': 'dhcpRanges', 'type': '[str]'},
        'gateway_address': {'key': 'gatewayAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dhcp_ranges: Optional[List[str]] = None,
        gateway_address: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadNetworkSegmentSubnet, self).__init__(**kwargs)
        self.dhcp_ranges = dhcp_ranges
        self.gateway_address = gateway_address


class WorkloadNetworkVirtualMachine(ProxyResource):
    """NSX Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the VM.
    :type display_name: str
    :ivar vm_type: Virtual machine type. Possible values include: "REGULAR", "EDGE", "SERVICE".
    :vartype vm_type: str or ~azure.mgmt.avs.models.VMTypeEnum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'vm_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'vm_type': {'key': 'properties.vmType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadNetworkVirtualMachine, self).__init__(**kwargs)
        self.display_name = display_name
        self.vm_type = None


class WorkloadNetworkVirtualMachinesList(msrest.serialization.Model):
    """A list of NSX Virtual Machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkVirtualMachine]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkVirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkVirtualMachinesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadNetworkVMGroup(ProxyResource):
    """NSX VM Group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the VM group.
    :type display_name: str
    :param members: Virtual machine members of this group.
    :type members: list[str]
    :ivar status: VM Group status. Possible values include: "SUCCESS", "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.VMGroupStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include: "Succeeded",
     "Failed", "Building", "Deleting", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkVMGroupProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'members': {'key': 'properties.members', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        members: Optional[List[str]] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadNetworkVMGroup, self).__init__(**kwargs)
        self.display_name = display_name
        self.members = members
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkVMGroupsList(msrest.serialization.Model):
    """A list of NSX VM Groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The items on the page.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkVMGroup]
    :ivar next_link: URL to get the next page if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadNetworkVMGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadNetworkVMGroupsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
