# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import AVSClientConfiguration
from .operations import Operations
from .operations import LocationsOperations
from .operations import PrivateCloudsOperations
from .operations import ClustersOperations
from .operations import DatastoresOperations
from .operations import HcxEnterpriseSitesOperations
from .operations import AuthorizationsOperations
from .operations import GlobalReachConnectionsOperations
from .operations import WorkloadNetworksOperations
from .operations import CloudLinksOperations
from .operations import AddonsOperations
from .operations import VirtualMachinesOperations
from .operations import PlacementPoliciesOperations
from .operations import ScriptPackagesOperations
from .operations import ScriptCmdletsOperations
from .operations import ScriptExecutionsOperations
from . import models


class AVSClient(object):
    """Azure VMware Solution API.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.avs.operations.Operations
    :ivar locations: LocationsOperations operations
    :vartype locations: azure.mgmt.avs.operations.LocationsOperations
    :ivar private_clouds: PrivateCloudsOperations operations
    :vartype private_clouds: azure.mgmt.avs.operations.PrivateCloudsOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.avs.operations.ClustersOperations
    :ivar datastores: DatastoresOperations operations
    :vartype datastores: azure.mgmt.avs.operations.DatastoresOperations
    :ivar hcx_enterprise_sites: HcxEnterpriseSitesOperations operations
    :vartype hcx_enterprise_sites: azure.mgmt.avs.operations.HcxEnterpriseSitesOperations
    :ivar authorizations: AuthorizationsOperations operations
    :vartype authorizations: azure.mgmt.avs.operations.AuthorizationsOperations
    :ivar global_reach_connections: GlobalReachConnectionsOperations operations
    :vartype global_reach_connections: azure.mgmt.avs.operations.GlobalReachConnectionsOperations
    :ivar workload_networks: WorkloadNetworksOperations operations
    :vartype workload_networks: azure.mgmt.avs.operations.WorkloadNetworksOperations
    :ivar cloud_links: CloudLinksOperations operations
    :vartype cloud_links: azure.mgmt.avs.operations.CloudLinksOperations
    :ivar addons: AddonsOperations operations
    :vartype addons: azure.mgmt.avs.operations.AddonsOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.avs.operations.VirtualMachinesOperations
    :ivar placement_policies: PlacementPoliciesOperations operations
    :vartype placement_policies: azure.mgmt.avs.operations.PlacementPoliciesOperations
    :ivar script_packages: ScriptPackagesOperations operations
    :vartype script_packages: azure.mgmt.avs.operations.ScriptPackagesOperations
    :ivar script_cmdlets: ScriptCmdletsOperations operations
    :vartype script_cmdlets: azure.mgmt.avs.operations.ScriptCmdletsOperations
    :ivar script_executions: ScriptExecutionsOperations operations
    :vartype script_executions: azure.mgmt.avs.operations.ScriptExecutionsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AVSClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_clouds = PrivateCloudsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.datastores = DatastoresOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hcx_enterprise_sites = HcxEnterpriseSitesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.authorizations = AuthorizationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.global_reach_connections = GlobalReachConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.workload_networks = WorkloadNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_links = CloudLinksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.addons = AddonsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.placement_policies = PlacementPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.script_packages = ScriptPackagesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.script_cmdlets = ScriptCmdletsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.script_executions = ScriptExecutionsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> AVSClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
