# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import MicrosoftSupportConfiguration
from .operations import Operations
from .operations import ServicesOperations
from .operations import ProblemClassificationsOperations
from .operations import SupportTicketsOperations
from .operations import CommunicationsOperations
from . import models


class MicrosoftSupport(SDKClient):
    """Microsoft Azure Support Resource Provider.

    :ivar config: Configuration for client.
    :vartype config: MicrosoftSupportConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.support.operations.Operations
    :ivar services: Services operations
    :vartype services: azure.mgmt.support.operations.ServicesOperations
    :ivar problem_classifications: ProblemClassifications operations
    :vartype problem_classifications: azure.mgmt.support.operations.ProblemClassificationsOperations
    :ivar support_tickets: SupportTickets operations
    :vartype support_tickets: azure.mgmt.support.operations.SupportTicketsOperations
    :ivar communications: Communications operations
    :vartype communications: azure.mgmt.support.operations.CommunicationsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Azure subscription id
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MicrosoftSupportConfiguration(credentials, subscription_id, base_url)
        super(MicrosoftSupport, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-04-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.services = ServicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.problem_classifications = ProblemClassificationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.support_tickets = SupportTicketsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.communications = CommunicationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
