# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import EventGridManagementClientConfiguration
from .operations import DomainsOperations
from .operations import DomainTopicsOperations
from .operations import EventSubscriptionsOperations
from .operations import Operations
from .operations import TopicsOperations
from .operations import PrivateEndpointConnectionsOperations
from .operations import PrivateLinkResourcesOperations
from .operations import TopicTypesOperations
from . import models


class EventGridManagementClient(SDKClient):
    """Azure EventGrid Management Client

    :ivar config: Configuration for client.
    :vartype config: EventGridManagementClientConfiguration

    :ivar domains: Domains operations
    :vartype domains: azure.mgmt.eventgrid.operations.DomainsOperations
    :ivar domain_topics: DomainTopics operations
    :vartype domain_topics: azure.mgmt.eventgrid.operations.DomainTopicsOperations
    :ivar event_subscriptions: EventSubscriptions operations
    :vartype event_subscriptions: azure.mgmt.eventgrid.operations.EventSubscriptionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.eventgrid.operations.Operations
    :ivar topics: Topics operations
    :vartype topics: azure.mgmt.eventgrid.operations.TopicsOperations
    :ivar private_endpoint_connections: PrivateEndpointConnections operations
    :vartype private_endpoint_connections: azure.mgmt.eventgrid.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResources operations
    :vartype private_link_resources: azure.mgmt.eventgrid.operations.PrivateLinkResourcesOperations
    :ivar topic_types: TopicTypes operations
    :vartype topic_types: azure.mgmt.eventgrid.operations.TopicTypesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify a
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = EventGridManagementClientConfiguration(credentials, subscription_id, base_url)
        super(EventGridManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-06-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.domains = DomainsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.domain_topics = DomainTopicsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.event_subscriptions = EventSubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.topics = TopicsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.topic_types = TopicTypesOperations(
            self._client, self.config, self._serialize, self._deserialize)
