# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class DiskStorageAccountTypes(str, Enum):

    standard_lrs = "Standard_LRS"  #: Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access.
    premium_lrs = "Premium_LRS"  #: Premium SSD locally redundant storage. Best for production and performance sensitive workloads.
    standard_ssd_lrs = "StandardSSD_LRS"  #: Standard SSD locally redundant storage. Best for web servers, lightly used enterprise applications and dev/test.
    ultra_ssd_lrs = "UltraSSD_LRS"  #: Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA, top tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.


class OperatingSystemTypes(str, Enum):

    windows = "Windows"
    linux = "Linux"


class HyperVGeneration(str, Enum):

    v1 = "V1"
    v2 = "V2"


class DiskCreateOption(str, Enum):

    empty = "Empty"  #: Create an empty data disk of a size given by diskSizeGB.
    attach = "Attach"  #: Disk will be attached to a VM.
    from_image = "FromImage"  #: Create a new disk from a platform image specified by the given imageReference or galleryImageReference.
    import_enum = "Import"  #: Create a disk by importing from a blob specified by a sourceUri in a storage account specified by storageAccountId.
    copy = "Copy"  #: Create a new disk or snapshot by copying from a disk or snapshot specified by the given sourceResourceId.
    restore = "Restore"  #: Create a new disk by copying from a backup recovery point.
    upload = "Upload"  #: Create a new disk by obtaining a write token and using it to directly upload the contents of the disk.


class DiskState(str, Enum):

    unattached = "Unattached"  #: The disk is not being used and can be attached to a VM.
    attached = "Attached"  #: The disk is currently mounted to a running VM.
    reserved = "Reserved"  #: The disk is mounted to a stopped-deallocated VM
    active_sas = "ActiveSAS"  #: The disk currently has an Active SAS Uri associated with it.
    ready_to_upload = "ReadyToUpload"  #: A disk is ready to be created by upload by requesting a write token.
    active_upload = "ActiveUpload"  #: A disk is created for upload and a write token has been issued for uploading to it.


class EncryptionType(str, Enum):

    encryption_at_rest_with_platform_key = "EncryptionAtRestWithPlatformKey"  #: Disk is encrypted at rest with Platform managed key. It is the default encryption type. This is not a valid encryption type for disk encryption sets.
    encryption_at_rest_with_customer_key = "EncryptionAtRestWithCustomerKey"  #: Disk is encrypted at rest with Customer managed key that can be changed and revoked by a customer.
    encryption_at_rest_with_platform_and_customer_keys = "EncryptionAtRestWithPlatformAndCustomerKeys"  #: Disk is encrypted at rest with 2 layers of encryption. One of the keys is Customer managed and the other key is Platform managed.


class NetworkAccessPolicy(str, Enum):

    allow_all = "AllowAll"  #: The disk can be exported or uploaded to from any network.
    allow_private = "AllowPrivate"  #: The disk can be exported or uploaded to using a DiskAccess resource's private endpoints.
    deny_all = "DenyAll"  #: The disk cannot be exported.


class SnapshotStorageAccountTypes(str, Enum):

    standard_lrs = "Standard_LRS"  #: Standard HDD locally redundant storage
    premium_lrs = "Premium_LRS"  #: Premium SSD locally redundant storage
    standard_zrs = "Standard_ZRS"  #: Standard zone redundant storage


class AccessLevel(str, Enum):

    none = "None"
    read = "Read"
    write = "Write"


class DiskEncryptionSetIdentityType(str, Enum):

    system_assigned = "SystemAssigned"


class PrivateEndpointServiceConnectionStatus(str, Enum):

    pending = "Pending"
    approved = "Approved"
    rejected = "Rejected"


class PrivateEndpointConnectionProvisioningState(str, Enum):

    succeeded = "Succeeded"
    creating = "Creating"
    deleting = "Deleting"
    failed = "Failed"
