# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse

from .. import models


class RuntimeOperations(object):
    """RuntimeOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def generate_answer(
            self, kb_id, generate_answer_payload, custom_headers=None, raw=False, **operation_config):
        """GenerateAnswer call to query the knowledgebase.

        :param kb_id: Knowledgebase id.
        :type kb_id: str
        :param generate_answer_payload: Post body of the request.
        :type generate_answer_payload:
         ~azure.cognitiveservices.knowledge.qnamaker.runtime.models.QueryDTO
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: QnASearchResultList or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.knowledge.qnamaker.runtime.models.QnASearchResultList
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.knowledge.qnamaker.runtime.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.generate_answer.metadata['url']
        path_format_arguments = {
            'RuntimeEndpoint': self._serialize.url("self.config.runtime_endpoint", self.config.runtime_endpoint, 'str', skip_quote=True),
            'kbId': self._serialize.url("kb_id", kb_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(generate_answer_payload, 'QueryDTO')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('QnASearchResultList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    generate_answer.metadata = {'url': '/knowledgebases/{kbId}/generateAnswer'}

    def train(
            self, kb_id, feedback_records=None, custom_headers=None, raw=False, **operation_config):
        """Train call to add suggestions to the knowledgebase.

        :param kb_id: Knowledgebase id.
        :type kb_id: str
        :param feedback_records: List of feedback records.
        :type feedback_records:
         list[~azure.cognitiveservices.knowledge.qnamaker.runtime.models.FeedbackRecordDTO]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.knowledge.qnamaker.runtime.models.ErrorResponseException>`
        """
        train_payload = models.FeedbackRecordsDTO(feedback_records=feedback_records)

        # Construct URL
        url = self.train.metadata['url']
        path_format_arguments = {
            'RuntimeEndpoint': self._serialize.url("self.config.runtime_endpoint", self.config.runtime_endpoint, 'str', skip_quote=True),
            'kbId': self._serialize.url("kb_id", kb_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(train_payload, 'FeedbackRecordsDTO')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise models.ErrorResponseException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    train.metadata = {'url': '/knowledgebases/{kbId}/train'}
