# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class QueryDTO(Model):
    """POST body schema to query the knowledgebase.

    :param qna_id: Exact qnaId to fetch from the knowledgebase, this field
     takes priority over question.
    :type qna_id: str
    :param question: User question to query against the knowledge base.
    :type question: str
    :param top: Max number of answers to be returned for the question.
    :type top: int
    :param user_id: Unique identifier for the user.
    :type user_id: str
    :param is_test: Query against the test index.
    :type is_test: bool
    :param score_threshold: Threshold for answers returned based on score.
    :type score_threshold: float
    :param context: Context object with previous QnA's information.
    :type context:
     ~azure.cognitiveservices.knowledge.qnamaker.runtime.models.QueryDTOContext
    :param ranker_type: Optional field. Set to 'QuestionOnly' for using a
     question only Ranker.
    :type ranker_type: str
    :param strict_filters: Find only answers that contain these metadata.
    :type strict_filters:
     list[~azure.cognitiveservices.knowledge.qnamaker.runtime.models.MetadataDTO]
    """

    _attribute_map = {
        'qna_id': {'key': 'qnaId', 'type': 'str'},
        'question': {'key': 'question', 'type': 'str'},
        'top': {'key': 'top', 'type': 'int'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'is_test': {'key': 'isTest', 'type': 'bool'},
        'score_threshold': {'key': 'scoreThreshold', 'type': 'float'},
        'context': {'key': 'context', 'type': 'QueryDTOContext'},
        'ranker_type': {'key': 'rankerType', 'type': 'str'},
        'strict_filters': {'key': 'strictFilters', 'type': '[MetadataDTO]'},
    }

    def __init__(self, **kwargs):
        super(QueryDTO, self).__init__(**kwargs)
        self.qna_id = kwargs.get('qna_id', None)
        self.question = kwargs.get('question', None)
        self.top = kwargs.get('top', None)
        self.user_id = kwargs.get('user_id', None)
        self.is_test = kwargs.get('is_test', None)
        self.score_threshold = kwargs.get('score_threshold', None)
        self.context = kwargs.get('context', None)
        self.ranker_type = kwargs.get('ranker_type', None)
        self.strict_filters = kwargs.get('strict_filters', None)
