# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class OSType(str, Enum):

    linux = "linux"  #: The Linux operating system.
    windows = "windows"  #: The Windows operating system.


class VerificationType(str, Enum):

    verified = "verified"  #: The Image is guaranteed to be compatible with the associated Compute Node agent SKU and all Batch features have been confirmed to work as expected.
    unverified = "unverified"  #: The associated Compute Node agent SKU should have binary compatibility with the Image, but specific functionality has not been verified.


class AccessScope(str, Enum):

    job = "job"  #: Grants access to perform all operations on the Job containing the Task.


class CertificateState(str, Enum):

    active = "active"  #: The Certificate is available for use in Pools.
    deleting = "deleting"  #: The user has requested that the Certificate be deleted, but the delete operation has not yet completed. You may not reference the Certificate when creating or updating Pools.
    delete_failed = "deletefailed"  #: The user requested that the Certificate be deleted, but there are Pools that still have references to the Certificate, or it is still installed on one or more Nodes. (The latter can occur if the Certificate has been removed from the Pool, but the Compute Node has not yet restarted. Compute Nodes refresh their Certificates only when they restart.) You may use the cancel Certificate delete operation to cancel the delete, or the delete Certificate operation to retry the delete.


class CertificateFormat(str, Enum):

    pfx = "pfx"  #: The Certificate is a PFX (PKCS#12) formatted Certificate or Certificate chain.
    cer = "cer"  #: The Certificate is a base64-encoded X.509 Certificate.


class ContainerWorkingDirectory(str, Enum):

    task_working_directory = "taskWorkingDirectory"  #: Use the standard Batch service Task working directory, which will contain the Task Resource Files populated by Batch.
    container_image_default = "containerImageDefault"  #: Use the working directory defined in the container Image. Beware that this directory will not contain the Resource Files downloaded by Batch.


class JobAction(str, Enum):

    none = "none"  #: Take no action.
    disable = "disable"  #: Disable the Job. This is equivalent to calling the disable Job API, with a disableTasks value of requeue.
    terminate = "terminate"  #: Terminate the Job. The terminateReason in the Job's executionInfo is set to "TaskFailed".


class DependencyAction(str, Enum):

    satisfy = "satisfy"  #: Satisfy tasks waiting on this task; once all dependencies are satisfied, the task will be scheduled to run.
    block = "block"  #: Blocks tasks waiting on this task, preventing them from being scheduled.


class AutoUserScope(str, Enum):

    task = "task"  #: Specifies that the service should create a new user for the Task.
    pool = "pool"  #: Specifies that the Task runs as the common auto user Account which is created on every Compute Node in a Pool.


class ElevationLevel(str, Enum):

    non_admin = "nonadmin"  #: The user is a standard user without elevated access.
    admin = "admin"  #: The user is a user with elevated access and operates with full Administrator permissions.


class LoginMode(str, Enum):

    batch = "batch"  #: The LOGON32_LOGON_BATCH Win32 login mode. The batch login mode is recommended for long running parallel processes.
    interactive = "interactive"  #: The LOGON32_LOGON_INTERACTIVE Win32 login mode. UAC is enabled on Windows VirtualMachineConfiguration Pools. If this option is used with an elevated user identity in a Windows VirtualMachineConfiguration Pool, the user session will not be elevated unless the application executed by the Task command line is configured to always require administrative privilege or to always require maximum privilege.


class OutputFileUploadCondition(str, Enum):

    task_success = "tasksuccess"  #: Upload the file(s) only after the Task process exits with an exit code of 0.
    task_failure = "taskfailure"  #: Upload the file(s) only after the Task process exits with a nonzero exit code.
    task_completion = "taskcompletion"  #: Upload the file(s) after the Task process exits, no matter what the exit code was.


class ComputeNodeFillType(str, Enum):

    spread = "spread"  #: Tasks should be assigned evenly across all Compute Nodes in the Pool.
    pack = "pack"  #: As many Tasks as possible (maxTasksPerNode) should be assigned to each Compute Node in the Pool before any Tasks are assigned to the next Compute Node in the Pool.


class CertificateStoreLocation(str, Enum):

    current_user = "currentuser"  #: Certificates should be installed to the CurrentUser Certificate store.
    local_machine = "localmachine"  #: Certificates should be installed to the LocalMachine Certificate store.


class CertificateVisibility(str, Enum):

    start_task = "starttask"  #: The Certificate should be visible to the user account under which the StartTask is run. Note that if AutoUser Scope is Pool for both the StartTask and a Task, this certificate will be visible to the Task as well.
    task = "task"  #: The Certificate should be visible to the user accounts under which Job Tasks are run.
    remote_user = "remoteuser"  #: The Certificate should be visible to the user accounts under which users remotely access the Compute Node.


class CachingType(str, Enum):

    none = "none"  #: The caching mode for the disk is not enabled.
    read_only = "readonly"  #: The caching mode for the disk is read only.
    read_write = "readwrite"  #: The caching mode for the disk is read and write.


class StorageAccountType(str, Enum):

    standard_lrs = "standard_lrs"  #: The data disk should use standard locally redundant storage.
    premium_lrs = "premium_lrs"  #: The data disk should use premium locally redundant storage.


class DiskEncryptionTarget(str, Enum):

    os_disk = "osdisk"  #: The OS Disk on the compute node is encrypted.
    temporary_disk = "temporarydisk"  #: The temporary disk on the compute node is encrypted. On Linux this encryption applies to other partitions (such as those on mounted data disks) when encryption occurs at boot time.


class DynamicVNetAssignmentScope(str, Enum):

    none = "none"  #: No dynamic VNet assignment is enabled.
    job = "job"  #: Dynamic VNet assignment is done per-job.


class InboundEndpointProtocol(str, Enum):

    tcp = "tcp"  #: Use TCP for the endpoint.
    udp = "udp"  #: Use UDP for the endpoint.


class NetworkSecurityGroupRuleAccess(str, Enum):

    allow = "allow"  #: Allow access.
    deny = "deny"  #: Deny access.


class IPAddressProvisioningType(str, Enum):

    batch_managed = "batchmanaged"  #: A public IP will be created and managed by Batch. There may be multiple public IPs depending on the size of the Pool.
    user_managed = "usermanaged"  #: Public IPs are provided by the user and will be used to provision the Compute Nodes.
    no_public_ip_addresses = "nopublicipaddresses"  #: No public IP Address will be created.


class PoolLifetimeOption(str, Enum):

    job_schedule = "jobschedule"  #: The Pool exists for the lifetime of the Job Schedule. The Batch Service creates the Pool when it creates the first Job on the schedule. You may apply this option only to Job Schedules, not to Jobs.
    job = "job"  #: The Pool exists for the lifetime of the Job to which it is dedicated. The Batch service creates the Pool when it creates the Job. If the 'job' option is applied to a Job Schedule, the Batch service creates a new auto Pool for every Job created on the schedule.


class OnAllTasksComplete(str, Enum):

    no_action = "noaction"  #: Do nothing. The Job remains active unless terminated or disabled by some other means.
    terminate_job = "terminatejob"  #: Terminate the Job. The Job's terminateReason is set to 'AllTasksComplete'.


class OnTaskFailure(str, Enum):

    no_action = "noaction"  #: Do nothing. The Job remains active unless terminated or disabled by some other means.
    perform_exit_options_job_action = "performexitoptionsjobaction"  #: Take the action associated with the Task exit condition in the Task's exitConditions collection. (This may still result in no action being taken, if that is what the Task specifies.)


class JobScheduleState(str, Enum):

    active = "active"  #: The Job Schedule is active and will create Jobs as per its schedule.
    completed = "completed"  #: The Job Schedule has terminated, either by reaching its end time or by the user terminating it explicitly.
    disabled = "disabled"  #: The user has disabled the Job Schedule. The scheduler will not initiate any new Jobs will on this schedule, but any existing active Job will continue to run.
    terminating = "terminating"  #: The Job Schedule has no more work to do, or has been explicitly terminated by the user, but the termination operation is still in progress. The scheduler will not initiate any new Jobs for this Job Schedule, nor is any existing Job active.
    deleting = "deleting"  #: The user has requested that the Job Schedule be deleted, but the delete operation is still in progress. The scheduler will not initiate any new Jobs for this Job Schedule, and will delete any existing Jobs and Tasks under the Job Schedule, including any active Job. The Job Schedule will be deleted when all Jobs and Tasks under the Job Schedule have been deleted.


class ErrorCategory(str, Enum):

    user_error = "usererror"  #: The error is due to a user issue, such as misconfiguration.
    server_error = "servererror"  #: The error is due to an internal server issue.


class JobState(str, Enum):

    active = "active"  #: The Job is available to have Tasks scheduled.
    disabling = "disabling"  #: A user has requested that the Job be disabled, but the disable operation is still in progress (for example, waiting for Tasks to terminate).
    disabled = "disabled"  #: A user has disabled the Job. No Tasks are running, and no new Tasks will be scheduled.
    enabling = "enabling"  #: A user has requested that the Job be enabled, but the enable operation is still in progress.
    terminating = "terminating"  #: The Job is about to complete, either because a Job Manager Task has completed or because the user has terminated the Job, but the terminate operation is still in progress (for example, because Job Release Tasks are running).
    completed = "completed"  #: All Tasks have terminated, and the system will not accept any more Tasks or any further changes to the Job.
    deleting = "deleting"  #: A user has requested that the Job be deleted, but the delete operation is still in progress (for example, because the system is still terminating running Tasks).


class JobPreparationTaskState(str, Enum):

    running = "running"  #: The Task is currently running (including retrying).
    completed = "completed"  #: The Task has exited with exit code 0, or the Task has exhausted its retry limit, or the Batch service was unable to start the Task due to Task preparation errors (such as resource file download failures).


class TaskExecutionResult(str, Enum):

    success = "success"  #: The Task ran successfully.
    failure = "failure"  #: There was an error during processing of the Task. The failure may have occurred before the Task process was launched, while the Task process was executing, or after the Task process exited.


class JobReleaseTaskState(str, Enum):

    running = "running"  #: The Task is currently running (including retrying).
    completed = "completed"  #: The Task has exited with exit code 0, or the Task has exhausted its retry limit, or the Batch service was unable to start the Task due to Task preparation errors (such as resource file download failures).


class PoolState(str, Enum):

    active = "active"  #: The Pool is available to run Tasks subject to the availability of Compute Nodes.
    deleting = "deleting"  #: The user has requested that the Pool be deleted, but the delete operation has not yet completed.


class AllocationState(str, Enum):

    steady = "steady"  #: The Pool is not resizing. There are no changes to the number of Compute Nodes in the Pool in progress. A Pool enters this state when it is created and when no operations are being performed on the Pool to change the number of Compute Nodes.
    resizing = "resizing"  #: The Pool is resizing; that is, Compute Nodes are being added to or removed from the Pool.
    stopping = "stopping"  #: The Pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed.


class TaskState(str, Enum):

    active = "active"  #: The Task is queued and able to run, but is not currently assigned to a Compute Node. A Task enters this state when it is created, when it is enabled after being disabled, or when it is awaiting a retry after a failed run.
    preparing = "preparing"  #: The Task has been assigned to a Compute Node, but is waiting for a required Job Preparation Task to complete on the Compute Node. If the Job Preparation Task succeeds, the Task will move to running. If the Job Preparation Task fails, the Task will return to active and will be eligible to be assigned to a different Compute Node.
    running = "running"  #: The Task is running on a Compute Node. This includes task-level preparation such as downloading resource files or deploying Packages specified on the Task - it does not necessarily mean that the Task command line has started executing.
    completed = "completed"  #: The Task is no longer eligible to run, usually because the Task has finished successfully, or the Task has finished unsuccessfully and has exhausted its retry limit. A Task is also marked as completed if an error occurred launching the Task, or when the Task has been terminated.


class TaskAddStatus(str, Enum):

    success = "success"  #: The Task was added successfully.
    client_error = "clienterror"  #: The Task failed to add due to a client error and should not be retried without modifying the request as appropriate.
    server_error = "servererror"  #: Task failed to add due to a server error and can be retried without modification.


class SubtaskState(str, Enum):

    preparing = "preparing"  #: The Task has been assigned to a Compute Node, but is waiting for a required Job Preparation Task to complete on the Compute Node. If the Job Preparation Task succeeds, the Task will move to running. If the Job Preparation Task fails, the Task will return to active and will be eligible to be assigned to a different Compute Node.
    running = "running"  #: The Task is running on a Compute Node. This includes task-level preparation such as downloading resource files or deploying Packages specified on the Task - it does not necessarily mean that the Task command line has started executing.
    completed = "completed"  #: The Task is no longer eligible to run, usually because the Task has finished successfully, or the Task has finished unsuccessfully and has exhausted its retry limit. A Task is also marked as completed if an error occurred launching the Task, or when the Task has been terminated.


class StartTaskState(str, Enum):

    running = "running"  #: The StartTask is currently running.
    completed = "completed"  #: The StartTask has exited with exit code 0, or the StartTask has failed and the retry limit has reached, or the StartTask process did not run due to Task preparation errors (such as resource file download failures).


class ComputeNodeState(str, Enum):

    idle = "idle"  #: The Compute Node is not currently running a Task.
    rebooting = "rebooting"  #: The Compute Node is rebooting.
    reimaging = "reimaging"  #: The Compute Node is reimaging.
    running = "running"  #: The Compute Node is running one or more Tasks (other than a StartTask).
    unusable = "unusable"  #: The Compute Node cannot be used for Task execution due to errors.
    creating = "creating"  #: The Batch service has obtained the underlying virtual machine from Azure Compute, but it has not yet started to join the Pool.
    starting = "starting"  #: The Batch service is starting on the underlying virtual machine.
    waiting_for_start_task = "waitingforstarttask"  #: The StartTask has started running on the Compute Node, but waitForSuccess is set and the StartTask has not yet completed.
    start_task_failed = "starttaskfailed"  #: The StartTask has failed on the Compute Node (and exhausted all retries), and waitForSuccess is set. The Compute Node is not usable for running Tasks.
    unknown = "unknown"  #: The Batch service has lost contact with the Compute Node, and does not know its true state.
    leaving_pool = "leavingpool"  #: The Compute Node is leaving the Pool, either because the user explicitly removed it or because the Pool is resizing or autoscaling down.
    offline = "offline"  #: The Compute Node is not currently running a Task, and scheduling of new Tasks to the Compute Node is disabled.
    preempted = "preempted"  #: The low-priority Compute Node has been preempted. Tasks which were running on the Compute Node when it was preempted will be rescheduled when another Compute Node becomes available.


class SchedulingState(str, Enum):

    enabled = "enabled"  #: Tasks can be scheduled on the Compute Node.
    disabled = "disabled"  #: No new Tasks will be scheduled on the Compute Node. Tasks already running on the Compute Node may still run to completion. All Compute Nodes start with scheduling enabled.


class DisableJobOption(str, Enum):

    requeue = "requeue"  #: Terminate running Tasks and requeue them. The Tasks will run again when the Job is enabled.
    terminate = "terminate"  #: Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again.
    wait = "wait"  #: Allow currently running Tasks to complete.


class ComputeNodeDeallocationOption(str, Enum):

    requeue = "requeue"  #: Terminate running Task processes and requeue the Tasks. The Tasks will run again when a Compute Node is available. Remove Compute Nodes as soon as Tasks have been terminated.
    terminate = "terminate"  #: Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Remove Compute Nodes as soon as Tasks have been terminated.
    task_completion = "taskcompletion"  #: Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Remove Compute Nodes when all Tasks have completed.
    retained_data = "retaineddata"  #: Allow currently running Tasks to complete, then wait for all Task data retention periods to expire. Schedule no new Tasks while waiting. Remove Compute Nodes when all Task retention periods have expired.


class ComputeNodeRebootOption(str, Enum):

    requeue = "requeue"  #: Terminate running Task processes and requeue the Tasks. The Tasks will run again when a Compute Node is available. Restart the Compute Node as soon as Tasks have been terminated.
    terminate = "terminate"  #: Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Restart the Compute Node as soon as Tasks have been terminated.
    task_completion = "taskcompletion"  #: Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Restart the Compute Node when all Tasks have completed.
    retained_data = "retaineddata"  #: Allow currently running Tasks to complete, then wait for all Task data retention periods to expire. Schedule no new Tasks while waiting. Restart the Compute Node when all Task retention periods have expired.


class ComputeNodeReimageOption(str, Enum):

    requeue = "requeue"  #: Terminate running Task processes and requeue the Tasks. The Tasks will run again when a Compute Node is available. Reimage the Compute Node as soon as Tasks have been terminated.
    terminate = "terminate"  #: Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Reimage the Compute Node as soon as Tasks have been terminated.
    task_completion = "taskcompletion"  #: Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Reimage the Compute Node when all Tasks have completed.
    retained_data = "retaineddata"  #: Allow currently running Tasks to complete, then wait for all Task data retention periods to expire. Schedule no new Tasks while waiting. Reimage the Compute Node when all Task retention periods have expired.


class DisableComputeNodeSchedulingOption(str, Enum):

    requeue = "requeue"  #: Terminate running Task processes and requeue the Tasks. The Tasks may run again on other Compute Nodes, or when Task scheduling is re-enabled on this Compute Node. Enter offline state as soon as Tasks have been terminated.
    terminate = "terminate"  #: Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Enter offline state as soon as Tasks have been terminated.
    task_completion = "taskcompletion"  #: Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Enter offline state when all Tasks have completed.
