# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Schedule(Model):
    """Defines how often to run the search and the time interval.

    All required parameters must be populated in order to send to Azure.

    :param frequency_in_minutes: Required. frequency (in minutes) at which
     rule condition should be evaluated.
    :type frequency_in_minutes: int
    :param time_window_in_minutes: Required. Time window for which data needs
     to be fetched for query (should be greater than or equal to
     frequencyInMinutes).
    :type time_window_in_minutes: int
    """

    _validation = {
        'frequency_in_minutes': {'required': True},
        'time_window_in_minutes': {'required': True},
    }

    _attribute_map = {
        'frequency_in_minutes': {'key': 'frequencyInMinutes', 'type': 'int'},
        'time_window_in_minutes': {'key': 'timeWindowInMinutes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Schedule, self).__init__(**kwargs)
        self.frequency_in_minutes = kwargs.get('frequency_in_minutes', None)
        self.time_window_in_minutes = kwargs.get('time_window_in_minutes', None)
