# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DenyAssignmentFilter(Model):
    """Deny Assignments filter.

    :param deny_assignment_name: Return deny assignment with specified name.
    :type deny_assignment_name: str
    :param principal_id: Return all deny assignments where the specified
     principal is listed in the principals list of deny assignments.
    :type principal_id: str
    :param gdpr_export_principal_id: Return all deny assignments where the
     specified principal is listed either in the principals list or exclude
     principals list of deny assignments.
    :type gdpr_export_principal_id: str
    """

    _attribute_map = {
        'deny_assignment_name': {'key': 'denyAssignmentName', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'gdpr_export_principal_id': {'key': 'gdprExportPrincipalId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DenyAssignmentFilter, self).__init__(**kwargs)
        self.deny_assignment_name = kwargs.get('deny_assignment_name', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.gdpr_export_principal_id = kwargs.get('gdpr_export_principal_id', None)
