# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeTypeDescription(Model):
    """Describes a node type in the cluster, each node type represents sub set of
    nodes in the cluster.

    :param name: Name of the node type
    :type name: str
    :param placement_properties: The placement tags applied to nodes in the
     node type, which can be used to indicate where certain services (workload)
     should run
    :type placement_properties: dict
    :param capacities: The capacity tags applied to the nodes in the node
     type, the cluster resource manager uses these tags to understand how much
     of a resource a node has
    :type capacities: dict
    :param client_connection_endpoint_port: The TCP cluster management
     endpoint port
    :type client_connection_endpoint_port: int
    :param http_gateway_endpoint_port: The HTTP cluster management endpoint
     port
    :type http_gateway_endpoint_port: int
    :param durability_level: Nodetype durability Level. Possible values
     include: 'Bronze', 'Silver', 'Gold'
    :type durability_level: str or :class:`enum
     <azure.mgmt.servicefabric.models.enum>`
    :param application_ports: Ports used by applications
    :type application_ports: :class:`EndpointRangeDescription
     <azure.mgmt.servicefabric.models.EndpointRangeDescription>`
    :param ephemeral_ports: System assgined application ports
    :type ephemeral_ports: :class:`EndpointRangeDescription
     <azure.mgmt.servicefabric.models.EndpointRangeDescription>`
    :param is_primary: Mark this as the primary node type
    :type is_primary: bool
    :param vm_instance_count: The number of node instances in the node type
    :type vm_instance_count: int
    :param reverse_proxy_endpoint_port: Endpoint used by reverse proxy
    :type reverse_proxy_endpoint_port: int
    """

    _validation = {
        'name': {'required': True},
        'client_connection_endpoint_port': {'required': True},
        'http_gateway_endpoint_port': {'required': True},
        'is_primary': {'required': True},
        'vm_instance_count': {'required': True, 'maximum': 2147483647, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'placement_properties': {'key': 'placementProperties', 'type': '{str}'},
        'capacities': {'key': 'capacities', 'type': '{str}'},
        'client_connection_endpoint_port': {'key': 'clientConnectionEndpointPort', 'type': 'int'},
        'http_gateway_endpoint_port': {'key': 'httpGatewayEndpointPort', 'type': 'int'},
        'durability_level': {'key': 'durabilityLevel', 'type': 'str'},
        'application_ports': {'key': 'applicationPorts', 'type': 'EndpointRangeDescription'},
        'ephemeral_ports': {'key': 'ephemeralPorts', 'type': 'EndpointRangeDescription'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'vm_instance_count': {'key': 'vmInstanceCount', 'type': 'int'},
        'reverse_proxy_endpoint_port': {'key': 'reverseProxyEndpointPort', 'type': 'int'},
    }

    def __init__(self, name, client_connection_endpoint_port, http_gateway_endpoint_port, is_primary, vm_instance_count, placement_properties=None, capacities=None, durability_level=None, application_ports=None, ephemeral_ports=None, reverse_proxy_endpoint_port=None):
        self.name = name
        self.placement_properties = placement_properties
        self.capacities = capacities
        self.client_connection_endpoint_port = client_connection_endpoint_port
        self.http_gateway_endpoint_port = http_gateway_endpoint_port
        self.durability_level = durability_level
        self.application_ports = application_ports
        self.ephemeral_ports = ephemeral_ports
        self.is_primary = is_primary
        self.vm_instance_count = vm_instance_count
        self.reverse_proxy_endpoint_port = reverse_proxy_endpoint_port
