"""HTTP Headers constants."""
from multidict import istr

METH_ANY = '*'
METH_CONNECT = 'CONNECT'
METH_HEAD = 'HEAD'
METH_GET = 'GET'
METH_DELETE = 'DELETE'
METH_OPTIONS = 'OPTIONS'
METH_PATCH = 'PATCH'
METH_POST = 'POST'
METH_PUT = 'PUT'
METH_TRACE = 'TRACE'

METH_ALL = {METH_CONNECT, METH_HEAD, METH_GET, METH_DELETE,
            METH_OPTIONS, METH_PATCH, METH_POST, METH_PUT, METH_TRACE}


ACCEPT = istr('ACCEPT')
ACCEPT_CHARSET = istr('ACCEPT-CHARSET')
ACCEPT_ENCODING = istr('ACCEPT-ENCODING')
ACCEPT_LANGUAGE = istr('ACCEPT-LANGUAGE')
ACCEPT_RANGES = istr('ACCEPT-RANGES')
ACCESS_CONTROL_MAX_AGE = istr('ACCESS-CONTROL-MAX-AGE')
ACCESS_CONTROL_ALLOW_CREDENTIALS = istr('ACCESS-CONTROL-ALLOW-CREDENTIALS')
ACCESS_CONTROL_ALLOW_HEADERS = istr('ACCESS-CONTROL-ALLOW-HEADERS')
ACCESS_CONTROL_ALLOW_METHODS = istr('ACCESS-CONTROL-ALLOW-METHODS')
ACCESS_CONTROL_ALLOW_ORIGIN = istr('ACCESS-CONTROL-ALLOW-ORIGIN')
ACCESS_CONTROL_EXPOSE_HEADERS = istr('ACCESS-CONTROL-EXPOSE-HEADERS')
ACCESS_CONTROL_REQUEST_HEADERS = istr('ACCESS-CONTROL-REQUEST-HEADERS')
ACCESS_CONTROL_REQUEST_METHOD = istr('ACCESS-CONTROL-REQUEST-METHOD')
AGE = istr('AGE')
ALLOW = istr('ALLOW')
AUTHORIZATION = istr('AUTHORIZATION')
CACHE_CONTROL = istr('CACHE-CONTROL')
CONNECTION = istr('CONNECTION')
CONTENT_DISPOSITION = istr('CONTENT-DISPOSITION')
CONTENT_ENCODING = istr('CONTENT-ENCODING')
CONTENT_LANGUAGE = istr('CONTENT-LANGUAGE')
CONTENT_LENGTH = istr('CONTENT-LENGTH')
CONTENT_LOCATION = istr('CONTENT-LOCATION')
CONTENT_MD5 = istr('CONTENT-MD5')
CONTENT_RANGE = istr('CONTENT-RANGE')
CONTENT_TRANSFER_ENCODING = istr('CONTENT-TRANSFER-ENCODING')
CONTENT_TYPE = istr('CONTENT-TYPE')
COOKIE = istr('COOKIE')
DATE = istr('DATE')
DESTINATION = istr('DESTINATION')
DIGEST = istr('DIGEST')
ETAG = istr('ETAG')
EXPECT = istr('EXPECT')
EXPIRES = istr('EXPIRES')
FROM = istr('FROM')
HOST = istr('HOST')
IF_MATCH = istr('IF-MATCH')
IF_MODIFIED_SINCE = istr('IF-MODIFIED-SINCE')
IF_NONE_MATCH = istr('IF-NONE-MATCH')
IF_RANGE = istr('IF-RANGE')
IF_UNMODIFIED_SINCE = istr('IF-UNMODIFIED-SINCE')
KEEP_ALIVE = istr('KEEP-ALIVE')
LAST_EVENT_ID = istr('LAST-EVENT-ID')
LAST_MODIFIED = istr('LAST-MODIFIED')
LINK = istr('LINK')
LOCATION = istr('LOCATION')
MAX_FORWARDS = istr('MAX-FORWARDS')
ORIGIN = istr('ORIGIN')
PRAGMA = istr('PRAGMA')
PROXY_AUTHENTICATE = istr('PROXY_AUTHENTICATE')
PROXY_AUTHORIZATION = istr('PROXY-AUTHORIZATION')
RANGE = istr('RANGE')
REFERER = istr('REFERER')
RETRY_AFTER = istr('RETRY-AFTER')
SEC_WEBSOCKET_ACCEPT = istr('SEC-WEBSOCKET-ACCEPT')
SEC_WEBSOCKET_VERSION = istr('SEC-WEBSOCKET-VERSION')
SEC_WEBSOCKET_PROTOCOL = istr('SEC-WEBSOCKET-PROTOCOL')
SEC_WEBSOCKET_KEY = istr('SEC-WEBSOCKET-KEY')
SEC_WEBSOCKET_KEY1 = istr('SEC-WEBSOCKET-KEY1')
SERVER = istr('SERVER')
SET_COOKIE = istr('SET-COOKIE')
TE = istr('TE')
TRAILER = istr('TRAILER')
TRANSFER_ENCODING = istr('TRANSFER-ENCODING')
UPGRADE = istr('UPGRADE')
WEBSOCKET = istr('WEBSOCKET')
URI = istr('URI')
USER_AGENT = istr('USER-AGENT')
VARY = istr('VARY')
VIA = istr('VIA')
WANT_DIGEST = istr('WANT-DIGEST')
WARNING = istr('WARNING')
WWW_AUTHENTICATE = istr('WWW-AUTHENTICATE')
