__revision__ = '$Id: __init__.py,v 1.4 2002/07/17 22:58:14 jkloth Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = []
    RemoveTests(files, ignored_files)

    ordered_files = []
    SortTests(files, ordered_files)

    ignored_dirs = ['Xslt']
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = ['Drivers',
                    'SCore',
                    'Lib',
                    ]
    SortTests(dirs, ordered_dirs)

    return (dirs, files)
