import sys
if sys.version < '2.4':
    raise SystemExit('Python 2.4+ required to run ' + __file__)

from distutils import log
log.set_threshold(log.INFO)

STUB_SOURCES = ['.\\stubmsg.mc', 'stubres.rc', 'stubmain.c']
STUB_DEPENDS = [__file__, 'stubres.h']
STUB_NAME = 'stubmain'

from distutils.ccompiler import new_compiler
compiler = new_compiler()
compiler.initialize()
# Do not link against 'msvcrt.dll'
compiler.compile_options.remove('/MD')
compiler.compile_options_debug.remove('/MDd')
# Compile the executable
objects = compiler.compile(STUB_SOURCES, depends=STUB_DEPENDS)
compiler.link_executable(objects, STUB_NAME,
                         output_dir=r'..\..\Ft\Lib\DistExt',
                         extra_preargs=['/MACHINE:x86'],
                         libraries=['user32'])
