########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/AliasImp.py,v 1.9 2006/03/23 09:53:43 cogbuji Exp $
"""
Alias repository resource class.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import XmlDocumentImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import ResourceTypes, Schema
from Ft.Server.Server import FtServerServerException, Error
from Ft.Server.Server.Drivers import Constants
from Ft.Xml.XPath import Evaluate

class AliasImp(XmlDocumentImp.XmlDocumentImp):
    """
    An alias for another repository resource
    """
    resourceType = ResourceTypes.ResourceType.ALIAS

    def getReference(self):
        """
        Traverses the alias and returns its reference (1 step)
        """
        self._verifyTx()
        con = self._driver.getContext(self._path)
        rt = Evaluate(Constants.ALIAS_REFERENCE_XPATH,context=con)
        if not rt:
            raise FtServerServerException(Error.BROKEN_ALIAS,
                                          path = self._path.displayPath)
        if not self.hasResource(rt):
            raise FtServerServerException(Error.BROKEN_ALIAS,
                                          path = self._path.displayPath)

        return self.fetchResource(rt+';no-traverse')

    def traverse(self):
        """
        Traverses the alias and returns its reference (n steps)
        """
        self._verifyTx()
        next = self.getReference()
        if next.isResourceType(ResourceTypes.ResourceType.ALIAS):
            return next.traverse()
        return next


def NewAliasXml(driver,reference,path,acl,owner,docDef):
    content = """<ftss:Alias xmlns:ftss="%s" reference='%s'/>"""% (FTSERVER_NAMESPACE,str(reference))
    return (XmlDocumentImp.NewXmlDocumentXml(driver,
                                             path,
                                             acl,
                                             owner,
                                             'text/xml',
                                             content,
                                             docDef,
                                             ResourceTypes.ResourceType.ALIAS)
            ,content)

