########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Drivers/Constants.py,v 1.5 2006/03/30 16:47:07 cogbuji Exp $
"""
Constants used in the driver

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XLink import XLINK_NAMESPACE
from Ft.Server import FTSERVER_NAMESPACE, RESERVED_NAMESPACE
from Ft.Xml import Domlette, InputSource, XPath, XLink, XUpdate

xu_reader = XUpdate.Reader()
NEW_CONTAINER_CHILD_XUPDATE_STRING = """<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
  xmlns:xlink="%s"
>
  <xupdate:append select="(ftss:Repository | ftss:Container)/ftss:Children" child="last()">
    <ftss:ChildReference xlink:type="simple" xlink:actuate="onLoad" xlink:show="embed">
      <xupdate:attribute name='xlink:href'><xupdate:value-of select='concat($child-name,";metadata")'/></xupdate:attribute>
    </ftss:ChildReference>
  </xupdate:append>
</xupdate:modifications>"""%(str(FTSERVER_NAMESPACE), str(XLINK_NAMESPACE))

DUMMY_URI = "urn:bogus:4suite-%s"
isrc = InputSource.DefaultFactory.fromString(NEW_CONTAINER_CHILD_XUPDATE_STRING, DUMMY_URI % 'xupdate-new-container-child')
NEW_CONTAINER_CHILD_XUPDATE = xu_reader.fromSrc(isrc)


DELETE_CONTAINER_CHILD_XUPDATE = """<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
  xmlns:xlink="%s"
>
  <xupdate:remove select="/ftss:*/ftss:Children/ftss:ChildReference[@xlink:href=concat($child-name, ';metadata')]"/>
</xupdate:modifications>
""" % (str(FTSERVER_NAMESPACE), str(XLINK_NAMESPACE))
isrc = InputSource.DefaultFactory.fromString(DELETE_CONTAINER_CHILD_XUPDATE, DUMMY_URI % 'xupdate-del-container-child')
DELETE_CONTAINER_CHILD_XUPDATE = xu_reader.fromSrc(isrc)


UPDATE_LAST_MODIFIED_AND_SIZE_STRING = """<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:update select="/ftss:MetaData/ftss:LastModifiedDate"><xupdate:value-of select='$lmd'/></xupdate:update>
  <xupdate:update select="/ftss:MetaData/ftss:Size"><xupdate:value-of select='$size'/></xupdate:update>
</xupdate:modifications>
""" % str(FTSERVER_NAMESPACE)

isrc = InputSource.DefaultFactory.fromString(UPDATE_LAST_MODIFIED_AND_SIZE_STRING, DUMMY_URI % 'xupdate-lastmod-and-size')
UPDATE_LAST_MODIFIED_AND_SIZE = xu_reader.fromSrc(isrc)


UPDATE_LAST_MODIFIED = """<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:update select="/ftss:MetaData/ftss:LastModifiedDate">%s</xupdate:update>
</xupdate:modifications>
"""

UPDATE_SIZE = """<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:update select="/ftss:MetaData/ftss:Size">%s</xupdate:update>
</xupdate:modifications>
"""

UPDATE_ACL = """<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:remove select="/ftss:MetaData/ftss:Acl"/>
  <xupdate:append select="/ftss:MetaData">%s</xupdate:append>
</xupdate:modifications>
"""

#System Metadata XPaths
RESOURCE_TYPE_XPATH      = XPath.Compile('string(/ftss:MetaData/@type)')
CREATION_DATE_XPATH      = XPath.Compile('string(/ftss:MetaData/@creation-date)')
LAST_MODIFIED_DATE_XPATH = XPath.Compile('string(/ftss:MetaData/ftss:LastModifiedDate)')
SIZE_XPATH               = XPath.Compile('string(/ftss:MetaData/ftss:Size)')
OWNER_XPATH              = XPath.Compile('string(/ftss:MetaData/ftss:Owner)')
URI_REFERENCE_XPATH      = XPath.Compile("string(/ftss:MetaData/ftss:Reference)")
DOCDEF_XPATH             = XPath.Compile("string(/ftss:MetaData/@document-definition)")
IMT_XPATH                = XPath.Compile('string(/ftss:MetaData/ftss:Imt)')
TTL_XPATH                = XPath.Compile('/ftss:MetaData/ftss:TimeToLive')

#Repository Document Content XPaths
GROUP_MEMBERS_XPATH       = XPath.Compile("/ftss:*/ftss:Members/ftss:MemberReference/@xlink:href")
ALIAS_REFERENCE_XPATH    = XPath.Compile("string(/ftss:Alias/@reference)")
BASE_DOCDEFS_XPATH        = XPath.Compile("/*/ftss:BaseNames/ftss:Base/@xlink:href")
SERVER_STATUS_XPATH      = XPath.Compile("string(/ftss:Server/ftss:Status/@running)")