#import os, cPickle, sys, cStringIO

import XmlDocumentClient
from Ft.Server.FtRpc import Commands

class AliasClient(XmlDocumentClient.XmlDocumentClient):

    def __init__(self, path, connection, resourceType, root):
        XmlDocumentClient.XmlDocumentClient.__init__(self,path,connection,resourceType,root)
        #Always set our path to no-traverse so that we always get information
        #about the alias
        self._path += ';no-traverse'
        return

    def getReference(self):
        """
        Traverses the alias and returns its reference (1 step)
        """
        dest = Commands.RemoteMethodCommand('getReference',
                                            self._path,
                                            ()
                                            ).send(self._connection).results
        return self.fetchResource(dest + ';no-traverse')

    def traverse(self):
        """
        Traverses the alias and returns its reference (n steps)
        """
        self._verifyTx()
        next = self.getReference()
        if next.isResourceType(ResourceTypes.ResourceType.ALIAS):
            return next.traverse()
        return next


