########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/__init__.py,v 1.16 2006/08/11 15:39:16 jkloth Exp $
"""
Implementation of '4ss' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import sys
from Ft import GetConfigVars
from Ft.Lib.CommandLine import Options, CommandLineApp
from Ft.Server.Client import FtServerClientException

# command modules to register as subcommands
import Add
import Agent
import Create
import Delete
import Export
import Fetch
import Install
import List
import Login
import Passwd
import Rdf
import Render
import Remove
import Set
import Update

g_commands = [Add,
              Agent,
              Create,
              Delete,
              Export,
              Fetch,
              Install,
              List,
              Login,
              Passwd,
              Rdf,
              Render,
              Remove,
              Set,
              Update,
              ]


# global options (inherited by all subcommands)
g_options = [Options.ExclusiveOptions([Options.Option('u',
                                                      'username=USER',
                                                      'connect using the given user name'),
                                       Options.Option('a',
                                                      'anonymous',
                                                      'connect as anonymous user'),
                                       ]),
             Options.Option(None,
                            'password=PASSWORD',
                            'connect using the given password'),
             Options.Option('p',
                            'port=PORT',
                            'the port to connect to'),
             Options.Option(None,
                            'host=HOST',
                            'the host to connect to'),
             ]


class GeneralCommandLineApp(CommandLineApp.CommandLineApp):

    project_name, project_version, project_url = \
        GetConfigVars('NAME', 'VERSION', 'URL')

    def __init__(self):
        CommandLineApp.CommandLineApp.__init__(
            self,
            '4ss',
            'Command-line client for 4Suite repository access',
            """This command is a client that provides access to a \
4Suite repository and RDF model from the command line. \
The repository must exist and must be accessible via a 4Suite RPC \
server.""",
            map(lambda x: x.Register(), g_commands),
            options=g_options,
            fileName=__file__,
            )

    def run(*args, **kwords):
        try:
            return CommandLineApp.CommandLineApp.run(*args, **kwords)
        except FtServerClientException, e:
            sys.stderr.write(str(e) + '\n')
            sys.stderr.flush()
