

from Ft.Server.Server import FtServerServerException,Error

from Ft.Server.Common import ResourceTypes

from Server.Server.SCore import test_helper


def test_create(tester):


    tester.startTest("Create XSLT Document w/ Xslt Document")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    sheet = test.createDocument('sheet1',SHEET1,docDef='test-xslt-def',forcedType=ResourceTypes.ResourceType.XSLT_DOCUMENT)
    doc = test.fetchResource('doc1')

    doc.applyXslt([sheet])

    tester.compare(1,hasattr(repo,'_TestVariable'))
    tester.compare(1,repo._TestVariable)
    tester.compare(1,hasattr(repo,'_TestElementVariable'))
    tester.compare(1,repo._TestElementVariable)

    repo.txCommit()

    tester.testDone()

def test_access(tester):

    tester.startTest("Fetching XSLT Document w/ Xslt Document")
    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    sheet = test.fetchResource('sheet1')
    doc = test.fetchResource('doc1')
    doc.applyXslt([sheet])
    tester.compare(1,hasattr(repo,'_TestVariable'))
    tester.compare(1,repo._TestVariable)
    tester.compare(1,hasattr(repo,'_TestElementVariable'))
    tester.compare(1,repo._TestElementVariable)
    repo.txCommit()
    tester.testDone()

def test_modify(tester):

    tester.startTest("Modify XSLT Document w/ Xslt Document")
    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    sheet = test.fetchResource('sheet1')
    sheet.setContent(SHEET2)
    doc = test.fetchResource('doc1')
    doc.applyXslt([sheet])
    tester.compare(1,hasattr(repo,'_TestVariable'))
    tester.compare(2,repo._TestVariable)
    tester.compare(1,hasattr(repo,'_TestElementVariable'))
    tester.compare(2,repo._TestElementVariable)
    repo.txCommit()
    tester.testDone()



def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    test = repo.createContainer("/test",1)

    doc = repo.createDocument('/test/doc1',DOC1,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)

    test.createDocument('test-xslt-def',DD1,forcedType=ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION)

    repo.txCommit()
    tester.testDone()


DOC1="""<docelem v='foo'/>"""
DOC2="""<docelem w='foo'/>"""

SHEET1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:ftext='http://test.com/foo'
    extension-element-prefixes="ftext"
    >
  <xsl:template match="/">
    <xsl:value-of select='ftext:test()'/>
    <ftext:test/>
  </xsl:template>
</xsl:stylesheet>"""

SHEET2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:ftext='http://test.com/foo'
    extension-element-prefixes="ftext"
    >
  <xsl:template match="/">
    <xsl:value-of select='ftext:test()'/>
    <ftext:test/>
    <xsl:value-of select='ftext:test()'/>
    <ftext:test/>
  </xsl:template>
</xsl:stylesheet>"""

DD1="""<?xml version='1.0' encoding='UTF-8'?>
<ft:DocDef xmlns:ft='http://xmlns.4suite.org/reserved'>
  <ft:CreationParams FullTextIndex='0' validate = '0'>
    <ft:ExtensionModule PyImport='Server.Server.Xslt.ext_module_test'/>
  </ft:CreationParams>
</ft:DocDef>
"""


def Test(tester):

    tester.startGroup("XSLT Extension Modules")

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_modify(tester)
    tester.groupDone()


