#!/usr/bin/python
########################################################################
#
# File Name:            GenerateException.py
#
# Documentation:        http://docs.4suite.org/4ODS/ParsedEnumType.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

import os, OdlUtil, GenerateType

from Ft.Ods.MetaData import MetaKind
from Ft.Ods import Constants
from Ft.Ods.Exception import FtodsUnsupportedError
import GenerateStructure

# File creation algorithms
def GenerateStubs(exception, params,fileName,useName,toSet):
    """File creation algorithms"""


    outFile = open(fileName,'a')

    outFile.write("\n# Begin Generation of Exception %s\n\n" % exception.name)

    outFile.write("from Ft.Ods import Exception\n")


    outFile.write("class %s(Exception.FtodsUserException):\n" % useName)

    if exception.result:
        full,names = GenerateStructure.BuildStructureData(params,exception.result)
        d = {}
        for name,(typ,default) in full.items():
            d[name] = default
    else:
        d = {}

                                                    

    outFile.write("    _members = %s\n" % repr(d))
    
    outFile.write("    _typeId = %d\n" % exception._4ods_getId())
    outFile.write("    _typeIds = (%d,)\n" % exception._4ods_getId())

    if toSet:
        parentName, actualName = toSet
        outFile.write("%s.%s=%s\n" % (parentName,actualName,useName))

    outFile.write("\n# End Generation of Exception %s\n\n" % exception.name)

    outFile.close()


    params.literalFiles.append((Constants.Types.EXCEPTION,fileName,[useName]))
    return






