from Xml.Xslt import test_harness
from Ft.Xml.Xslt import Error

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:variable name='spam' select='"original"'/>
  <xsl:import href='Xml/Xslt/Core/addr_book3.xsl'/>

</xsl:stylesheet>
"""

sheet = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:import href='Xml/Xslt/Core/addr_book3.xsl'/>

  <xsl:variable name='spam' select='"original"'/>

  <xsl:template match="ENTRY">
    <xsl:text>ENTRY from original: </xsl:text>
        <TR>
          <xsl:value-of select='@ID'/>
          <xsl:apply-templates select='NAME | PHONENUM'/>
        </TR>
  </xsl:template>

  <xsl:template match='PHONENUM'>
    <xsl:text>PHONENUM from original: </xsl:text>
      <xsl:element name='TD'>
        <xsl:attribute name='ALIGN'>CENTER</xsl:attribute>
        <xsl:text>Type: </xsl:text><xsl:value-of select='@DESC'/>
        <xsl:apply-templates/>
      </xsl:element>
  </xsl:template>
</xsl:stylesheet>
"""

expected = """<HTML>
  <HEAD>
    <META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'>
    <TITLE>Address Book</TITLE>
  </HEAD>
  <BODY>
    <H1>Tabulate just the Names</H1>
    <TABLE>ADDRBOOK from imported: original</TABLE>
  </BODY>
</HTML>"""

def Test(tester):

    source = test_harness.FileInfo(uri="Xml/Xslt/Core/addr_book1.xml")
    sty = test_harness.FileInfo(string=sheet)
    test_harness.XsltTest(tester, source, [sty], expected,
                          title="Default reader")


    source = test_harness.FileInfo(uri="Xml/Xslt/Core/addr_book1.xml")
    sty = test_harness.FileInfo(string=sheet_1)
    test_harness.XsltTest(tester, source, [sty], expected,
                          exceptionCode=Error.ILLEGAL_IMPORT,
                          title="Illegal import at root")
    return
