from Xml.Xslt import test_harness
from Ft.Xml.Xslt import Error

source_1 = """<?xml version="1.0" encoding="utf-8"?><dummy/>"""

# An element enables forwards-compatible mode for itself, its
# attributes, its descendants and their attributes if either it is an
# xsl:stylesheet element whose version attribute is not equal to 1.0,
# or it is a literal result element that has an xsl:version attribute
# whose value is not equal to 1.0. [...]
#
# If an element is processed in forwards-compatible mode, then:

# if it is a top-level element and XSLT 1.0 does not allow such
# elements as top-level elements, then the element must be ignored
# along with its content;
#
sheet_1 = """<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  <xsl:text xsl:version="3.0">hello</xsl:text>
  <xsl:template match="/">
    <result/>
  </xsl:template>
</xsl:stylesheet>"""

expected_1 = """<?xml version="1.0" encoding="UTF-8"?>
<result/>"""



# forwards-compatible processing example from the spec
sheet_1 = """<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="system-property('xsl:version') >= 1.1">
        <xsl:exciting-new-1.1-feature/>
      </xsl:when>
      <xsl:otherwise>
        <html>
        <head>
          <title>XSLT 1.1 required</title>
        </head>
        <body>
          <p>Sorry, this stylesheet requires XSLT 1.1.</p>
        </body>
        </html>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>"""

expected_1 = """<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>XSLT 1.1 required</title>
  </head>
  <body>
    <p>Sorry, this stylesheet requires XSLT 1.1.</p>
  </body>
</html>"""

sheet_2 = """<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="/">
    <!--
      literal result element version = 1.0;
      fallback instruction is noop.
    -->
    <result xsl:version="1.0">
      <xsl:fallback>fallback</xsl:fallback>
    </result>
  </xsl:template>
</xsl:stylesheet>"""

expected_2 = """<?xml version="1.0" encoding="UTF-8"?>
<result/>"""

sheet_3 = """<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="/">
    <!--
      literal result element version != 1.0;
      element is not instantiated;
      no error must be signaled.
    -->
    <result xsl:version="3.0">
      <xsl:choose>
        <xsl:when test="false()">
          <xsl:perform-magic>We do magic<xsl:fallback>Sorry, we don't do magic</xsl:fallback></xsl:perform-magic>
        </xsl:when>
        <xsl:otherwise>hello world</xsl:otherwise>
      </xsl:choose>
    </result>
  </xsl:template>
</xsl:stylesheet>"""

expected_3 = """<?xml version="1.0" encoding="UTF-8"?>
<result>hello world</result>"""

sheet_4 = """<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="/">
    <!--
      literal result element version != 1.0;
      fallback must be performed;
    -->
    <result xsl:version="3.0">
      <xsl:perform-magic>We do magic<xsl:fallback>Sorry, we don't do magic</xsl:fallback></xsl:perform-magic>
    </result>
  </xsl:template>
</xsl:stylesheet>"""

expected_4 = """<?xml version="1.0" encoding="UTF-8"?>
<result>Sorry, we don't do magic</result>"""

sheet_5 = """<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="/">
    <!--
      literal result element version != 1.0;
      fallback must be performed;
      since no fallback child, error must be signaled.
    -->
    <result xsl:version="3.0">
      <xsl:perform-magic/>
    </result>
  </xsl:template>
</xsl:stylesheet>"""


def Test(tester):
    tester.startGroup('forwards-compatible processing')

    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_1)
    test_harness.XsltTest(tester, source, [sheet], '',
                          exceptionCode=Error.FWD_COMPAT_WITHOUT_FALLBACK,
                          title='non-1.0 disallowed top-level elem')


    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_1)
    test_harness.XsltTest(tester, source, [sheet], expected_1,
                          title='forwards-compatible example from XSLT 1.0 spec')

    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_2)
    test_harness.XsltTest(tester, source, [sheet], expected_2,
                          title='1.0 literal result elem w/fallback')

    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_3)
    test_harness.XsltTest(tester, source, [sheet], expected_3,
                          title='uninstantiated non-1.0 literal result elem')

    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_4)
    test_harness.XsltTest(tester, source, [sheet], expected_4,
                          title='non-1.0 literal result elem w/fallback')

    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(string=sheet_5)
    test_harness.XsltTest(tester, source, [sheet], '',
                          exceptionCode=Error.FWD_COMPAT_WITHOUT_FALLBACK,
                          title='non-1.0 literal result elem w/o fallback')

    tester.groupDone()
    return
