__revision__ = '$Id: __init__.py,v 1.15 2004/02/13 03:01:02 jkloth Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)

    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = []
    RemoveTests(files, ignored_files)

    ordered_files = []
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = ['Core', 'Borrowed']
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

# -- run modes -------------------------------------------------------

class _DomTree:
    def __init__(self, dom):
        from xml.dom import Node
        self.DOM = dom
        self.PI = dom.firstChild
        self.ROOT = dom.documentElement
        comment = self.ROOT.firstChild
        while comment and comment.nodeType != Node.COMMENT_NODE:
            comment = comment.nextSibling
        self.COMMENT = comment
        self.CHILDREN = filter(lambda node, type=Node.ELEMENT_NODE:
                               node.nodeType == type,
                               self.ROOT.childNodes)

        self.CHILD1 = self.CHILDREN[0]
        self.ATTR1 = self.CHILD1.getAttributeNodeNS(None, 'attr1')
        self.GCHILDREN1 = filter(lambda node, type=Node.ELEMENT_NODE:
                                 node.nodeType == type,
                                 self.CHILD1.childNodes)
        self.GCHILD11 = self.GCHILDREN1[0]
        self.GCHILD12 = self.GCHILDREN1[1]
        self.TEXT1 = self.CHILD1.lastChild

        self.CHILD2 = self.CHILDREN[1]
        self.ATTR2 = self.CHILD2.getAttributeNodeNS(None, 'attr1')
        self.IDATTR2 = self.CHILD2.getAttributeNodeNS(None, 'CODE')
        self.GCHILDREN2 = filter(lambda node, type=Node.ELEMENT_NODE:
                                 node.nodeType == type,
                                 self.CHILD2.childNodes)
        self.GCHILD21 = self.GCHILDREN2[0]
        self.GCHILD22 = self.GCHILDREN2[1]

        self.CHILD3 = self.CHILDREN[2]
        self.ATTR3 = self.CHILD3.getAttributeNodeNS('http://foo.com', 'name')

        self.PI2 = dom.lastChild

        self.LANG = self.CHILDREN[3]
        self.LCHILDREN = filter(lambda node, type=Node.ELEMENT_NODE:
                                node.nodeType == type,
                                self.LANG.childNodes)
        self.LCHILD1 = self.LCHILDREN[0]
        self.LCHILD2 = self.LCHILDREN[1]

# Assume that all DOMs are available
from Ft.Xml import cDomlette, FtMiniDom, InputSource


xml = """<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE ROOT [
  <!ELEMENT CHILD2 (#PCDATA|GCHILD)*>
  <!ATTLIST CHILD2 attr1 CDATA #IMPLIED
                   CODE ID #REQUIRED>
]>
<?xml-stylesheet "Data" ?>
<ROOT>
  <!-- Test Comment -->
  <CHILD1 attr1="val1" >
    <GCHILD name="GCHILD11"/>
    <GCHILD name="GCHILD12"/>
    Text1
  </CHILD1>
  <CHILD2 attr1="val2" CODE="1">
    <GCHILD name="GCHILD21"/>
    <GCHILD name="GCHILD22"/>
  </CHILD2>
  <foo:CHILD3 xmlns:foo="http://foo.com" foo:name="mike"/>
  <lang xml:lang="en">
    <foo xml:lang=""/>
    <foo/>
  </lang>
</ROOT>
<?no-data ?>
"""

from Ft.Lib.TestSuite import TestMode

class XPathMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self,self.modeName,self.default)

    def _init(self,tester):
        return 1

    def _pre(self,tester):
        tester.test_data['tree'] = _DomMapping[self.modeName][0]
        tester.test_data['parse'] = _DomMapping[self.modeName][1]

_DomMapping = {}
isrc = InputSource.DefaultFactory.fromString(xml, 'urn:cDomlette-test-tree')
_DomMapping['cDomlette'] = (_DomTree(cDomlette.nonvalParse(isrc)),
                            cDomlette.nonvalParse)

class _cDomletteMode(XPathMode):
    modeName = 'cDomlette'
    default = 1

MODES = [_cDomletteMode()]


from Ft.Xml import HAS_PYEXPAT
if HAS_PYEXPAT:
    isrc = InputSource.DefaultFactory.fromString(xml, 'urn:FtMiniDom-test-tree')
    _DomMapping['FtMiniDom'] = (_DomTree(FtMiniDom.nonvalParse(isrc)),
                                FtMiniDom.nonvalParse)

    class _minidomMode(XPathMode):
        modeName = 'FtMiniDom'
        default = 1

    MODES.append(_minidomMode())


##try:
##    from xml.dom.ext.reader import Sax2

##    def nonvalParse(isrc):
##        reader = Sax2.Reader()
##        return reader.fromStream(isrc.stream)

##    _DomMapping['4DOM'] =  (_DomTree(Sax2.FromXml(xml)), nonvalParse)

##    class _4DOMMode(XPathMode):
##        modeName = '4DOM'
##        default = 0

##    MODES.append(_4DOMMode())
##except ImportError:
##    pass

