import os, string, cStringIO
from Ft.Lib import Uri
from Ft.Xml import XInclude, Domlette
from Ft.Xml import cDomlette, FtMiniDom, HAS_PYEXPAT

def Test(tester):
    # cDomlette
    tester.startGroup("Source from cDomlette")
    reader = Domlette._Reader(cDomlette.nonvalParse)
    test_xinclude(tester, reader)
    test_xinclude_xptr(tester)
    test_lowlevel_xinclude_xptr(tester)
    tester.groupDone()

    # FtMiniDom (aka pDomlette)
    tester.startGroup("Source from FtMiniDom")
    if HAS_PYEXPAT:
        reader = Domlette._Reader(FtMiniDom.nonvalParse)
        test_xinclude(tester, reader)
    else:
        tester.warning("You need PyExpat to use FtMiniDom")
    tester.groupDone()
    return


def test_xinclude(tester, reader):
    refUri = Uri.OsPathToUri(os.path.abspath(__file__))

    tester.startGroup("XInclude")
    tester.startTest("simple XInclude")
    doc = reader.parseString(SRC_1, refUri)
    st = cStringIO.StringIO()
    #print doc.childNodes
    Domlette.Print(doc,stream=st)
    tester.compare(expected_1, st.getvalue())
    tester.testDone()

    tester.startTest("Recursive XInclude")
    doc = reader.parseString(SRC_2, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_2, st.getvalue())
    tester.testDone()

    tester.startTest("XInclude text attribute")
    doc = reader.parseString(SRC_3, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_3, st.getvalue())
    tester.testDone()

    tester.groupDone()
    return


def test_xinclude_xptr(tester):
    refUri = Uri.OsPathToUri(os.path.abspath(__file__))

    tester.startGroup("XInclude with XPointer")
    tester.startTest("/ADDRBOOK/ENTRY part 1")
    doc = XInclude.ProcessIncludesFromString(SRC_4, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_4, st.getvalue())
    tester.testDone()

    tester.startTest("/ADDRBOOK/ENTRY part 2")
    doc = XInclude.ProcessIncludesFromString(SRC_5, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_5, st.getvalue())
    tester.testDone()

    tester.startTest("/ADDRBOOK")
    doc = XInclude.ProcessIncludesFromString(SRC_6, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_6, st.getvalue())
    tester.testDone()

    tester.startTest("/ADDRBOOK/ENTRY/NAME")
    doc = XInclude.ProcessIncludesFromString(SRC_7, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_7, st.getvalue())
    tester.testDone()

    tester.startTest("/ADDRBOOK/ENTRY[2]")
    doc = XInclude.ProcessIncludesFromString(SRC_8, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_8, st.getvalue())
    tester.testDone()

    tester.startTest("/ADDRBOOK/ENTRY[@ID='en']")
    doc = XInclude.ProcessIncludesFromString(SRC_9, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_9, st.getvalue())
    tester.testDone()

    tester.startTest("/messages/msg[@xml:lang='en']")
    doc = XInclude.ProcessIncludesFromString(SRC_10, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_10, st.getvalue())
    tester.testDone()

    tester.startTest("/x:ADDRBOOK/x:ENTRY with x=http://spam.com")
    doc = XInclude.ProcessIncludesFromString(SRC_11, refUri)
    st = cStringIO.StringIO()
    Domlette.Print(doc,stream=st)
    tester.compare(expected_11, st.getvalue())
    tester.testDone()

    tester.groupDone()
    return

def test_lowlevel_xinclude_xptr(tester):
    tester.startGroup("Low level XInclude XPointer")
    ELEMENT_MATCH = cDomlette.ELEMENT_MATCH
    ELEMENT_COUNT = cDomlette.ELEMENT_COUNT
    ATTRIBUTE_MATCH = cDomlette.ATTRIBUTE_MATCH
    START = 2

    FRAG = "#xpointer(/spam)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam/eggs)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam/eggs/juice)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')]),
                (103, 106, 107, 108, [(ELEMENT_MATCH, None, u'juice')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(spam)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(spam/eggs)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(spam/eggs/juice)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')]),
                (103, 106, 107, 108, [(ELEMENT_MATCH, None, u'juice')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam/eggs[1])"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs'), (ELEMENT_COUNT, 1, [1])])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam[1]/eggs)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam'), (ELEMENT_COUNT, 1, [1])]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam[1]/eggs[1])"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam'), (ELEMENT_COUNT, 1, [1])]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs'), (ELEMENT_COUNT, 1, [1])])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam/eggs[@a='b'])"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs'), (ATTRIBUTE_MATCH, None, u'a', u'b')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam[@a='b']/eggs)"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam'), (ATTRIBUTE_MATCH, None, u'a', u'b')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xpointer(/spam[@a='b']/eggs[@a='b'])"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam'), (ATTRIBUTE_MATCH, None, u'a', u'b')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs'), (ATTRIBUTE_MATCH, None, u'a', u'b')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    FRAG = "#xmlns(ns=http://spam.com) xpointer(/spam/eggs[@ns:a='b'])"
    EXPECTED = [(START, 100, 101, 102, [(ELEMENT_MATCH, None, u'spam')]),
                (100, 103, 104, 105, [(ELEMENT_MATCH, None, u'eggs'), (ATTRIBUTE_MATCH, u'http://spam.com', u'a', u'b')])]
    tester.startTest(FRAG)
    spec = cDomlette.ProcessFragment(FRAG)
    tester.compare(EXPECTED, spec.states)
    tester.testDone()

    tester.groupDone()
    return


SRC_1="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include1.xml"/>
</x>"""

expected_1 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<foo/>
</x>"""

SRC_2="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml"/>
</x>"""

expected_2="""<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<foo>
  <foo/>
</foo>
</x>"""

SRC_3="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml" parse='text'/>
</x>"""

expected_3="""<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
&lt;?xml version='1.0' encoding='utf-8'?&gt;
&lt;foo xmlns:xi="http://www.w3.org/2001/XInclude"&gt;
  &lt;xi:include href="include1.xml"/&gt;
&lt;/foo&gt;
</x>"""

SRC_4="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include3.xml#xpointer(/ADDRBOOK/ENTRY)"/>
</x>"""

expected_4 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<ENTRY ID="pa">
    <NAME>Pieter Aaron</NAME>
    <EMAIL>pieter.aaron@inter.net</EMAIL>
  </ENTRY>
</x>"""

SRC_5="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include4.xml#xpointer(/ADDRBOOK/ENTRY)"/>
</x>"""

expected_5 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<ENTRY ID="pa">
    <NAME>Pieter Aaron</NAME>
    <EMAIL>pieter.aaron@inter.net</EMAIL>
  </ENTRY><ENTRY ID="en">
    <NAME>Emeka Ndubuisi</NAME>
    <EMAIL>endubuisi@spamtron.com</EMAIL>
  </ENTRY><ENTRY ID="vz">
    <NAME>Vasia Zhugenev</NAME>
    <EMAIL>vxz@gog.ru</EMAIL>
  </ENTRY>
</x>"""

SRC_6="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include3.xml#xpointer(/ADDRBOOK)"/>
</x>"""

expected_6 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<ADDRBOOK>
  <ENTRY ID="pa">
    <NAME>Pieter Aaron</NAME>
    <EMAIL>pieter.aaron@inter.net</EMAIL>
  </ENTRY>
</ADDRBOOK>
</x>"""

SRC_7="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include3.xml#xpointer(/ADDRBOOK/ENTRY/NAME)"/>
</x>"""

expected_7 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<NAME>Pieter Aaron</NAME>
</x>"""

SRC_8="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include4.xml#xpointer(/ADDRBOOK/ENTRY[2])"/>
</x>"""

expected_8 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<ENTRY ID="en">
    <NAME>Emeka Ndubuisi</NAME>
    <EMAIL>endubuisi@spamtron.com</EMAIL>
  </ENTRY>
</x>"""

SRC_9="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include4.xml#xpointer(/ADDRBOOK/ENTRY[@ID='en'])"/>
</x>"""

expected_9 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<ENTRY ID="en">
    <NAME>Emeka Ndubuisi</NAME>
    <EMAIL>endubuisi@spamtron.com</EMAIL>
  </ENTRY>
</x>"""

SRC_10="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include6.xml#xpointer(/messages/msg[@xml:lang='en'])"/>
</x>"""

expected_10 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<msg xml:lang="en">Hello</msg>
</x>"""

SRC_11="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
  <xi:include href="include7.xml#xmlns(x=http://spam.com) xpointer(/x:ADDRBOOK/x:ENTRY)"/>
</x>"""

expected_11 = """<?xml version="1.0" encoding="UTF-8"?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  <ENTRY xmlns="http://spam.com" ID="pa">
    <NAME>Pieter Aaron</NAME>
    <EMAIL>pieter.aaron@inter.net</EMAIL>
  </ENTRY>
</x>"""

if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

