from Ft.Lib.Uri import OsPathToUri
from Ft.Server.Server import FtServerServerException, Error
from Ft.Server.Common import AclConstants, ResourceTypes, Schema


import test_helper

def test_create(tester):


    tester.startTest("Create URI Reference File")
    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource("/test")
    of = test.createUriReferenceFile('of1', 'text/plain', g_osFileUri)

    ofContent = of.getContent()
    ofMd = of.getMetaDataResource().getContent()

    cd, md = test_helper.TestMetaData(tester,
                                     ofMd,
                                     'of1',
                                     ResourceTypes.ResourceType.URI_REFERENCE_FILE,
                                     [],
                                     tester.test_data['userName'],
                                     'text/plain',
                                     str(len(ofContent)),
                                     []
                                     )

    test_helper.TestUriReferenceFileRdf(tester, repo, '/test/of1', len(ofContent),
                                        tester.test_data['userName'], cd, md,
                                        'text/plain', g_osFileUri)

    tester.compare(ResourceTypes.ResourceType.URI_REFERENCE_FILE, test.hasResource('of1'))
    tester.compare(of, test.fetchResource('of1'))
    tester.compare(ResourceTypes.ResourceType.URI_REFERENCE_FILE, of.getResourceType())
    tester.compare(1, of.isResourceType(ResourceTypes.ResourceType.URI_REFERENCE_FILE))
    tester.compare(1, of.isResourceType(ResourceTypes.ResourceType.RAW_FILE))
    tester.compare(0, of.isResourceType(ResourceTypes.ResourceType.XML_DOCUMENT))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource("/test")
    tester.compare(ResourceTypes.ResourceType.URI_REFERENCE_FILE, test.hasResource('of1'))
    repo.txRollback()

    repo = test_helper.GetRepo(tester)
    rf = repo.fetchResource("/test/of1")
    test = repo.fetchResource('/test')
    tester.compare(test, rf.getParent())
    repo.txRollback()

    tester.testDone()
    return



def test_access(tester):


    tester.startTest("URI Reference File Access")

    repo = test_helper.GetRepo(tester)
    of = repo.fetchResource("/test/of1")
    tester.compare('text/plain', of.getImt())
    tester.compare(DATA1, of.getContent())
    tester.compare(len(DATA1), of.getSize())
    tester.compare(None, of.getValidationInfo())
    #Just call, don't test
    of.getCreationDate()
    of.getLastModifiedDate()
    repo.txRollback()

    tester.testDone()


def test_modify(tester):


    tester.startTest("URI Reference File Modification")

    repo = test_helper.GetRepo(tester)
    of = repo.fetchResource("/test/of1")
    of.setImt('image/jpg')
    tester.compare('image/jpg', of.getImt())

    ofMd = of.getMetaDataResource().getContent()
    ofContent = of.getContent()

    cd, md = test_helper.TestMetaData(tester,
                                     ofMd,
                                     'of1',
                                     ResourceTypes.ResourceType.URI_REFERENCE_FILE,
                                     [],
                                     tester.test_data['userName'],
                                     'image/jpg',
                                     str(len(ofContent)),
                                     []
                                     )

    test_helper.TestUriReferenceFileRdf(tester, repo, '/test/of1', len(ofContent), tester.test_data['userName'], None, None, 'image/jpg', g_osFileUri)
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    of = repo.fetchResource("/test/of1")
    tester.testException(of.setContent, ("foo", ), FtServerServerException, {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Modify on Disk")
    open(g_osFileName, 'w').write(DATA2)
    repo = test_helper.GetRepo(tester)
    of = repo.fetchResource("/test/of1")

    ofContent = of.getContent()
    ofMd = of.getMetaDataResource().getContent()



    cd, md = test_helper.TestMetaData(tester,
                                     ofMd,
                                     'of1',
                                     ResourceTypes.ResourceType.URI_REFERENCE_FILE,
                                     [],
                                     tester.test_data['userName'],
                                     'image/jpg',
                                     str(len(ofContent)),
                                     []
                                     )

    tester.compare(DATA2, ofContent)

    test_helper.TestUriReferenceFileRdf(tester, repo, '/test/of1', len(ofContent), tester.test_data['userName'], cd, md, 'image/jpg', g_osFileUri)


    repo.txRollback()
    tester.testDone()



def test_delete(tester):

    tester.startTest("Delete URI Reference File")
    repo = test_helper.GetRepo(tester)

    of = repo.fetchResource("/test/of1")
    test = of.getParent()
    of.delete()
    tester.compare(0, test.hasResource('of1'))
    tester.compare(0, len(repo.getModel().complete('/test/of1', None, None)))
    tester.compare(0, len(repo.getModel().complete('/test', Schema.CONTAINER_CHILD, None)))
    tester.testException(of.getContent, (), FtServerServerException, {'code':Error.OBJECT_DELETED})
    import os
    tester.compare(1, os.path.exists(g_osFileName))
    repo.txCommit()
    tester.testDone()

    os.unlink(g_osFileName)



def cleanup(tester):

    import tempfile
    global g_osFileName
    g_osFileName = tempfile.mktemp()
    global g_osFileUri
    g_osFileUri = OsPathToUri(g_osFileName)
    open(g_osFileName, 'w').write(DATA1)
    tester.startTest("Prepare / Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test", 1)
    repo.txCommit()
    tester.testDone()



DATA1 = "Test Data"
DATA2 = "More coll stuff written to disk"

def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_modify(tester)
    test_delete(tester)



