# an xml:lang example from RDF/XML Syntax (Revised)

RDF1 = """<?xml version="1.0" encoding="utf-8"?>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:dc="http://purl.org/dc/elements/1.1/">
  <rdf:Description rdf:about="http://www.w3.org/TR/rdf-syntax-grammar">
    <dc:title>RDF/XML Syntax Specification (Revised)</dc:title>
    <dc:title xml:lang="en">RDF/XML Syntax Specification (Revised)</dc:title>
    <dc:title xml:lang="en-US">RDF/XML Syntax Specification (Revised)</dc:title>
  </rdf:Description>

  <rdf:Description rdf:about="http://example.org/buecher/baum" xml:lang="de">
    <dc:title>Der Baum</dc:title>
    <dc:description>Das Buch ist au&#xDF;ergew&#xF6;hnlich</dc:description>
    <dc:title xml:lang="en">The Tree</dc:title>
  </rdf:Description>
</rdf:RDF>
"""

# I am really not sure what the expected result is.
# Here's the same doc again, with dc->ns1:
EXPECTED1 = """<?xml version="1.0" encoding="UTF-8"?>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:ns1="http://purl.org/dc/elements/1.1/">
  <rdf:Description rdf:about="http://www.w3.org/TR/rdf-syntax-grammar">
    <ns1:title>RDF/XML Syntax Specification (Revised)</ns1:title>
    <ns1:title xml:lang="en">RDF/XML Syntax Specification (Revised)</ns1:title>
    <ns1:title xml:lang="en-US">RDF/XML Syntax Specification (Revised)</ns1:title>
  </rdf:Description>

  <rdf:Description rdf:about="http://example.org/buecher/baum" xml:lang="de">
    <ns1:title>Der Baum</ns1:title>
    <ns1:description>Das Buch ist au&#xDF;ergew&#xF6;hnlich</ns1:description>
    <ns1:title xml:lang="en">The Tree</ns1:title>
  </rdf:Description>
</rdf:RDF>
"""

# Here's what we're getting today:
NOT_EXPECTED1 = """<?xml version="1.0" encoding="UTF-8"?>
<rdf:RDF xmlns:ns1="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="http://example.org/buecher/baum">
    <ns1:title>Der Baum</ns1:title>
    <ns1:title>The Tree</ns1:title>
    <ns1:description>Das Buch ist au&#xDF;ergew&#xF6;hnlich</ns1:description>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/TR/rdf-syntax-grammar">
    <ns1:title>RDF/XML Syntax Specification (Revised)</ns1:title>
    <ns1:title>RDF/XML Syntax Specification (Revised)</ns1:title>
    <ns1:title>RDF/XML Syntax Specification (Revised)</ns1:title>
  </rdf:Description>
</rdf:RDF>
"""

def Test(tester):
    from cStringIO import StringIO
    from Ft.Lib.Uri import OsPathToUri
    from Ft.Rdf import Util
    from Ft.Xml.Domlette import PrettyPrint
    from Ft.Xml.Lib import TreeCompare

    tester.startTest('Deserialize and reserialize w/xml:lang')
    scope = OsPathToUri(__file__, attemptAbsolute=True)
    scope += '-INTERNAL-XML-STRING'
    model, db = Util.DeserializeFromString(RDF1, scope=scope)
    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    stream = StringIO()
    doc = serializer.serialize(model)
    PrettyPrint(doc, stream)
    res = stream.getvalue()
    #print res
    tester.compare(res, EXPECTED1, func=TreeCompare.TreeCompare)
    tester.testDone()

