<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="DocMap">
    <paths>
      <xsl:apply-templates/>
    </paths>
  </xsl:template>
  
  <xsl:template match="DocSet">
    <xsl:param name="path"/>
    <xsl:apply-templates>
      <xsl:with-param name="path">
        <xsl:if test="$path">
          <xsl:value-of select="concat($path,'/')"/>
        </xsl:if>
        <xsl:value-of select="@path"/>
      </xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="Document">
    <xsl:param name="path"/>
    <doc id="{@id}" path="{concat($path,'/',@path)}"/>
  </xsl:template>

  <xsl:template  match="*"/>

</xsl:stylesheet>
