#include "Python.h"

#ifdef SPLITQNAME_STANDALONE
#define FUNCSPEC(x) static x
#define FUNCNAME Standalone_SplitQName
#else
#define FUNCSPEC(x) x
#define FUNCNAME SplitQName
#endif

FUNCSPEC(int)
FUNCNAME(PyObject *qualifiedName, PyObject **prefix, PyObject **localName)
{
  int i;
  Py_UNICODE colon = ':';
  int len = PyUnicode_GET_SIZE(qualifiedName);
  const Py_UNICODE *p = PyUnicode_AS_UNICODE(qualifiedName);
  
  for (i = len-1; i > -1; i--) {
    if (p[i] == colon) {
      PyObject *u, *v;
      u = PyUnicode_FromUnicode(p, i);
      if (u == NULL) {
        return 0;
      }
      /* skip over the colon */
      i++;
      v = PyUnicode_FromUnicode((p + i), (len - i));
      if (v == NULL) {
        Py_DECREF(u);
        return 0;
      }
      *prefix = u;
      *localName = v;
      return 1;
    }
  }

  /* No prefix */
  *prefix = Py_None;
  Py_INCREF(Py_None);
  *localName = qualifiedName;
  Py_INCREF(qualifiedName);
  return 1;
}
