#ifndef __PARSE_EVENT_HANDLER__
#define __PARSE_EVENT_HANDLER__

#include "expat_module.h"

/* States */

#define PARSE_STREAM_STATE 2

#define ENTITY_REF_CALLBACK 10
#define START_ELEMENT_CALLBACK 11
#define END_ELEMENT_CALLBACK 12
#define CHARACTER_DATA_CALLBACK 13
#define COMMENT_CALLBACK 14
#define PI_CALLBACK 15
#define START_NS_SCOPE_CALLBACK 16
#define END_NS_SCOPE_CALLBACK 17

/* Events */

#define PARSE_RESUME_EVENT 1
#define ENTITY_REF_EVENT 10
#define START_ELEMENT_EVENT 11
#define END_ELEMENT_EVENT 12
#define CHARACTER_DATA_EVENT 13
#define COMMENT_EVENT 14
#define PI_EVENT 15
#define START_NS_SCOPE_EVENT 16
#define END_NS_SCOPE_EVENT 17


#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  PyObject *prefix;
  PyObject *uri;
  PyObject *local;
  PyObject *qname;
} UniversalName;

/*static int initializeStateTableForParseEvents(State *state);*/
  UniversalName *buildUniversalName(PyObject *expanded_name);
  void destroyUniversalName(UniversalName *un);


#ifdef __cplusplus
}
#endif

#endif

