#ifndef __DOM__ELEMENT__
#define __DOM__ELEMENT__

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "node.h"
#include "attr.h"

  typedef struct {
    PyNode_HEAD
    PyObject *namespaceURI;
    PyObject *prefix;
    PyObject *localName;
    PyObject *nodeName;
    PyObject *attributes;
    PyObject *childNodes;
    PyObject *xmlBase; /* see http://www.w3.org/TR/xmlbase.  Overrides the document's refUri*/
  } PyElementObject;

#define PyElement_Check(op) ((op)->ob_type == &PyDomletteElement_Type)
#define PyElement_NAMESPACE_URI(op) (((PyElementObject *)(op))->namespaceURI)
#define PyElement_PREFIX(op) (((PyElementObject *)(op))->prefix)
#define PyElement_ATTRIBUTES(op) (((PyElementObject *)(op))->attributes)
#define PyElement_CHILDNODES(op) (((PyElementObject *)(op))->childNodes)
#define PyElement_BASE_URI(op) (((PyElementObject *)(op))->xmlBase)

  extern PyTypeObject PyDomletteElement_Type;

  int DomletteElement_Init(void);
  void DomletteElement_Fini(void);

  /* Element Methods */

  PyAttrObject *Element_SetAttributeNS(PyElementObject *self, 
                                       PyObject *namespaceURI,
                                       PyObject *qualifiedName,
                                       PyObject *prefix,
                                       PyObject *localName, 
                                       PyObject *value);

  PyElementObject *Element_CloneNode(PyObject *node, int deep,
				     PyNodeObject *newOwnerDocument);

  int element_test_ref_counts(PyObject *tester, PyElementObject *node,
			      long *childCtr, PyObject *internDict, int base);

#ifdef __cplusplus
}
#endif

#endif /* __DOM__ELEMENT__ */
