#include "domlette.h"

PyObject *g_implementation;

/*Internal Interfaces*/


/*External Interfaces*/

static char PyDOMImplementation_HasFeature__doc__[] =
"See if this implementation supports a given feature";
static PyObject *PyDOMImplementation_HasFeature(PyObject *self, PyObject *args)
{
/*     _features = {'CORE' : 2.0, */
/*                  'XML' : 2.0, */
/*                  } */

/*     def hasFeature(self, feature, version=''): */
/*         fv = self._features.get(string.upper(feature)) */
/*         if fv: */
/*             if version: */
/*                 try: */
/*                     return float(version) == fv */
/*                 except: */
/*                     return 0 */
/*             return 1 */
/*         return 0 */


  char *feature;
  char *version;
  PyObject *res;

  if(!PyArg_ParseTuple(args,"ss:hasFeature",&feature,&version))
    return NULL;

  if (strcasecmp(feature,"core") ) {
    res = PyInt_FromLong(0);
  }
  else if (atoi(version) <= 2.0 ) {
    res = PyInt_FromLong(1);
  } else {
    res = PyInt_FromLong(0);
  }
  return res;
}


static char PyDOMImplementation_CreateDocument__doc__[] =
"Create a new document instance";
static PyObject *PyDOMImplementation_CreateDocument(PyObject *self,
						    PyObject *args)
{
  PyObject *namespaceURI, *doctype, *qualifiedName, *documentURI = Py_None;
  PyDocumentObject *doc;
  unsigned long index;

  if(!PyArg_ParseTuple(args,"OOO|O:createDocument",
		       &namespaceURI, &qualifiedName, &doctype, &documentURI))
    return NULL;

  /* validate the arguments */
  /*
See: http://lists.fourthought.com/pipermail/4suite-dev/2003-August/001484.html
 - if the qname arg is None, don't check namespace arg
 - else:
    - if the namespace arg is a non-empty Unicode string, OK
    - else if the namespace arg is EMPTY_NAMESPACE, OK
    - else complain
   */
  
  namespaceURI = DOMString_ConvertArgument(namespaceURI, "namespaceURI", 1);
  if (namespaceURI == NULL) {
    return NULL;
  }

  qualifiedName = DOMString_ConvertArgument(qualifiedName, "qualifiedName", 1);
  if (qualifiedName == NULL) {
    Py_DECREF(namespaceURI);
    return NULL;
  }

  if (doctype != Py_None) {
    DOMException_NotSupportedErr("doctype must be None for Domlettes");
    Py_DECREF(namespaceURI);
    Py_DECREF(qualifiedName);
    return NULL;
  }

  documentURI = DOMString_ConvertArgument(documentURI, "documentURI", 1);
  if (documentURI == NULL) {
    Py_DECREF(namespaceURI);
    Py_DECREF(qualifiedName);
    return NULL;
  }

  doc = Document_New(&index, documentURI);

  /* See if we need to add a documentElement */
  if (qualifiedName != Py_None) {
    PyObject *prefix, *localName;
    PyElementObject *elem;

    if (!SplitQName(qualifiedName, &prefix, &localName)) {
      Py_DECREF(namespaceURI);
      Py_DECREF(qualifiedName);
      Py_DECREF(doc);
      return NULL;
    }

    elem = Document_CreateElementNS(doc, namespaceURI, qualifiedName, prefix, 
                                    localName, &index);

    Py_DECREF(prefix);
    Py_DECREF(localName);

    if (elem == NULL) {
      Py_DECREF(doc);
      doc = NULL;
    }
    else {
      Node_AppendChild((PyNodeObject *)doc, (PyNodeObject *)elem);
      Py_DECREF(elem);
    }
  }

  Py_DECREF(namespaceURI);
  Py_DECREF(qualifiedName);
  Py_DECREF(documentURI);

  return (PyObject *)doc;
}


static char PyDOMImplementation_CreateRootNode__doc__[] =
"Create a new document instance";

static PyObject *PyDOMImplementation_CreateRootNode(PyObject *self,
						    PyObject *args)
{
  PyObject *documentURI = Py_None;
  unsigned long index;
  PyDocumentObject *doc;

  if(!PyArg_ParseTuple(args,"|O:createRootNode", &documentURI))
    return NULL;

  documentURI = DOMString_ConvertArgument(documentURI, "documentURI", 1);
  if (documentURI == NULL) {
    return NULL;
  }

  doc = Document_New(&index, documentURI);
  Py_DECREF(documentURI);

  return (PyObject *) doc;
}


static struct PyMethodDef DOMImplementation_methods[] = {
  { "hasFeature", PyDOMImplementation_HasFeature, METH_VARARGS,
    PyDOMImplementation_HasFeature__doc__ },
  { "createDocument", PyDOMImplementation_CreateDocument, METH_VARARGS,
    PyDOMImplementation_CreateDocument__doc__ },
  { "createRootNode", PyDOMImplementation_CreateRootNode, METH_VARARGS,
    PyDOMImplementation_CreateRootNode__doc__ },
  {NULL, NULL}      /* sentinel */
};


/*
  Type Interfaces
*/

static PyObject *domimp_getattr(PyDOMImplementationObject *self, char *name)
{
  return Py_FindMethod(DOMImplementation_methods, (PyObject *)self, name);
}

static int domimp_setattr(PyDOMImplementationObject *self, char *name, PyObject *v)
{
  /* Set attribute 'name' to value 'v'. v==NULL means delete */
  if (v == NULL) {
    PyErr_Format(PyExc_AttributeError,
                 "Cannot delete attribute '%.400s' on '%.50s' object",
                 name, self->ob_type->tp_name);
  } else {
    PyErr_Format(PyExc_AttributeError,
                 "Cannot set attribute '%.400s' on '%.50s' object",
                 name, self->ob_type->tp_name);
  }
  return -1;
}

static void
domimp_dealloc(PyDOMImplementationObject *node)
{
  PyMem_DEL(node);
}


static PyObject *domimp_repr(PyDOMImplementationObject *domimp)
{
  char buf[256];
  sprintf(buf, "<cDOMImplementation at %p>", domimp);
  return PyString_FromString(buf);
}

static char domimp_doc[] = 
"The DOMImplementation interface provides a number of methods for performing\n\
operations that are independent of any particular instance of the document\n\
object model.";

PyTypeObject PyDomletteDOMImplementation_Type = {
  /* PyObject_HEAD  */ PyObject_HEAD_INIT(NULL)
  /* ob_size        */ 0,
  /* tp_name        */ "cDomlette.DOMImplementation",
  /* tp_basicsize   */ sizeof(PyDOMImplementationObject),
  /* tp_itemsize    */ 0,
  /* tp_dealloc     */ (destructor) domimp_dealloc,
  /* tp_print       */ (printfunc) 0,
  /* tp_getattr     */ (getattrfunc) domimp_getattr,
  /* tp_setattr     */ (setattrfunc) domimp_setattr,
  /* tp_compare     */ (cmpfunc) 0,
  /* tp_repr        */ (reprfunc) domimp_repr,
  /* tp_as_number   */ (PyNumberMethods *) 0,
  /* tp_as_sequence */ (PySequenceMethods *) 0,
  /* tp_as_mapping  */ (PyMappingMethods *) 0,
  /* tp_hash        */ (hashfunc) 0,
  /* tp_call        */ (ternaryfunc) 0,
  /* tp_str         */ (reprfunc) 0,
  /* tp_getattro    */ (getattrofunc) 0,
  /* tp_setattro    */ (setattrofunc) 0,
  /* tp_as_buffer   */ (PyBufferProcs *) 0,
  /* tp_flags       */ Py_TPFLAGS_DEFAULT,
  /* tp_doc         */ (char *) domimp_doc,
  /* tp_traverse    */ (traverseproc) 0,
  /* tp_clear       */ (inquiry) 0,
};

int DomletteDOMImplementation_Init(void)
{
  PyDomletteDOMImplementation_Type.ob_type = &PyType_Type;

  g_implementation = (PyObject *)PyObject_New(PyDOMImplementationObject,
                                              &PyDomletteDOMImplementation_Type);
  if (g_implementation == NULL) return -1;

  return 0;
}

void DomletteDOMImplementation_Fini(void)
{
  Py_DECREF(g_implementation);
}

