########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/cDomlette.py,v 1.31 2003/08/25 15:05:28 jkloth Exp $
"""
cDomlette implementation: a very fast DOM-like library tailored for use in XPath/XSLT

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

try:
    isinstance('', ())
except TypeError:
    #
    # Wrap isinstance() to make it compatible with the version in
    # Python 2.2 and newer.
    #
    _isinstance = isinstance
    def isinstance(obj, type_or_seq):
        try:
            return _isinstance(obj, type_or_seq)
        except TypeError:
            for t in type_or_seq:
                if _isinstance(obj, t):
                    return 1
            return 0
    
import re

from cDomlettec import implementation

from cDomlettec import nonvalParse

#NOTE - because cDomlette does not yet have a validating parser, we
# need to use minidom
from FtMiniDom import valParse

# cDomlette optimized NS functions
from cDomlettec import GetAllNs, SeekNss

# Functions used for testing
from cDomlettec import TestTree, TestRefCounts, StartNodeCounting, GetNodeCount


# Fragment processing

class FragmentSpec:
    def __init__(self):
        self.states = []
        self.nextAvailStateId = g_nextAvailStateId
        self.fromState = g_initialState
        return

#FIXME: these constants are copied from Ft/Xml/src/domlette/state_machine.h
#They should be instead set by code in the C expat handler to ensure sync
g_nextAvailStateId = 100
g_initialState = 2

ELEMENT_MATCH = 1
ELEMENT_COUNT = 2
ATTRIBUTE_MATCH = 3


def ProcessFragment(frag):
    """
    Take an XPointer fragment and return a structure suitable for the
    cDomlette parser to update state tables
    Xptr e.g. xmlns(x=http://uche.ogbuji.net/eg) xpointer(/x:spam/x:eggs)
    """
    from Ft.Xml import XML_NAMESPACE
    from Ft.Xml.XPath import Compile
    from Ft.Xml.XPath.ParsedAbsoluteLocationPath import ParsedAbsoluteLocationPath
    XPTR_EXPR = re.compile("#.*xpointer\((?P<xptr>.*?)\)")
    NS_EXPR = re.compile("xmlns\((?P<nsdata>.*?)\)")
    xptr = XPTR_EXPR.findall(frag)
    #There must be an xptr expression
    if not xptr: return None

    xptr = xptr[0]
    ns_mappings = {u'xml': XML_NAMESPACE}
    ns_matches = NS_EXPR.findall(frag)
    for m in ns_matches:
        try:
            prefix, ns = m.split('=')
            ns_mappings[prefix] = ns
        except ValueError:
            # FIXME: if we get here, then m doesn't conform to
            # the xmlns() scheme syntax. Raise exception?
            pass
    expr = Compile(xptr)
    #Assume context = root, which means in effect that the absolute = its relative "child"
    if isinstance(expr, ParsedAbsoluteLocationPath):
        #Extract the relative part (which looks like one form of parsed step)
        expr = expr._child
    result = FragmentSpec()
    HandleStep(expr, result, ns_mappings)
    return result


def HandleStep(expr, spec, nss):
    from Ft.Xml.XPath import Util
    from Ft.Xml.XPath.ParsedExpr import ParsedNLiteralExpr, ParsedEqualityExpr
    from Ft.Xml.XPath.ParsedNodeTest import LocalNameTest, QualifiedNameTest
    if hasattr(expr, "_left"):
        lstep = expr._left
        curr_step = expr._right
        HandleStep(lstep, spec, nss)
    elif hasattr(expr, "_left"):
        #Down to the "last" recursive step
        curr_step = expr._child
    else:
        #Down to the "last" recursive step
        curr_step = expr

    #Set criteria by expanded name
    node_test = curr_step._nodeTest
    if isinstance(node_test, (LocalNameTest, QualifiedNameTest)):
        element_exp_name = node_test.getQuickKey(nss)[1]
    else:
        raise NotImplementedError(str(node_test))
    criteria = [(ELEMENT_MATCH,) + element_exp_name]

    #Set criteria from predicates
    if curr_step._predicates:
        pred = curr_step._predicates._predicates[0]
        if isinstance(pred, ParsedNLiteralExpr):
            #The third item is a counter used to count elements during the parsing
            criteria.extend([(ELEMENT_COUNT, int(pred._literal), [1])])
        elif isinstance(pred, ParsedEqualityExpr) and pred._op == u'=':
            if hasattr(pred._left, '_axis') and \
                   pred._left._axis._axis == 'attribute':
                # criteria code
                criterion = [ATTRIBUTE_MATCH]

                # Add the expanded name
                if hasattr(pred._left._nodeTest, '_localName'):
                    criterion.append(nss[pred._left._nodeTest._prefix])
                    criterion.append(pred._left._nodeTest._localName)
                else:
                    criterion.append(None)
                    criterion.append(pred._left._nodeTest._name)

                # Add the expected value
                criterion.append(pred._right._literal)

                # Add this information to the criteria
                criteria.append(tuple(criterion))

    # Add state transitions for the current step
    spec.states.append((spec.fromState, spec.nextAvailStateId,
                        spec.nextAvailStateId + 1, spec.nextAvailStateId + 2,
                        criteria
                        ))
    spec.fromState = spec.nextAvailStateId
    spec.nextAvailStateId += 3
    return


