########################################################################
#
# File Name:            ValueOfElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ValueOfElement.py.html
#
"""
Implementation of the XSLT Spec import stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Xml import EMPTY_NAMESPACE
from Ft.Xml.Xslt import XsltElement, XsltException, Error, XSL_NAMESPACE
from Ft.Xml.Xslt import CategoryTypes, ContentInfo, AttributeInfo
from Ft.Xml.XPath import Conversions

class ValueOfElement(XsltElement):
    category = CategoryTypes.INSTRUCTION
    content = ContentInfo.Empty
    legalAttrs = {
        'select' : AttributeInfo.StringExpression(required=1),
        'disable-output-escaping' : AttributeInfo.YesNo(default='no'),
        }

    def instantiate(self, context, processor):
        context.processorNss = self.namespaces
        context.currentInstruction = self

        text = Conversions.StringValue(self._select.evaluate(context))
        if text:
            if self._disable_output_escaping:
                processor.writers[-1].text(text, escapeOutput=0)
            else:
                processor.writers[-1].text(text)

        return (context,)

