########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/Xslt/LiteralElement.py,v 1.7 2003/07/24 23:11:25 jkloth Exp $
"""
Implementation of XSLT literal result elements

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.Xslt import XSL_NAMESPACE, XsltElement, XsltRuntimeException, Error
from Ft.Xml import EMPTY_NAMESPACE, EMPTY_PREFIX
from Ft.Xml.Xslt.AttributeInfo import ExpressionWrapper


class LiteralElement(XsltElement):

    # usually not supplied so default it
    _use_attribute_sets = []

    doesSetup = 1

    def setup(self):
        reversed = {}
        for (prefix, namespace) in self.namespaces.items():
            #Prefer use of default namespace
            if not reversed.has_key(namespace) or reversed[namespace] != EMPTY_PREFIX:
                reversed[namespace] = prefix

        # handle the element name
        self._output_namespace, local = self.expandedName
        prefix = reversed[self._output_namespace]
        if prefix:
            self._output_qname = u':'.join([prefix, local])
        else:
            self._output_qname = local

        # handle the attributes
        self._output_attrs = []
        for (namespace, local), value in self.attributes.items():
            if namespace == XSL_NAMESPACE:
                continue
            if namespace:
                # attributes do not use the default namespace
                prefix = reversed[namespace]
                if prefix:
                    qname = u':'.join([prefix, local])
                else:
                    qname = local
            else:
                qname = local
            self._output_attrs.append((qname, namespace, self.parseAVT(value)))

        # handle the namespaces
        self._output_nss = {}
        # the ignored namespaces as defined by XSLT spec section 7.1.1
        # NOTE: this is NOT changed by any imports or includes
        ignored_ns = [self._output_namespace]
        ignored_ns.extend(self.excludedNss)
        for (prefix, namespace) in self.namespaces.items():
            if namespace not in ignored_ns:
                self._output_nss[prefix] = namespace
        return

    # This will be called by the stylesheet if it contains any
    # xsl:namespace-alias declarations
    def fixupAliases(self, namespaceAliases):
        # prepare output information
        reversed = {}
        for (prefix, namespace) in self.namespaces.items():
            reversed[namespace] = prefix

        # handle the element itself
        if namespaceAliases.has_key(self._output_namespace):
            alias_info = namespaceAliases[self._output_namespace]
            self._output_namespace, orig_prefix, prefix = alias_info[:3]
            if prefix:
                self._output_qname = u':'.join([prefix, self.expandedName[1]])
            else:
                self._output_qname = self.expandedName[1]

        # reprocess the attributes
        pos = 0
        for qname, namespace, value in self._output_attrs:
            # NOTE - attributes do not use the default namespace
            if namespace and namespaceAliases.has_key(namespace):
                alias_info = namespaceAliases[self._output_namespace]
                namespace, old_prefix, prefix = alias_info[:3]
                local = qname.split(':')[-1]
                if prefix:
                    qname = u':'.join([prefix, local])
                else:
                    qname = local
                self._output_attrs[pos] = (qname, namespace, value)
            pos += 1

        # handle the namespaces
        for prefix, namespace in self._output_nss.items():
            if namespaceAliases.has_key(namespace):
                # remove the old entry
                del self._output_nss[prefix]
                # get the aliased namespace and add that pairing
                namespace, old_prefix, prefix = namespaceAliases[namespace][:3]
                self._output_nss[prefix] = namespace

        return

    def instantiate(self, context, processor):
        context.processorNss = self.namespaces
        context.currentInstruction = self

        processor.writers[-1].startElement(self._output_qname,
                                           self._output_namespace,
                                           self._output_nss)

        for (qname, namespace, value) in self._output_attrs:
            # ExpressionWrapper will add position info to exceptions
            # raised during evaluate()
            wrappedAvt = ExpressionWrapper(value, self, value.source)
            value = wrappedAvt.evaluate(context)
            processor.writers[-1].attribute(qname, value, namespace)

        for attr_set_name in self._use_attribute_sets:
            try:
                attr_set = processor.attributeSets[attr_set_name]
            except KeyError:
                raise XsltRuntimeException(Error.UNDEFINED_ATTRIBUTE_SET,
                                           self, attr_set_name)
            attr_set.instantiate(context, processor)

        context = reduce(lambda context, child, processor=processor:
                         child.instantiate(context, processor)[0],
                         self.children, context)

        processor.writers[-1].endElement(self._output_qname,
                                         self._output_namespace)


        return (context,)
