
### Exceptions ###

from Ft import FtException
class XPtrException(FtException):
    INTERNAL_ERROR = 1
    SYNTAX_ERROR = 2
    RESOURCE_ERROR = 3
    SUB_RESOURCE_ERROR = 4

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.g_errorMessages, args)
        return

import MessageSource

### Convienence Functions ###

def SelectUri(uri, contextNode=None, nss=None):

    """
    Takes a URI and splits it into an url and fragment that can be
    consumed by SelectNode.
    """
    import urllib
    try:
        from xml.sax.saxlib import SAXException
    except ImportError:
        from xml.sax import SAXException

    from Ft.Xml import Domlette
    base, fragment = urllib.splittag(uri)
    if fragment is None:
        return reader.fromUri(uri, baseUri=baseUri)
    fragment = urllib.unquote(fragment)
    try:
        doc = Domlette.NonvalidatingReader.parseUri(base)
    except FtException:
        # Already handled somewhere else
        raise
    except SAXException, exc:
        raise XPtrException(XPtrException.RESOURCE_ERROR, str(exc))
    except Exception, exc:
        import traceback
        traceback.print_exc()
        raise XPtrException(XPtrException.INTERNAL_ERROR, str(exc))
    return SelectNode(doc, fragment, nss, contextNode)


def SelectNode(doc, fragment, nss=None, contextNode=None):
    """
    Accepts a valid DOM node and a unescaped fragment.
    """
    try:
        import XPointerParserc
        parser = XPointerParserc.new()
    except:
        import XPointerParser
        parser = XPointerParser.new()
    try:
        xptr = parser.parse(fragment)
    except SyntaxError, exc:
        raise XPtrException(XPtrException.SYNTAX_ERROR, str(exc))
    except Exception, exc:
        import traceback
        traceback.print_exc()
        raise XPtrException(XPtrException.INTERNAL_ERROR, str(exc))

    context = XPtrContext.XPtrContext(doc, 1, 1, contextNode or doc, nss or {})
    return xptr.select(context)


    
