########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/XPath/__init__.py,v 1.26 2004/09/11 05:37:22 uogbuji Exp $
"""
4XPath initialization and principal functions

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

NAMESPACE_NODE = 10000
FT_OLD_EXT_NAMESPACE = 'http://xmlns.4suite.org/xpath/extensions'
FT_EXT_NAMESPACE = 'http://xmlns.4suite.org/ext'

from Ft.Lib import boolean
from Ft.Lib.number import nan as NaN
from Ft.Lib.number import inf as Inf


# -- XPath exceptions --------------------------------------------------

from Ft import FtException

class XPathException(FtException):
    """
    Base class for exceptions specific to XPath processing
    """
    def __init__(self, errorCode, messages, args):
        FtException.__init__(self, errorCode, messages, args)


class CompiletimeException(XPathException):
    """
    The exception raised when an error is encountered during the
    parsing or compilation of an XPath expression.
    """
    #errorCodes:
    # internal/unexpected errors
    INTERNAL = 1
    # other expression compile-time errors
    SYNTAX = 2

    def __init__(self, errorCode, *args):
        # import here to avoid circularity
        import MessageSource
        XPathException.__init__(self, errorCode,
                                MessageSource.ERROR_COMPILETIME, args)
        return


class RuntimeException(XPathException):
    """
    The exception raised when an error is encountered during the
    parsing or evaluation of an XPath expression.
    """
    #errorCodes:
    # internal/unexpected errors
    INTERNAL = 1
    # other expression evaluation (run-time) errors
    NO_CONTEXT         = 10
    UNDEFINED_VARIABLE = 100
    UNDEFINED_PREFIX   = 101
    UNDEFINED_FUNCTION = 102
    WRONG_ARGUMENTS    = 200
    ARGCOUNT_NONE      = 201
    ARGCOUNT_ATLEAST   = 202
    ARGCOUNT_EXACT     = 203
    ARGCOUNT_ATMOST    = 204

    def __init__(self, errorCode, *args):
        # import here to avoid circularity
        import MessageSource
        XPathException.__init__(self, errorCode,
                                MessageSource.ERROR_RUNTIME, args)
        return

# -- Additional setup --------------------------------------------------

try:
    import XPathParserc
    parser = XPathParserc
except ImportError:
    import XPathParser
    parser = XPathParser

#Name module global properly.  Leave "parser" alone for now for backwards-compat
#name "parser" is deprecated
g_parser = parser

# -- Core XPath API ---------------------------------------------------------

import Context

from Util import Evaluate, SimpleEvaluate, Compile, CreateContext

#Allow access to the NormalizeNode function
from Util import NormalizeNode

Util.XPathParser = g_parser
Util.Context = Context

