########################################################################
#
# File Name:   NamespaceNode.py
#
# Docs:        http://docs.4suite.org/XPATH/NamespaceNode.py.py.html
#
"""
A container class for namespace nodes (accessible via namespace axis).
See http://www.w3.org/TR/xpath#namespace-nodes

WWW: http://4suite.org/XPATH        e-mail: support@4suite.org
Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Xml import EMPTY_NAMESPACE
from Ft.Xml.XPath import NAMESPACE_NODE

class NamespaceNode:

    childNodes = []
    
    def __init__(self, prefix, uri, parent, document):
        self.prefix = None
        # We must use an empty string for the name not None
        self.nodeName = self.localName = prefix or ''
        self.namespaceURI = EMPTY_NAMESPACE
        self.value = self.stringValue = uri
        self.nodeType = NAMESPACE_NODE
        self.ownerDocument = self.rootNode = document
        self.parentNode = parent
        self.baseURI = parent.baseURI
        
        # Remember that there is an index gap reserved between
        # the element and attributes for namespace nodes,
        # in accordance with XPath spec
        self.docIndex = parent.docIndex + 1
        return

    def __repr__(self):
        return "<NamespaceNode at %x: %s, %s>"%(id(self), self.nodeName, self.value)


