########################################################################
#
# File Name:            __init__.py
#
"""
XSLT and XPath extensions for use to access the 4SS API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

#Must come first because of circular import

import Alias, Command, Container, DocumentDefinition, GroupableObject, Group, Http, RawFile, RdfDocument, Model, Repository, ResourceMetaData, SchematronDocument, Server, UriReferenceFile, User, XmlDocument, XPathDocumentDefinition, XsltDocumentDefinition, XsltDocument, XmlRpcClient

#import Imap

mods = [Alias,
        Command,
        Container,
        DocumentDefinition,
        GroupableObject,
        Group,
        Http,
        RawFile,
        RdfDocument,
        Model,
        Repository,
        ResourceMetaData,
        SchematronDocument,
        Server,
        UriReferenceFile,
        User,
        XmlDocument,
        XPathDocumentDefinition,
        XsltDocumentDefinition,
        XsltDocument,
        #Imap,
        XmlRpcClient,
        ]

import Ns

ExtNamespaces = {
    Ns.SCORE_NS : 'fcore',
    Ns.HTTP_NS : 'fhttp',
    Ns.RDF_NS : 'frdf',
    Ns.IMAP_NS : 'fimap',
    Ns.UTIL_NS : 'futil',
    }

ExtFunctions = {}
ExtElements = {}

for mod in mods:
    ExtFunctions.update(getattr(mod,'ExtFunctions'))
    ExtElements.update(getattr(mod,'ExtElements'))

del mod
