########################################################################
#
# File Name:            XPathDocumentDefinition.py
#
"""
XSLT and XPath extensions supporting the 4SS XPathDocumentDefinition API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ns import SCORE_NS

import FtssXsltBase
from Ft.Server import FTSERVER_NAMESPACE
from Ft.Xml.XPath import Conversions
from Ft.Server.Common import DocumentDefinitionSerialization
from Ft.Xml import Domlette
from Ft.Rdf import OBJECT_TYPE_LITERAL, OBJECT_TYPE_RESOURCE

from Ft.Xml.Xslt import XsltElement
from Ft.Xml.Xslt import ContentInfo, AttributeInfo
from Ft.Xml.Xslt import OutputParameters
import cStringIO

def GetNsMap(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)

    doc = Domlette.implementation.createDocument(FTSERVER_NAMESPACE,'ftss:NsMap',None)
    DocumentDefinitionSerialization._SerializeNsMap(doc,base.getNsMap())
    return [doc]

def GetRdfMaps(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)

    proc = context.processor
    proc.pushResult()
    for (s,p,o,t) in base.getRdfMaps():
        proc.writers[-1].startElement('RdfMapping')
        proc.writers[-1].startElement('Subject')
        proc.writers[-1].text(s)
        proc.writers[-1].endElement('Subject')
        proc.writers[-1].startElement('Predicate')
        proc.writers[-1].text(p)
        proc.writers[-1].endElement('Predicate')
        proc.writers[-1].startElement('Object')
        if t == OBJECT_TYPE_RESOURCE:
            proc.writers[-1].attribute('type',"RESOURCE")
        elif t == OBJECT_TYPE_LITERAL:
            proc.writers[-1].attribute('type',"LITERAL")
        proc.writers[-1].text(o)
        proc.writers[-1].endElement('Object')
        proc.writers[-1].endElement('RdfMapping')

    frag = proc.popResult()
    context.rtfs.append(frag)
    stmt_nodeset = frag.childNodes
    return stmt_nodeset

class RemoveNsMapElement(XsltElement):
    """
    Change the namespace mapping of this doc def.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document definition'),
        'prefix' : AttributeInfo.PrefixesAvt(required = 1,
					     description='The prefix(s) to remove.  For multiple seperate with white space.'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
	prefixes = self._prefix.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)


	nsMap = base.getNsMap()
	for p in prefixes:
	    if nsMap.has_key(p):
		del nsMap[p]

	base.setNsMap(nsMap);

        return (context,)

class AddNsMapElement(XsltElement):
    """
    Change the namespace mapping of this doc def.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document definition'),
        'prefix' : AttributeInfo.PrefixAvt(required = 1,
					    description='The prefix to add.'),
        'uri' : AttributeInfo.UriReferenceAvt(required = 1,
					      description='The uri to add.'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
	prefix = self._prefix.evaluate(context)
	uri = self._uri.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)


	nsMap = base.getNsMap()
	nsMap[prefix] = uri
	base.setNsMap(nsMap);

        return (context,)

class AddRdfMapElement(XsltElement):
    """
    Change the rdf mapping of this doc def.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document definition'),
        'subject' : AttributeInfo.StringAvt(required = 1,
					    description='The subject to add.'),
        'predicate' : AttributeInfo.StringAvt(required = 1,
					      description='The predicate to add.'),
        'object' : AttributeInfo.StringAvt(required = 1,
					   description='The object to add.'),
        'object-is-resource' : AttributeInfo.YesNoAvt(required = 1,
						      description='Is the object a resource?'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
	subject = self._subject.evaluate(context)
	predicate = self._predicate.evaluate(context)
	object = self._object.evaluate(context)
	ot = self._object_is_resource.evaluate(context)

	if ot:
	    ot = OBJECT_TYPE_RESOURCE
	else:
	    ot = OBJECT_TYPE_LITERAL

        base = FtssXsltBase.FetchBaseObject(processor, path)

	nm = (subject,predicate,object,ot)
	rMap = base.getRdfMaps()
	rMap.append(nm)
	base.setRdfMaps(rMap)

        return (context,)

class RemoveRdfMapElement(XsltElement):
    """
    Change the rdf mapping of this doc def.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document definition'),
        'subject' : AttributeInfo.StringAvt(required = 1,
					    description='The subject to add.'),
        'predicate' : AttributeInfo.StringAvt(required = 1,
					      description='The predicate to add.'),
        'object' : AttributeInfo.StringAvt(required = 1,
					   description='The object to add.'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
	subject = self._subject.evaluate(context)
	predicate = self._predicate.evaluate(context)
	object = self._object.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)

	rMap = base.getRdfMaps()
	nMap = []
	for s,p,o,t in rMap:
	    print s,subject,p,predicate,o,object
	    if (s != subject or p != predicate or o != object):
		nMap.append((s,p,o,t))
		
	base.setRdfMaps(nMap)

        return (context,)


ExtFunctions = {
    (SCORE_NS, 'get-ns-map'): GetNsMap,    
    (SCORE_NS, 'get-rdf-maps'): GetRdfMaps,
}

ExtElements = {
    (SCORE_NS, 'remove-ns-map'): RemoveNsMapElement,
    (SCORE_NS, 'add-ns-map'): AddNsMapElement,
    (SCORE_NS, 'add-rdf-map'): AddRdfMapElement,
    (SCORE_NS, 'remove-rdf-map'): RemoveRdfMapElement,
}
