########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/Group.py,v 1.9 2003/01/19 05:08:26 jkloth Exp $
"""
XSLT and XPath extensions supporting the 4SS group API

Copyright 2002 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, AttributeInfo, ContentInfo
from Ns import SCORE_NS
import FtssXsltBase

def GetMemberPaths(context, group):
    """
    Returns the full paths to all user resources that are members
    of the specified group
    """
    repo = context.processor._repository
    res= repo.fetchResource(Conversions.StringValue(group))


    processor = context.processor
    processor.pushResultTree(context.currentInstruction.baseUri)
    try:
        for path in res.getMemberPaths():
            processor.writers[-1].startElement('path')
            processor.writers[-1].text(path)
            processor.writers[-1].endElement('path')
    finally:
        rtf = processor.popResult()
    return rtf.childNodes


class AddMemberElement(XsltElement):
    """
    Adds a user or group to the specified group
    """

    content = ContentInfo.Empty

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(required=1,
                                              description='The path of the group '
                                              'to which to add this member.'),
        'member-path' : AttributeInfo.UriReferenceAvt(required=1,
                                                     description='The path of the '
                                                     'new member (user or group) to '
                                                     'add to this group.'),
        }

    childArgument = None

    def instantiate(self, context, processor):
        context.setProcessState(self)
        repo = context.processor._repository

        path = self._path.evaluate(context)
        memberPath = self._member_path.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)
        newMember = repo.fetchResource(memberPath)
        base.addMember(newMember)

        return (context,)


class RemoveMemberElement(XsltElement):
    """
    Removes a user or group from the specified group
    """

    content = ContentInfo.Empty

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(required=1,
                                              description='The path of the group '
                                              'to which to remove this member.'),
        'member-path' : AttributeInfo.UriReferenceAvt(required=1,
                                                     description='The path of the '
                                                     'member (user or group) to '
                                                     'remove from this group.'),
        }

    childArgument = None

    def instantiate(self, context, processor):
        context.setProcessState(self)

        repo = context.processor._repository

        path = self._path.evaluate(context)
        memberPath = self._member_path.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)
        oldMember = repo.fetchResource(memberPath)
        base.removeMember(oldMember)

        return (context,)


ExtFunctions = {
    (SCORE_NS, 'get-member-paths'): GetMemberPaths,
}

ExtElements = {
    (SCORE_NS, 'add-member'): AddMemberElement,
    (SCORE_NS, 'remove-member'): RemoveMemberElement,
}

