import sys, os, copy

from Ft.Server.Server.Lib import LogUtil, ConfigFile

# Each server configuration file has this structure generated
        
class ServerConfig:
    def __init__(self, path, virtual=0):
        # Configuration settings
        self.path = path

        self.properties = None
        self.modifiedDate = None

        # Contact information
        self.admin = None
        self.hostname = None
        self.port = 0

        # Log files
        self.errorFilename = None
        self.errorLog = None
        self.logLevel = None

        self.accessFilename = None
        self.accessLog = None

        self.isVirtual = virtual
        self.virtualHosts = []
        
        # Transaction handling
        # Timeout for waiting for messages
        self.timeout = 300
        self.keepalive = 1
        # Timeout for waiting for next request in keepalive
        self.keepaliveTimeout = 15
        # Number of requests to entertain per connection
        self.keepaliveMax = 100

        self.names = []

        self.handler = None
        return

    def finalize(self, date, properties):
        self.modifiedDate = date
        self.properties = properties.copy()

        if self.admin is None:
            self.admin = '[no address given]'

        if self.hostname is None:
            self.hostname = 'unknown'

        if self.logLevel is None:
            self.logLevel = LogUtil.LOG_NOTICE

        for virtual in self.virtualHosts:
            virtual.merge(self)

        return

    def merge(self, parent):
        d = self.__dict__
        for name in ('admin', 'hostname', 'port', 'handler', 'logLevel',
                     'modifiedDate', 'properties'):
            if not d[name]:
                d[name] = copy.copy(parent.__dict__[name])

        for name, value in parent.__dict__.items():
            if not d.has_key(name):
                # Assume any unset values from parent
                d[name] = copy.copy(value)
        return

    def openLogs(self, globals):
        ident = self.handler.__name__
        if globals.debug:
            # Redirect our logging to stderr and force debug maxlevel
            self.errorLog = LogUtil.Logger(ident, sys.stderr, LogUtil.LOG_DEBUG)
        else:
            self.errorLog = LogUtil.Logger(ident, globals.logFilename,
                                           self.logLevel, showPid=1)

        for virtual in self.virtualHosts:
            virtual.openLogs(globals)
        return

