<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f	"http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
  <!ENTITY vcard "http://4suite.org/nexus/rdfs/vcard#">
]>
<xsl:stylesheet
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fcore="http://xmlns.4suite.org/4ss/score" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" 
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;" 
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;" 
  xmlns:f="&f;" 
  xmlns:vcard="&vcard;" 
  xmlns:fschema="http://schemas.4suite.org/4ss"
  xmlns:doc="http://docbook.org/docbook/xml/4.0/namespace"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  FILENAME HERE

Description:

    DESCRIPTION HERE


WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->

  <xsl:import href='/ftss/data/docbook_html1.xslt'/>
  <xsl:import href='docs-common.xslt'/>
  <xsl:variable name="display-name" select="'Index'"/>


  <xsl:template name="genericManager">
    <table class="normal" cellspacing="1" cellpadding="4">
      <tr>
        <td colspan="3" class="titleBar">
          <xsl:value-of select='doc:article/doc:articleinfo/doc:title'/>
        </td>
      </tr>
      <tr>
        <td colspan="3">
          <xsl:apply-templates select='/doc:article/doc:section'/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Override to create the links needed, term is the name and def is the link  -->
  <xsl:template match="doc:glosslist">
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="doc:glossentry">
    <xsl:variable name='stylesheet-ref'>
      <xsl:choose>
        <xsl:when test='string(ancestor::doc:section/doc:title)="Modules"'>
          <xsl:text>docs-modules.xslt</xsl:text>
        </xsl:when>
        <xsl:when test='string(ancestor::doc:section/doc:title)="XPath/XSLT Extensions"'>
          <xsl:text>docs-extensions.xslt</xsl:text>
        </xsl:when>
        <xsl:when test='string(ancestor::doc:section/doc:title)="Command-line Applications"'>
          <xsl:text>docs-commandline.xslt</xsl:text>
        </xsl:when>
        <xsl:when test='document(doc:glossdef)/article'>
          <xsl:text>docs-sgeneral.xslt</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>docs-general.xslt</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <li><a href='{doc:glossdef}?xslt=/ftss/dashboard/{$stylesheet-ref}'><xsl:value-of select='doc:glossterm'/></a></li>
  </xsl:template>

</xsl:stylesheet>
