########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/List/Groups.py,v 1.7 2004/09/23 20:53:30 mbrown Exp $
"""
Implementation of '4ss list groups' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command lists all Group resources in a 4Suite \
repository. If necessary, you will be prompted first for \
credentials and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil


def Run(options,args):
    repo = CommandUtil.GetRepository(options, '4ss.list.groups')
    if repo is not None:
        try:
            if options.has_key('fullpaths'):
                groups = repo.getAllGroupPaths()
            else:
                groups = repo.getAllGroupNames()
            CommandUtil.WritePreamble("Groups in the repository:")
            for g in groups:
                print g
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('groups',
                          'List all Groups in a repository',
                          '',
                          __doc__,
                          function = Run,
                          options = Options.Options([Options.Option('f',
                                                                    'fullpaths',
                                                                    'list full paths instead of group names'),
                                     ]),
                          arguments = [
                                       ],
                          fileName = __file__,
                          )
    return cmd
