########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Create/Container.py,v 1.12 2004/09/23 20:53:28 mbrown Exp $
"""
Implementation of '4ss create container' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""
__doc__ = """This command creates a new Container resource in a 4Suite \
repository. If necessary, you will be prompted first \
for credentials and access info to connect to the repository."""


from Ft.Server.Client.Commands import CommandUtil


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.create.container')
    if repo is not None:
        commit = False
        try:
            repo.createContainer(args['name'], options.get('create-parents') != None)
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass
    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('container',
                          'Create a new Container in a 4Suite repository',
                          '/documents',
                          __doc__,
                          function=Run,
                          arguments=[Arguments.RequiredArgument('name',
                                                                'The name (repo path) of container to create',
                                                                str),
                                     ],
                          options=Options.Options([Options.Option('r',
                                                                  'create-parents',
                                                                  'Recursively build all parent containers to complete the path.'),
                                                   ]),
                          fileName=__file__,
                          )
    return cmd

